package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleDictionaryDao;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.StringUtil;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDictionary;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDictionarytype;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.service.console.DictionaryService;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/dictionary"})
public class TDictionaryController {
   @Autowired
   private DictionaryService dictionaryService;
   private static final Logger ddmauditLogger = LoggerFactory.getLogger("ddmauditLogger");
   private static final Logger operationLogger = LoggerFactory.getLogger("operationLogger");
   @Autowired
   private TConsoleDictionaryDao tConsoleDictionaryDao;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/rules/dictionary";
   }

   @GetMapping({"/getDictinaryTypes"})
   @ResponseBody
   public Response getDictinaryTypes(@RequestBody(required = false) Map<String, Object> params) {
      List<ComboboxVO> list = new ArrayList();

      for(TConsoleDictionarytype type : this.dictionaryService.getDictinaryTypes()) {
         ComboboxVO temp = new ComboboxVO();
         temp.setTid(type.getId());
         temp.setText(type.getTypename());
         temp.setValue(type.getTypecode());
         list.add(temp);
      }

      ddmauditLogger.info(MesUtil.getMsg("DDM_00709", new String[]{CommonUtils.loginUsername()}));
      return RespHelper.successResp(list);
   }

   @PostMapping({"/addDictionaryType"})
   @ResponseBody
   public Response addDictionaryType(@RequestBody(required = false) Map<String, Object> params) {
      TConsoleDictionarytype dictionaryType = null;
      if (null != params) {
         dictionaryType = (TConsoleDictionarytype)ObjectTool.getObjectByMap(TConsoleDictionarytype.class, (Map)params.get("dictionaryType"));
         new HashMap();
         long typeCount = this.dictionaryService.queryDictionaryTypeCount(dictionaryType.getTypename());
         if (StringUtil.isBlank(dictionaryType.getId())) {
            ddmauditLogger.info(MesUtil.getMsg("DDM_00811", new String[]{CommonUtils.loginUsername(), dictionaryType.getTypename()}));
         } else {
            ddmauditLogger.info(MesUtil.getMsg("DDM_00812", new String[]{CommonUtils.loginUsername(), dictionaryType.getTypename()}));
         }

         this.dictionaryService.addDictionaryType(dictionaryType);
         return RespHelper.successResp();
      } else {
         return RespHelper.createResp(false, "POP_00022", MesUtil.getMsg("POP_00022", new String[0]));
      }
   }

   @PostMapping({"/initEditType"})
   @ResponseBody
   public Response initEditType(@RequestBody(required = false) Map<String, Object> params) {
      String typeId = "4028b8817032efbf017037dd17ee0002";
      if (null != params) {
         typeId = (String)params.get("typeId");
         TConsoleDictionarytype tConsoleDictionarytype = this.dictionaryService.initEditDictionaryType(typeId);
         ddmauditLogger.info(MesUtil.getMsg("DDM_00810", new String[]{CommonUtils.loginUsername(), tConsoleDictionarytype.getTypename()}));
         Map<String, Object> reMap = new HashMap();
         reMap.put("tConsoleDictionarytype", tConsoleDictionarytype);
         return RespHelper.successResp(reMap);
      } else {
         return RespHelper.createResp(false, "POP_00022", MesUtil.getMsg("POP_00022", new String[0]));
      }
   }

   @PostMapping({"/delDictionaryType"})
   @ResponseBody
   public Response delDictionaryType(@RequestBody(required = false) Map<String, Object> params) {
      List<String> idlist = new ArrayList();
      String dictionaryTypeCode = "";
      String dictionaryTypeName = "";
      if (null != params) {
         dictionaryTypeCode = (String)params.get("dictionaryTypeCode");
         dictionaryTypeName = (String)params.get("dictionaryTypeName");
      } else if (StringUtil.isBlank(dictionaryTypeCode)) {
         return RespHelper.createResp(false, "POP_00022", MesUtil.getMsg("POP_00022", new String[0]));
      }

      ddmauditLogger.info(MesUtil.getMsg("DDM_00813", new String[]{CommonUtils.loginUsername(), dictionaryTypeName}));
      idlist.add(dictionaryTypeCode);
      this.dictionaryService.removeDictionaryType(idlist);
      return RespHelper.successResp();
   }

   @PostMapping({"/query"})
   @ResponseBody
   public Response query(@RequestBody(required = false) Map<String, Object> params) {
      PageInfo pageInfo = new PageInfo();
      String typecode = "";
      String typename = "";
      if (null != params) {
         Integer page = (Integer)params.get("pageno");
         Integer rows = (Integer)params.get("pagesize");
         System.out.println();
         pageInfo.setPageno(page);
         pageInfo.setPagesize(rows);
         typecode = (String)params.get("typecode");
         typename = (String)params.get("typename");
         ddmauditLogger.info(MesUtil.getMsg("DDM_00814", new String[]{CommonUtils.loginUsername(), "code:" + typename}));
         List var9 = this.dictionaryService.queryDictionaryByTypeCode(typecode, pageInfo, params);
         return RespHelper.updateResp(pageInfo, var9);
      } else {
         return RespHelper.createResp(false, "POP_00022", MesUtil.getMsg("POP_00022", new String[0]));
      }
   }

   @PostMapping({"/add"})
   @ResponseBody
   public Response add(@RequestBody(required = false) Map<String, Object> params) {
      TConsoleDictionary dictionary = null;
      if (null != params) {
         dictionary = (TConsoleDictionary)ObjectTool.getObjectByMap(TConsoleDictionary.class, (Map)params.get("dictionary"));
         dictionary.setCreatetime(new Date());
         if (StringUtil.isBlank(dictionary.getId())) {
            ddmauditLogger.info(MesUtil.getMsg("DDM_00816", new String[]{CommonUtils.loginUsername(), dictionary.getValue()}));
         } else {
            ddmauditLogger.info(MesUtil.getMsg("DDM_00817", new String[]{CommonUtils.loginUsername(), dictionary.getValue()}));
         }

         this.dictionaryService.save(dictionary);
         return RespHelper.successResp();
      } else {
         return RespHelper.createResp(false, "POP_00022", MesUtil.getMsg("POP_00022", new String[0]));
      }
   }

   @PostMapping({"/del"})
   @ResponseBody
   public Response del(@RequestBody(required = false) Map<String, Object> params) {
      String dicId = "";
      String dicName = "";
      if (null != params) {
         dicId = (String)params.get("dicId");
         dicName = (String)params.get("dicName");
      } else if (StringUtil.isBlank(dicId)) {
         dicId = "077ee245bb774eb9af3e0a8d12d0c2fd";
         dicName = "测试字典名称";
         return RespHelper.createResp(false, "POP_00022", MesUtil.getMsg("POP_00022", new String[0]));
      }

      if (StringUtils.isBlank(dicName)) {
         TConsoleDictionary tConsoleDictionary = (TConsoleDictionary)this.tConsoleDictionaryDao.get(dicId);
         dicName = tConsoleDictionary.getValue();
      }

      ddmauditLogger.info(MesUtil.getMsg("DDM_00818", new String[]{CommonUtils.loginUsername(), dicName}));
      this.dictionaryService.remove(dicId);
      return RespHelper.successResp();
   }

   @PostMapping({"/initEdit"})
   @ResponseBody
   public Response initEdit(@RequestBody(required = false) Map<String, Object> params) {
      String dicId = "183";
      if (null != params) {
         dicId = (String)params.get("dicId");
         TConsoleDictionary tConsoleDictionary = this.dictionaryService.initEditDictionary(dicId);
         ddmauditLogger.info(MesUtil.getMsg("DDM_00815", new String[]{CommonUtils.loginUsername(), tConsoleDictionary.getName()}));
         Map<String, Object> reMap = new HashMap();
         reMap.put("tConsoleDictionary", tConsoleDictionary);
         return RespHelper.successResp(reMap);
      } else {
         return RespHelper.createResp(false, "POP_00022", MesUtil.getMsg("POP_00022", new String[0]));
      }
   }

   @GetMapping({"/checkNameExitType"})
   @ResponseBody
   public Response checkNameExitType(@RequestParam(required = false) String typename) {
      boolean result = true;
      List<TConsoleDictionarytype> typeList = this.dictionaryService.getDictinaryTypesbytypename(typename);
      if (null == typeList || typeList.size() == 0) {
         result = false;
      }

      return result ? RespHelper.createResp(false, "POP_00020", MesUtil.getMsg("POP_00020", new String[0])) : RespHelper.successResp(result);
   }

   @GetMapping({"/checkNameExit"})
   @ResponseBody
   public Response checkNameExit(@RequestParam(required = false) String dicname) {
      boolean result = true;
      List<TConsoleDictionary> list = this.dictionaryService.getDictinaryByname(dicname);
      if (null == list || list.size() == 0) {
         result = false;
      }

      return result ? RespHelper.createResp(false, "POP_00021", MesUtil.getMsg("POP_00021", new String[0])) : RespHelper.successResp(result);
   }
}
