package com.chenyang.nse.bussiness.controller.core;

import com.chenyang.nse.bussiness.annot.EncryptLog;
import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreEncryptionTypeFieldDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataProject;
import com.chenyang.nse.bussiness.entity.vo.dataproject.DatasystemProjectdatasourceVO;
import com.chenyang.nse.bussiness.entity.vo.encyption.EncryptionConfigVO;
import com.chenyang.nse.bussiness.service.core.TdataProjectService;
import com.chenyang.nse.bussiness.service.core.encryption.EncryptionConfigService;
import com.chenyang.nse.bussiness.service.core.udf.UdfService;
import java.sql.Connection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/udf"})
public class UdfController {
   private final TdataProjectService tdataProjectService;
   private final EncryptionConfigService encryptionConfigService;
   private final UdfService udfService;
   private final TCoreEncryptionTypeFieldDao tCoreEncryptionTypeFieldDao;
   @Value("${classify.classifyEnable}")
   private boolean classifyEnable;
   private Connection connection = null;

   public UdfController(TdataProjectService tdataProjectService, EncryptionConfigService encryptionConfigService, UdfService udfService, TCoreEncryptionTypeFieldDao tCoreEncryptionTypeFieldDao) {
      this.tdataProjectService = tdataProjectService;
      this.encryptionConfigService = encryptionConfigService;
      this.udfService = udfService;
      this.tCoreEncryptionTypeFieldDao = tCoreEncryptionTypeFieldDao;
   }

   @EncryptLog
   @RequestMapping({"/init"})
   @ResponseBody
   public Response initUdf(@RequestBody EncryptionConfigVO vo, HttpServletRequest request, HttpServletResponse response) {
      String projectId = vo.getProjectId();
      TCoreDataProject project = this.tdataProjectService.selectOneDataProject(projectId);
      String type = project.getProjectType();
      if (!type.equals("udf")) {
         return RespHelper.createResp(false, "-1", "该项目不是udf项目");
      } else {
         String tableName = vo.getTable_name();
         if (this.udfService.isInited(tableName)) {
            return RespHelper.createResp(false, "-1", "该表已经初始化过了");
         } else {
            String udfTableName = tableName + this.udfService.suffix;
            String schemaName = vo.getSchema();
            TCoreDatasystem tCoreDatasystem = this.tdataProjectService.selectOneProDataSource(vo.getDatasystem_id());
            this.udfService.getClassItem(tCoreDatasystem).alterTableName(tCoreDatasystem, schemaName, tableName, udfTableName);
            return RespHelper.successResp(udfTableName);
         }
      }
   }

   @EncryptLog
   @RequestMapping({"/finish"})
   @ResponseBody
   public Response finishUdf(@RequestBody EncryptionConfigVO vo, HttpServletRequest request, HttpServletResponse response) {
      String datasystemid = vo.getDatasystem_id();
      String schema = vo.getSchema();
      String tablename = vo.getTable_name();
      if (!this.udfService.isInited(tablename)) {
         return RespHelper.createResp(false, "-1", "该表未初始化");
      } else if (this.udfService.getClassItem(datasystemid).isFinished(datasystemid, schema, tablename)) {
         return RespHelper.createResp(false, "-1", "该表已经完成");
      } else {
         String res = this.udfService.finish(vo);
         return !res.equals("ok") ? RespHelper.createResp(false, "-1", res) : RespHelper.successResp();
      }
   }

   @EncryptLog
   @RequestMapping({"/status"})
   @ResponseBody
   public Response status(@RequestBody EncryptionConfigVO vo) {
      Map<String, String> map = new HashMap();
      String init = "show";
      String finish = "show";
      String projectId = vo.getProjectId();
      TCoreDataProject project = this.tdataProjectService.selectOneDataProject(projectId);
      String type = project.getProjectType();
      if (!type.equals("udf")) {
         init = "display";
         finish = "display";
      } else {
         String tableName = vo.getTable_name();
         String datasystemId = vo.getDatasystem_id();
         String schema = vo.getSchema();
         tableName = vo.getTable_name();
         if (this.udfService.isInited(tableName)) {
            init = "disable";
         }

         if (this.udfService.getClassItem(datasystemId).isFinished(datasystemId, schema, tableName)) {
            finish = "disable";
         }
      }

      map.put("init", init);
      map.put("finish", finish);
      return RespHelper.successResp(map);
   }

   @EncryptLog
   @RequestMapping({"/closeUdf"})
   @ResponseBody
   public Response udfToNormal(@RequestBody EncryptionConfigVO vo) {
      String projectId = vo.getProjectId();
      TCoreDataProject project = this.tdataProjectService.selectOneDataProject(projectId);
      project.setProjectType("normal");
      List<DatasystemProjectdatasourceVO> datasystemList = this.tdataProjectService.queryDatasourceByProjectId(projectId);
      new HashMap();

      for(int i = 0; i < datasystemList.size(); ++i) {
         Map<String, String> t = (Map)datasystemList.get(i);
         String id = (String)t.get("tid");
         this.udfService.closeUdf(id);
      }

      this.tdataProjectService.saveDataProject(project);
      return RespHelper.successResp();
   }

   public static void main(String[] args) {
   }
}
