package com.chenyang.nse.bussiness.controller.core.dataproject;

import com.chenyang.nse.bussiness.entity.vo.DiscoveryMonitorVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreDiscoveryTaskVO;
import com.chenyang.nse.bussiness.service.core.dataproject.DiscoverytaskService;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/discoverymonitorlog"})
public class AllDiscoveryTaskMonitorController {
   @Autowired
   private DiscoverytaskService discoverytaskService;

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      return "core/dataproject/monitor/alldiscoverytask_monitor";
   }

   @RequestMapping({"/queryDiscoveryTask"})
   @ResponseBody
   public List<DiscoveryMonitorVO> queryDiscoveryTask(HttpServletRequest request, HttpServletResponse response, String projectid) {
      return this.discoverytaskService.queryDiscoveryTaskForMonitor(projectid);
   }

   @ResponseBody
   @RequestMapping({"/queryDetail"})
   public List<TCoreDiscoveryTaskVO> queryDetail(String taskid, String discoverytype, String isDmpFlag) {
      new ArrayList();
      List list;
      if (!"1".equals(discoverytype) && !"3".equals(discoverytype) && !"4".equals(discoverytype)) {
         if ("1".equals(isDmpFlag)) {
            list = this.discoverytaskService.queryDiscoveryTaskDetailforDmp(taskid);
         } else {
            list = this.discoverytaskService.queryDiscoveryTaskDetailforTxt(taskid);
         }
      } else {
         list = this.discoverytaskService.queryDiscoveryTaskDetailforDB(taskid);
      }

      return list;
   }
}
