package com.chenyang.nse.bussiness.controller.core.dataproject;

import cn.hutool.core.bean.BeanUtil;
import com.chenyang.nse.bussiness.annot.PassToken;
import com.chenyang.nse.bussiness.commmon.json.ErrCode;
import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.controller.core.FieldScopeController;
import com.chenyang.nse.bussiness.controller.core.TdiscoverResultController;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TcoreDiscoveryColumnDao;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.StringUtil;
import com.chenyang.nse.bussiness.entity.cache.LoginUser;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleLog;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectFile;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreProjectFileDetail;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryColumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryTask;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreTaskFindrule;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructure;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurespliter;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DBTableVO;
import com.chenyang.nse.bussiness.entity.vo.DataGridVO;
import com.chenyang.nse.bussiness.entity.vo.DiscoveryParamVO;
import com.chenyang.nse.bussiness.entity.vo.DiscoveryResultVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreProjectVersionCompareVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TcoreProjectFilestructureVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.RqSaveEditionParamsVO;
import com.chenyang.nse.bussiness.service.console.OperationService;
import com.chenyang.nse.bussiness.service.console.UserService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.FileSystemService;
import com.chenyang.nse.bussiness.service.core.TdataDiscoveryResultService;
import com.chenyang.nse.bussiness.service.core.TdataDiscoveryService;
import com.chenyang.nse.bussiness.service.core.dataproject.DiscoverytaskService;
import com.chenyang.nse.bussiness.service.core.dataproject.ExecuteDiscoverytaskService;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import com.chenyang.nse.bussiness.tools.command.CommandTool;
import com.chenyang.nse.bussiness.tools.dmp.DmpDpTool;
import com.chenyang.nse.bussiness.tools.dmp.DmpTool;
import com.chenyang.nse.bussiness.tools.dmp.MultipleDmpDpTool;
import com.chenyang.nse.bussiness.tools.dmp.MultipleDmpTool;
import com.chenyang.nse.bussiness.tools.dmp.TableStructureInfo;
import com.chenyang.nse.bussiness.tools.es.EsUtil;
import com.chenyang.nse.bussiness.tools.filesystem.FileSystemTool;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.jdbc.MongodbTool;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import com.chenyang.nse.bussiness.tools.net.FtpTool;
import com.chenyang.nse.bussiness.tools.net.SFTPUtil;
import com.chenyang.nse.bussiness.tools.string.AesTool;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import com.chenyang.nse.bussiness.tools.xml.ReadJsonTool;
import com.jcraft.jsch.ChannelSftp;
import com.mongodb.MongoClient;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.hadoop.fs.FileStatus;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/tdatadiscovery"})
public class TdataDiscoveryController {
   private static final String tdatadiscovery = "TdataDiscovery";
   private static final String tdatadiscovery_map = "TdataDiscovery_tablemap";
   @Autowired
   private RedisService redisService;
   @Autowired
   private TdataDiscoveryService tdataDiscoveryService;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private UserService userService;
   @Autowired
   private OperationService operationService;
   @Autowired
   private FileSystemService fileSystemService;
   @Autowired
   private DiscoverytaskService discoverytaskService;
   @Autowired
   private TcoreDiscoveryColumnDao tcoreDiscoveryColumnDao;
   @Autowired
   private ExecuteDiscoverytaskService executeDiscoverytaskService;
   @Autowired
   private TdataDiscoveryResultService tdataDiscoveryResultService;
   @Autowired
   private TdiscoverResultController tdiscoverResultController;
   @Autowired
   private FieldScopeController fieldScopeController;
   @Autowired
   private TCoreDatasystemDao tCoreDatasystemDao;
   private static final Logger ddmauditLogger = LoggerFactory.getLogger("ddmauditLogger");
   private static final Logger operationLogger = LoggerFactory.getLogger("operationLogger");
   private static final Logger handleprocessLogger = LoggerFactory.getLogger("handleprocessLogger");

   @RequestMapping
   public String index(HttpServletRequest request, HttpServletResponse response, Model model) {
      String crud = request.getParameter("crud");
      String projectid = (String)request.getSession().getAttribute("projectid");
      model.addAttribute("projectid", projectid);
      model.addAttribute("crud", crud);
      return "core/dataproject/discoverytask/discoverytask_list";
   }

   @RequestMapping({"/monitor"})
   public String monitor(HttpServletRequest request, HttpServletResponse response, Model model) {
      String taskid = request.getParameter("taskid");
      String projectid = request.getParameter("projectid");
      String resultid = request.getParameter("resultid");
      String version = request.getParameter("version");
      model.addAttribute("taskid", taskid);
      model.addAttribute("projectid", projectid);
      model.addAttribute("taskstatus", this.redisService.get("taskstatus_" + taskid));
      model.addAttribute("resultid", resultid);
      model.addAttribute("version", version);
      return "core/dataproject/monitor/monitordetails";
   }

   @RequestMapping({"/contrastdata"})
   public String contrastdata(HttpServletRequest request, HttpServletResponse response, Model model) {
      String projectid = (String)request.getSession().getAttribute("projectid");
      String taskid = request.getParameter("taskid");
      model.addAttribute("taskid", taskid);
      return "core/dataproject/discoverytask/contrastdata";
   }

   @ResponseBody
   @RequestMapping({"/discoverytasklist"})
   public DataGridVO<TcoreDiscoveryTask> discoverytasklist(PageInfo pageInfo, Integer page, Integer rows, HttpServletRequest request, HttpServletResponse response, Model model) {
      String projectid = (String)request.getSession().getAttribute("projectid");
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<TcoreDiscoveryTask> list = this.tdataDiscoveryService.queryDiscoverytasklist(pageInfo, projectid);
      DataGridVO<TcoreDiscoveryTask> vo = new DataGridVO<TcoreDiscoveryTask>(pageInfo.getCount(), list);
      return vo;
   }

   @RequestMapping({"/createtask"})
   public String createtask(String step, @RequestParam Map<String, String> map, HttpServletRequest request, HttpServletResponse response, Model model) {
      if (map.get("taskid") == null || "".equals(map.get("taskid"))) {
         map.put("taskid", (String)request.getSession().getAttribute("taskid"));
      }

      if (step == null) {
         step = (String)request.getSession().getAttribute((String)map.get("pageparamkey"));
      }

      if (map.get("pageparamkey") != null) {
         request.getSession().setAttribute((String)map.get("pageparamkey"), map.get("pageparamvalue"));
      }

      switch (step) {
         case "discoverytask_one":
            this.discoverytask_one(map, request, model);
            break;
         case "discoverytask_two":
            step = this.discoverytask_two(map, request, response, model);
            break;
         case "discoverytask_two_file":
            this.discoverytask_two_file(map, model);
            break;
         case "discoverytask_three":
            this.discoverytask_three(map, request, model);
      }

      model.addAttribute("projectid", "projectid");
      return "core/dataproject/discoverytask/" + step;
   }

   public void discoverytask_one(Map<String, String> map, HttpServletRequest request, Model model) {
      String newtask = (String)map.get("newtask");
      String way = (String)map.get("way");
      String projectid = (String)request.getSession().getAttribute("projectid");
      this.redisService.remove("TdataDiscovery_tablemap");
      if (newtask != null) {
         model.addAttribute("projectid", projectid);
         request.getSession().setAttribute("projectid", projectid);
         this.redisService.remove("TdataDiscovery_taskmap");
         request.getSession().setAttribute("taskid", "");
      } else if ("prev".equals(way)) {
         String taskid = (String)map.get("taskid");
         Map<String, Object> taskmap = (Map)this.redisService.get("TdataDiscovery_taskmap" + taskid);
         model.addAttribute("taskname", taskmap.get("taskname"));
         model.addAttribute("remark", taskmap.get("remark"));
         request.getSession().setAttribute("taskid", map.get("taskid"));
         model.addAttribute("editstep", map.get("editstep"));
      } else {
         this.redisService.remove("TdataDiscovery_taskmap");
         TcoreDiscoveryTask tcoreDiscoveryTask = this.queryDiscoveryTask((String)map.get("taskid"), (LoginUser)request.getSession().getAttribute("loginUser"));
         model.addAttribute("taskname", tcoreDiscoveryTask.getTname());
         model.addAttribute("remark", tcoreDiscoveryTask.getNote());
         model.addAttribute("edittask", "edittask");
         model.addAttribute("editstep", "edittask");
         request.getSession().setAttribute("taskid", map.get("taskid"));
         map.put("taskname", tcoreDiscoveryTask.getTname());
         map.put("discoverytype", tcoreDiscoveryTask.getDiscoverytype());
         map.put("isdmpflag", tcoreDiscoveryTask.getIsdmpflag());
         map.put("remark", tcoreDiscoveryTask.getNote());
         map.put("cyfs", tcoreDiscoveryTask.getCyfs());
         map.put("cys", tcoreDiscoveryTask.getCys());
         map.put("ppl", tcoreDiscoveryTask.getPpl());
         this.redisService.set("TdataDiscovery_taskmap" + (String)map.get("taskid"), map);
      }

   }

   @GetMapping({"/isrepeatname"})
   @ResponseBody
   public Response isrepeatname(@RequestParam("taskname") String taskname, @RequestParam("datasystemid") String datasystemid) {
      Boolean result = null;
      TcoreDiscoveryTask tcoreDiscoveryTask = this.tdataDiscoveryService.queryTaskByName(taskname, datasystemid);
      if (tcoreDiscoveryTask != null) {
         result = true;
      } else {
         result = false;
      }

      return !result ? RespHelper.createResp(false, "POP_00002", MesUtil.getMsg("POP_00002", new String[]{taskname})) : RespHelper.successResp();
   }

   public String discoverytask_two(Map<String, String> map, HttpServletRequest request, HttpServletResponse response, Model model) {
      String step = "discoverytask_two";
      model.addAttribute("editstep", map.get("editstep"));
      if (((String)map.get("way")).equals("prev")) {
         String taskid = request.getSession().getAttribute("taskid").toString();
         this.tdataDiscoveryService.queryFilelist(taskid);
         Map<String, Object> redismap = (Map)this.redisService.get("TdataDiscovery_taskmap" + taskid);
         model.addAttribute("discoverytype", redismap.get("discoverytype"));
         if ("1".equals(redismap.get("discoverytype"))) {
            model.addAttribute("datasource", redismap.get("datasource"));
         } else if ("2".equals(redismap.get("discoverytype"))) {
            String isknowstructure = redismap.get("isknowstructure").toString();
            model.addAttribute("structure", isknowstructure);
            if ("know".equals(isknowstructure)) {
               model.addAttribute("filetype", redismap.get("filetype"));
               model.addAttribute("filesourcetype", redismap.get("filesourcetype"));
               model.addAttribute("filesource", redismap.get("filesource"));
               if ("0".equals(redismap.get("filetype"))) {
                  model.addAttribute("filedir", redismap.get("fileurl"));
                  model.addAttribute("dmpfiletype", redismap.get("dmpfiletype"));
                  model.addAttribute("dmptype", redismap.get("dmptype"));
                  model.addAttribute("filename", redismap.get("filename"));
                  model.addAttribute("dmptables", redismap.get("dmptablename"));
               } else if ("5".equals(redismap.get("filetype"))) {
                  model.addAttribute("filegroup", redismap.get("filegroup"));
                  model.addAttribute("filedir", redismap.get("fileurl"));
               }

               step = "discoverytask_two_file";
            } else {
               model.addAttribute("filesourcetype", redismap.get("filesourcetype"));
               model.addAttribute("filesource", redismap.get("filesource"));
               model.addAttribute("filedir", redismap.get("fileurl"));
               step = "discoverytask_two_file";
            }
         } else if ("3".equals(redismap.get("discoverytype"))) {
            model.addAttribute("hadoop", "1");
            model.addAttribute("datasource", redismap.get("datasource"));
         } else if ("4".equals(redismap.get("discoverytype"))) {
            model.addAttribute("nosql", "1");
            model.addAttribute("datasource", redismap.get("datasource"));
         }
      } else if (((String)map.get("way")).equals("next")) {
         if ("edittask".equals(map.get("edittask"))) {
            String taskid = request.getSession().getAttribute("taskid").toString();
            Map<String, Object> taskmap = (Map)this.redisService.get("TdataDiscovery_taskmap" + taskid);
            String discoverytype = (String)taskmap.get("discoverytype");
            if (!"1".equals(discoverytype) && !"3".equals(discoverytype) && !"4".equals(discoverytype)) {
               if ("2".equals(discoverytype)) {
                  List<TCoreProjectFile> discoveryFileList = this.tdataDiscoveryService.queryFilelist(taskid);
                  if (discoveryFileList.size() > 0) {
                     String filetype = ((TCoreProjectFile)discoveryFileList.get(0)).getFiletype();
                     String filesourcetype = ((TCoreProjectFile)discoveryFileList.get(0)).getFilesourcetype();
                     String filesource = ((TCoreProjectFile)discoveryFileList.get(0)).getFilesource();
                     String fileurl = ((TCoreProjectFile)discoveryFileList.get(0)).getFileurl();
                     String isknowstructure = ((TCoreProjectFile)discoveryFileList.get(0)).getIsknowstructure();
                     if (!"know".equals(isknowstructure)) {
                        this.redisService.set("TdataDiscovery_taskmap" + taskid, taskmap);
                     } else if ("0".equals(filetype)) {
                        String dmpfiletype = ((TCoreProjectFile)discoveryFileList.get(0)).getDmpfiletype();
                        String dmptype = ((TCoreProjectFile)discoveryFileList.get(0)).getDmptype();
                        String filename = ((TCoreProjectFile)discoveryFileList.get(0)).getFilename();
                        String dmptables = ((TCoreProjectFile)discoveryFileList.get(0)).getDmptables();
                        model.addAttribute("dmpfiletype", dmpfiletype);
                        model.addAttribute("dmptype", dmptype);
                        model.addAttribute("filename", filename);
                        model.addAttribute("dmptables", dmptables);
                     } else if ("5".equals(filetype)) {
                        String filename = "";
                        String filestructureid = "";
                        String filestructure = "";
                        String filegroup = ((TCoreProjectFile)discoveryFileList.get(0)).getFilegroup();
                        List<TcoreProjectFilestructureVO> filestructurename = new ArrayList();

                        for(int i = 0; i < discoveryFileList.size(); ++i) {
                           TcoreProjectFilestructureVO tcoreProjectFilestructureVO = new TcoreProjectFilestructureVO();
                           filename = ((TCoreProjectFile)discoveryFileList.get(i)).getFilename();
                           filestructureid = ((TCoreProjectFile)discoveryFileList.get(i)).getFilestructureid();
                           filestructure = ((TCoreProjectFile)discoveryFileList.get(i)).getFilestructure();
                           tcoreProjectFilestructureVO.setFilename(filename);
                           tcoreProjectFilestructureVO.setFilestructureid(filestructureid);
                           tcoreProjectFilestructureVO.setFilestructure(filestructure);
                           filestructurename.add(tcoreProjectFilestructureVO);
                        }

                        taskmap.put("filetructurenamelist", filestructurename);
                        this.redisService.set("TdataDiscovery_taskmap" + taskid, taskmap);
                        model.addAttribute("filegroup", filegroup);
                        taskmap.put("filegroup", filegroup);
                     }

                     model.addAttribute("structure", isknowstructure);
                     model.addAttribute("filetype", filetype);
                     model.addAttribute("filesourcetype", filesourcetype);
                     model.addAttribute("filesource", filesource);
                     model.addAttribute("filedir", fileurl);
                     model.addAttribute("edittask", "edittask");
                     taskmap.put("filetype", filetype);
                     taskmap.put("filesourcetype", filesourcetype);
                     taskmap.put("filesource", filesource);
                     taskmap.put("filedir", fileurl);
                  }

                  step = "discoverytask_two_file";
               }
            } else {
               List<TcoreDiscoveryColumn> discoveryColumnList = this.tdataDiscoveryService.queryDiscoveryColumn(taskid);
               if (discoveryColumnList.size() > 0) {
                  String dataSystemId = ((TcoreDiscoveryColumn)discoveryColumnList.get(0)).getDatasourceid();
                  List<String> table = new ArrayList();
                  String schemaname = ((TcoreDiscoveryColumn)discoveryColumnList.get(0)).getTschema();

                  for(int i = 0; i < discoveryColumnList.size(); ++i) {
                     if (schemaname.equals(((TcoreDiscoveryColumn)discoveryColumnList.get(i)).getTschema())) {
                        table.add(((TcoreDiscoveryColumn)discoveryColumnList.get(i)).getTablename());
                     } else {
                        this.redisService.hmSet("TdataDiscovery_tablemap", schemaname, table);
                        table.clear();
                        table.add(((TcoreDiscoveryColumn)discoveryColumnList.get(i)).getTablename());
                     }

                     schemaname = ((TcoreDiscoveryColumn)discoveryColumnList.get(i)).getTschema();
                  }

                  this.redisService.hmSet("TdataDiscovery_tablemap", schemaname, table);
                  if ("3".equals(discoverytype)) {
                     model.addAttribute("hadoop", "1");
                  } else if ("4".equals(discoverytype)) {
                     model.addAttribute("nosql", "1");
                  }

                  model.addAttribute("datasource", dataSystemId);
                  model.addAttribute("edittask", "edittask");
               }
            }

            taskmap.put("taskname", map.get("taskname"));
            taskmap.put("remark", map.get("remark"));
            this.redisService.set("TdataDiscovery_taskmap" + taskid, taskmap);
         } else {
            String taskid = "";
            if (request.getSession().getAttribute("taskid") != null && !"".equals(request.getSession().getAttribute("taskid").toString())) {
               taskid = request.getSession().getAttribute("taskid").toString();
            } else {
               taskid = UUID.randomUUID().toString();
            }

            this.redisService.set("TdataDiscovery_taskmap" + taskid, map);
            request.getSession().setAttribute("taskid", taskid);
         }
      } else {
         this.redisService.remove("TdataDiscovery_tablemap");
         if ("1".equals(map.get("hadoop"))) {
            model.addAttribute("hadoop", map.get("hadoop"));
            request.getSession().setAttribute("hadoop_s", "1");
         } else if ("1".equals(map.get("nosql"))) {
            model.addAttribute("nosql", map.get("nosql"));
            request.getSession().setAttribute("nosql_s", "1");
         } else {
            model.addAttribute("hadoop", "0");
            model.addAttribute("nosql", "0");
            request.getSession().setAttribute("hadoop_s", "0");
            request.getSession().setAttribute("nosql_s", "0");
         }
      }

      return step;
   }

   @RequestMapping({"/queryfiletructurename"})
   @ResponseBody
   public List<TcoreProjectFilestructureVO> queryfiletructurename(HttpServletRequest request, HttpServletResponse response) {
      String taskid = (String)request.getSession().getAttribute("taskid");
      Map<String, Object> filetructurenamelist = (Map)this.redisService.get("TdataDiscovery_taskmap" + taskid);
      List<TcoreProjectFilestructureVO> list = (List)filetructurenamelist.get("filetructurenamelist");
      return list;
   }

   public void discoverytask_two_file(Map<String, String> map, Model model) {
      model.addAttribute("editstep", map.get("editstep"));
   }

   public void discoverytask_two_nosql(Map<String, String> map, Model model) {
      model.addAttribute("editstep", map.get("editstep"));
   }

   @RequestMapping({"/queryfiletype"})
   @ResponseBody
   public List<ComboboxVO> queryfiletype() {
      List<ComboboxVO> fileTypeList = new ArrayList();
      ComboboxVO vo0 = new ComboboxVO();
      vo0.setValue("0");
      vo0.setText(".dmp");
      fileTypeList.add(vo0);
      ComboboxVO vo5 = new ComboboxVO();
      vo5.setValue("5");
      vo5.setText(".txt");
      fileTypeList.add(vo5);
      return fileTypeList;
   }

   @RequestMapping({"/queryfiletypemasking"})
   @ResponseBody
   public List<ComboboxVO> queryfiletypemasking() {
      List<ComboboxVO> fileTypeList = new ArrayList();
      ComboboxVO vo0 = new ComboboxVO();
      String systype = (String)this.redisService.get("systype");
      String ftype = (String)this.redisService.get("ftype");
      String dbtype = (String)this.redisService.get("dbtype");
      if ("1".equals(systype) && "1".equals(ftype) || "ORACLE".equals(dbtype)) {
         vo0.setValue("0");
         vo0.setText(".dmp");
         fileTypeList.add(vo0);
      }

      ComboboxVO vo2 = new ComboboxVO();
      if (!"1".equals(ftype)) {
         vo2.setValue("2");
         vo2.setText(".xls");
         fileTypeList.add(vo2);
      }

      ComboboxVO vo5 = new ComboboxVO();
      vo5.setValue("5");
      vo5.setText(".txt");
      fileTypeList.add(vo5);
      return fileTypeList;
   }

   @RequestMapping({"/querydir"})
   @ResponseBody
   public Map<String, Object> querydir(String path, String filesourceid, String filesourcetype) {
      Map<String, Object> map = new HashMap();
      List<TCoreProjectFileDetail> list = new ArrayList();
      if ("".equals(filesourceid)) {
         FileSystemTool fst = new FileSystemTool();

         try {
            FileStatus[] files = FileSystemTool.getFileByPath(path);

            for(int i = 0; i < files.length; ++i) {
               FileStatus fileStatus = files[i];
               TCoreProjectFileDetail tCoreProjectFileDetail = new TCoreProjectFileDetail();
               tCoreProjectFileDetail.setFilename(fileStatus.getPath().toString().substring(fileStatus.getPath().toString().lastIndexOf("/") + 1));
               tCoreProjectFileDetail.setIsdir(fileStatus.isDir());
               if (fileStatus.isDir()) {
                  tCoreProjectFileDetail.setFilesize(0L);
               } else {
                  tCoreProjectFileDetail.setFilesize(fileStatus.getLen());
               }

               String os = System.getProperty("os.name");
               if (os.toLowerCase().startsWith("win")) {
                  tCoreProjectFileDetail.setOwner("");
                  tCoreProjectFileDetail.setPermission("");
               } else {
                  tCoreProjectFileDetail.setOwner(files[i].getOwner());
                  tCoreProjectFileDetail.setPermission(fileStatus.getPermission().toString());
               }

               list.add(tCoreProjectFileDetail);
            }

            map.put("result", "success");
            map.put("list", list);
         } catch (Exception e) {
            e.printStackTrace();
            map.put("result", "文件路径输入错误");
         }
      } else {
         new TCoreDatasystem();
         TCoreDatasystem var19 = this.dataSystemService.queryDataSystemById(filesourceid);
         if ("FTP".equals(filesourcetype)) {
            Map<String, Object> filemap = this.tdataDiscoveryService.queryFtpdir(var19.getDbip(), Integer.parseInt(var19.getDbport()), var19.getUsername(), var19.getPassword(), path, "", var19.getPagecode());
            new ArrayList();
            if (!(Boolean)filemap.get("listresult")) {
               map.put("result", filemap.get("message"));
            } else {
               List<Map<String, String>> fileList = (List)filemap.get("list");
               for(Map<String, String> file : fileList) {
                  Pattern pattern = Pattern.compile("[^\\s]*");
                  Matcher matcher = pattern.matcher((CharSequence)file.get("detail"));
                  List<String> detaillist = new ArrayList();
                  TCoreProjectFileDetail tCoreProjectFileDetail = new TCoreProjectFileDetail();
                  tCoreProjectFileDetail.setFilename((String)file.get("name"));
                  int i = 0;

                  while(matcher.find() && i < 5) {
                     if (!"".equals(matcher.group())) {
                        detaillist.add(matcher.group());
                        ++i;
                     }
                  }

                  if ("d".equals(((String)detaillist.get(0)).substring(0, 1))) {
                     tCoreProjectFileDetail.setIsdir(true);
                     tCoreProjectFileDetail.setFilesize(0L);
                  } else {
                     tCoreProjectFileDetail.setIsdir(false);
                     tCoreProjectFileDetail.setFilesize(Long.parseLong((String)detaillist.get(4)));
                  }

                  tCoreProjectFileDetail.setPermission((String)detaillist.get(0));
                  tCoreProjectFileDetail.setOwner((String)detaillist.get(2));
                  list.add(tCoreProjectFileDetail);
               }

               map.put("result", "success");
            }

            map.put("list", list);
         } else if ("SFTP".equals(filesourcetype)) {
            Map<String, Object> filemap = this.tdataDiscoveryService.querySftpdir(path, Integer.parseInt(var19.getDbport()), var19.getDbip(), var19.getUsername(), var19.getPassword());
            Vector<ChannelSftp.LsEntry> listFiles = (Vector)filemap.get("list");
            if (!(Boolean)filemap.get("listresult")) {
               map.put("result", filemap.get("message"));
            } else {
               for(ChannelSftp.LsEntry file : listFiles) {
                  String fileName = file.getFilename();
                  String longName = file.getLongname();
                  List<String> detaillist = new ArrayList();
                  if (!".".equals(fileName) && !"..".equals(fileName) && !".".equals(fileName.substring(0, 1))) {
                     TCoreProjectFileDetail tCoreProjectFileDetail = new TCoreProjectFileDetail();
                     tCoreProjectFileDetail.setFilename(fileName);
                     Pattern pattern = Pattern.compile("[^\\s]*");
                     Matcher matcher = pattern.matcher(longName);
                     int i = 0;

                     while(matcher.find() && i < 5) {
                        if (!"".equals(matcher.group())) {
                           detaillist.add(matcher.group());
                           ++i;
                        }
                     }

                     if (!"d".equals(((String)detaillist.get(0)).substring(0, 1)) && !"l".equals(((String)detaillist.get(0)).substring(0, 1))) {
                        tCoreProjectFileDetail.setIsdir(false);
                        tCoreProjectFileDetail.setFilesize(Long.parseLong((String)detaillist.get(4)));
                     } else {
                        tCoreProjectFileDetail.setIsdir(true);
                        tCoreProjectFileDetail.setFilesize(0L);
                     }

                     tCoreProjectFileDetail.setPermission((String)detaillist.get(0));
                     tCoreProjectFileDetail.setOwner((String)detaillist.get(2));
                     list.add(tCoreProjectFileDetail);
                  }
               }

               map.put("result", "success");
            }

            map.put("list", list);
         }
      }

      return map;
   }

   @RequestMapping({"/querydirOrderByFile"})
   @ResponseBody
   public Map<String, Object> querydirOrderByFile(String path, String filesourceid, String filesourcetype) {
      Map<String, Object> map = new HashMap();
      List<TCoreProjectFileDetail> list = new ArrayList();
      List<TCoreProjectFileDetail> list_s = new ArrayList();
      if ("".equals(filesourceid)) {
         FileSystemTool fst = new FileSystemTool();

         try {
            FileStatus[] files = FileSystemTool.getFileByPath(path);

            for(int i = 0; i < files.length; ++i) {
               FileStatus fileStatus = files[i];
               TCoreProjectFileDetail tCoreProjectFileDetail = new TCoreProjectFileDetail();
               String fileName = fileStatus.getPath().toString().substring(fileStatus.getPath().toString().lastIndexOf("/") + 1);
               byte[] fileNameBytes = fileName.getBytes();
               String fileNameFinal = new String(fileNameBytes, 0, fileNameBytes.length, "utf8");
               tCoreProjectFileDetail.setFilename(fileNameFinal);
               tCoreProjectFileDetail.setIsdir(fileStatus.isDir());
               String os = System.getProperty("os.name");
               if (os.toLowerCase().startsWith("win")) {
                  tCoreProjectFileDetail.setOwner("");
                  tCoreProjectFileDetail.setPermission("");
               } else {
                  tCoreProjectFileDetail.setOwner(files[i].getOwner());
                  tCoreProjectFileDetail.setPermission(fileStatus.getPermission().toString());
               }

               if (fileStatus.isDir()) {
                  tCoreProjectFileDetail.setFilesize(0L);
                  list.add(tCoreProjectFileDetail);
               } else {
                  tCoreProjectFileDetail.setFilesize(fileStatus.getLen());
                  list_s.add(tCoreProjectFileDetail);
               }
            }

            list.addAll(list_s);
            map.put("result", "success");
            map.put("list", list);
         } catch (IOException e) {
            e.printStackTrace();
            map.put("result", "文件路径输入错误");
         } catch (Exception e) {
            e.printStackTrace();
            map.put("result", "文件路径输入错误");
         }
      } else {
         new TCoreDatasystem();
         TCoreDatasystem var21 = this.dataSystemService.queryDataSystemById(filesourceid);
         if ("FTP".equals(filesourcetype)) {
            Map<String, Object> filemap = this.tdataDiscoveryService.queryFtpdir(var21.getDbip(), Integer.parseInt(var21.getDbport()), var21.getUsername(), var21.getPassword(), path, "", var21.getPagecode());
            new ArrayList();
            if (!(Boolean)filemap.get("listresult")) {
               map.put("result", filemap.get("message"));
            } else {
               List<Map<String, String>> fileList = (List)filemap.get("list");
               for(Map<String, String> file : fileList) {
                  Pattern pattern = Pattern.compile("[^\\s]*");
                  Matcher matcher = pattern.matcher((CharSequence)file.get("detail"));
                  List<String> detaillist = new ArrayList();
                  TCoreProjectFileDetail tCoreProjectFileDetail = new TCoreProjectFileDetail();
                  tCoreProjectFileDetail.setFilename((String)file.get("name"));
                  int i = 0;

                  while(matcher.find() && i < 5) {
                     if (!"".equals(matcher.group())) {
                        detaillist.add(matcher.group());
                        ++i;
                     }
                  }

                  if ("d".equals(((String)detaillist.get(0)).substring(0, 1))) {
                     tCoreProjectFileDetail.setIsdir(true);
                     tCoreProjectFileDetail.setFilesize(0L);
                  } else {
                     tCoreProjectFileDetail.setIsdir(false);
                     tCoreProjectFileDetail.setFilesize(Long.parseLong((String)detaillist.get(4)));
                  }

                  tCoreProjectFileDetail.setPermission((String)detaillist.get(0));
                  tCoreProjectFileDetail.setOwner((String)detaillist.get(2));
                  list.add(tCoreProjectFileDetail);
               }

               map.put("result", "success");
            }

            map.put("list", list);
         } else if ("SFTP".equals(filesourcetype)) {
            Map<String, Object> filemap = this.tdataDiscoveryService.querySftpdir(path, Integer.parseInt(var21.getDbport()), var21.getDbip(), var21.getUsername(), var21.getPassword());
            Vector<ChannelSftp.LsEntry> listFiles = (Vector)filemap.get("list");
            if (!(Boolean)filemap.get("listresult")) {
               map.put("result", filemap.get("message"));
            } else {
               for(ChannelSftp.LsEntry file : listFiles) {
                  String fileName = file.getFilename();
                  String longName = file.getLongname();
                  List<String> detaillist = new ArrayList();
                  if (!".".equals(fileName) && !"..".equals(fileName) && !".".equals(fileName.substring(0, 1))) {
                     TCoreProjectFileDetail tCoreProjectFileDetail = new TCoreProjectFileDetail();
                     tCoreProjectFileDetail.setFilename(fileName);
                     Pattern pattern = Pattern.compile("[^\\s]*");
                     Matcher matcher = pattern.matcher(longName);
                     int i = 0;

                     while(matcher.find() && i < 5) {
                        if (!"".equals(matcher.group())) {
                           detaillist.add(matcher.group());
                           ++i;
                        }
                     }

                     tCoreProjectFileDetail.setPermission((String)detaillist.get(0));
                     tCoreProjectFileDetail.setOwner((String)detaillist.get(2));
                     if ("d".equals(((String)detaillist.get(0)).substring(0, 1))) {
                        tCoreProjectFileDetail.setIsdir(true);
                        tCoreProjectFileDetail.setFilesize(0L);
                        list.add(tCoreProjectFileDetail);
                     } else {
                        tCoreProjectFileDetail.setIsdir(false);
                        tCoreProjectFileDetail.setFilesize(Long.parseLong((String)detaillist.get(4)));
                        list_s.add(tCoreProjectFileDetail);
                     }
                  }
               }

               map.put("result", "success");
            }

            list.addAll(list_s);
            map.put("list", list);
         }
      }

      return map;
   }

   @RequestMapping({"/queryfilestructurelist"})
   @ResponseBody
   public List<TCoreFileStructure> queryfilestructurelist(String filegroup) {
      return this.fileSystemService.queryStructureByGroup(filegroup, "");
   }

   @RequestMapping({"/comparefilestructure"})
   @ResponseBody
   public List<TcoreProjectFilestructureVO> comparefilestructure(String filenames, String path, String filegroup, String filesourcetype, String filesource) {
      List<TcoreProjectFilestructureVO> list = new ArrayList();
      List<TCoreFileStructure> filestructureList = this.fileSystemService.queryStructureByGroup(filegroup, "");

      for(int x = 0; x < filenames.split(",").length; ++x) {
         boolean flag = true;
         TcoreProjectFilestructureVO filestructure = new TcoreProjectFilestructureVO();

         for(int y = 0; y < filestructureList.size(); ++y) {
            if (this.ismatch(filenames.split(",")[x], ((TCoreFileStructure)filestructureList.get(y)).getId(), ((TCoreFileStructure)filestructureList.get(y)).getFilestructurename(), path, ((TCoreFileStructure)filestructureList.get(y)).getSkiprows(), filesourcetype, filesource)) {
               filestructure.setFilename(filenames.split(",")[x]);
               filestructure.setFilestructureid(((TCoreFileStructure)filestructureList.get(y)).getId());
               filestructure.setFilestructure(((TCoreFileStructure)filestructureList.get(y)).getFilestructurename());
               flag = false;
               break;
            }

            if (flag) {
               filestructure.setFilename(filenames.split(",")[x]);
               filestructure.setFilestructure("");
            }
         }

         list.add(filestructure);
      }

      return list;
   }

   public boolean ismatch(String filenames, String structureid, String filestructure, String url, String skiprows, String filesourcetype, String filesource) {
      boolean flag = false;
      String filename = filenames.split("\\.")[0];
      if (filename.equals(filestructure)) {
         TCoreFileStructurespliter spliter = this.fileSystemService.queryFileStructureSpliter(structureid);
         if (spliter == null) {
            return flag;
         }

         int tructureCount = this.fileSystemService.queryFileStructureColumn(structureid).size();
         String delimiters = this.fileSystemService.queryFileStructureSpliter(structureid).getDelimiters();
         if ("LOCALFILE".equals(filesourcetype)) {
            Process process = null;

            try {
               Runtime runtime = Runtime.getRuntime();
               process = runtime.exec(new String[]{"sh", "/data/infa_file/./files.sh", url + File.separator + filename + ".txt", delimiters, Integer.toString(Integer.parseInt(skiprows) + 1)});
               BufferedReader inputStream = new BufferedReader(new InputStreamReader(process.getInputStream()));
               String line = "";

               while((line = inputStream.readLine()) != null) {
                  System.out.println("line-->" + line);
                  if (String.valueOf(tructureCount).equals(line)) {
                     flag = true;
                  }
               }

               inputStream.close();
            } catch (IOException e) {
               e.printStackTrace();
            }
         } else {
            new TCoreDatasystem();
            TCoreDatasystem var21 = this.dataSystemService.queryDataSystemById(filesource);
            int row = Integer.parseInt(skiprows) + 1;
            String os = System.getProperty("os.name");
            Process process = null;
            if (!os.toLowerCase().startsWith("win")) {
               if ("SFTP".equals(filesourcetype)) {
                  String cmd = "sed -n " + row + "p " + url + "/" + filename + ".txt | awk --field-separator=" + delimiters + "  '{ print NF}'";
                  List<String> list = CommandTool.remoteRunCmd(var21.getDbip(), Integer.parseInt(var21.getDbport()), var21.getUsername(), var21.getPassword(), cmd, var21.getPagecode());
                  if (list.size() > 0 && String.valueOf(tructureCount).equals(list.get(0))) {
                     flag = true;
                  }
               } else {
                  List<String> list = CommandTool.remoteRunCmdftp(url + "/" + filenames, var21.getDbip(), Integer.parseInt(var21.getDbport()), var21.getUsername(), var21.getPassword(), row, delimiters, var21.getPagecode());
                  if (list.size() > 0 && String.valueOf(tructureCount).equals(list.get(0))) {
                     flag = true;
                  }
               }
            }
         }
      }

      return flag;
   }

   @RequestMapping({"/queryFiledetail"})
   @ResponseBody
   public StringBuffer queryFiledetail(HttpServletRequest request, String path, String filename, String filesourcetype, String filesource) {
      String command = "cat " + path + File.separator + filename;
      StringBuffer tv_result = new StringBuffer();
      int count = 0;
      BufferedReader reader = null;
      InputStreamReader is = null;

      try {
         if ("LOCALFILE".equals(filesourcetype)) {
            Process process = null;
            process = Runtime.getRuntime().exec(command);
            String code = ReadJsonTool.charset(path + File.separator + filename);
            is = new InputStreamReader(process.getInputStream(), code);

            String line;
            for(reader = new BufferedReader(is); (line = reader.readLine()) != null && count < 5; ++count) {
               tv_result.append(line + "</br>");
            }

            System.out.println("command is :" + command);
            System.out.println("command return :" + tv_result);
            process.waitFor();
         } else if ("SFTP".equals(filesourcetype)) {
            new TCoreDatasystem();
            TCoreDatasystem var47 = this.dataSystemService.queryDataSystemById(filesource);
            InputStream dataInputStream = null;
            SFTPUtil sftp = null;
            sftp = new SFTPUtil(var47.getUsername(), var47.getPassword(), var47.getDbip(), Integer.parseInt(var47.getDbport()));
            SFTPUtil.login();
            String charset = "UTF-8";

            try {
               dataInputStream = sftp.getDataInputStream(path + File.separator + filename);
               if (dataInputStream != null) {
                  charset = ReadJsonTool.sftpCharset(dataInputStream);
                  dataInputStream.close();
                  if (sftp != null) {
                     sftp.logout();
                  }
               }
            } catch (Exception e) {
               dataInputStream.close();
               e.printStackTrace();
            }

            List<String> list = CommandTool.remoteRunCmd(var47.getDbip(), Integer.parseInt(var47.getDbport()), var47.getUsername(), var47.getPassword(), command, charset);
            if (list.size() > 5) {
               count = 5;
            } else {
               count = list.size();
            }

            for(int i = 0; i < count; ++i) {
               tv_result.append((String)list.get(i) + "</br>");
            }
         } else {
            new TCoreDatasystem();
            TCoreDatasystem var48 = this.dataSystemService.queryDataSystemById(filesource);
            List<String> list = new ArrayList();
            InputStream dataInputStream = null;
            FTPClient ftpClient = new FTPClient();
            ftpClient.setControlEncoding(var48.getPagecode());
            if (!ftpClient.isConnected()) {
               ftpClient.connect(var48.getDbip(), Integer.parseInt(var48.getDbport()));
            }

            boolean loginresult = ftpClient.login(var48.getUsername(), var48.getPassword());
            String charset = "UTF-8";

            try {
               if (loginresult) {
                  dataInputStream = FtpTool.getDataInputStream(ftpClient, path, filename, var48.getPagecode());
                  if (dataInputStream != null) {
                     charset = ReadJsonTool.sftpCharset(dataInputStream);
                     dataInputStream.close();
                     ftpClient.disconnect();
                  }
               }
            } catch (Exception e) {
               dataInputStream.close();
               e.printStackTrace();
            }

            try {
               list = FtpTool.getData(var48.getDbip(), Integer.parseInt(var48.getDbport()), var48.getUsername(), var48.getPassword(), path, filename, charset);
            } catch (NumberFormatException e) {
               e.printStackTrace();
            } catch (Exception e) {
               e.printStackTrace();
            }

            if (list.size() > 5) {
               count = 5;
            } else {
               count = list.size();
            }

            for(int i = 0; i < count; ++i) {
               tv_result.append((String)list.get(i) + "</br>");
            }
         }
      } catch (IOException e) {
         e.printStackTrace();
      } catch (InterruptedException e) {
         e.printStackTrace();
      } finally {
         if (reader != null) {
            try {
               reader.close();
            } catch (IOException e) {
               e.printStackTrace();
            }
         }

         if (is != null) {
            try {
               is.close();
            } catch (IOException e) {
               e.printStackTrace();
            }
         }

      }

      return tv_result;
   }

   @RequestMapping({"/queryFilesource"})
   @ResponseBody
   public List<ComboboxVO> queryFilesource(HttpServletRequest request, String filetype) {
      String projectid = (String)request.getSession().getAttribute("projectid");
      LoginUser loginUser = (LoginUser)request.getSession().getAttribute("loginUser");
      String userid = loginUser.getTsysUser().getId();
      return this.tdataDiscoveryService.queryfilesource(projectid, filetype, userid);
   }

   public void discoverytask_three(Map<String, String> map, HttpServletRequest request, Model model) {
      String taskid = (String)request.getSession().getAttribute("taskid");
      model.addAttribute("editstep", map.get("editstep"));
      model.addAttribute("discoverytype", map.get("discoverytype"));
      if (map.get("edittask") != null && !"".equals(map.get("edittask"))) {
         Map<String, Object> taskmap = (Map)this.redisService.get("TdataDiscovery_taskmap" + taskid);
         model.addAttribute("cyfs", taskmap.get("cyfs"));
         model.addAttribute("cys", taskmap.get("cys"));
         model.addAttribute("ppl", taskmap.get("ppl"));
         model.addAttribute("edittask", map.get("edittask"));
         this.redisService.set("TdataDiscovery_taskmap" + taskid, taskmap);
      }

      if (!"1".equals(map.get("discoverytype")) && !"3".equals(map.get("discoverytype")) && !"4".equals(map.get("discoverytype"))) {
         if ("2".equals(map.get("discoverytype"))) {
            Map<String, Object> redismap = (Map)this.redisService.get("TdataDiscovery_taskmap" + taskid);
            redismap.put("discoverytype", map.get("discoverytype"));
            redismap.put("filetype", map.get("filetype"));
            redismap.put("filesourcetype", map.get("filesourcetype"));
            redismap.put("filesource", map.get("filesource"));
            redismap.put("taskid", taskid);
            redismap.put("isknowstructure", ((String)map.get("structure")).toString());
            if ("know".equals(((String)map.get("structure")).toString())) {
               if ("0".equalsIgnoreCase((String)map.get("filetype"))) {
                  redismap.put("filename", map.get("dmpfilename"));
                  redismap.put("fileurl", map.get("dmpdirname"));
                  redismap.put("dmptype", map.get("dmptypevalue"));
                  redismap.put("dmpfiletype", map.get("dmpfiletypevalue"));
                  redismap.put("dmptablename", map.get("dmptablename"));
                  this.redisService.set("TdataDiscovery_taskmap" + taskid, redismap);
               } else if ("5".equalsIgnoreCase((String)map.get("filetype"))) {
                  redismap.put("filegroup", map.get("filegroup"));
                  redismap.put("fileurl", map.get("filedir"));
                  List<TcoreProjectFilestructureVO> list = new ArrayList();
                  String filestructurename = (String)map.get("filestructurename");

                  for(int i = 0; i < filestructurename.split(",").length; ++i) {
                     TcoreProjectFilestructureVO tcoreProjectFilestructureVO = new TcoreProjectFilestructureVO();
                     tcoreProjectFilestructureVO.setFilename(filestructurename.split(",")[i].split("#")[0]);
                     tcoreProjectFilestructureVO.setFilestructureid("undefined".equals(filestructurename.split(",")[i].split("#")[1]) ? "" : filestructurename.split(",")[i].split("#")[1]);
                     tcoreProjectFilestructureVO.setFilestructure(filestructurename.split(",")[i].split("#")[2]);
                     list.add(tcoreProjectFilestructureVO);
                  }

                  redismap.put("filetructurenamelist", list);
                  this.redisService.set("TdataDiscovery_taskmap" + taskid, redismap);
               }
            } else {
               redismap.put("fileurl", map.get("filedir"));
               this.redisService.set("TdataDiscovery_taskmap" + taskid, redismap);
            }
         }
      } else {
         Map<String, Object> redismap = (Map)this.redisService.get("TdataDiscovery_taskmap" + taskid);
         redismap.put("datasource", map.get("datasource"));
         redismap.put("discoverytype", map.get("discoverytype"));
         this.redisService.set("TdataDiscovery_taskmap" + taskid, redismap);
      }

   }

   @RequestMapping({"/queryCyfs"})
   @ResponseBody
   public List<ComboboxVO> queryCyfs(String discoverytype) {
      List<ComboboxVO> list = new ArrayList();
      if ("1".equals(discoverytype)) {
         ComboboxVO comboboxVO1 = new ComboboxVO();
         comboboxVO1.setValue("1");
         comboboxVO1.setText("顺序采样");
         ComboboxVO comboboxVO2 = new ComboboxVO();
         comboboxVO2.setValue("3");
         comboboxVO2.setText("插补法采样");
         list.add(comboboxVO1);
         list.add(comboboxVO2);
      } else {
         ComboboxVO comboboxVO = new ComboboxVO();
         comboboxVO.setValue("1");
         comboboxVO.setText("顺序采样");
         list.add(comboboxVO);
      }

      return list;
   }

   @RequestMapping({"/setTable"})
   @ResponseBody
   public void setTable(String schema, @RequestParam("table[]") List<String> table) {
      this.redisService.hmSet("TdataDiscovery_tablemap", schema, table);
   }

   @RequestMapping({"/removeTable"})
   @ResponseBody
   public void removeTable(String schema) {
      this.redisService.hmDel("TdataDiscovery_tablemap", schema);
   }

   public void createTable(String resultid) {
      StringBuilder sqlstr = new StringBuilder("CREATE TABLE R_A" + resultid + "(");
      sqlstr.append(" id varchar(100),");
      sqlstr.append(" tdatasystem_id varchar(100),");
      sqlstr.append(" tschemas varchar(100),");
      sqlstr.append(" ttables varchar(500),");
      sqlstr.append(" tfields varchar(500),");
      sqlstr.append(" tfieldremark varchar(500),");
      sqlstr.append(" tsampling varchar(100),");
      sqlstr.append(" teffe_sampling varchar(100),");
      sqlstr.append(" tmatching varchar(500),");
      sqlstr.append(" dataarea_id varchar(100),");
      sqlstr.append(" dataarea_name varchar(500),");
      sqlstr.append(" sensitive_id varchar(100),");
      sqlstr.append(" sensitive_name varchar(100),");
      sqlstr.append(" issure varchar(100),");
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("1")) {
         sqlstr.append(" correlation text,");
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("0")) {
         sqlstr.append(" correlation text(0),");
      } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
         sqlstr.append(" correlation text,");
      }

      sqlstr.append(" filestruct varchar(100),");
      sqlstr.append(" filecontent text,");
      sqlstr.append(" PRIMARY KEY (id))");
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("0")) {
         sqlstr.append(" ENGINE=InnoDB DEFAULT CHARSET=utf8");
      }

      this.tdataDiscoveryService.createsqlstr(sqlstr);
   }

   @PassToken
   @PostMapping({"/autofind"})
   @ResponseBody
   public Response autofind(@RequestBody DiscoveryParamVO discoveryParamVO) throws Exception {
      String code = discoveryParamVO.getCode();
      String schema = discoveryParamVO.getSchema();
      String tablename = discoveryParamVO.getTablename();
      List<String> fields = discoveryParamVO.getFields();
      TCoreDatasystem tCoreDatasystem = this.dataSystemService.queryDataSystemByCode(code);
      if (tCoreDatasystem == null) {
         return RespHelper.errResp(ErrCode.DATA_NOT_FOUND);
      } else {
         String datasystemid = tCoreDatasystem.getId();
         TcoreDiscoveryColumn tcoreDiscoveryColumn = this.discoverytaskService.queryTaskAndProjectBySchemaName(datasystemid, schema);
         if (tcoreDiscoveryColumn == null) {
            return RespHelper.errResp(ErrCode.DATA_NOT_FOUND);
         } else {
            String taskid = tcoreDiscoveryColumn.getTaskid();
            TcoreDiscoveryTask discoveryTask = this.tdataDiscoveryService.queryTaskByid(taskid);
            String projectid = tcoreDiscoveryColumn.getProjectid();
            List<TcoreDiscoveryColumn> tcoreDiscoveryColumns = this.tcoreDiscoveryColumnDao.queryAll(new Criterion[]{Restrictions.eq("taskid", taskid), Restrictions.eq("tschema", schema)});
            Optional<TcoreDiscoveryColumn> first = tcoreDiscoveryColumns.stream().filter((item) -> item.getTablename().equals(tablename)).findFirst();
            TcoreDiscoveryColumn column;
            if (!first.isPresent()) {
               column = new TcoreDiscoveryColumn();
               BeanUtil.copyProperties(tcoreDiscoveryColumn, column, new String[0]);
               column.setTablename(tablename);
            } else {
               column = (TcoreDiscoveryColumn)first.get();
               String sql = "select * from " + discoveryTask.getResultid() + " where tdatasystem_id= ? and tschemas= ? and ttables= ?";
               Properties props = new Properties();

               try {
                  props = PropertiesLoaderUtils.loadAllProperties("config.properties");
               } catch (IOException e) {
                  e.printStackTrace();
               }

               String driver = props.getProperty("jdbc.driver");
               String jdbcurl = props.getProperty("jdbc.url");
               String user = props.getProperty("jdbc.user");
               String password = props.getProperty("jdbc.password");

               try {
                  Connection connection = JdbcTool.getConnectionlog(driver, jdbcurl, user, password);
                  PreparedStatement pstmt = connection.prepareStatement(sql);
                  pstmt.setString(1, datasystemid);
                  pstmt.setString(2, schema);
                  pstmt.setString(3, tablename);
                  ResultSet rs = pstmt.executeQuery();
                  List<String> rfieldList = new ArrayList();

                  while(rs.next()) {
                     String field = rs.getString("tfields");
                     rfieldList.add(field);
                  }

                  if (rs != null) {
                     rs.close();
                  }

                  if (pstmt != null) {
                     pstmt.close();
                  }

                  if (connection != null) {
                     connection.close();
                  }

                  if (rfieldList.size() > 0) {
                     int cnt = 0;

                     for(String fieldname : fields) {
                        long count = rfieldList.stream().filter((rfield) -> rfield.equalsIgnoreCase(fieldname)).count();
                        if (count < 1L) {
                           break;
                        }

                        ++cnt;
                     }

                     if (cnt == fields.size()) {
                        return RespHelper.successResp();
                     }
                  }
               } catch (SQLException e) {
                  ddmauditLogger.error("ERROR", "Error found:", e);
                  throw new Exception();
               } catch (ClassNotFoundException e) {
                  ddmauditLogger.error("ERROR", "Error found:", e);
                  throw new Exception();
               }
            }

            List<TcoreDiscoveryColumn> columnList = new ArrayList();
            columnList.add(column);
            Boolean isAssignTable = true;
            String resultid = String.valueOf(System.currentTimeMillis());
            this.createTable(resultid);
            this.tdataDiscoveryService.updateAutofindResultid(taskid, "R_A" + resultid);
            this.executeDiscoverytaskService.execute(taskid, projectid, "", "", "system", isAssignTable, columnList);
            DiscoveryResultVO discoveryResultVO = new DiscoveryResultVO();
            discoveryResultVO.setNschema(schema);
            discoveryResultVO.setNtable(tablename);
            discoveryResultVO.setChecksure("2");
            discoveryResultVO.setIssensitive("0");
            discoveryResultVO.setIssure("1");
            discoveryResultVO.setNfield("");
            discoveryResultVO.setTablename(discoveryTask.getAutofindresultid());
            this.tdataDiscoveryResultService.makeDiscoverResultSureAll(discoveryResultVO);
            RqSaveEditionParamsVO vo = new RqSaveEditionParamsVO();
            String versionName = "auto";
            vo.setFlag("2");
            vo.setProjectid(projectid);
            vo.setResultid(discoveryTask.getAutofindresultid());
            vo.setTaskid(taskid);
            vo.setVersion("custom_version");
            vo.setVersionname(versionName);
            vo.setSchemaname(schema);
            vo.setTablename(tablename);
            this.tdiscoverResultController.saveEdition(vo);
            Map<String, String> param = new HashMap();
            param.put("dataSystemid", discoveryTask.getDatasystemid());
            param.put("projectid", projectid);
            param.put("versions", "CustomVersion/" + versionName);
            this.fieldScopeController.allsave(param);
            return RespHelper.successResp();
         }
      }
   }

   @PostMapping({"/add"})
   @ResponseBody
   public Response savetask(@RequestBody Map<String, Object> params, HttpServletRequest request, HttpServletResponse response, Model model) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
      String taskid = (String)params.get("taskid");
      String taskedit = "";
      if (!StringUtil.isBlank(taskid)) {
         taskedit = "edittask";
      }

      String taskname = (String)params.get("taskname");
      String remark = (String)params.get("remark");
      List<String> ruleidlist = (List)params.get("ruleidlist");
      String cyfs = (String)params.get("cyfs");
      String cys = (String)params.get("cys");
      String ppl = (String)params.get("ppl");
      String discoverytype = (String)params.get("discoverytype");
      String dataSystemId = (String)params.get("dataSystemId");
      String dataSystemName = (String)params.get("dataSystemName");
      Map<String, List<String>> schematblist = (Map)params.get("schematblist");
      String flag = (String)params.get("flag");
      String projectId = (String)params.get("projectid");
      String alltableschema = (String)params.get("alltableschema");
      if ("edittask".equals(taskedit)) {
         ddmauditLogger.info(MesUtil.getMsg("DDM_00403", new String[]{CommonUtils.loginUsername(), dataSystemName, taskname}));
      } else {
         taskid = StringTool.getTablePrimaryKey();
         ddmauditLogger.info(MesUtil.getMsg("DDM_00404", new String[]{CommonUtils.loginUsername(), dataSystemName, taskname}));
      }

      if (ruleidlist.contains("0")) {
         ruleidlist.clear();
      }

      Date nowdate = new Date();
      String resultid = "";
      resultid = String.valueOf(System.currentTimeMillis());
      Map<String, Object> taskmap = new HashMap();
      taskmap.put("taskid", taskid);
      taskmap.put("taskname", taskname);
      taskmap.put("remark", remark);
      taskmap.put("cyfs", cyfs);
      taskmap.put("cys", cys);
      taskmap.put("ppl", ppl);
      taskmap.put("ruleidlist", ruleidlist);
      taskmap.put("taskedit", taskedit);
      taskmap.put("username", CommonUtils.loginUsername());
      taskmap.put("flag", flag);
      taskmap.put("datasystemid", dataSystemId);
      taskmap.put("discoverytype", discoverytype);
      taskmap.put("alltableschema", alltableschema);
      if (!"0".equals(discoverytype) && !"2".equals(discoverytype)) {
         if ("1".equals(discoverytype)) {
            if ("edittask".equals(taskedit)) {
               this.tdataDiscoveryService.deleteTCoreProjectFile(taskid);
            }

            if ("know".equals(taskmap.get("isknowstructure").toString())) {
               if ("0".equals(taskmap.get("filetype").toString())) {
                  TCoreProjectFile tCoreProjectFile = new TCoreProjectFile();
                  tCoreProjectFile.setProject_id(projectId);
                  tCoreProjectFile.setTaskid(taskid);
                  tCoreProjectFile.setFiletype(taskmap.get("filetype").toString());
                  tCoreProjectFile.setFilesourcetype(taskmap.get("filesourcetype").toString());
                  tCoreProjectFile.setFilesource(taskmap.get("filesource").toString());
                  tCoreProjectFile.setFileurl(taskmap.get("fileurl").toString());
                  tCoreProjectFile.setFilename(taskmap.get("filename").toString());
                  tCoreProjectFile.setDmptype(taskmap.get("dmptype").toString());
                  tCoreProjectFile.setDmpfiletype(taskmap.get("dmpfiletype").toString());
                  tCoreProjectFile.setDmptables(taskmap.get("dmptablename").toString());
                  tCoreProjectFile.setIsknowstructure(taskmap.get("isknowstructure").toString());
                  this.tdataDiscoveryService.saveTCoreProjectFile(tCoreProjectFile);
               } else if ("5".equals(taskmap.get("filetype").toString())) {
                  List<TcoreProjectFilestructureVO> list = (List)taskmap.get("filetructurenamelist");

                  for(int i = 0; i < list.size(); ++i) {
                     TCoreProjectFile tCoreProjectFile = new TCoreProjectFile();
                     tCoreProjectFile.setProject_id(projectId);
                     tCoreProjectFile.setTaskid(taskid);
                     tCoreProjectFile.setFiletype(taskmap.get("filetype").toString());
                     tCoreProjectFile.setFilesourcetype(taskmap.get("filesourcetype").toString());
                     tCoreProjectFile.setFilesource(taskmap.get("filesource").toString());
                     tCoreProjectFile.setFilegroup(taskmap.get("filegroup").toString());
                     tCoreProjectFile.setFileurl(taskmap.get("fileurl").toString());
                     tCoreProjectFile.setFilename(((TcoreProjectFilestructureVO)list.get(i)).getFilename());
                     tCoreProjectFile.setFilestructureid(((TcoreProjectFilestructureVO)list.get(i)).getFilestructureid());
                     tCoreProjectFile.setFilestructure(((TcoreProjectFilestructureVO)list.get(i)).getFilestructure());
                     tCoreProjectFile.setIsknowstructure(taskmap.get("isknowstructure").toString());
                     this.tdataDiscoveryService.saveTCoreProjectFile(tCoreProjectFile);
                  }
               }
            } else {
               TCoreProjectFile tCoreProjectFile = new TCoreProjectFile();
               tCoreProjectFile.setProject_id(projectId);
               tCoreProjectFile.setTaskid(taskid);
               tCoreProjectFile.setFilesourcetype(taskmap.get("filesourcetype").toString());
               tCoreProjectFile.setFilesource(taskmap.get("filesource").toString());
               tCoreProjectFile.setFileurl(taskmap.get("fileurl").toString());
               tCoreProjectFile.setIsknowstructure(taskmap.get("isknowstructure").toString());
               this.tdataDiscoveryService.saveTCoreProjectFile(tCoreProjectFile);
            }
         }
      } else {
         if ("edittask".equals(taskedit)) {
            this.tdataDiscoveryService.delDiscoveryColumn(taskid);
         }

         StringBuilder tcoreDiscoveryColumn_sql = new StringBuilder();
         List<String> list_table = JdbcTool.sql_insert_q(new TcoreDiscoveryColumn());
         list_table.add("id");
         String sqlBase = JdbcTool.sql_insert_z(list_table, "T_CORE_DISCOVERY_COLUMN");
         tcoreDiscoveryColumn_sql.append(sqlBase);

         for(Map.Entry<String, List<String>> tblist : schematblist.entrySet()) {
            List<String> tablenameList = (List)tblist.getValue();
            for(String tablename : tablenameList) {
               TcoreDiscoveryColumn tcoreDiscoveryColumn = new TcoreDiscoveryColumn();
               tcoreDiscoveryColumn.setId(UUID.randomUUID().toString());
               tcoreDiscoveryColumn.setProjectid(projectId);
               tcoreDiscoveryColumn.setTaskid(taskid);
               tcoreDiscoveryColumn.setDatasourceid(dataSystemId);
               tcoreDiscoveryColumn.setTschema((String)tblist.getKey());
               tcoreDiscoveryColumn.setTablename(tablename);
               tcoreDiscoveryColumn.setCreatetime(nowdate);
               tcoreDiscoveryColumn_sql.append(JdbcTool.sql_insert_h_date(tcoreDiscoveryColumn, list_table));
               if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
                  this.tcoreDiscoveryColumnDao.save(tcoreDiscoveryColumn);
               }
            }
         }

         if (!HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
            this.tdataDiscoveryService.createsqlstr(tcoreDiscoveryColumn_sql.deleteCharAt(tcoreDiscoveryColumn_sql.length() - 1));
         }
      }

      this.tdataDiscoveryService.saveDiscoveryTask(taskmap, nowdate, resultid, projectId);
      if (taskedit == null || "".equals(taskedit)) {
         StringBuilder sqlstr = new StringBuilder("CREATE TABLE R_" + resultid + "(");
         if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
            sqlstr.append(" id varchar(100) PRIMARY KEY,");
            sqlstr.append(" tdatasystem_id varchar(100),");
            sqlstr.append(" tschemas varchar(100),");
            sqlstr.append(" ttables varchar(500),");
            sqlstr.append(" tfields varchar(500),");
            sqlstr.append(" tfieldremark varchar(500),");
            sqlstr.append(" tsampling varchar(100),");
            sqlstr.append(" teffe_sampling varchar(100),");
            sqlstr.append(" tmatching varchar(500),");
            sqlstr.append(" dataarea_id varchar(100),");
            sqlstr.append(" dataarea_name varchar(500),");
            sqlstr.append(" sensitive_id varchar(100),");
            sqlstr.append(" sensitive_name varchar(100),");
            sqlstr.append(" issure varchar(100),");
            sqlstr.append(" correlation text,");
            sqlstr.append(" filestruct varchar(100),");
            sqlstr.append(" filecontent text)");
         } else {
            sqlstr.append(" id varchar(100),");
            sqlstr.append(" tdatasystem_id varchar(100),");
            sqlstr.append(" tschemas varchar(100),");
            sqlstr.append(" ttables varchar(500),");
            sqlstr.append(" tfields varchar(500),");
            sqlstr.append(" tfieldremark varchar(500),");
            sqlstr.append(" tsampling varchar(100),");
            sqlstr.append(" teffe_sampling varchar(100),");
            sqlstr.append(" tmatching varchar(500),");
            sqlstr.append(" dataarea_id varchar(100),");
            sqlstr.append(" dataarea_name varchar(500),");
            sqlstr.append(" sensitive_id varchar(100),");
            sqlstr.append(" sensitive_name varchar(100),");
            sqlstr.append(" issure varchar(100),");
            if (HibernateConfig.PEIZHIKUDBTYPE.equals("0")) {
               sqlstr.append(" correlation text(0),");
            } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("1")) {
               sqlstr.append(" correlation text,");
            } else if (HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
               sqlstr.append(" correlation text,");
            }

            sqlstr.append(" filestruct varchar(100),");
            sqlstr.append(" filecontent text,");
            sqlstr.append(" PRIMARY KEY (id))");
            if (HibernateConfig.PEIZHIKUDBTYPE.equals("0")) {
               sqlstr.append(" ENGINE=InnoDB DEFAULT CHARSET=utf8");
            }
         }

         this.tdataDiscoveryService.createsqlstr(sqlstr);
      }

      return RespHelper.successResp();
   }

   @ResponseBody
   @PostMapping({"/query"})
   public Response queryTask(@RequestBody Map<String, Object> params, HttpServletResponse res) {
      Integer page = (Integer)params.get("pageno");
      Integer rows = (Integer)params.get("pagesize");
      String project = (String)params.get("project");
      String projectid = (String)params.get("projectid");
      String dataSystemId = (String)params.get("dataSystemid");
      String taskname = (String)params.get("taskname");
      ddmauditLogger.info(MesUtil.getMsg("DDM_02001", new String[]{CommonUtils.loginUsername(), project}));
      PageInfo pageInfo = new PageInfo();
      pageInfo.setPageno(page);
      pageInfo.setPagesize(rows);
      List<TcoreDiscoveryTask> tcoreDiscoveryTaskList = this.discoverytaskService.queryDiscoverytasklist(pageInfo, projectid, taskname);
      this.tdataDiscoveryService.queryCountRes(tcoreDiscoveryTaskList);
      return RespHelper.updateResp(pageInfo, tcoreDiscoveryTaskList);
   }

   @ResponseBody
   @GetMapping({"/initEdit"})
   public Response queryTaskById(@RequestParam String taskid) {
      TcoreDiscoveryTask tcoreDiscoveryTask = this.discoverytaskService.get(taskid);
      TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(tcoreDiscoveryTask.getDatasystemid());
      List<TcoreDiscoveryColumn> tcoreDiscoveryColumns = this.tdataDiscoveryService.queryDiscoveryColumn(taskid);
      List<TcoreDiscoveryColumn> resultDataList = new ArrayList();
      List<TcoreDiscoveryColumn> removeDataList = new ArrayList();
      if (StringUtils.isNotBlank(tcoreDiscoveryTask.getAlltableschema())) {
         String[] schemas = tcoreDiscoveryTask.getAlltableschema().split("-");

         for(int i = 0; i < schemas.length; ++i) {
            String schema = schemas[i];
            List<TcoreDiscoveryColumn> collect = (List)tcoreDiscoveryColumns.stream().filter((n) -> n.getTschema().equals(schema)).collect(Collectors.toList());
            removeDataList.addAll(collect);
            List<String> allTableName = new ArrayList();
            if ("ES".equals(tCoreDatasystem.getDbtype())) {
               EsUtil esUtil = new EsUtil();
               allTableName = esUtil.getESType(tCoreDatasystem.getDbip(), tCoreDatasystem.getDbport(), schema);
            } else if ("MONGODB".equals(tCoreDatasystem.getDbtype())) {
               try {
                  MongoClient client = MongodbTool.connect(tCoreDatasystem.getDbservername(), tCoreDatasystem.getUsername(), AesTool.decrypt(tCoreDatasystem.getPassword(), "ghca"), tCoreDatasystem.getDbip(), Integer.parseInt(tCoreDatasystem.getDbport()), true);
                  allTableName = MongodbTool.findAllTables(client, schema);
               } catch (Exception e) {
                  e.printStackTrace();
               }
            } else {
               Connection connection = JdbcTool.getConnection(tCoreDatasystem);
               allTableName = JdbcTool.getAllTableName(connection, schema);
            }

            allTableName.forEach((item) -> {
               TcoreDiscoveryColumn column = new TcoreDiscoveryColumn();
               column.setTablename(item);
               column.setDatasourceid(tcoreDiscoveryTask.getDatasystemid());
               column.setProjectid(tcoreDiscoveryTask.getProjectid());
               column.setTaskid(tcoreDiscoveryTask.getId());
               column.setTschema(schema);
               resultDataList.add(column);
            });
         }

         tcoreDiscoveryColumns.removeAll(removeDataList);
         tcoreDiscoveryColumns.addAll(resultDataList);
      }

      List<TcoreTaskFindrule> tcoreTaskFindrules = this.tdataDiscoveryService.queryFindrulelist(taskid);
      ddmauditLogger.info(MesUtil.getMsg("DDM_00402", new String[]{CommonUtils.loginUsername(), this.dataSystemService.queryDataSystemById(tcoreDiscoveryTask.getDatasystemid()).getDblinkname()}));
      Map<String, Object> map = new HashMap();
      map.put("taskinfo", tcoreDiscoveryTask);
      map.put("datalist", tcoreDiscoveryColumns);
      map.put("rulelist", tcoreTaskFindrules);
      return RespHelper.successResp(map);
   }

   @ResponseBody
   @PostMapping({"/del"})
   public Response deleteDiscoverytask(@RequestBody Map<String, Object> params) {
      String taskid = (String)params.get("taskid");
      String dataSystemName = (String)params.get("dataSystemName");
      TcoreDiscoveryTask task = this.discoverytaskService.get(taskid);
      ddmauditLogger.info(MesUtil.getMsg("DDM_00405", new String[]{CommonUtils.loginUsername(), dataSystemName, task.getTname()}));
      this.discoverytaskService.deleteDiscoverytask(taskid, task.getResultid());
      return RespHelper.successResp();
   }

   @ResponseBody
   @PostMapping({"/querySchemas"})
   public Response querySchemas(@RequestBody Map<String, Object> params, HttpServletRequest request, HttpServletResponse response, Model model) throws SQLException, IOException, ClassNotFoundException {
      String dbType = (String)params.get("dbType");
      String dataSystemId = (String)params.get("dataSystemId");
      String dataSystemname = (String)params.get("dataSystemname");
      String taskname = (String)params.get("taskname");
      List<ComboboxVO> listvo = this.dataSystemService.queryshemas(dbType, dataSystemId);
      String filtername = (String)params.get("filtername");
      if (!StringUtil.isBlank(filtername)) {
         listvo = (List)listvo.stream().filter((x) -> x.getValue().indexOf(filtername) > 0).collect(Collectors.toList());
      }

      handleprocessLogger.info(MesUtil.getMsg("DDM_01201", new String[]{CommonUtils.loginUsername(), dataSystemname == null ? "" : dataSystemname, taskname}));
      return RespHelper.successResp(listvo);
   }

   @ResponseBody
   @PostMapping({"/getSchemaList"})
   public Response getSchemaList(@RequestBody Map<String, Object> params, HttpServletRequest request, HttpServletResponse response, Model model) throws SQLException, IOException, ClassNotFoundException {
      String projectid = (String)params.get("projectid");
      String dataSystemId = (String)params.get("dataSystemId");
      String dataSystemname = (String)params.get("dataSystemname");
      String taskname = (String)params.get("taskname");
      List<ComboboxVO> listvo = this.dataSystemService.getSchemaList(projectid, dataSystemId);
      String filtername = (String)params.get("filtername");
      if (!StringUtil.isBlank(filtername)) {
         listvo = (List)listvo.stream().filter((x) -> x.getValue().indexOf(filtername) > 0).collect(Collectors.toList());
      }

      handleprocessLogger.info(MesUtil.getMsg("DDM_01201", new String[]{CommonUtils.loginUsername(), dataSystemname == null ? "" : dataSystemname, taskname}));
      return RespHelper.successResp(listvo);
   }

   public static String getExceptionSrintStackTrace(Exception e) {
      StringWriter sw = new StringWriter();
      PrintWriter pw = new PrintWriter(sw);
      e.printStackTrace(pw);
      return sw.toString();
   }

   @ResponseBody
   @RequestMapping({"/removeRedis"})
   public void removeRedis() {
      this.redisService.remove("TdataDiscovery_tablemap");
   }

   @ResponseBody
   @PostMapping({"/queryTable"})
   public Response queryTable(@RequestBody Map<String, Object> params, HttpServletRequest request, HttpServletResponse response, Model model) {
      String dataSystemId = (String)params.get("dataSystemId");
      String dataSystemname = (String)params.get("dataSystemname");
      String taskname = (String)params.get("taskname");
      String schema = (String)params.get("schema");
      List<DBTableVO> listvo = this.dataSystemService.queryTablename(dataSystemId, schema);
      String tablename = (String)params.get("tablename");
      if (!StringUtil.isBlank(tablename)) {
         listvo = (List)listvo.stream().filter((x) -> x.getTablename().indexOf(tablename) > 0).collect(Collectors.toList());
      }

      listvo.sort((a, b) -> a.getTablename().compareTo(b.getTablename()));
      handleprocessLogger.info(MesUtil.getMsg("DDM_01202", new String[]{CommonUtils.loginUsername(), dataSystemname, taskname, schema}));
      return RespHelper.successResp(listvo);
   }

   public static Boolean columnnameLikeMethod(String name, String columnname) {
      String eColumnname = columnname.replace("%", "");
      if (columnname.contains("%")) {
         if (columnname.endsWith("%") && columnname.startsWith("%")) {
            return name.contains(eColumnname);
         }

         if (columnname.endsWith("%")) {
            return name.startsWith(eColumnname);
         }

         if (columnname.startsWith("%")) {
            return name.endsWith(eColumnname);
         }
      }

      return name.equals(eColumnname);
   }

   @ResponseBody
   @RequestMapping({"/queryDiscoveryTask"})
   public TcoreDiscoveryTask queryDiscoveryTask(String taskid, LoginUser user) {
      TcoreDiscoveryTask tcoreDiscoveryTask = this.tdataDiscoveryService.queryTaskByid(taskid);
      String tname = tcoreDiscoveryTask.getTname();
      TConsoleLog record = new TConsoleLog();
      String username = user.getTsysUser().getUsername();
      record.setUser(username);
      record.setLogmessage("编辑敏感数据发现任务");
      record.setModule("敏感数据发现");
      record.setOperationtime(new Date());
      record.setOperationObject(tname);
      this.operationService.add(record);
      return tcoreDiscoveryTask;
   }

   @ResponseBody
   public TcoreDiscoveryTask queryDiscoveryTask(String taskid) {
      TcoreDiscoveryTask tcoreDiscoveryTask = this.tdataDiscoveryService.queryTaskByid(taskid);
      return tcoreDiscoveryTask;
   }

   @ResponseBody
   @RequestMapping({"/queryProjectVersion"})
   public List<String> queryProjectVersion(String taskid) {
      String taskname = this.queryDiscoveryTask(taskid).getTname();
      List<String> list = new ArrayList();
      String str = "";
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      File file = new File(props.getProperty("TaskVersion") + taskid);
      File[] f = file.listFiles();

      for(int i = 0; i < f.length; ++i) {
         SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
         str = f[i].getName().split(".txt")[0];
         String time = simpleDateFormat.format(new Date(Long.parseLong(str.split("_")[0] + "000")));
         String userid = str.split("_")[1];
         String username = this.userService.queryByUserid(userid).getUsername();
         list.add(time + "," + username + "," + taskname + "," + f[i].getName());
      }

      new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      return list;
   }

   @ResponseBody
   @RequestMapping({"/initExecute"})
   public Response<Map<String, Object>> initExecute(@RequestParam("taskid") String taskid, @RequestParam("projectid") String projectid) {
      Map<String, Object> map = new HashMap();
      List<Map<String, String>> taskversionlist = new ArrayList();
      Map<String, String> projectversion = new HashMap();
      Map<String, String> allversion = new HashMap();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      File taskfile = new File(props.getProperty("TaskVersion"));
      File projectfile = new File(props.getProperty("ProjectVersion"));
      File allfile = new File(props.getProperty("AllVersion"));
      if (!taskfile.exists()) {
         taskfile.mkdirs();
      }

      if (!projectfile.exists()) {
         projectfile.mkdirs();
      }

      if (!allfile.exists()) {
         allfile.mkdirs();
      }

      taskfile = new File(props.getProperty("TaskVersion") + taskid);
      projectfile = new File(props.getProperty("ProjectVersion") + projectid);
      String str = "";
      if (taskfile.listFiles() != null) {
         File[] f = taskfile.listFiles();

         for(int i = 0; i < f.length; ++i) {
            str = f[i].getName().split("\\.txt")[0];
            String username = str.substring(str.lastIndexOf("_") + 1);
            String s = str.replace("_" + username, "");
            String datetime = s.substring(s.lastIndexOf("_") + 1);
            String versionname = s.replace("_" + datetime, "");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String sd = sdf.format(new Date(Long.parseLong(datetime + "000")));
            Map<String, String> map1 = new HashMap();
            map1.put("versionname", versionname);
            map1.put("datetime", sd);
            map1.put("username", username);
            map1.put("filename", f[i].getName());
            taskversionlist.add(map1);
         }
      }

      if (projectfile.listFiles() != null && projectfile.listFiles().length > 0) {
         str = projectfile.listFiles()[0].getName().split("\\.txt")[0];
         String username = str.substring(str.lastIndexOf("_") + 1);
         String s = str.replace("_" + username, "");
         String datetime = s.substring(s.lastIndexOf("_") + 1);
         String versionname = s.replace("_" + datetime, "");
         SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
         String sd = sdf.format(new Date(Long.parseLong(datetime + "000")));
         projectversion.put("versionname", versionname);
         projectversion.put("datetime", sd);
         projectversion.put("username", username);
         projectversion.put("filename", projectfile.listFiles()[0].getName());
      }

      if (allfile.listFiles() != null && allfile.listFiles().length > 0) {
         str = allfile.listFiles()[0].getName().split("\\.txt")[0];
         String username = str.substring(str.lastIndexOf("_") + 1);
         String s = str.replace("_" + username, "");
         String datetime = s.substring(s.lastIndexOf("_") + 1);
         String versionname = s.replace("_" + datetime, "");
         SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
         String sd = sdf.format(new Date(Long.parseLong(datetime + "000")));
         allversion.put("versionname", versionname);
         allversion.put("datetime", sd);
         allversion.put("username", username);
         allversion.put("filename", allfile.listFiles()[0].getName());
      }

      map.put("all_version", allversion);
      map.put("project_version", projectversion);
      map.put("task_version", taskversionlist);
      return RespHelper.<Map<String, Object>>successResp(map);
   }

   @ResponseBody
   @GetMapping({"/getfilterlist"})
   public Response getFilterList(@RequestParam("data") String data, @RequestParam("taskid") String taskid) throws ParseException, IOException {
      String[] fileName = data.split(",");
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String[] v1 = fileName[0].split("_");
      String filename1 = "";
      Calendar calendar = Calendar.getInstance();
      calendar.setTime((new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).parse(v1[1]));
      filename1 = v1[0] + "_" + calendar.getTimeInMillis() / 1000L + "_" + v1[2];
      String[] v2 = fileName[1].split("_");
      String filename2 = "";
      Calendar calendar2 = Calendar.getInstance();
      calendar2.setTime((new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).parse(v2[1]));
      filename2 = v2[0] + "_" + calendar2.getTimeInMillis() / 1000L + "_" + v2[2];
      File file1 = new File(props.getProperty("TaskVersion") + taskid + File.separator + filename1 + ".txt");
      File file2 = new File(props.getProperty("TaskVersion") + taskid + File.separator + filename2 + ".txt");
      InputStreamReader read1 = new InputStreamReader(new FileInputStream(file1), "GBK");
      InputStreamReader read2 = new InputStreamReader(new FileInputStream(file2), "GBK");
      BufferedReader newBufferedReader1 = new BufferedReader(read1);
      BufferedReader newBufferedReader2 = new BufferedReader(read2);
      String informationLine1 = "";
      String informationLine2 = "";
      String[] temp1 = null;
      String[] temp2 = null;
      new HashMap();
      Set<String> set = new HashSet();

      while((informationLine1 = newBufferedReader1.readLine()) != null) {
         temp1 = informationLine1.split(",", -1);
         String key = temp1[0] + "#" + temp1[1] + "#" + temp1[2];
         set.add(key);
      }

      while((informationLine2 = newBufferedReader2.readLine()) != null) {
         temp2 = informationLine2.split(",", -1);
         String key = temp2[0] + "#" + temp2[1] + "#" + temp2[2];
         set.add(key);
      }

      List<Map<String, String>> list = new ArrayList();

      for(String s : set) {
         Map<String, String> map = new HashMap();
         String[] split = s.split("#");
         map.put("schema", split[0]);
         map.put("table", split[1]);
         map.put("column", split[2]);
         list.add(map);
      }

      Map<String, Map<String, Set<String>>> relist = new HashMap();
      Map<String, List<Map<String, String>>> collect = (Map)list.stream().collect(Collectors.groupingBy((ex) -> (String)ex.get("schema")));
      collect.forEach((key, value) -> {
         Set<String> table = (Set)value.stream().map((x) -> (String)x.get("table")).collect(Collectors.toSet());
         Map<String, Set<String>> map = new HashMap();
         table.forEach((tablename) -> {
            Set<String> column = (Set)value.stream().filter((x) -> ((String)x.get("schema")).equals(key) && ((String)x.get("table")).equals(tablename)).map((x) -> (String)x.get("column")).collect(Collectors.toSet());
            map.put(tablename, column);
         });
         relist.put(key, map);
      });
      return RespHelper.successResp(relist);
   }

   @ResponseBody
   @PostMapping({"/contrastProject"})
   public Response contrastProject(@RequestBody Map<String, Object> params) throws Exception {
      String data = (String)params.get("data");
      String taskid = (String)params.get("taskid");
      Integer page = (Integer)params.get("page");
      Integer rows = (Integer)params.get("rows");
      String schema = (String)params.get("schema");
      String table = (String)params.get("table");
      String column = (String)params.get("column");
      String showdisf = (String)params.get("showdisf");
      PageInfo pageInfo = new PageInfo();
      if (!"".equals(data) && !"".equals(taskid)) {
         List<TCoreProjectVersionCompareVO> list = new ArrayList();
         String[] fileName = data.split(",");
         Properties props = new Properties();

         try {
            props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         } catch (IOException e) {
            e.printStackTrace();
         }

         String[] v1 = fileName[0].split("_");
         String filename1 = "";
         Calendar calendar = Calendar.getInstance();
         calendar.setTime((new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).parse(v1[1]));
         filename1 = v1[0] + "_" + calendar.getTimeInMillis() / 1000L + "_" + v1[2];
         String[] v2 = fileName[1].split("_");
         String filename2 = "";
         Calendar calendar2 = Calendar.getInstance();
         calendar2.setTime((new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")).parse(v2[1]));
         filename2 = v2[0] + "_" + calendar2.getTimeInMillis() / 1000L + "_" + v2[2];
         File file1 = new File(props.getProperty("TaskVersion") + taskid + File.separator + filename1 + ".txt");
         File file2 = new File(props.getProperty("TaskVersion") + taskid + File.separator + filename2 + ".txt");
         InputStreamReader read1 = new InputStreamReader(new FileInputStream(file1), "GBK");
         InputStreamReader read2 = new InputStreamReader(new FileInputStream(file2), "GBK");
         BufferedReader newBufferedReader1 = new BufferedReader(read1);
         BufferedReader newBufferedReader2 = new BufferedReader(read2);
         String informationLine1 = "";
         String informationLine2 = "";
         String[] temp1 = null;
         String[] temp2 = null;
         Map<String, String> map1 = new HashMap();
         Map<String, String> map2 = new HashMap();

         while((informationLine1 = newBufferedReader1.readLine()) != null) {
            temp1 = informationLine1.split(",", -1);
            String key = temp1[0] + "#" + temp1[1] + "#" + temp1[2];
            map1.put(key, temp1[4] + "#" + temp1[6] + "#" + temp1[7]);
         }

         while((informationLine2 = newBufferedReader2.readLine()) != null) {
            temp2 = informationLine2.split(",", -1);
            String key = temp2[0] + "#" + temp2[1] + "#" + temp2[2];
            map2.put(key, temp2[4] + "#" + temp2[6] + "#" + temp2[7]);
         }

         for(Map.Entry<String, String> entry : map2.entrySet()) {
            TCoreProjectVersionCompareVO tCoreProjectVersionCompareVO = new TCoreProjectVersionCompareVO();
            String dataarea1 = map1.get(entry.getKey()) != null && ((String)map1.get(entry.getKey())).split("#")[0] != null && !"".equals(((String)map1.get(entry.getKey())).split("#")[0]) ? ((String)map1.get(entry.getKey())).split("#")[0] : "无";
            String maskingrule1 = map1.get(entry.getKey()) != null && ((String)map1.get(entry.getKey())).split("#")[1] != null && !"".equals(((String)map1.get(entry.getKey())).split("#")[1]) ? ((String)map1.get(entry.getKey())).split("#")[1] : "无";
            String issure1 = map1.get(entry.getKey()) != null && ((String)map1.get(entry.getKey())).split("#")[2] != null && !"".equals(((String)map1.get(entry.getKey())).split("#")[2]) ? ((String)map1.get(entry.getKey())).split("#")[2] : "无";
            String dataarea2 = ((String)entry.getValue()).split("#")[0] != null && !"".equals(((String)entry.getValue()).split("#")[0]) ? ((String)entry.getValue()).split("#")[0] : "无";
            String maskingrule2 = ((String)entry.getValue()).split("#")[1] != null && !"".equals(((String)entry.getValue()).split("#")[1]) ? ((String)entry.getValue()).split("#")[1] : "无";
            String issure2 = ((String)entry.getValue()).split("#")[2] != null && !"".equals(((String)entry.getValue()).split("#")[2]) ? ((String)entry.getValue()).split("#")[2] : "无";
            String black1 = "";
            String white1 = "";
            String black2 = "";
            String white2 = "";
            tCoreProjectVersionCompareVO.setSchemaName(((String)entry.getKey()).split("#")[0]);
            tCoreProjectVersionCompareVO.setTableName(((String)entry.getKey()).split("#")[1]);
            tCoreProjectVersionCompareVO.setColumnName(((String)entry.getKey()).split("#")[2]);
            if (map1.containsKey(entry.getKey())) {
               if (!dataarea1.equals(dataarea2)) {
                  if ("1".equals(issure1)) {
                     issure1 = "确认";
                     black1 = "未确认";
                     white1 = "未确认";
                  } else if ("2".equals(issure1)) {
                     issure1 = "未确认";
                     black1 = "未确认";
                     white1 = "确认";
                  } else if ("3".equals(issure1)) {
                     issure1 = "未确认";
                     black1 = "确认";
                     white1 = "未确认";
                  }

                  if ("1".equals(issure2)) {
                     issure2 = "确认";
                     black2 = "未确认";
                     white2 = "未确认";
                  } else if ("2".equals(issure2)) {
                     issure2 = "未确认";
                     black2 = "未确认";
                     white2 = "确认";
                  } else if ("3".equals(issure2)) {
                     issure2 = "未确认";
                     black2 = "确认";
                     white2 = "未确认";
                  }

                  if (dataarea1.equals(dataarea2)) {
                     tCoreProjectVersionCompareVO.setDataareaName1(dataarea1 + "#" + 0);
                     tCoreProjectVersionCompareVO.setDataareaName2(dataarea2 + "#" + 0);
                  } else {
                     tCoreProjectVersionCompareVO.setDataareaName1(dataarea1 + "#" + 1);
                     tCoreProjectVersionCompareVO.setDataareaName2(dataarea2 + "#" + 1);
                  }

                  if (maskingrule1.equals(maskingrule2)) {
                     tCoreProjectVersionCompareVO.setSensitiveName1(maskingrule1 + "#" + 0);
                     tCoreProjectVersionCompareVO.setSensitiveName2(maskingrule2 + "#" + 0);
                  } else {
                     tCoreProjectVersionCompareVO.setSensitiveName1(maskingrule1 + "#" + 1);
                     tCoreProjectVersionCompareVO.setSensitiveName2(maskingrule2 + "#" + 1);
                  }

                  if (issure1.equals(issure2)) {
                     tCoreProjectVersionCompareVO.setIssure1(issure1 + "#" + 0);
                     tCoreProjectVersionCompareVO.setIssure2(issure2 + "#" + 0);
                  } else {
                     tCoreProjectVersionCompareVO.setIssure1(issure1 + "#" + 1);
                     tCoreProjectVersionCompareVO.setIssure2(issure2 + "#" + 1);
                  }

                  if (black1.equals(black2)) {
                     tCoreProjectVersionCompareVO.setBlack1(black1 + "#" + 0);
                     tCoreProjectVersionCompareVO.setBlack2(black2 + "#" + 0);
                  } else {
                     tCoreProjectVersionCompareVO.setBlack1(black1 + "#" + 1);
                     tCoreProjectVersionCompareVO.setBlack2(black2 + "#" + 1);
                  }

                  if (white1.equals(white2)) {
                     tCoreProjectVersionCompareVO.setWhite1(white1 + "#" + 0);
                     tCoreProjectVersionCompareVO.setWhite2(white2 + "#" + 0);
                  } else {
                     tCoreProjectVersionCompareVO.setWhite1(white1 + "#" + 1);
                     tCoreProjectVersionCompareVO.setWhite2(white2 + "#" + 1);
                  }

                  tCoreProjectVersionCompareVO.setIsdiff("1");
                  list.add(tCoreProjectVersionCompareVO);
               } else {
                  if ("1".equals(issure1)) {
                     issure1 = "确认";
                     black1 = "未确认";
                     white1 = "未确认";
                  } else if ("2".equals(issure1)) {
                     issure1 = "未确认";
                     black1 = "未确认";
                     white1 = "确认";
                  } else if ("3".equals(issure1)) {
                     issure1 = "未确认";
                     black1 = "确认";
                     white1 = "未确认";
                  }

                  if ("1".equals(issure2)) {
                     issure2 = "确认";
                     black2 = "未确认";
                     white2 = "未确认";
                  } else if ("2".equals(issure2)) {
                     issure2 = "未确认";
                     black2 = "未确认";
                     white2 = "确认";
                  } else if ("3".equals(issure2)) {
                     issure2 = "未确认";
                     black2 = "确认";
                     white2 = "未确认";
                  }

                  tCoreProjectVersionCompareVO.setDataareaName1(dataarea1 + "#" + 0);
                  tCoreProjectVersionCompareVO.setDataareaName2(dataarea2 + "#" + 0);
                  tCoreProjectVersionCompareVO.setSensitiveName1(maskingrule1 + "#" + 0);
                  tCoreProjectVersionCompareVO.setSensitiveName2(maskingrule2 + "#" + 0);
                  tCoreProjectVersionCompareVO.setSensitiveName1(maskingrule1 + "#" + 0);
                  tCoreProjectVersionCompareVO.setSensitiveName2(maskingrule2 + "#" + 0);
                  tCoreProjectVersionCompareVO.setIssure1(issure1 + "#" + 0);
                  tCoreProjectVersionCompareVO.setIssure2(issure2 + "#" + 0);
                  tCoreProjectVersionCompareVO.setBlack1(black1 + "#" + 0);
                  tCoreProjectVersionCompareVO.setBlack2(black2 + "#" + 0);
                  tCoreProjectVersionCompareVO.setWhite1(white1 + "#" + 0);
                  tCoreProjectVersionCompareVO.setWhite2(white2 + "#" + 0);
                  tCoreProjectVersionCompareVO.setIsdiff("0");
                  list.add(tCoreProjectVersionCompareVO);
               }
            } else {
               if ("无".equals(dataarea2)) {
                  tCoreProjectVersionCompareVO.setDataareaName1("无#0");
                  tCoreProjectVersionCompareVO.setDataareaName2("无#0");
               } else {
                  tCoreProjectVersionCompareVO.setDataareaName1("无#1");
                  tCoreProjectVersionCompareVO.setDataareaName2(dataarea2 + "#1");
               }

               if ("无".equals(maskingrule2)) {
                  tCoreProjectVersionCompareVO.setSensitiveName1("无#0");
                  tCoreProjectVersionCompareVO.setSensitiveName2("无#0");
               } else {
                  tCoreProjectVersionCompareVO.setSensitiveName1("无#1");
                  tCoreProjectVersionCompareVO.setSensitiveName2(maskingrule2 + "#1");
               }

               if ("1".equals(issure2)) {
                  tCoreProjectVersionCompareVO.setIssure1("未确认#1");
                  tCoreProjectVersionCompareVO.setIssure2("确认#1");
                  tCoreProjectVersionCompareVO.setBlack1("未确认#0");
                  tCoreProjectVersionCompareVO.setBlack2("未确认#0");
                  tCoreProjectVersionCompareVO.setWhite1("未确认#0");
                  tCoreProjectVersionCompareVO.setWhite2("未确认#0");
               } else if ("2".equals(issure2)) {
                  tCoreProjectVersionCompareVO.setIssure1("未确认#0");
                  tCoreProjectVersionCompareVO.setIssure2("未确认#0");
                  tCoreProjectVersionCompareVO.setBlack1("未确认#0");
                  tCoreProjectVersionCompareVO.setBlack2("未确认#0");
                  tCoreProjectVersionCompareVO.setWhite1("未确认#1");
                  tCoreProjectVersionCompareVO.setWhite2("确认#1");
               } else if ("3".equals(issure2)) {
                  tCoreProjectVersionCompareVO.setIssure1("未确认#0");
                  tCoreProjectVersionCompareVO.setIssure2("未确认#0");
                  tCoreProjectVersionCompareVO.setBlack1("未确认#1");
                  tCoreProjectVersionCompareVO.setBlack2("确认#1");
                  tCoreProjectVersionCompareVO.setWhite1("未确认#0");
                  tCoreProjectVersionCompareVO.setWhite2("未确认#0");
               }

               tCoreProjectVersionCompareVO.setIsdiff("1");
               list.add(tCoreProjectVersionCompareVO);
            }
         }

         for(Map.Entry<String, String> entry : map1.entrySet()) {
            TCoreProjectVersionCompareVO tCoreProjectVersionCompareVO = new TCoreProjectVersionCompareVO();
            if (!map2.containsKey(entry.getKey())) {
               String dataarea1 = "".equals(((String)entry.getValue()).split("#")[0]) ? "" : ((String)entry.getValue()).split("#")[0];
               String maskingrule1 = "".equals(((String)entry.getValue()).split("#")[1]) ? "" : ((String)entry.getValue()).split("#")[1];
               String issure1 = "".equals(((String)entry.getValue()).split("#")[2]) ? "" : ((String)entry.getValue()).split("#")[2];
               tCoreProjectVersionCompareVO.setSchemaName(((String)entry.getKey()).split("#")[0]);
               tCoreProjectVersionCompareVO.setTableName(((String)entry.getKey()).split("#")[1]);
               tCoreProjectVersionCompareVO.setColumnName(((String)entry.getKey()).split("#")[2]);
               if ("".equals(dataarea1)) {
                  tCoreProjectVersionCompareVO.setDataareaName1("无#0");
                  tCoreProjectVersionCompareVO.setDataareaName2("无#0");
               } else {
                  tCoreProjectVersionCompareVO.setDataareaName1(dataarea1 + "#" + 1);
                  tCoreProjectVersionCompareVO.setDataareaName2("无#1");
               }

               if ("".equals(maskingrule1)) {
                  tCoreProjectVersionCompareVO.setSensitiveName1("无#0");
                  tCoreProjectVersionCompareVO.setSensitiveName2("无#0");
               } else {
                  tCoreProjectVersionCompareVO.setSensitiveName1(maskingrule1 + "#" + 1);
                  tCoreProjectVersionCompareVO.setSensitiveName2("无#1");
               }

               if ("1".equals(issure1)) {
                  tCoreProjectVersionCompareVO.setIssure1("确认#1");
                  tCoreProjectVersionCompareVO.setIssure2("未确认#1");
                  tCoreProjectVersionCompareVO.setBlack1("未确认#0");
                  tCoreProjectVersionCompareVO.setBlack2("未确认#0");
                  tCoreProjectVersionCompareVO.setWhite1("未确认#0");
                  tCoreProjectVersionCompareVO.setWhite2("未确认#0");
               } else if ("2".equals(issure1)) {
                  tCoreProjectVersionCompareVO.setIssure1("未确认#0");
                  tCoreProjectVersionCompareVO.setIssure2("未确认#0");
                  tCoreProjectVersionCompareVO.setBlack1("未确认#0");
                  tCoreProjectVersionCompareVO.setBlack2("未确认#0");
                  tCoreProjectVersionCompareVO.setWhite1("确认#1");
                  tCoreProjectVersionCompareVO.setWhite2("未确认#1");
               } else if ("3".equals(issure1)) {
                  tCoreProjectVersionCompareVO.setIssure1("未确认#0");
                  tCoreProjectVersionCompareVO.setIssure2("未确认#0");
                  tCoreProjectVersionCompareVO.setBlack1("确认#1");
                  tCoreProjectVersionCompareVO.setBlack2("未确认#1");
                  tCoreProjectVersionCompareVO.setWhite1("未确认#0");
                  tCoreProjectVersionCompareVO.setWhite2("未确认#0");
               }

               tCoreProjectVersionCompareVO.setIsdiff("1");
               list.add(tCoreProjectVersionCompareVO);
            }
         }

         if (!StringUtil.isBlank(schema)) {
            list = (List)list.stream().filter((x) -> schema.equals(x.getSchemaName())).collect(Collectors.toList());
         }

         if (!StringUtil.isBlank(table)) {
            list = (List)list.stream().filter((x) -> table.equals(x.getTableName())).collect(Collectors.toList());
         }

         if (!StringUtil.isBlank(column)) {
            list = (List)list.stream().filter((x) -> column.equals(x.getColumnName())).collect(Collectors.toList());
         }

         if (!StringUtil.isBlank(showdisf) && "1".equals(showdisf)) {
            list = (List)list.stream().filter((x) -> showdisf.equals(x.getIsdiff())).collect(Collectors.toList());
         }

         pageInfo.setPageno(page);
         pageInfo.setPagesize(rows);
         pageInfo.setCount((long)list.size());
         new DataGridVO();
         DataGridVO var55;
         if ((list.size() - pageInfo.getOffset()) / rows < 1) {
            var55 = new DataGridVO((long)list.size(), list.subList(pageInfo.getOffset(), pageInfo.getOffset() + (list.size() - pageInfo.getOffset()) % rows));
         } else {
            var55 = new DataGridVO((long)list.size(), list.subList(pageInfo.getOffset(), pageInfo.getOffset() + pageInfo.getPagesize()));
         }

         List relist = new ArrayList();
         relist.add(var55);
         return RespHelper.updateResp(pageInfo, relist);
      } else {
         return null;
      }
   }

   @RequestMapping({"/isMultiFileDir"})
   @ResponseBody
   public String[] isMultiFileDir(String filepath) {
      boolean directory = true;
      File subFiles = new File(filepath);
      String[] list = subFiles.list();
      System.out.println(list.toString());
      return list;
   }

   @RequestMapping({"/getdmpPash"})
   @ResponseBody
   public String getFiles(String path) {
      File file = new File(path);
      String[] filename = new String[0];
      String[] fileName = file.list();
      String name = Arrays.toString(fileName);
      return name;
   }

   @RequestMapping({"/getjindu"})
   @ResponseBody
   public String getjindu(HttpServletRequest request) {
      String getjindu = DmpTool.getjindu();
      return getjindu;
   }

   @RequestMapping({"/getdmptablename"})
   @ResponseBody
   public List<Map<String, String>> getAllTableNameList(HttpServletRequest request, String path, String filenames, String dmpfiletype, String dmptype) {
      List<Map<String, String>> showTableNameList = new ArrayList();
      List<String> list = new ArrayList();
      List<String> listfiledir = new ArrayList();
      String sourcefiledname = "";
      if ("1".equals(dmpfiletype)) {
         String[] dmpfiles = filenames.split(",");

         for(String dmpfile : dmpfiles) {
            String pathfiledname = path + File.separator + dmpfile;
            listfiledir.add(pathfiledname);
            sourcefiledname = sourcefiledname + pathfiledname + ",";
         }

         sourcefiledname = sourcefiledname.substring(0, sourcefiledname.length() - 1);
         if ("0".equals(dmptype)) {
            Map<String, Object> tableInfoMap = null;
            tableInfoMap = (Map)this.redisService.get(sourcefiledname + "multiDmpdp_tableInfoMap");
            if (null == tableInfoMap) {
               tableInfoMap = MultipleDmpDpTool.getAllTableinfo(listfiledir);
            }

            if (null == tableInfoMap) {
               return null;
            }

            this.redisService.set(sourcefiledname + "multiDmpdp_tableInfoMap", tableInfoMap);
            if (tableInfoMap.size() > 0) {
               List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");

               for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                  list.add(((TableStructureInfo)tableStructureInfoList.get(i)).getTablename());
               }
            }
         } else {
            Map<String, Object> tableInfoMap = null;
            tableInfoMap = (Map)this.redisService.get(sourcefiledname + "multiDmp_tableInfoMap");
            if (null == tableInfoMap) {
               tableInfoMap = MultipleDmpTool.getAllTableinfo(listfiledir);
            }

            if (null == tableInfoMap) {
               return null;
            }

            this.redisService.set(sourcefiledname + "multiDmp_tableInfoMap", tableInfoMap);
            if (tableInfoMap.size() > 0) {
               List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");

               for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                  list.add(((TableStructureInfo)tableStructureInfoList.get(i)).getTablename());
               }
            }
         }
      } else {
         sourcefiledname = path + File.separator + filenames;
         if ("0".equals(dmptype)) {
            Map<String, Object> tableInfoMap = null;
            tableInfoMap = (Map)this.redisService.get(sourcefiledname + "Dmpdp_tableInfoMap");
            if (null == tableInfoMap) {
               tableInfoMap = DmpDpTool.getAllTableinfo(sourcefiledname);
            }

            if (null == tableInfoMap) {
               return null;
            }

            this.redisService.set(sourcefiledname + "Dmpdp_tableInfoMap", tableInfoMap);
            if (tableInfoMap.size() > 0) {
               List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");

               for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                  list.add(((TableStructureInfo)tableStructureInfoList.get(i)).getTablename());
               }
            }
         } else {
            Map<String, Object> tableInfoMap = null;
            tableInfoMap = (Map)this.redisService.get(sourcefiledname + "Dmp_tableInfoMap");
            if (null == tableInfoMap) {
               tableInfoMap = DmpTool.getAllTableinfo(sourcefiledname);
            }

            if (null == tableInfoMap) {
               return null;
            }

            this.redisService.set(sourcefiledname + "Dmp_tableInfoMap", tableInfoMap);
            if (tableInfoMap.size() > 0) {
               List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");

               for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                  list.add(((TableStructureInfo)tableStructureInfoList.get(i)).getTablename());
               }
            }
         }
      }

      Map<String, String> map = new HashMap();
      map.put("tablename", "全选");
      showTableNameList.add(map);

      for(int i = 0; i < list.size(); ++i) {
         map = new HashMap();
         map.put("tablename", list.get(i));
         showTableNameList.add(map);
      }

      return showTableNameList;
   }

   public static void main(String[] args) {
      TdataDiscoveryController TdataDiscoveryController = new TdataDiscoveryController();
      TdataDiscoveryController.getFiles("F:\\dmp");
   }

   @RequestMapping({"/isRepeatName"})
   @ResponseBody
   public Response isRepeatName(@RequestBody Map<String, String> map) {
      String projectid = (String)map.get("projectid");
      String taskname = (String)map.get("taskname");
      String taskid = (String)map.get("taskid");
      return RespHelper.successResp(this.tdataDiscoveryService.isRepeatName(projectid, taskname, taskid));
   }
}
