package com.chenyang.nse.bussiness.controller.core.dataproject;

import com.alibaba.fastjson.JSON;
import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.entity.db.ExceptionInformationList;
import com.chenyang.nse.bussiness.entity.db.MonitorTable;
import com.chenyang.nse.bussiness.entity.vo.ResultVO;
import com.chenyang.nse.bussiness.service.core.dataproject.DiscoverytaskService;
import com.chenyang.nse.bussiness.service.core.dataproject.ExecuteDiscoverytaskService;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import com.chenyang.nse.bussiness.tools.redis.CacheUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/tdataMonitor"})
public class TdataMonitorController {
   @Autowired
   private RedisService redisService;
   @Autowired
   private ExecuteDiscoverytaskService executeDiscoverytaskService;
   @Autowired
   private DiscoverytaskService discoverytaskService;

   @ResponseBody
   @GetMapping({"/monitorTableSum"})
   public Response monitorTableSum(@RequestParam String taskid) {
      Map<String, Object> tableMap = new HashMap();
      Integer tableSum = Integer.valueOf((CacheUtil.getCacheValue(taskid + "tableSum") == null ? "0" : CacheUtil.getCacheValue(taskid + "tableSum")).toString());
      Integer count = Integer.valueOf((CacheUtil.getCacheValue(taskid + "tableCount") == null ? "0" : CacheUtil.getCacheValue(taskid + "tableCount")).toString());
      tableMap.put("tableSum", tableSum);
      tableMap.put("count", count);
      return RespHelper.successResp(tableMap);
   }

   @ResponseBody
   @GetMapping({"/query"})
   public Response queryMonitorInfo(@RequestParam String taskid, @RequestParam String projectid) throws Exception {
      Map<String, Object> tableMap = new HashMap();
      Integer tableSum = Integer.valueOf((CacheUtil.getCacheValue(taskid + "tableSum") == null ? "0" : CacheUtil.getCacheValue(taskid + "tableSum")).toString());
      Integer count = Integer.valueOf((CacheUtil.getCacheValue(taskid + "tableCount") == null ? "0" : CacheUtil.getCacheValue(taskid + "tableCount")).toString());
      tableMap.put("tableSum", tableSum);
      tableMap.put("count", count);
      ResultVO dbdatavo = this.databaseList(projectid, taskid);
      List<ExceptionInformationList> exceptionInformationLists = this.exceptionInformationList(projectid, taskid);
      Map<String, Object> map = new HashMap();
      map.put("statistics", tableMap);
      map.put("dbdatainfo", dbdatavo);
      map.put("errorlist", exceptionInformationLists);
      return RespHelper.successResp(map);
   }

   @ResponseBody
   @RequestMapping({"/stop"})
   public void stopThread(String taskid) {
      CacheUtil.put("taskstatus_" + taskid, "stop");
      List<String> list = new ArrayList();
      list.add("pool" + taskid);
      this.executeDiscoverytaskService.onOff(list);
   }

   @ResponseBody
   @RequestMapping({"/databaseList"})
   public ResultVO databaseList(String projectid, String taskid) throws Exception {
      ResultVO resultvo = new ResultVO();
      new MonitorTable();
      List<MonitorTable> list = new ArrayList();
      new Properties();

      Properties props;
      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
         resultvo.setResult(false);
         resultvo.setMessage("获取配置文件失败");
         return resultvo;
      }

      File discoveryTestFile = new File(props.getProperty("monitorFile") + projectid + File.separator + taskid + File.separator + "done.txt");
      if (!discoveryTestFile.exists()) {
         try {
            discoveryTestFile.getParentFile().mkdirs();
            discoveryTestFile.createNewFile();
         } catch (Exception e) {
            e.printStackTrace();
            resultvo.setResult(false);
            resultvo.setMessage("创建监控文件失败");
            return resultvo;
         }
      }

      String discoveryInformationLine = "";
      String[] discoveryInformationArray = null;
      InputStreamReader discoveryTestFileReader = new InputStreamReader(new FileInputStream(discoveryTestFile), "GBK");
      BufferedReader discoveryTestFileBR = new BufferedReader(discoveryTestFileReader);

      while((discoveryInformationLine = discoveryTestFileBR.readLine()) != null) {
         MonitorTable monitorTable = new MonitorTable();
         discoveryInformationArray = discoveryInformationLine.split(",");
         monitorTable.setDbType(discoveryInformationArray[0]);
         monitorTable.setDbName(discoveryInformationArray[1]);
         monitorTable.setCreateTime(discoveryInformationArray[2]);
         String[] var17 = null;
         list.add(monitorTable);
      }

      discoveryTestFileBR.close();
      String json = JSON.toJSONString(list);
      resultvo.setMessage(json);
      resultvo.setResult(true);
      return resultvo;
   }

   @ResponseBody
   @RequestMapping({"/errormanage"})
   public void errorManage(String runstatus) throws Exception {
   }

   @ResponseBody
   @RequestMapping({"/exceptionInformationList"})
   public List<ExceptionInformationList> exceptionInformationList(String projectid, String taskid) throws Exception {
      List<ExceptionInformationList> list = new ArrayList();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      File discoveryErrorFile = new File(props.getProperty("monitorFile") + projectid + File.separator + taskid + File.separator + "errormanage.txt");
      if (!discoveryErrorFile.exists()) {
         discoveryErrorFile.createNewFile();
      }

      String discoveryInformationLine = "";
      String[] discoveryInformationArray = null;
      InputStreamReader discoveryTestFileReader = new InputStreamReader(new FileInputStream(discoveryErrorFile), "GBK");
      BufferedReader discoveryTestFileBR = new BufferedReader(discoveryTestFileReader);
      DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

      while((discoveryInformationLine = discoveryTestFileBR.readLine()) != null) {
         ExceptionInformationList exceptionInformationList = new ExceptionInformationList();
         discoveryInformationArray = discoveryInformationLine.split(",");
         exceptionInformationList.setErrorType(discoveryInformationArray[0]);
         exceptionInformationList.setSeriousness(discoveryInformationArray[1]);
         exceptionInformationList.setExcutionTime(format.parse(discoveryInformationArray[2]));
         exceptionInformationList.setOperation(discoveryInformationArray[3]);
         String[] var15 = null;
         list.add(exceptionInformationList);
      }

      discoveryTestFileBR.close();
      return list;
   }

   @ResponseBody
   @GetMapping({"/errodetail"})
   public Response errodetail(@RequestParam String projectid, @RequestParam String taskid, @RequestParam String errofilename) throws Exception {
      List<String> list = new ArrayList();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      File discoveryErrorFile = new File(props.getProperty("monitorFile") + projectid + File.separator + taskid + File.separator + errofilename + ".txt");
      if (!discoveryErrorFile.exists()) {
         discoveryErrorFile.createNewFile();
      }

      String discoveryInformationLine = "";
      InputStreamReader discoveryTestFileReader = new InputStreamReader(new FileInputStream(discoveryErrorFile), "GBK");
      BufferedReader discoveryTestFileBR = new BufferedReader(discoveryTestFileReader);
      new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      String errorcontent = "";

      while((discoveryInformationLine = discoveryTestFileBR.readLine()) != null) {
         list.add(discoveryInformationLine.toString());
      }

      discoveryTestFileBR.close();
      return RespHelper.successResp(list);
   }

   @ResponseBody
   @RequestMapping({"/dtailErrorInformation"})
   public String dtailErrorInformation(String errorid) {
      String errorlogs = "I. 10/07 20:45:42。    TCPIP 链接已成功启动I. 10/07 20:45:42。    TCPIP 链接已成功启动I. 10/07 20:45:42。    TCPIP 链接已成功启动I. 10/07 20:45:42。    TCPIP 链接已成功启动I. 10/07 20:45:42。    TCPIP 链接已成功启动I. 10/07 20:45:42。    TCPIP 链接已成功启动I. 10/07 20:45:42。    TCPIP 链接已成功启动I. 10/07 20:45:42。    TCPIP 链接已成功启动I. 10/07 20:45:42。    TCPIP 链接已成功启动I. 10/07 20:45:42。    TCPIP 链接已成功启动I. 10/07 20:45:42。    TCPIP 链接已成功启动I. 10/07 20:45:42。    TCPIP 链接已成功启动I. 10/07 20:45:42。    TCPIP 链接已成功启动I. 10/07 20:45:42。    TCPIP 链接已成功启动I. 10/07 20:45:42。    TCPIP 链接已成功启动I. 10/07 20:45:42。    TCPIP 链接已成功启动I. 10/07 20:45:42。    TCPIP 链接已成功启动I. 10/07 20:45:42。    TCPIP 链接已成功启动I. 10/07 20:45:42。    TCPIP 链接已成功启动I. 10/07 20:45:42。    TCPIP 链接已成功启动I. 10/07 20:45:42。    TCPIP 链接已成功启动I. 10/07 20:45:42。    TCPIP 链接已成功启动I. 10/07 20:45:42。    TCPIP 链接已成功启动I. 10/07 20:45:42。    TCPIP 链接已成功启动";
      return errorlogs;
   }
}
