package com.chenyang.nse.bussiness.controller.core.strategy.masking;

import com.alibaba.fastjson.JSON;
import com.chenyang.nse.bussiness.commmon.json.RespHelper;
import com.chenyang.nse.bussiness.commmon.json.Response;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.StringUtil;
import com.chenyang.nse.bussiness.entity.db.ColumnInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataArea;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoveryTask;
import com.chenyang.nse.bussiness.entity.orm.table.core.rule.app.AppDataRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.rule.conditions.ApplicationConditions;
import com.chenyang.nse.bussiness.entity.orm.table.core.rule.conditions.DateConditions;
import com.chenyang.nse.bussiness.entity.orm.table.core.rule.conditions.DbuserConditions;
import com.chenyang.nse.bussiness.entity.orm.table.core.rule.conditions.IpConditions;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.audit.app.AuditAppDataRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.audit.conditions.AuditApplicationConditions;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.audit.conditions.AuditDateConditions;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.audit.conditions.AuditDbuserConditions;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.audit.conditions.AuditIpConditions;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.masking.app.MaksingAppDataRule;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.masking.relevance.MaksingJoinFieldInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.strategy.masking.relevance.MaksingJoinTableInfo;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.DataScopeEntity;
import com.chenyang.nse.bussiness.entity.vo.Scope;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.service.console.SearchRegexService;
import com.chenyang.nse.bussiness.service.core.AppDataRuleService;
import com.chenyang.nse.bussiness.service.core.DataSecurityControlledAssetService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.TdataProjectService;
import com.chenyang.nse.bussiness.service.core.dataproject.DiscoverytaskService;
import com.chenyang.nse.bussiness.service.core.strategy.AuditAppDataRuleService;
import com.chenyang.nse.bussiness.service.core.strategy.MaksingAppDataRuleService;
import com.chenyang.nse.bussiness.tools.filesystem.JarUtilTool;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.msg.MesUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping({"/core/masking/appdatarule"})
public class MaksingAppDataRuleController {
   private static final Logger ddmauditLogger = LoggerFactory.getLogger("ddmauditLogger");
   private static final Logger operationLogger = LoggerFactory.getLogger("operationLogger");
   @Autowired
   private MaksingAppDataRuleService maksingAppDataRuleService;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private DiscoverytaskService discoverytaskService;
   @Autowired
   private AuditAppDataRuleService auditAppDataRuleService;
   @Autowired
   private AppDataRuleService appDataRuleService;
   @Autowired
   private SearchRegexService searchRegexService;
   @Autowired
   private TdataProjectService tdataProjectService;
   @Autowired
   DataSecurityControlledAssetService dataSecurityControlledAssetService;
   @Autowired
   TCoreDatasystemDao tCoreDatasystemDao;
   @Value("${classify.classifyEnable}")
   private boolean classifyEnable;

   @PostMapping({"/query"})
   @ResponseBody
   public Response querytables(@RequestBody Map<String, Object> params) throws IOException {
      String dataSystemid = (String)params.get("dataSystemid");
      String taskid = (String)params.get("taskid");
      String versionname = (String)params.get("versionname");
      List<String> schemas = (List)params.get("schemas");
      List<String> tablenames = (List)params.get("tablenames");
      String tablefield = (String)params.get("tablefield");
      String dataareaid = (String)params.get("dataareaid");
      String editstate = (String)params.get("editstate");
      String strategyid = (String)params.get("strategyid");
      TCoreDatasystem tCoreDatasystem = this.maksingAppDataRuleService.queryDataSystemById(dataSystemid);
      ddmauditLogger.info(MesUtil.getMsg("DDM_01501", new String[]{CommonUtils.loginUsername(), tCoreDatasystem.getDblinkname()}));
      new ArrayList();
      List<Map<String, String>> versionlist = new ArrayList();
      if (StringUtils.isNotBlank(taskid)) {
         Properties props = new Properties();

         try {
            props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         } catch (IOException e) {
            e.printStackTrace();
         }

         File taskfile = new File(props.getProperty("TaskVersion"));
         if (!taskfile.exists()) {
            taskfile.mkdirs();
         }

         taskfile = new File(props.getProperty("TaskVersion") + taskid);
         String str = "";
         if (taskfile.listFiles() != null) {
            File[] f = taskfile.listFiles();

            for(int i = 0; i < f.length; ++i) {
               str = f[i].getName().split("\\.")[0];
               String[] split = str.split("_");
               if (versionname.equals(split[0])) {
                  InputStreamReader read = new InputStreamReader(new FileInputStream(f[i]), "GBK");
                  BufferedReader newBufferedReader = new BufferedReader(read);
                  String line = "";

                  while((line = newBufferedReader.readLine()) != null) {
                     String[] split1 = line.split(",", -1);
                     Map<String, String> map = new HashMap();
                     if (StringUtils.isNotBlank(split1[3])) {
                        map.put("schema", split1[0]);
                        map.put("tablename", split1[1]);
                        map.put("columnname", split1[2]);
                        map.put("dataareaid", split1[3]);
                        map.put("ruleid", split1[5]);
                        map.put("rulename", split1[6]);
                        versionlist.add(map);
                     }
                  }
               }
            }
         }
      }

      if (StringUtils.isNotBlank(dataareaid)) {
         if (tablenames.size() > 0) {
            versionlist = (List)versionlist.stream().filter((x) -> ((String)x.get("dataareaid")).equals(dataareaid) && schemas.contains(x.get("schema")) && tablenames.contains(x.get("tablename"))).collect(Collectors.toList());
         } else {
            versionlist = (List)versionlist.stream().filter((x) -> ((String)x.get("dataareaid")).equals(dataareaid) && schemas.contains(x.get("schema"))).collect(Collectors.toList());
         }
      }

      if (schemas.size() <= 0) {
         return RespHelper.successResp();
      } else {
         List<Map<String, String>> list = this.maksingAppDataRuleService.querytables(dataSystemid, schemas, tablenames, tablefield);
         if (versionlist.size() > 0 && StringUtils.isNotBlank(dataareaid)) {
            for(int i = 0; i < versionlist.size(); ++i) {
               int finalI = i;
               List<Map<String, String>> finalVersionlist = versionlist;
               int size = ((list).stream().filter((x) -> ((String)x.get("schema")).equals((finalVersionlist.get(finalI)).get("schema")) && ((String)x.get("tablename")).equals((finalVersionlist.get(finalI)).get("tablename"))).collect(Collectors.toList())).size();
               if (size == 0) {
                  versionlist.remove(versionlist.get(i));
               }
            }

            list = versionlist;
         } else if (versionlist.size() > 0) {
            for(int i = 0; i < ((List)list).size(); ++i) {
               for(int j = 0; j < versionlist.size(); ++j) {
                  if (((String)((Map)((List)list).get(i)).get("schema")).equals(((Map)versionlist.get(j)).get("schema")) && ((String)((Map)((List)list).get(i)).get("tablename")).equals(((Map)versionlist.get(j)).get("tablename")) && ((String)((Map)((List)list).get(i)).get("columnname")).equals(((Map)versionlist.get(j)).get("columnname"))) {
                     String finalVersionlist1 = (String)((Map)versionlist.get(j)).get("dataareaid");
                     ((Map)((List)list).get(i)).put("dataareaid", finalVersionlist1);
                     ((Map)((List)list).get(i)).put("columnname", ((Map)((List)list).get(i)).get("columnname"));
                     String ruleid = (String)((Map)versionlist.get(j)).get("ruleid");
                     String rulename = (String)((Map)versionlist.get(j)).get("rulename");
                     ((Map)((List)list).get(i)).put("ruleid", ruleid);
                     ((Map)((List)list).get(i)).put("rulename", rulename);
                  }
               }
            }
         }

         Map<Object, List<Map<String, String>>> collect = (Map)(list).stream().collect(Collectors.groupingBy((ex) -> fetchGroupKey(ex)));
         return RespHelper.successResp(collect);
      }
   }

   private static String fetchGroupKey(Map<String, String> map) {
      return (String)map.get("schema") + "." + (String)map.get("tablename");
   }

   @ResponseBody
   @PostMapping({"/querytask"})
   public Response queryTask(@RequestBody Map<String, Object> params, HttpServletResponse res) {
      String dataSystemId = (String)params.get("datasystemid");
      String dataSystemName = (String)params.get("datasystemname");
      List<TcoreDiscoveryTask> tcoreDiscoveryTaskList = this.discoverytaskService.querytasklistById(dataSystemId);
      String taskname = (String)params.get("taskname");
      TCoreDatasystem tCoreDatasystem = this.maksingAppDataRuleService.queryDataSystemById(dataSystemId);
      ddmauditLogger.info(MesUtil.getMsg("DDM_01502", new String[]{CommonUtils.loginUsername(), tCoreDatasystem.getDblinkname()}));
      if (!StringUtil.isBlank(taskname)) {
         tcoreDiscoveryTaskList = (List)tcoreDiscoveryTaskList.stream().filter((x) -> x.getTname().indexOf(taskname) > 0).collect(Collectors.toList());
      }

      return RespHelper.successResp(tcoreDiscoveryTaskList);
   }

   @ResponseBody
   @PostMapping({"/querySchemas"})
   public Response querySchemas(@RequestBody Map<String, Object> params) throws SQLException, IOException, ClassNotFoundException {
      String dbType = (String)params.get("dbType");
      String dataSystemId = (String)params.get("dataSystemId");
      String dataSystemname = (String)params.get("dataSystemname");
      TCoreDatasystem tCoreDatasystem = this.maksingAppDataRuleService.queryDataSystemById(dataSystemId);
      ddmauditLogger.info(MesUtil.getMsg("DDM_01503", new String[]{CommonUtils.loginUsername(), tCoreDatasystem.getDblinkname()}));
      List<ComboboxVO> listvo = this.dataSystemService.queryshemas(dbType, dataSystemId);
      String filtername = (String)params.get("filtername");
      if (!StringUtil.isBlank(filtername)) {
         listvo = (List)listvo.stream().filter((x) -> x.getValue().indexOf(filtername) > 0).collect(Collectors.toList());
      }

      return RespHelper.successResp(listvo);
   }

   @PostMapping({"/getfield"})
   @ResponseBody
   public Response getFieldByTablename(@RequestBody Map<String, Object> params) {
      String taskid = (String)params.get("taskid");
      String datasystemid = (String)params.get("datasystemid");
      String schema = (String)params.get("schema");
      String tablename = (String)params.get("tablename");
      TCoreDatasystem tCoreDatasystem = this.maksingAppDataRuleService.queryDataSystemById(datasystemid);
      ddmauditLogger.info(MesUtil.getMsg("DDM_01504", new String[]{CommonUtils.loginUsername(), tCoreDatasystem.getDblinkname(), schema, tablename}));
      List<ColumnInfoVO> columnInfoVOS = this.maksingAppDataRuleService.queryColumnInfo(datasystemid, schema, tablename);
      Map<String, String> map = new HashMap();
      map.put("dbip", tCoreDatasystem.getDbip());
      map.put("dbport", tCoreDatasystem.getDbport());
      map.put("dbtype", tCoreDatasystem.getDbtype());
      List<Map<String, String>> list = new ArrayList();
      list.add(map);
      if (this.classifyEnable) {
         for(ColumnInfoVO columnInfoVO : columnInfoVOS) {
            Map<String, List<DataScopeEntity>> classifyInfos = this.dataSecurityControlledAssetService.getClassifyInfos(list, schema, tablename);
            this.mergeClassify(classifyInfos, columnInfoVO);
         }
      }

      columnInfoVOS.sort(Comparator.comparing(ColumnInfo::getColumnname));
      return RespHelper.successResp(columnInfoVOS);
   }

   public void mergeClassify(Map<String, List<DataScopeEntity>> classifyInfos, ColumnInfoVO columnInfoVO) {
      List<DataScopeEntity> dataAreaList = (List)classifyInfos.get("dataareas");
      if (null != dataAreaList && dataAreaList.size() > 0) {
         List<DataScopeEntity> collect = (List)dataAreaList.stream().filter((x) -> x.getColumnName().equals(columnInfoVO.getColumnname())).collect(Collectors.toList());
         if (null != collect && collect.size() > 0) {
            columnInfoVO.setDataareaName(((DataScopeEntity)collect.get(0)).getDataareaName());
         }
      }

      List<DataScopeEntity> scopeNameList = (List)classifyInfos.get("scopeNames");
      Set<Scope> scopeList = new HashSet();
      if (null != scopeNameList && scopeNameList.size() > 0) {
         List<DataScopeEntity> collect = (List)scopeNameList.stream().filter((x) -> x.getColumnName().equals(columnInfoVO.getColumnname())).collect(Collectors.toList());
         if (null != collect && collect.size() > 0) {
            for(DataScopeEntity scopeEntity : collect) {
               Scope scope = new Scope();
               scope.setScopeName(scopeEntity.getScopeName());
               scope.setIsAuto(scopeEntity.getIsAuto());
               scopeList.add(scope);
            }

            columnInfoVO.setScopes((List)scopeList.stream().collect(Collectors.toList()));
         }
      }

      List<DataScopeEntity> fieldSensitivesList = (List)classifyInfos.get("fieldSensitives");
      if (null != fieldSensitivesList && fieldSensitivesList.size() > 0) {
         List<DataScopeEntity> collect = (List)fieldSensitivesList.stream().filter((x) -> x.getColumnName().equals(columnInfoVO.getColumnname())).collect(Collectors.toList());
         if (null != collect && collect.size() > 0) {
            columnInfoVO.setSensitiveLevel(((DataScopeEntity)collect.get(0)).getSensitiveLevel());
         }
      }

   }

   @PostMapping({"/add"})
   @ResponseBody
   public Response addTableInfo(@RequestBody Map<String, Object> params) {
      String datasystemid = (String)params.get("datasystemid");
      String name = (String)params.get("name");
      String strategytype = (String)params.get("strategytype");
      String remark = (String)params.get("remark");
      String enablestatus = (String)params.get("enablestatus");
      String strategyid = (String)params.get("strategyid");
      List<Map<String, Object>> tableinfoList = (List)params.get("tableinfo");
      TCoreDatasystem tCoreDatasystem = this.maksingAppDataRuleService.queryDataSystemById(datasystemid);
      ddmauditLogger.info(MesUtil.getMsg("DDM_01505", new String[]{CommonUtils.loginUsername(), tCoreDatasystem.getDblinkname(), name}));
      MaksingAppDataRule maksingAppDataRule;
      if (StringUtils.isBlank(strategyid)) {
         maksingAppDataRule = new MaksingAppDataRule();
         maksingAppDataRule.setId(UUID.randomUUID().toString());
         maksingAppDataRule.setCreatetime(new Date());
         maksingAppDataRule.setCreateuser(CommonUtils.loginUsername());
      } else {
         maksingAppDataRule = this.maksingAppDataRuleService.queryById(strategyid);
         maksingAppDataRule.setUpdatetime(new Date());
         maksingAppDataRule.setUpdateuser(CommonUtils.loginUsername());
         this.maksingAppDataRuleService.removeFieldInfo(strategyid);
         this.maksingAppDataRuleService.removeRuleInfo(strategyid);
      }

      maksingAppDataRule.setName(name);
      maksingAppDataRule.setStrategytype(strategytype);
      maksingAppDataRule.setEnablestatus(enablestatus);
      maksingAppDataRule.setDatasystemid(datasystemid);
      tableinfoList.forEach((tableinfo) -> {
         MaksingJoinTableInfo maksingJoinTableInfo = new MaksingJoinTableInfo();
         maksingJoinTableInfo.setId(UUID.randomUUID().toString());
         maksingJoinTableInfo.setMaskingid(maksingAppDataRule.getId());
         maksingJoinTableInfo.setSchemaname((String)tableinfo.get("schema"));
         maksingJoinTableInfo.setTablename((String)tableinfo.get("tablename"));
         maksingJoinTableInfo.setEditstate((String)tableinfo.get("editstate"));
         List<Map<String, String>> fieldinfolist = (List)tableinfo.get("fieldinfo");
         fieldinfolist.forEach((fieldinfo) -> {
            MaksingJoinFieldInfo maksingJoinFieldInfo = new MaksingJoinFieldInfo();
            maksingJoinFieldInfo.setColumnname((String)fieldinfo.get("columnname"));
            maksingJoinFieldInfo.setDataareaid((String)fieldinfo.get("dataareaid"));
            maksingJoinFieldInfo.setRuleid((String)fieldinfo.get("ruleid"));
            maksingJoinFieldInfo.setTableid(maksingJoinTableInfo.getId());
            maksingJoinFieldInfo.setMaskingid(maksingAppDataRule.getId());
            this.maksingAppDataRuleService.saveFieldInfo(maksingJoinFieldInfo);
         });
         this.maksingAppDataRuleService.saveRuleInfo(maksingJoinTableInfo);
      });
      maksingAppDataRule.setRemark(remark);
      if (StringUtils.isBlank(strategyid)) {
         this.maksingAppDataRuleService.saveRule(maksingAppDataRule);
      } else {
         this.maksingAppDataRuleService.updateRule(maksingAppDataRule);
      }

      return RespHelper.successResp();
   }

   @GetMapping({"/initEdit"})
   @ResponseBody
   public Response initEdit(@RequestParam("strategyid") String strategyid) {
      MaksingAppDataRule maksingAppDataRule = this.maksingAppDataRuleService.queryById(strategyid);
      TCoreDatasystem tCoreDatasystem = this.maksingAppDataRuleService.queryDataSystemById(maksingAppDataRule.getDatasystemid());
      ddmauditLogger.info(MesUtil.getMsg("DDM_01506", new String[]{CommonUtils.loginUsername(), tCoreDatasystem.getDblinkname(), maksingAppDataRule.getName()}));
      List<MaksingJoinTableInfo> tableInfolist = this.maksingAppDataRuleService.queryTableInfoById(maksingAppDataRule.getId());
      tableInfolist.forEach((tableInfo) -> tableInfo.setFieldinfo(this.maksingAppDataRuleService.queryFieldInfoById(tableInfo.getId())));
      maksingAppDataRule.setTableinfo(tableInfolist);
      return RespHelper.successResp(maksingAppDataRule);
   }

   @PostMapping({"/del"})
   @ResponseBody
   public Response removeStrategy(@RequestBody Map<String, Object> params) {
      String strategyid = (String)params.get("strategyid");
      String name = (String)params.get("name");
      MaksingAppDataRule maksingAppDataRule = this.maksingAppDataRuleService.queryById(strategyid);
      TCoreDatasystem tCoreDatasystem = this.maksingAppDataRuleService.queryDataSystemById(maksingAppDataRule.getDatasystemid());
      ddmauditLogger.info(MesUtil.getMsg("DDM_01507", new String[]{CommonUtils.loginUsername(), tCoreDatasystem.getDblinkname(), maksingAppDataRule.getName()}));
      this.maksingAppDataRuleService.removeStrategy(strategyid);
      this.maksingAppDataRuleService.removeRuleInfo(strategyid);
      this.maksingAppDataRuleService.removeFieldInfo(strategyid);
      return RespHelper.successResp();
   }

   @PostMapping({"/updatestatus"})
   @ResponseBody
   public Response updateStatus(@RequestBody Map<String, Object> params) {
      String strategyid = (String)params.get("strategyid");
      String status = (String)params.get("status");
      MaksingAppDataRule maksingAppDataRule = this.maksingAppDataRuleService.queryById(strategyid);
      TCoreDatasystem tCoreDatasystem = this.maksingAppDataRuleService.queryDataSystemById(maksingAppDataRule.getDatasystemid());
      ddmauditLogger.info(MesUtil.getMsg("DDM_01508", new String[]{CommonUtils.loginUsername(), tCoreDatasystem.getDblinkname(), maksingAppDataRule.getName()}));
      this.maksingAppDataRuleService.updateMaskingStatus(strategyid, status);
      return RespHelper.successResp();
   }

   @PostMapping({"/getmaskingrule"})
   @ResponseBody
   public Response getMaskingRule(@RequestBody(required = false) Map<String, Object> params) {
      ddmauditLogger.info(MesUtil.getMsg("DDM_00701", new String[]{CommonUtils.loginUsername()}));
      String dataarea = "";
      String rulename = "";
      String dbtype = "";
      if (null != params) {
         dataarea = (String)params.get("dataarea");
         rulename = (String)params.get("rulename");
         dbtype = (String)params.get("dbtype");
      } else {
         dataarea = "";
         rulename = "";
         dbtype = "";
      }

      List<TCoreDataArea> allDataareaList = this.searchRegexService.queryAllDataarea(params);
      List<Map<String, Object>> relist = new ArrayList();

      for(int i = 0; i < allDataareaList.size(); ++i) {
         Map<String, Object> dataMap = new HashMap();
         TCoreDataArea tCoreDataArea = (TCoreDataArea)allDataareaList.get(i);
         String dataareaid = tCoreDataArea.getId();
         List<AppDataRule> appDataRules = this.appDataRuleService.queryRuleBygroup(dataareaid, dbtype);
         dataMap.put("dataarea", tCoreDataArea);
         dataMap.put("data", appDataRules);
         relist.add(dataMap);
      }

      return RespHelper.successResp(relist);
   }

   @GetMapping({"/download"})
   @ResponseBody
   public void download(@RequestParam("datasystemid") String datasystemid, HttpServletRequest request, HttpServletResponse response) throws Exception {
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String filepath = props.getProperty("jdbcproxypath");
      String maskingname = props.getProperty("jdbcmaskingfilename");
      File fileTarget = new File(filepath);
      if (!fileTarget.exists()) {
         fileTarget.mkdirs();
      }

      Map<String, Object> map1 = new HashMap();
      List<AuditAppDataRule> auditInfoList = this.auditAppDataRuleService.getAuditInfoByDatasystemid(datasystemid);
      new ArrayList();

      for(AuditAppDataRule auditAppDataRule : auditInfoList) {
         String id = auditAppDataRule.getId();
         List<AuditIpConditions> ipConditionsList = this.auditAppDataRuleService.getIpConditionsInfoByRuleId(id);
         List<AuditApplicationConditions> applicationConditionsList = this.auditAppDataRuleService.getApplicationConditionsInfoByRuleId(id);
         List<AuditDbuserConditions> dbuserConditionsList = this.auditAppDataRuleService.getDbuserConditionsInfoByRuleId(id);
         List<AuditDateConditions> dateConditionsList = this.auditAppDataRuleService.getDateConditionsInfoByRuleId(id);
         Map<String, Object> map = new HashMap();
         map.put("ipConditions", ipConditionsList);
         map.put("applicationConditions", applicationConditionsList);
         map.put("dbuserConditions", dbuserConditionsList);
         map.put("dateConditions", dateConditionsList);
         map1.put(auditAppDataRule.getId() + "_" + auditAppDataRule.getName() + "_" + auditAppDataRule.getType(), map);
      }

      for(MaksingAppDataRule maksingAppDataRule : this.maksingAppDataRuleService.getMaksingInfoByDataSystemById(datasystemid)) {
         List<MaksingJoinTableInfo> tableInfolist = this.maksingAppDataRuleService.queryTableInfoById(maksingAppDataRule.getId());
         tableInfolist.forEach((tableInfo) -> {
            List<MaksingJoinFieldInfo> maksingJoinFieldInfos = this.maksingAppDataRuleService.queryFieldInfoById(tableInfo.getId());

            for(MaksingJoinFieldInfo maksingJoinFieldInfo : maksingJoinFieldInfos) {
               String id = maksingJoinFieldInfo.getRuleid();
               AppDataRule appRuleInfo = this.appDataRuleService.getAppRuleInfoById(id);
               List<IpConditions> ipConditionsList = this.appDataRuleService.getIpConditionsInfoByRuleId(id);
               List<ApplicationConditions> applicationConditionsList = this.appDataRuleService.getApplicationConditionsInfoByRuleId(id);
               List<DbuserConditions> dbuserConditionsList = this.appDataRuleService.getDbuserConditionsInfoByRuleId(id);
               List<DateConditions> dateConditionsList = this.appDataRuleService.getDateConditionsInfoByRuleId(id);
               Map<String, Object> map = new HashMap();
               map.put("ruleinfo", appRuleInfo);
               map.put("ipConditions", ipConditionsList);
               map.put("applicationConditions", applicationConditionsList);
               map.put("dbuserConditions", dbuserConditionsList);
               map.put("dateConditions", dateConditionsList);
               maksingJoinFieldInfo.setMap(map);
            }

            tableInfo.setFieldinfo(maksingJoinFieldInfos);
         });
         maksingAppDataRule.setTableinfo(tableInfolist);
         map1.put(maksingAppDataRule.getId() + "_" + maksingAppDataRule.getName() + "_" + maksingAppDataRule.getStrategytype(), maksingAppDataRule);
      }

      String s = JSON.toJSONString(map1);
      JarUtilTool.writeJarFile(filepath, maskingname, s.getBytes());
      String path = "";

      try {
         response.setCharacterEncoding("utf-8");
         response.setContentType("multipart/form-data");
         response.setHeader("Content-Disposition", "attachment;fileName=masking.jar");
         InputStream inputStream = new FileInputStream(new File(filepath));
         OutputStream os = response.getOutputStream();
         byte[] b = new byte[2048];

         int length;
         while((length = inputStream.read(b)) > 0) {
            os.write(b, 0, length);
         }

         os.close();
         inputStream.close();
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   @PostMapping({"/getClassifyEnable"})
   @ResponseBody
   public Response getClassifyEnable() {
      return RespHelper.successResp(this.classifyEnable);
   }

   @PostMapping({"/getSensitiveLevel"})
   @ResponseBody
   public Response getSensitiveLevel(@RequestBody Map<String, Object> params) {
      String datasystemid = (String)params.get("datasystemid");
      TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(datasystemid);
      Map<String, String> datasystemmap = new HashMap();
      datasystemmap.put("dbip", tCoreDatasystem.getDbip());
      datasystemmap.put("dbport", tCoreDatasystem.getDbport());
      datasystemmap.put("dbtype", tCoreDatasystem.getDbtype());
      List<Map<String, String>> datasystem = new ArrayList();
      datasystem.add(datasystemmap);
      List<String> classifyInfos = this.dataSecurityControlledAssetService.getClassifyInfos(datasystem);
      if (null != classifyInfos && classifyInfos.size() > 0) {
         classifyInfos = (List)classifyInfos.stream().sorted((x, y) -> -x.compareTo(y)).collect(Collectors.toList());
      }

      return RespHelper.successResp(classifyInfos);
   }
}
