package com.chenyang.nse.bussiness.dao.core;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.vo.api.DiscoverApiDirectoryVO;
import com.chenyang.nse.bussiness.entity.vo.datascope.ComplianceDirectoryVO;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class ComplianceDirectoryDao extends BaseDao<Object, String> {
   public List<ComplianceDirectoryVO> getDataScopeGroup(ComplianceDirectoryVO vo) {
      String sql = StringUtils.isNotEmpty(vo.getSearchVal()) ? XmlTool.getSql("compliancedirectory", "dataScopeGroupByCondition") : XmlTool.getSql("compliancedirectory", "dataScopeGroup");
      List<ComplianceDirectoryVO> res = null;
      NativeQuery nativeQuery = this.getSession().createNativeQuery(sql).setParameter("edition_id", vo.getEdition_id());
      if (StringUtils.isNotEmpty(vo.getSearchVal())) {
         nativeQuery.setParameter("condition", vo.getCondition()).setParameter("searchVal", vo.getSearchVal());
      }

      res = nativeQuery.setResultTransformer(Transformers.aliasToBean(ComplianceDirectoryVO.class)).getResultList();
      return res;
   }

   public List<DiscoverApiDirectoryVO> getComplianceDirectory(String edition_id) {
      String sql = XmlTool.getSql("compliancedirectory", "complianceDirectory");
      List<DiscoverApiDirectoryVO> vo = this.getSession().createNativeQuery(sql).setParameter("edition_id", edition_id).setResultTransformer(Transformers.aliasToBean(DiscoverApiDirectoryVO.class)).getResultList();
      return vo;
   }

   public int insertAddFa(ComplianceDirectoryVO scope) {
      String sql = XmlTool.getSql("compliancedirectory", "addfa");
      int i = this.getSession().createNativeQuery(sql).setParameter("text", scope.getText()).setParameter("edition_id", scope.getEdition_id()).setParameter("id", scope.getTid()).setParameter("note", scope.getNote()).setParameter("chinese_name", scope.getChinese_name()).setParameter("foreigh_name", scope.getForeigh_name()).setParameter("abbreviation", scope.getAbbreviation()).setParameter("public_name", scope.getPublic_name()).setParameter("public_date", scope.getPublic_date()).setParameter("implementation_date", scope.getImplementation_date()).setParameter("revised_date", scope.getRevised_date()).setParameter("application_state", scope.getApplication_state()).setParameter("directory_type", scope.getDirectory_type()).setParameter("create_user", scope.getCreate_user()).setParameter("projectid", scope.getProjectId()).executeUpdate();
      return i;
   }

   public List<ComplianceDirectoryVO> ishavebro(ComplianceDirectoryVO scope) {
      String sql = XmlTool.getSql("compliancedirectory", "ishavebro");
      List<ComplianceDirectoryVO> vo = this.getSession().createNativeQuery(sql).setParameter("fa_tid", scope.getFa_tid()).setResultTransformer(Transformers.aliasToBean(ComplianceDirectoryVO.class)).getResultList();
      return vo;
   }

   public int havebro(ComplianceDirectoryVO scope) {
      String sql = XmlTool.getSql("compliancedirectory", "havebro");
      int i = this.getSession().createNativeQuery(sql).setParameter("text", scope.getText()).setParameter("id", scope.getTid()).setParameter("edition_id", scope.getEdition_id()).setParameter("fa_tid", scope.getFa_tid()).setParameter("note", scope.getNote()).setParameter("chinese_name", scope.getChinese_name()).setParameter("foreigh_name", scope.getForeigh_name()).setParameter("abbreviation", scope.getAbbreviation()).setParameter("public_name", scope.getPublic_name()).setParameter("public_date", scope.getPublic_date()).setParameter("implementation_date", scope.getImplementation_date()).setParameter("revised_date", scope.getRevised_date()).setParameter("application_state", scope.getApplication_state()).setParameter("directory_type", scope.getDirectory_type()).setParameter("create_user", scope.getCreate_user()).setParameter("projectid", scope.getProjectId()).executeUpdate();
      return i;
   }

   public int nothavebro(ComplianceDirectoryVO scope) {
      String sql = XmlTool.getSql("compliancedirectory", "nothavebro");
      int i = this.getSession().createNativeQuery(sql).setParameter("text", scope.getText()).setParameter("id", scope.getTid()).setParameter("edition_id", scope.getEdition_id()).setParameter("fa_tid", scope.getFa_tid()).setParameter("note", scope.getNote()).setParameter("chinese_name", scope.getChinese_name()).setParameter("foreigh_name", scope.getForeigh_name()).setParameter("abbreviation", scope.getAbbreviation()).setParameter("public_name", scope.getPublic_name()).setParameter("public_date", scope.getPublic_date()).setParameter("implementation_date", scope.getImplementation_date()).setParameter("revised_date", scope.getRevised_date()).setParameter("application_state", scope.getApplication_state()).setParameter("directory_type", scope.getDirectory_type()).setParameter("create_user", scope.getCreate_user()).setParameter("projectid", scope.getProjectId()).executeUpdate();
      return i;
   }

   public int updateScope(ComplianceDirectoryVO scope) {
      String sql = XmlTool.getSql("compliancedirectory", "updatescope");
      int i = this.getSession().createNativeQuery(sql).setParameter("text", scope.getText()).setParameter("id", scope.getTid()).setParameter("note", scope.getNote()).setParameter("chinese_name", scope.getChinese_name()).setParameter("foreigh_name", scope.getForeigh_name()).setParameter("abbreviation", scope.getAbbreviation()).setParameter("public_name", scope.getPublic_name()).setParameter("public_date", scope.getPublic_date()).setParameter("implementation_date", scope.getImplementation_date()).setParameter("revised_date", scope.getRevised_date()).setParameter("application_state", scope.getApplication_state()).setParameter("directory_type", scope.getDirectory_type()).setParameter("create_user", scope.getCreate_user()).executeUpdate();
      return i;
   }

   public int delselfandson(String scope_id) {
      String sql = XmlTool.getSql("compliancedirectory", "delselfandson");
      int i = this.getSession().createNativeQuery(sql).setParameter("directory_id", scope_id).executeUpdate();
      return i;
   }

   public List<ComplianceDirectoryVO> findbroandhisson(String scope_id, String fa_id) {
      String sql = XmlTool.getSql("compliancedirectory", "findbroandhisson");
      List<ComplianceDirectoryVO> vo = this.getSession().createNativeQuery(sql).setParameter("fa_id", fa_id).setParameter("directory_id", scope_id).setResultTransformer(Transformers.aliasToBean(ComplianceDirectoryVO.class)).getResultList();
      return vo;
   }

   public int updatebro(String id) {
      String sql = XmlTool.getSql("compliancedirectory", "updatebro");
      int i = this.getSession().createNativeQuery(sql).setParameter("id", id).executeUpdate();
      return i;
   }

   public int updatebroson(String id, String del_id) {
      String sql = XmlTool.getSql("compliancedirectory", "updatebroson");
      int i = this.getSession().createNativeQuery(sql).setParameter("id", id).setParameter("del_id", del_id).executeUpdate();
      return i;
   }

   public int insertAddZero(ComplianceDirectoryVO scope) {
      String sql = XmlTool.getSql("compliancedirectory", "addzero");
      int i = this.getSession().createNativeQuery(sql).setParameter("text", scope.getText()).setParameter("id", scope.getTid()).setParameter("note", scope.getNote()).setParameter("chinese_name", scope.getChinese_name()).setParameter("foreigh_name", scope.getForeigh_name()).setParameter("abbreviation", scope.getAbbreviation()).setParameter("public_name", scope.getPublic_name()).setParameter("public_date", scope.getPublic_date()).setParameter("implementation_date", scope.getImplementation_date()).setParameter("revised_date", scope.getRevised_date()).setParameter("application_state", scope.getApplication_state()).setParameter("directory_type", scope.getDirectory_type()).setParameter("create_user", scope.getCreate_user()).setParameter("projectid", scope.getProjectId()).setParameter("edition_id", scope.getEdition_id()).executeUpdate();
      return i;
   }

   public List<ComplianceDirectoryVO> getselfandson(String directory_id) {
      String sql = XmlTool.getSql("compliancedirectory", "getselfandson");
      return this.getSession().createNativeQuery(sql).setParameter("directory_id", directory_id).setResultTransformer(Transformers.aliasToBean(ComplianceDirectoryVO.class)).getResultList();
   }

   public List<Map<String, Object>> selectComplianceDirCount(String id) {
      String sql = "SELECT COUNT(id) AS s FROM t_core_compliance_directory WHERE projectid = '" + id + "'";
      List<Map<String, Object>> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return vo;
   }

   public List<Map<String, Object>> selectComplianceDirCount1(String edition_id) {
      String sql = "SELECT COUNT(id) AS s FROM t_core_compliance_directory WHERE edition_id = '" + edition_id + "'";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "SELECT COUNT(id) AS \"s\" FROM t_core_compliance_directory WHERE edition_id = '" + edition_id + "'";
      }

      List<Map<String, Object>> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return vo;
   }
}
