package com.chenyang.nse.bussiness.dao.core;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class CoreDao extends BaseDao<Object, String> {
   public List<Map> dataSystemReport() {
      String sql = XmlTool.getSql("core", "dataSystemReport");
      List<Map> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public List<Map> sensitiveDataReport() {
      String sql = XmlTool.getSql("core", "sensitiveDataReport");
      List<Map> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public List<Map> maskingRuleReport() {
      String sql = XmlTool.getSql("core", "maskingRuleReport");
      List<Map> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public Map maskingEfficiencyReport() {
      String sql_row = XmlTool.getSql("core", "maskingTotalRow");
      String sql_time = XmlTool.getSql("core", "maskingTotalTime");
      String totalrow = "0";
      String totaltime = "0";

      try {
         totalrow = this.getSession().createNativeQuery(sql_row).uniqueResult().toString();
         totaltime = this.getSession().createNativeQuery(sql_time).uniqueResult().toString();
      } catch (Exception var6) {
      }

      Map map = new HashMap();
      map.put("totalrow", totalrow);
      map.put("totaltime", totaltime);
      return map;
   }
}
