package com.chenyang.nse.bussiness.dao.core;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class DataMapDao extends BaseDao<Object, String> {
   public List<String> queryUserMapTableName(String datamapid, String userid) {
      String sql = XmlTool.getSql("datamap", "queryUserMapTableName");
      List<String> list = this.getSession().createNativeQuery(sql).setParameter("datamapid", datamapid).setParameter("userid", userid).getResultList();
      return list;
   }

   public List<String> queryUserMapDataSystemId(String userid) {
      String sql = XmlTool.getSql("datamap", "queryUserMapDataSystemId");
      List<String> list = this.getSession().createNativeQuery(sql).setParameter("userid", userid).getResultList();
      return list;
   }

   public List<String> queryUserMapSchema(String userid, String datasystemid) {
      String sql = XmlTool.getSql("datamap", "queryUserMapSchema");
      List<String> list = this.getSession().createNativeQuery(sql).setParameter("userid", userid).setParameter("datasystemid", datasystemid).getResultList();
      return list;
   }

   public List<String> queryTableId(String datamapid, String userid) {
      String hql = "select usermap.tableid from TCoreDatamapUsermap usermap where usermap.datamapid = :datamapid and usermap.userid = :userid";
      List<String> idlist = this.getSession().createQuery(hql).setParameter("datamapid", datamapid).setParameter("userid", userid).getResultList();
      return idlist;
   }
}
