package com.chenyang.nse.bussiness.dao.core;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.vo.engine.EnginePropertyVO;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class EngineDao extends BaseDao<Object, String> {
   public List<EnginePropertyVO> queryEngineProperty(String engineid) {
      String sql = XmlTool.getSql("engine", "queryEngineProperty");
      List<EnginePropertyVO> list = this.getSession().createNativeQuery(sql).setParameter("engineid", engineid).setResultTransformer(Transformers.aliasToBean(EnginePropertyVO.class)).getResultList();
      return list;
   }

   public Map<String, Object> queryEnginePropertyKeyValue(String engineid) {
      List<EnginePropertyVO> list = this.queryEngineProperty(engineid);
      Map<String, Object> map = null;
      if (list != null && list.size() > 0) {
         if (map == null) {
            map = new HashMap();
         }

         for(EnginePropertyVO item : list) {
            map.put(item.getPropertyname(), item.getPropertyvalue());
         }
      }

      return map;
   }
}
