package com.chenyang.nse.bussiness.dao.core;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreBussinessSystem;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.hibernate.transform.Transformers;
import org.hibernate.type.StandardBasicTypes;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreBusinessSystemDao extends BaseDao<TCoreBussinessSystem, String> {
   @PersistenceContext
   private EntityManager entityManager;

   public List<TCoreBussinessSystem> query(TCoreBussinessSystem condition) {
      StringBuffer sql = new StringBuffer("SELECT id as id, bussiness_name as bussinessName,bussiness_remarks as bussinessRemarks,createdatetime as createdatetime FROM T_CORE_BUSSINESS_SYSTEM WHERE 1=1 ORDER BY id DESC");
      sql.append(" limit " + (condition.getCurrentPage() - 1) * condition.getPageSize() + "," + condition.getPageSize());
      Query nativeQuery = this.getSession().createNativeQuery(sql.toString()).addScalar("id", StandardBasicTypes.STRING).addScalar("bussinessName", StandardBasicTypes.STRING).addScalar("createdatetime", StandardBasicTypes.STRING).addScalar("bussinessRemarks", StandardBasicTypes.STRING).setResultTransformer(Transformers.aliasToBean(TCoreBussinessSystem.class));
      return nativeQuery.getResultList();
   }
}
