package com.chenyang.nse.bussiness.dao.table.base;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.vo.DutyPersonVO;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.util.List;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TBaseDutyPersonDao extends BaseDao<Object, String> {
   public List<DutyPersonVO> selectDutyPerson(DutyPersonVO vo) {
      String sql = XmlTool.getSql("duty", "selectDutyPerson");
      return this.getSession().createNativeQuery(sql).setParameter("datasystemid", vo.getDatasystemid()).setParameter("duty_scope", vo.getDuty_scope()).setParameter("projectid", vo.getProjectid()).setResultTransformer(Transformers.aliasToBean(DutyPersonVO.class)).getResultList();
   }

   public List<DutyPersonVO> isExistPerson(DutyPersonVO vo) {
      String sql = XmlTool.getSql("duty", "isExistPerson");
      return this.getSession().createNativeQuery(sql).setParameter("datasystemid", vo.getDatasystemid()).setParameter("duty_scope", vo.getDuty_scope()).setParameter("duty_id", vo.getDuty_id()).setResultTransformer(Transformers.aliasToBean(DutyPersonVO.class)).getResultList();
   }

   public int saveDutyPerson(DutyPersonVO vo) {
      String sql = XmlTool.getSql("duty", "saveDutyPerson");
      int i = this.getSession().createNativeQuery(sql).setParameter("datasystemid", vo.getDatasystemid()).setParameter("duty_id", vo.getDuty_id()).setParameter("duty_name", vo.getDuty_name()).setParameter("duty_scope", vo.getDuty_scope()).setParameter("duty_main", vo.getDuty_main()).setParameter("projectid", vo.getProjectid()).executeUpdate();
      return i;
   }

   public int updateDutyPerson(DutyPersonVO vo) {
      String sql = XmlTool.getSql("duty", "updateDutyPerson");
      int i = this.getSession().createNativeQuery(sql).setParameter("id", vo.getId()).setParameter("duty_scope", vo.getDuty_scope()).setParameter("duty_main", vo.getDuty_main()).setParameter("duty_name", vo.getDuty_name()).setParameter("duty_id", vo.getDuty_id()).executeUpdate();
      return i;
   }

   public int delDutyPersonById(DutyPersonVO vo) {
      String sql = XmlTool.getSql("duty", "delDutyPersonById");
      int i = this.getSession().createNativeQuery(sql).setParameter("id", vo.getId()).executeUpdate();
      return i;
   }
}
