package com.chenyang.nse.bussiness.dao.table.core;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreCurrencyInfo;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.util.List;
import java.util.Map;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreCurrencyInfoDao extends BaseDao<TCoreCurrencyInfo, String> {
   public List<TCoreCurrencyInfo> getCurrencyInfoTable(String datasystem, String schema) {
      String sql = XmlTool.getSql("currencyinfo", "getCurrencyInfoE");
      return this.getSession().createNativeQuery(sql).setParameter("datasystemid", datasystem).setParameter("schema", schema).setResultTransformer(Transformers.aliasToBean(TCoreCurrencyInfo.class)).getResultList();
   }

   public List<Map<String, String>> getCurrencyInfoPrimary(String name) {
      String sql = XmlTool.getSql("currencyinfo", "getCurrencyInfoPrimaryL");
      return this.getSession().createNativeQuery(sql).setParameter("name", name).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
   }
}
