package com.chenyang.nse.bussiness.dao.table.core;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitiveLevel;
import com.chenyang.nse.bussiness.entity.vo.datascope.ReportCheckboxVO;
import com.chenyang.nse.bussiness.tools.DataSourceTools;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreSensitiveLevelDao extends BaseDao<TCoreSensitiveLevel, String> {
   public List<Map<String, Object>> getDatacount() {
      String sql = "select sensitive_id, count(0) as count FROM t_core_field_sensitive AS a, t_core_table_field AS b WHERE\tb.id = a.tablefield_id  GROUP BY a.sensitive_id";
      List<Map<String, Object>> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public long getDatacountByproject(String table) {
      String sql = " select  count(0) as count FROM t_core_field_sensitive AS a, (select a.id from t_core_table_field as a," + table + " as b where a.tschemas = b.tschema and a.names = b.tablename and a.fields = b.columnname ) AS b WHERE\tb.id = a.tablefield_id   ";
      BigInteger count = (BigInteger)this.getSession().createNativeQuery(sql).uniqueResult();
      return count.longValue();
   }

   public List<ReportCheckboxVO> getTCoreSensitiveLevelList() {
      String sql = XmlTool.getSql("datascope", "getTCoreSensitiveLevelList");
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(ReportCheckboxVO.class)).getResultList();
   }

   public int insert(String project) {
      String sql = "insert into t_view_sensitive_level_project select UUID() as id,'' as flag,'' as note,y.columnid,x.columnname,x.datasystemid,y.directory_name, x.projectid,x.projectname,x.tablename,x.tschema from ( select a.projectname,b.projectid, b.tschema,b.tablename,b.columnname,b.datasystemid  from t_core_project_info a LEFT JOIN " + project + " b on a.realprojectname=b.projectid) x, (select c.id,c.sensitive_name as directory_name,e.datasystem_id,e.id as columnid,e.tschemas,e.\"names\",e.\"fields\",e.flag from t_core_sensitive_level c,t_core_field_sensitive d,t_core_table_field e where c.id=d.sensitive_id and d.tablefield_id=e.id )y where x.tschema=y.tschemas and x.tablename=y.\"names\" and x.columnname=y.\"fields\"";
      sql = DataSourceTools.dealSqlFormat(sql);
      int size = this.getSession().createNativeQuery(sql).executeUpdate();
      return size;
   }

   public int truncate(String table) {
      String sql = "delete from " + table;
      int size = this.getSession().createNativeQuery(sql).executeUpdate();
      return size;
   }

   public List<Map<String, Object>> getEachDatacount(String name) {
      String sql = "select projectname, count(0) as count FROM t_view_sensitive_level_project AS a where directory_name = '" + name + "' GROUP BY a.projectname";
      List<Map<String, Object>> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public List<Map<String, Object>> getmaxdatetid(String editionid) {
      String sql = "select id from t_core_sensitive_level where edition_id = '" + editionid + "' order by create_date desc limit 1";
      List<Map<String, Object>> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public void saveDataScope(StringBuilder sql) {
      this.getSession().createNativeQuery(sql.toString()).executeUpdate();
   }

   public void deleteDataScope(StringBuilder sql) {
      this.getSession().createNativeQuery(sql.toString()).executeUpdate();
   }

   public List<Map<String, Object>> relatedfandson(String sensitive_id, String edition_id) {
      String sql = "SELECT id FROM t_core_sensitive_level WHERE sensitive_id LIKE (CONCAT('" + sensitive_id + "', '%')) AND edition_id = '" + edition_id + "'";
      List<Map<String, Object>> list = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public void saveExcelData(StringBuilder sql) {
      this.getSession().createNativeQuery(sql.toString()).executeUpdate();
   }
}
