package com.chenyang.nse.bussiness.dao.table.core;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitivegroup;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.math.BigInteger;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreSensitivegroupDao extends BaseDao<TCoreSensitivegroup, String> {
   public List<TCoreSensitivegroup> querySensitiveGroup(String dataSourceId, List<String> schemas) {
      String sql = XmlTool.getSql("sensitivegroup", "querySensitiveGroup");
      return this.getSession().createNativeQuery(sql, TCoreSensitivegroup.class).setParameter("DATASOURCEID", dataSourceId).setParameter("SCHEMAS", schemas).getResultList();
   }

   public List<TCoreSensitivegroup> querySensitiveGroup(String dataSourceId) {
      String sql = XmlTool.getSql("sensitivegroup", "querySensitiveGroupByMysql");
      return this.getSession().createNativeQuery(sql, TCoreSensitivegroup.class).setParameter("DATASOURCEID", dataSourceId).getResultList();
   }

   public List<TCoreSensitivegroup> queryAllSensitiveGroupPage(PageInfo pageInfo) {
      String sql = XmlTool.getSql("sensitivegroup", "querySensitiveGroupCount");
      long count = (long)((BigInteger)this.getSession().createNativeQuery(sql).getSingleResult()).intValue();
      pageInfo.setCount(count);
      sql = XmlTool.getSql("sensitivegroup", "querySensitiveGroupPage");
      return this.getSession().createNativeQuery(sql).setFirstResult(pageInfo.getOffset()).setMaxResults(pageInfo.getPagesize()).getResultList();
   }

   public List<TCoreSensitivegroup> queryAllSensitiveGroup() {
      return (List)this.getSession().getSession().createCriteria(TCoreSensitivegroup.class);
   }

   public List<TCoreSensitivegroup> queryAllSensitiveGroupOrderByUpdatetime() {
      String sql = XmlTool.getSql("sensitivegroup", "queryAllSensitiveGroupOrderByUpdatetime");
      return this.getSession().createNativeQuery(sql, TCoreSensitivegroup.class).getResultList();
   }
}
