package com.chenyang.nse.bussiness.dao.table.core.dataproject;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataArea;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import java.util.List;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreDataAreaDao extends BaseDao<TCoreDataArea, String> {
   public List<String> queryAllDataarea() {
      String sql = "select dataarea from t_core_dataarea order by dataarea";
      return this.getSession().createNativeQuery(sql).getResultList();
   }

   public List<TCoreDataArea> queryAll() {
      String sql = "select id AS id, dataarea from t_core_dataarea order by createtime desc";
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreDataArea.class)).getResultList();
   }

   public List<ComboboxVO> queryAllDataareaid() {
      String sql = "select id as value,dataarea as text  from t_core_dataarea order by dataarea";
      List<ComboboxVO> vo = this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return vo;
   }

   public List<String> queryDataareaid(String dataarea) {
      String sql = "select id from t_core_dataarea where dataarea='" + dataarea + "'";
      return this.getSession().createNativeQuery(sql).getResultList();
   }

   public List<TCoreDataArea> queryByAssetId(String assetid) {
      String sql = "select u.id as id,u.dataarea from t_core_dataarea u inner join t_core_controlled_asset_area r on u.id = r.areaid where u.id!=1 and r.assetid = :assetid order by u.createtime desc ";
      return this.getSession().createNativeQuery(sql).setParameter("assetid", assetid).setResultTransformer(Transformers.aliasToBean(TCoreDataArea.class)).getResultList();
   }

   public List<TCoreDataArea> selectDataAreaHasFindRule() {
      String sql = "SELECT a.id,a.dataarea FROM t_core_dataarea a ";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "SELECT a.id as \"id\",a.dataarea as \"dataarea\" FROM t_core_dataarea a ";
      }

      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreDataArea.class)).getResultList();
   }

   public List<TCoreDataArea> queryDataareaByProjectid(String projectid) {
      String sql = "select distinct b.id as id,b.dataarea,b.areatype,b.createtime,b.createuser from t_core_project_findrule a LEFT JOIN t_core_dataarea b on a.dataarea_id=b.id where a.project_id='" + projectid + "'";
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "select distinct b.id as \"id\",b.dataarea as \"dataarea\",b.areatype as \"areatype\",b.createtime as \"createtime\",b.createuser as \"createuser\" from t_core_project_findrule a LEFT JOIN t_core_dataarea b on a.dataarea_id=b.id where a.project_id='" + projectid + "'";
      }

      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreDataArea.class)).getResultList();
   }
}
