package com.chenyang.nse.bussiness.dao.table.core.dataproject;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.StringUtil;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreSearchregexVO;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.math.BigInteger;
import java.util.List;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreSearchregexVoDao extends BaseDao<TCoreSearchregexVO, String> {
   public List<TCoreSearchregexVO> querySearchregexList(String dataarea, String rulename, PageInfo pageInfo) {
      String sqls = XmlTool.getSql("dataarea", "queryAllSearchregexCount");
      BigInteger i = (BigInteger)this.getSession().createNativeQuery(sqls).setParameter("dataarea", "%" + dataarea + "%").setParameter("rulename", "%" + rulename + "%").uniqueResult();
      pageInfo.setCount(i.longValue());
      String sql = XmlTool.getSql("dataarea", "querySearchregexList");
      return this.getSession().createNativeQuery(sql).setParameter("dataarea", "%" + dataarea + "%").setParameter("rulename", "%" + rulename + "%").setFirstResult(pageInfo.getOffset()).setMaxResults(pageInfo.getPagesize()).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
   }

   public List<TCoreSearchregexVO> queryDataAreaSearchregexList(String dataarea, String rulename) {
      String sql = XmlTool.getSql("dataarea", "querySearchregexList");
      if (StringUtil.isBlank(dataarea)) {
         dataarea = "";
      }

      if (StringUtil.isBlank(rulename)) {
         rulename = "";
      }

      if (HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
         sql = sql.replaceAll("`", "");
      }

      return this.getSession().createNativeQuery(sql).setParameter("dataarea", "%" + dataarea + "%").setParameter("rulename", "%" + rulename + "%").setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
   }

   public List<TCoreSearchregexVO> queryDataAreaSearchregexByProjectid(String projectid) {
      String sql = XmlTool.getSql("dataarea", "querySearchregexbyprojectid");
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("2")) {
         sql = sql.replaceAll("`", "");
      }

      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         sql = "SELECT\n\t\ta.id as \"id\",\n\t\ta.createtime as \"createtime\",\n\t\ta.createuser as \"createuser\",\n\t\ta.dataarea as \"dataarea\",\n\t\tb.flag as \"flag\",\n\t\tb.icon as \"icon\",\n\t\tb.id as \"ruleid\",\n\t\tb.name as \"name\",\n\t\tb.regex as \"regex\",\n\t\tb.ruleexample as \"ruleexample\",\n\t\tb.ruleargument as \"ruleargument\",\n\t\tb.note as \"note\",\n\t\tb.defaulttype as \"defaulttype\",\n\t\tb.discoverway as \"discoverway\",\n\t\tb.selectdatafield as \"selectdatafield\",\n\t\tb.dictionaryClass as \"dictionaryClass\",\n\t\tb.matchingway as \"matchingway\",\n\t\tb.remark as \"remark\"\n\t\tFROM\n\t\tt_core_dataarea a left JOIN\n\t\tt_console_searchregex b on\n\t\ta.id = b.dataarea_id left JOIN\n\t\tt_core_project_findrule c on\n\t\tb.id = c.rule_id\n\t\twhere b.name is not null\n\t\tand c.project_id =:projectid\n\t\tORDER BY b.dataarea_id";
      }

      return this.getSession().createNativeQuery(sql).setParameter("projectid", projectid).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
   }

   public List<TCoreSearchregexVO> querySearchregexById(String id) {
      String sql = XmlTool.getSql("dataarea", "querySearchregexById");
      return this.getSession().createNativeQuery(sql).setParameter("id", id).setResultTransformer(Transformers.aliasToBean(TCoreSearchregexVO.class)).getResultList();
   }

   public int queryRuleCount(String dataareaId) {
      String sql = XmlTool.getSql("dataarea", "queryRuleCount");
      int count = Integer.parseInt(this.getSession().createNativeQuery(sql).setParameter("dataareaId", dataareaId).uniqueResult().toString());
      return count;
   }
}
