package com.chenyang.nse.bussiness.dao.table.core.encryption;

import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.SymmetricAlgorithm;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.tools.encryption.EncProvider;
import org.springframework.stereotype.Repository;

@Repository
public class EncryptionConfigDao extends BaseDao<Object, String> {
   public String SM4(String key, String content, String isLike, String keepfirst, String encdigit, String twoindex) throws Exception {
      String decryptStr = EncProvider.decryptEcb("SM4", key, content, isLike, keepfirst, encdigit, twoindex);
      return decryptStr;
   }

   public String DESede(String content, String eky) {
      byte[] key = SecureUtil.generateKey(eky).getEncoded();
      SymmetricCrypto des = new SymmetricCrypto(SymmetricAlgorithm.DESede, key);
      String decryptStr = des.decryptStr(content);
      return decryptStr;
   }
}
