package com.chenyang.nse.bussiness.dao.table.core.file;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructure;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.util.List;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreFileStructureDao extends BaseDao<TCoreFileStructure, String> {
   public List<String> queryDistinctGroupname() {
      String sql = XmlTool.getSql("filesystem", "queryDistinctGroupname");
      List<String> list = this.getSession().createNativeQuery(sql).getResultList();
      return list;
   }

   public List<TCoreFileStructure> queryGroupFileList() {
      String sql = "SELECT s.Id AS \"id\",s.flag AS \"flag\",s.codepage AS \"codepage\",s.filestructurename AS \"filestructurename\",s.skiprows AS \"skiprows\"\n,s.splitertype AS \"splitertype\",g.groupname AS \"filestructuregroup\" ,g.id as \"groupid\"  \nFROM t_core_file_structure s\nright JOIN t_core_file_structure_group g on s.filestructuregroup = g.groupname";
      return this.getSession().createNativeQuery(sql).setResultTransformer(Transformers.aliasToBean(TCoreFileStructure.class)).getResultList();
   }

   public void updateFileStructureGroup(String groupname, String groupname1) {
      String sql = "UPDATE t_core_file_structure SET filestructuregroup = ? WHERE filestructuregroup = ?";
      this.getSession().createNativeQuery(sql).setParameter(1, groupname).setParameter(2, groupname1).executeUpdate();
   }
}
