package com.chenyang.nse.bussiness.dao.table.core.masking;

import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingTask;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.TCoreMaskingTaskVO;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.util.List;
import java.util.Map;
import org.hibernate.transform.Transformers;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreMaskingTaskDao extends BaseDao<TCoreMaskingTask, String> {
   public List<TCoreMaskingTaskVO> queryMaskingTaskVOByID(String taskid) {
      String sql = XmlTool.getSql("maskingtask", "queryMaskingTaskVOByID");
      List<TCoreMaskingTaskVO> list = this.getSession().createNativeQuery(sql).setParameter("taskid", taskid).setResultTransformer(Transformers.aliasToBean(TCoreMaskingTaskVO.class)).getResultList();
      return list;
   }

   public List<Map<String, String>> queryMultiDBSourceMapping(String taskid, String tablename) {
      String sql = XmlTool.getSql("maskingtask", "queryMultiDBSourceMapping");
      List<Map<String, String>> list = this.getSession().createNativeQuery(sql).setParameter("taskid", taskid).setParameter("tablename", tablename).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public List<Map<String, String>> queryMultiHiveSourceMapping(String taskid, String tablename) {
      String sql = XmlTool.getSql("maskingtask", "queryMultiHiveSourceMapping");
      List<Map<String, String>> list = this.getSession().createNativeQuery(sql).setParameter("taskid", taskid).setParameter("tablename", tablename).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public List<Map<String, String>> queryMultiFSSourceMapping(String taskid, String structureid) {
      String sql = XmlTool.getSql("maskingtask", "queryMultiFSSourceMapping");
      List<Map<String, String>> list = this.getSession().createNativeQuery(sql).setParameter("taskid", taskid).setParameter("structureid", structureid).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public List<Map<String, String>> queryMultiDbToFsStructure(String taskid) {
      String sql = XmlTool.getSql("maskingtask", "queryMultiDbToFsStructure");
      List<Map<String, String>> list = this.getSession().createNativeQuery(sql).setParameter("taskid", taskid).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public List<Map<String, String>> queryStructureSpli(String structureid) {
      String sql = XmlTool.getSql("maskingtask", "queryStructureSpli");
      List<Map<String, String>> list = this.getSession().createNativeQuery(sql).setParameter("structureid", structureid).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public List<Map<String, String>> queryStructureWidth(String structureid) {
      String sql = XmlTool.getSql("maskingtask", "queryStructureWidth");
      List<Map<String, String>> list = this.getSession().createNativeQuery(sql).setParameter("structureid", structureid).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public List<TCoreMaskingTask> querytask(String flag) {
      String sql = XmlTool.getSql("maskingtask", "querytask");
      List<TCoreMaskingTask> list = this.getSession().createNativeQuery(sql, TCoreMaskingTask.class).setParameter("flag", flag).setMaxResults(10).getResultList();
      return list;
   }

   public List<Map<String, String>> querySingleDbMapping(String taskid, String datadirection) {
      String sql = XmlTool.getSql("maskingtask", "querySingleDbMapping");
      List<Map<String, String>> list = this.getSession().createNativeQuery(sql).setParameter("taskid", taskid).setParameter("datadirection", datadirection).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public List<Map<String, String>> querySingleHiveMapping(String taskid, String datadirection) {
      String sql = XmlTool.getSql("maskingtask", "querySingleHiveMapping");
      List<Map<String, String>> list = this.getSession().createNativeQuery(sql).setParameter("taskid", taskid).setParameter("datadirection", datadirection).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }

   public List<Map<String, String>> querySingleFsMapping(String taskid, String datadirection) {
      String sql = XmlTool.getSql("maskingtask", "querySingleFsMapping");
      List<Map<String, String>> list = this.getSession().createNativeQuery(sql).setParameter("taskid", taskid).setParameter("datadirection", datadirection).setResultTransformer(Transformers.ALIAS_TO_ENTITY_MAP).getResultList();
      return list;
   }
}
