package com.chenyang.nse.bussiness.engine.infa.basic.wsclient;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(
   name = "WorkflowRequest",
   propOrder = {"diServiceInfo", "folderName", "workflowName", "workflowRunId", "workflowRunInstanceName", "reason", "attribute", "key", "parameterFileName", "parameters", "requestMode", "taskInstancePath", "isAbort", "osUser"}
)
public class WorkflowRequest {
   @XmlElement(
      name = "DIServiceInfo",
      required = true,
      nillable = true
   )
   protected DIServiceInfo diServiceInfo;
   @XmlElement(
      name = "FolderName",
      required = true,
      nillable = true
   )
   protected String folderName;
   @XmlElement(
      name = "WorkflowName",
      required = true,
      nillable = true
   )
   protected String workflowName;
   @XmlElement(
      name = "WorkflowRunId",
      required = true,
      type = Integer.class,
      nillable = true
   )
   protected Integer workflowRunId;
   @XmlElement(
      name = "WorkflowRunInstanceName",
      required = true,
      nillable = true
   )
   protected String workflowRunInstanceName;
   @XmlElement(
      name = "Reason",
      required = true,
      nillable = true
   )
   protected String reason;
   @XmlElement(
      name = "Attribute"
   )
   protected List<Attribute> attribute;
   @XmlElement(
      name = "Key"
   )
   protected List<Key> key;
   @XmlElement(
      name = "ParameterFileName",
      required = true,
      nillable = true
   )
   protected String parameterFileName;
   @XmlElement(
      name = "Parameters",
      required = true,
      nillable = true
   )
   protected ParameterArray parameters;
   @XmlElement(
      name = "RequestMode",
      required = true,
      nillable = true
   )
   @XmlSchemaType(
      name = "token"
   )
   protected ETaskRunMode requestMode;
   @XmlElement(
      name = "TaskInstancePath",
      required = true,
      nillable = true
   )
   protected String taskInstancePath;
   @XmlElement(
      name = "IsAbort"
   )
   protected boolean isAbort;
   @XmlElement(
      name = "OSUser",
      required = true,
      nillable = true
   )
   protected String osUser;

   public DIServiceInfo getDIServiceInfo() {
      return this.diServiceInfo;
   }

   public void setDIServiceInfo(DIServiceInfo value) {
      this.diServiceInfo = value;
   }

   public String getFolderName() {
      return this.folderName;
   }

   public void setFolderName(String value) {
      this.folderName = value;
   }

   public String getWorkflowName() {
      return this.workflowName;
   }

   public void setWorkflowName(String value) {
      this.workflowName = value;
   }

   public Integer getWorkflowRunId() {
      return this.workflowRunId;
   }

   public void setWorkflowRunId(Integer value) {
      this.workflowRunId = value;
   }

   public String getWorkflowRunInstanceName() {
      return this.workflowRunInstanceName;
   }

   public void setWorkflowRunInstanceName(String value) {
      this.workflowRunInstanceName = value;
   }

   public String getReason() {
      return this.reason;
   }

   public void setReason(String value) {
      this.reason = value;
   }

   public List<Attribute> getAttribute() {
      if (this.attribute == null) {
         this.attribute = new ArrayList();
      }

      return this.attribute;
   }

   public List<Key> getKey() {
      if (this.key == null) {
         this.key = new ArrayList();
      }

      return this.key;
   }

   public String getParameterFileName() {
      return this.parameterFileName;
   }

   public void setParameterFileName(String value) {
      this.parameterFileName = value;
   }

   public ParameterArray getParameters() {
      return this.parameters;
   }

   public void setParameters(ParameterArray value) {
      this.parameters = value;
   }

   public ETaskRunMode getRequestMode() {
      return this.requestMode;
   }

   public void setRequestMode(ETaskRunMode value) {
      this.requestMode = value;
   }

   public String getTaskInstancePath() {
      return this.taskInstancePath;
   }

   public void setTaskInstancePath(String value) {
      this.taskInstancePath = value;
   }

   public boolean isIsAbort() {
      return this.isAbort;
   }

   public void setIsAbort(boolean value) {
      this.isAbort = value;
   }

   public String getOSUser() {
      return this.osUser;
   }

   public void setOSUser(String value) {
      this.osUser = value;
   }
}
