package com.chenyang.nse.bussiness.engine.infa.powercenter961.maskdata;

import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.TARGET;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.TARGETFIELD;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.TargetBean;
import java.util.ArrayList;
import java.util.List;

public class Targetutil {
   public static TARGET getTarget(TargetBean tar_bean) {
      TARGET target = new TARGET();

      try {
         target = getTARGETXml(tar_bean.getDatabasetype(), tar_bean.getTar_name(), tar_bean.getCb().getKeytype(), tar_bean.getCb().getNameList(), tar_bean.getCb().getTypeList(), tar_bean.getCb().getLengthList(), tar_bean.getCb().getScalelist(), tar_bean.getCb().getPrecisionList());
      } catch (Exception e) {
         e.printStackTrace();
      }

      return target;
   }

   public static TARGET getTARGETXml(String dbtype, String targetname, List<String> keytype, List<String> nameList, List<String> typeList, List<String> lengthList, List<String> scalelist, List<String> precisionlist) throws Exception {
      TARGET target = new TARGET();
      target.setBUSINESSNAME("");
      target.setCONSTRAINT("");
      target.setDATABASETYPE(dbtype);
      target.setDESCRIPTION("");
      target.setNAME(targetname);
      target.setOBJECTVERSION("1");
      target.setTABLEOPTIONS("");
      target.setVERSIONNUMBER("1");

      for(TARGETFIELD targetfield : getConvertTableInfoToTARGETFIELD(keytype, nameList, typeList, lengthList, scalelist, precisionlist, dbtype)) {
         target.getTARGETFIELD().add(targetfield);
      }

      return target;
   }

   public static List<TARGETFIELD> getConvertTableInfoToTARGETFIELD(List<String> keytype, List<String> nameList, List<String> typeList, List<String> lengthList, List<String> scalelist, List<String> precisionlist, String dbtype) {
      List targetFieldList = new ArrayList();
      String[] targetFieldInfoStr = null;
      if ("DB2".equalsIgnoreCase(dbtype)) {
         for(int i = 0; i < nameList.size(); ++i) {
            TARGETFIELD targetfield = new TARGETFIELD();
            targetfield.setBUSINESSNAME("");
            if ("date".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("10");
               targetfield.setSCALE("0");
            } else if ("time".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("8");
               targetfield.setSCALE("0");
            } else if ("timestamp".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("26");
               targetfield.setSCALE("6");
            } else {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
            }

            if ("character".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setDATATYPE("char");
            } else {
               targetfield.setDATATYPE((String)typeList.get(i));
            }

            targetfield.setDESCRIPTION("");
            targetfield.setFIELDNUMBER("" + (i + 1));
            targetfield.setKEYTYPE((String)keytype.get(i));
            targetfield.setNAME((String)nameList.get(i));
            if ("PRIMARY KEY".equals(keytype.get(i))) {
               targetfield.setNULLABLE("NOTNULL");
            } else {
               targetfield.setNULLABLE("NULL");
            }

            targetfield.setPICTURETEXT("");
            targetFieldList.add(targetfield);
         }
      } else if ("Oracle".equalsIgnoreCase(dbtype)) {
         for(int i = 0; i < nameList.size(); ++i) {
            TARGETFIELD targetfield = new TARGETFIELD();
            targetfield.setBUSINESSNAME("");
            if ("date".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("19");
               targetfield.setSCALE("0");
            } else if ("time".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("8");
               targetfield.setSCALE("0");
            } else if ("timestamp".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setPRECISION("26");
               targetfield.setSCALE("6");
            } else {
               targetfield.setSCALE((String)scalelist.get(i));
               targetfield.setPRECISION((String)precisionlist.get(i));
            }

            if ("character".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setDATATYPE("char");
            } else if ("number".equalsIgnoreCase((String)typeList.get(i))) {
               targetfield.setDATATYPE("number(p,s)");
            } else {
               targetfield.setDATATYPE((String)typeList.get(i));
            }

            targetfield.setDESCRIPTION("");
            targetfield.setFIELDNUMBER("" + (i + 1));
            targetfield.setKEYTYPE((String)keytype.get(i));
            targetfield.setNAME((String)nameList.get(i));
            if ("PRIMARY KEY".equals(keytype.get(i))) {
               targetfield.setNULLABLE("NOTNULL");
            } else {
               targetfield.setNULLABLE("NULL");
            }

            targetfield.setPICTURETEXT("");
            targetFieldList.add(targetfield);
         }
      }

      return targetFieldList;
   }
}
