package com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool;

import com.sun.xml.internal.txw2.output.CharacterEscapeHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.springframework.stereotype.Component;

@Component
public class ToObjutil {
   public static Object unmarshal(String contextPath, InputStream xmlStream) throws JAXBException {
      JAXBContext jc = JAXBContext.newInstance(contextPath);
      Unmarshaller u = jc.createUnmarshaller();
      return u.unmarshal(xmlStream);
   }

   public static Object unmarshalmo(String contextPath, String in) throws Exception {
      InputStream xmlStream = new ByteArrayInputStream(in.getBytes("UTF-8"));
      JAXBContext jc = JAXBContext.newInstance(contextPath);
      Unmarshaller u = jc.createUnmarshaller();
      return u.unmarshal(xmlStream);
   }

   public static void marshal(String contextPath, List<Object> obj, OutputStream stream, String hasTitle) throws JAXBException, IOException {
      OutputStreamWriter writer = null;

      try {
         JAXBContext jc = JAXBContext.newInstance(contextPath);
         Marshaller m = jc.createMarshaller();
         m.setProperty("jaxb.encoding", "UTF-8");
         m.setProperty("jaxb.formatted.output", true);
         m.setProperty("jaxb.fragment", true);
         m.setProperty("com.sun.xml.internal.bind.marshaller.CharacterEscapeHandler", new CharacterEscapeHandler() {
            public void escape(char[] ch, int start, int length, boolean isAttVal, Writer writer) throws IOException {
               writer.write(ch, start, length);
            }
         });
         writer = new OutputStreamWriter(stream, "utf-8");
         writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
         writer.append("<!DOCTYPE POWERMART SYSTEM \"powrmart.dtd\">\n");
         m.marshal(obj.get(0), writer);
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         if (null != writer) {
            writer.close();
         }

      }

   }

   public static void marshalmapplet(String contextPath, List<Object> obj, OutputStream stream, String hasTitle) throws JAXBException, IOException {
      OutputStreamWriter writer = null;

      try {
         JAXBContext jc = JAXBContext.newInstance(contextPath);
         Marshaller m = jc.createMarshaller();
         m.setProperty("jaxb.encoding", "UTF-8");
         m.setProperty("jaxb.formatted.output", true);
         m.setProperty("jaxb.fragment", true);
         writer = new OutputStreamWriter(stream, "utf-8");
         writer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
         writer.append("<!DOCTYPE POWERMART SYSTEM \"powrmart.dtd\">\n");
         m.marshal(obj.get(0), writer);
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         if (null != writer) {
            writer.close();
         }

      }

   }

   public static void marshalImport(String contextPath, List<Object> obj, OutputStream stream, String hasTitle) throws JAXBException, IOException {
      OutputStreamWriter writer = null;

      try {
         JAXBContext jc = JAXBContext.newInstance(contextPath);
         Marshaller m = jc.createMarshaller();
         m.setProperty("jaxb.encoding", "UTF-8");
         m.setProperty("jaxb.formatted.output", true);
         m.setProperty("jaxb.fragment", true);
         writer = new OutputStreamWriter(stream);
         writer.append("<!DOCTYPE IMPORTPARAMS SYSTEM \"impcntl.dtd\">");
         m.marshal(obj.get(0), writer);
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         if (null != writer) {
            writer.close();
         }

      }

   }
}
