package com.chenyang.nse.bussiness.engine.infa.powercenter961.targetforhive;

import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.FLATFILE;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.SOURCE;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.SOURCEFIELD;
import com.chenyang.nse.bussiness.engine.infa.basic.xmlbean.TABLEATTRIBUTE;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubbean.SourceBean;
import java.util.ArrayList;
import java.util.List;

public class SourceUtil {
   public static SOURCE getSource(SourceBean sou_bean) {
      SOURCE source = new SOURCE();
      source.setBUSINESSNAME("");
      if ("Flat File".equalsIgnoreCase(sou_bean.getDatabasetype())) {
         source.setDBDNAME("FlatFile");
      } else {
         source.setDBDNAME(sou_bean.getDbdname());
      }

      source.setNAME(sou_bean.getSo_name());
      source.setOWNERNAME(sou_bean.getSo_ownname());
      source.setDESCRIPTION("");
      source.setOBJECTVERSION("1");
      source.setVERSIONNUMBER("1");
      List<SOURCEFIELD> sourceFieldList = new ArrayList();
      if ("ORACLE".equalsIgnoreCase(sou_bean.getDatabasetype())) {
         sourceFieldList = getOracleField(sou_bean);
         source.setDATABASETYPE(sou_bean.getDatabasetype());
      } else if ("DB2".equalsIgnoreCase(sou_bean.getDatabasetype())) {
         sourceFieldList = getDb2Field(sou_bean);
         source.setDATABASETYPE(sou_bean.getDatabasetype());
      } else if ("INFORMIX".equalsIgnoreCase(sou_bean.getDatabasetype())) {
         sourceFieldList = getInformixField(sou_bean);
         source.setDATABASETYPE("Informix");
      } else if ("MSSQLSERVER".equalsIgnoreCase(sou_bean.getDatabasetype())) {
         sourceFieldList = getSqlserverField(sou_bean);
         source.setDATABASETYPE("Microsoft SQL Server");
      } else if ("MYSQL".equalsIgnoreCase(sou_bean.getDatabasetype())) {
         sourceFieldList = getMysqlField(sou_bean);
         source.setDATABASETYPE("ODBC");
      } else if ("AS400".equalsIgnoreCase(sou_bean.getDatabasetype())) {
         sourceFieldList = getASField(sou_bean);
         source.setDATABASETYPE("ODBC");
      } else if ("SYBASE".equalsIgnoreCase(sou_bean.getDatabasetype())) {
         sourceFieldList = getSybaseField(sou_bean);
         source.setDATABASETYPE("Sybase");
      } else if ("HIVE".equalsIgnoreCase(sou_bean.getDatabasetype())) {
         source.setDATABASETYPE("Flat File");
         source.setDBDNAME("Flat_File");
         FLATFILE flatfile = new FLATFILE();
         flatfile.setCODEPAGE(sou_bean.getFilebean().getCodepage());
         flatfile.setCONSECDELIMITERSASONE(sou_bean.getFilebean().getConsecdelimitersasone());
         flatfile.setDELIMITED(sou_bean.getFilebean().getDelimited());
         flatfile.setDELIMITERS(sou_bean.getFilebean().getDelimiters());
         flatfile.setESCAPECHARACTER(sou_bean.getFilebean().getEscape_character());
         flatfile.setKEEPESCAPECHAR(sou_bean.getFilebean().getKeepescapechar());
         flatfile.setLINESEQUENTIAL("NO");
         flatfile.setMULTIDELIMITERSASAND(sou_bean.getFilebean().getMultidelimitersasand());
         flatfile.setNULLCHARTYPE("ASCII");
         flatfile.setNULLCHARACTER("*");
         flatfile.setPADBYTES("1");
         flatfile.setQUOTECHARACTER(sou_bean.getFilebean().getQuote_character());
         flatfile.setREPEATABLE("NO");
         flatfile.setROWDELIMITER(sou_bean.getFilebean().getRowdelimiter());
         flatfile.setSKIPROWS("0");
         flatfile.setSTRIPTRAILINGBLANKS("NO");
         source.setFLATFILE(flatfile);
         if ("".equals(sou_bean.getDateformateparam()) || sou_bean.getDateformateparam() == null) {
            sou_bean.setDateformateparam("F  29 YYYY-MM-DD HH:MM:SS");
         }

         for(int i = 0; i < sou_bean.getCb().getDateformatlist().size(); ++i) {
            if (sou_bean.getCb().getDateformatlist().get(i) != null && !"".equals(sou_bean.getCb().getDateformatlist().get(i))) {
               sou_bean.setDateformateparam("F  29 " + (String)sou_bean.getCb().getDateformatlist().get(i));
               break;
            }
         }

         String[] attributeStr = new String[]{"Datetime Format@" + sou_bean.getDateformateparam(), "Thousand Separator@None", "Decimal Separator@.", "Line Endings@System default"};
         String[] tmpAttr = null;
         TABLEATTRIBUTE[] attribute = new TABLEATTRIBUTE[attributeStr.length];

         for(int j = 0; j < attributeStr.length; ++j) {
            tmpAttr = attributeStr[j].split("@");
            attribute[j] = new TABLEATTRIBUTE();
            attribute[j].setNAME(tmpAttr[0]);
            if (tmpAttr.length > 1) {
               attribute[j].setVALUE(tmpAttr[1]);
            } else {
               attribute[j].setVALUE("");
            }

            source.getTABLEATTRIBUTE().add(attribute[j]);
         }

         sourceFieldList = getHiveFileField(sou_bean);
      } else if ("Flat File".equalsIgnoreCase(sou_bean.getDatabasetype())) {
         source.setDATABASETYPE(sou_bean.getDatabasetype());
         FLATFILE flatfile = new FLATFILE();
         if ("1".equals(sou_bean.getFileparam())) {
            flatfile.setCODEPAGE(sou_bean.getFilebean().getCodepage());
            flatfile.setCONSECDELIMITERSASONE(sou_bean.getFilebean().getConsecdelimitersasone());
            flatfile.setDELIMITED(sou_bean.getFilebean().getDelimited());
            flatfile.setDELIMITERS(sou_bean.getFilebean().getDelimiters());
            flatfile.setESCAPECHARACTER(sou_bean.getFilebean().getEscape_character());
            flatfile.setKEEPESCAPECHAR(sou_bean.getFilebean().getKeepescapechar());
            flatfile.setLINESEQUENTIAL("NO");
            flatfile.setMULTIDELIMITERSASAND(sou_bean.getFilebean().getMultidelimitersasand());
            flatfile.setNULLCHARTYPE("ASCII");
            flatfile.setNULLCHARACTER("*");
            flatfile.setPADBYTES("1");
            flatfile.setQUOTECHARACTER(sou_bean.getFilebean().getQuote_character());
            flatfile.setREPEATABLE("NO");
            flatfile.setROWDELIMITER(sou_bean.getFilebean().getRowdelimiter());
            flatfile.setSHIFTSENSITIVEDATA("NO");
            flatfile.setSKIPROWS(sou_bean.getFilebean().getSkiprows());
            flatfile.setSTRIPTRAILINGBLANKS("NO");
         } else {
            flatfile.setCODEPAGE(sou_bean.getFilebean().getCodepage());
            flatfile.setCONSECDELIMITERSASONE("NO");
            flatfile.setDELIMITED("NO");
            flatfile.setDELIMITERS("NO");
            flatfile.setESCAPECHARACTER("");
            flatfile.setKEEPESCAPECHAR("DOUBLE");
            flatfile.setLINESEQUENTIAL(sou_bean.getFilebean().getLinesequential());
            flatfile.setMULTIDELIMITERSASAND("NO");
            flatfile.setNULLCHARTYPE(sou_bean.getFilebean().getNullchartype());
            flatfile.setNULLCHARACTER(sou_bean.getFilebean().getNull_character());
            flatfile.setPADBYTES(sou_bean.getFilebean().getPadbytes());
            flatfile.setQUOTECHARACTER("DOUBLE");
            flatfile.setREPEATABLE(sou_bean.getFilebean().getRepeatable());
            flatfile.setROWDELIMITER("0");
            flatfile.setSHIFTSENSITIVEDATA(sou_bean.getFilebean().getShiftsensitivedata());
            flatfile.setSKIPROWS(sou_bean.getFilebean().getSkiprows());
            flatfile.setSTRIPTRAILINGBLANKS(sou_bean.getFilebean().getStriptrailingblanks());
         }

         source.setFLATFILE(flatfile);
         if ("".equals(sou_bean.getDateformateparam()) || sou_bean.getDateformateparam() == null) {
            sou_bean.setDateformateparam("A  19 mm/dd/yyyy hh24:mi:ss");
         }

         String[] attributeStr = new String[]{"Base Table Name@", "Search Specification@", "Sort Specification@", "Datetime Format@" + sou_bean.getDateformateparam(), "Thousand Separator@None", "Decimal Separator@.", "Add Currently Processed Flat File Name Port@NO"};
         String[] tmpAttr = null;
         TABLEATTRIBUTE[] attribute = new TABLEATTRIBUTE[attributeStr.length];

         for(int j = 0; j < attributeStr.length; ++j) {
            tmpAttr = attributeStr[j].split("@");
            attribute[j] = new TABLEATTRIBUTE();
            attribute[j].setNAME(tmpAttr[0]);
            if (tmpAttr.length > 1) {
               attribute[j].setVALUE(tmpAttr[1]);
            } else {
               attribute[j].setVALUE("");
            }

            source.getTABLEATTRIBUTE().add(attribute[j]);
         }

         if ("1".equals(sou_bean.getFileparam())) {
            sourceFieldList = getFileLimitField(sou_bean);
         } else {
            sourceFieldList = getFileSpaceField(sou_bean);
         }
      }

      for(SOURCEFIELD sourcefield : sourceFieldList) {
         source.getSOURCEFIELD().add(sourcefield);
      }

      return source;
   }

   public static List<SOURCEFIELD> getOracleField(SourceBean sou_bean) {
      List<SOURCEFIELD> sourceFieldList = new ArrayList();
      int phyOffset = 0;
      int prePhyOffset = 0;
      int offset = 0;
      int preOffset = 0;

      for(int i = 0; i < sou_bean.getCb().getNameList().size(); ++i) {
         SOURCEFIELD sourceField = new SOURCEFIELD();
         sourceField.setBUSINESSNAME("");
         sourceField.setDESCRIPTION("");
         sourceField.setFIELDNUMBER(i + 1 + "");
         sourceField.setFIELDPROPERTY("0");
         sourceField.setFIELDTYPE("ELEMITEM");
         sourceField.setHIDDEN("NO");
         sourceField.setKEYTYPE((String)sou_bean.getCb().getKeytype().get(i));
         if ("VARCHAR2".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("varchar2");
         } else if ("NUMBER".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("24");
            sourceField.setPHYSICALLENGTH("15");
            sourceField.setPRECISION("15");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("number");
         } else if ("DATE".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("19");
            sourceField.setPHYSICALLENGTH("19");
            sourceField.setPRECISION("19");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("date");
         } else if ("CLOB".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("4000");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("4000");
            sourceField.setDATATYPE("clob");
         } else if ("BLOB".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("8000");
            sourceField.setPHYSICALLENGTH("4000");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("4000");
            sourceField.setDATATYPE("blob");
         } else if ("BFILE".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("8000");
            sourceField.setPHYSICALLENGTH("4000");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("4000");
            sourceField.setDATATYPE("long raw");
         } else if ("BINARY_DOUBLE".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("24");
            sourceField.setPHYSICALLENGTH("15");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("15");
            sourceField.setDATATYPE("number");
         } else if ("BINARY_FLOAT".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("24");
            sourceField.setPHYSICALLENGTH("15");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("15");
            sourceField.setDATATYPE("number");
         } else if ("CHAR".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("1");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("1");
            sourceField.setDATATYPE("char");
         } else if ("number(p,s)".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("40");
            sourceField.setPHYSICALLENGTH("38");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("38");
            sourceField.setDATATYPE("number(p,s)");
         } else if ("INTERVAL DAY(2) TO SECOND(6)".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("0");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("0");
            sourceField.setDATATYPE("varchar2");
         } else if ("INTERVAL YEAR(2) TO MONTH".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("0");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("0");
            sourceField.setDATATYPE("varchar2");
         } else if ("LONG".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("4000");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("4000");
            sourceField.setDATATYPE("long");
         } else if ("NCHAR".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("1");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("1");
            sourceField.setDATATYPE("varchar2");
         } else if ("NVARCHAR2".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("20");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("20");
            sourceField.setDATATYPE("varchar2");
         } else if ("NCLOB".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("0");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("0");
            sourceField.setDATATYPE("varchar2");
         } else if ("RAW".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("40");
            sourceField.setPHYSICALLENGTH("20");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("20");
            sourceField.setDATATYPE("raw");
         } else if ("ROWID".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("0");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("0");
            sourceField.setDATATYPE("varchar2");
         } else if ("TIMESTAMP(6)".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("19");
            sourceField.setPHYSICALLENGTH("26");
            sourceField.setSCALE("6");
            sourceField.setPRECISION("26");
            sourceField.setDATATYPE("timestamp");
         } else if ("UROWID".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("0");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("0");
            sourceField.setDATATYPE("varchar2");
         } else if ("FLOAT".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH("15");
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION("15");
            sourceField.setDATATYPE("number");
         } else {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE((String)sou_bean.getCb().getTypeList().get(i));
         }

         sourceField.setLEVEL("0");
         sourceField.setNAME((String)sou_bean.getCb().getNameList().get(i));
         if ("PRIMARY KEY".equals(sou_bean.getCb().getKeytype().get(i))) {
            sourceField.setNULLABLE("NOTNULL");
         } else {
            sourceField.setNULLABLE("NULL");
         }

         sourceField.setKEYTYPE((String)sou_bean.getCb().getKeytype().get(i));
         sourceField.setOCCURS("0");
         offset += preOffset;
         sourceField.setOFFSET(offset + "");
         phyOffset += prePhyOffset;
         sourceField.setPHYSICALOFFSET(phyOffset + "");
         sourceField.setPICTURETEXT("");
         sourceField.setUSAGEFLAGS("");
         sourceFieldList.add(sourceField);
      }

      return sourceFieldList;
   }

   public static List<SOURCEFIELD> getDb2Field(SourceBean sou_bean) {
      List<SOURCEFIELD> sourceFieldList = new ArrayList();
      int phyOffset = 0;
      int prePhyOffset = 0;
      int offset = 0;
      int preOffset = 0;

      for(int i = 0; i < sou_bean.getCb().getNameList().size(); ++i) {
         SOURCEFIELD sourceField = new SOURCEFIELD();
         sourceField.setBUSINESSNAME("");
         sourceField.setDESCRIPTION("");
         sourceField.setFIELDNUMBER(i + 1 + "");
         sourceField.setFIELDPROPERTY("0");
         sourceField.setFIELDTYPE("ELEMITEM");
         sourceField.setHIDDEN("NO");
         sourceField.setKEYTYPE((String)sou_bean.getCb().getKeytype().get(i));
         if ("blob".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("8000");
            sourceField.setPHYSICALLENGTH("4000");
            sourceField.setPRECISION("4000");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("Byte");
         } else if ("boolean".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("5");
            sourceField.setPHYSICALLENGTH("5");
            sourceField.setPRECISION("5");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("SmallInt");
         } else if ("byte".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("8000");
            sourceField.setPHYSICALLENGTH("4000");
            sourceField.setPRECISION("4000");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("Byte");
         } else if ("varchar".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("Varchar");
         } else if ("char".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("Char");
         } else if ("clob".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("4000");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("4000");
            sourceField.setDATATYPE("Text");
         } else if ("date".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("19");
            sourceField.setPHYSICALLENGTH("10");
            sourceField.setPRECISION("10");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("Date");
         } else if ("datetime".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("19");
            sourceField.setPHYSICALLENGTH("25");
            sourceField.setPRECISION("25");
            sourceField.setSCALE("5");
            sourceField.setDATATYPE("Datetime year to fraction(5)");
         } else if ("float".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("24");
            sourceField.setPHYSICALLENGTH("15");
            sourceField.setPRECISION("15");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("Float");
         } else if ("int8".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("20");
            sourceField.setPHYSICALLENGTH("19");
            sourceField.setPRECISION("19");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("Int8");
         } else if ("int".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("11");
            sourceField.setPHYSICALLENGTH("10");
            sourceField.setPRECISION("10");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("Integer");
         } else if ("money".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("16");
            sourceField.setPRECISION("16");
            sourceField.setSCALE("2");
            sourceField.setDATATYPE("Money");
         } else if ("nchar".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("char");
         } else if ("nvarchar".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("NVarchar");
         } else if ("lvarchar".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("varchar");
         } else if ("serial".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("11");
            sourceField.setPHYSICALLENGTH("10");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("10");
            sourceField.setDATATYPE("Serial");
         } else if ("serial8".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("20");
            sourceField.setPHYSICALLENGTH("19");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("19");
            sourceField.setDATATYPE("Int8");
         } else if ("smallfloat".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("24");
            sourceField.setPHYSICALLENGTH("7");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("7");
            sourceField.setDATATYPE("SmallFloat");
         } else if ("smallint".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("6");
            sourceField.setPHYSICALLENGTH("5");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("5");
            sourceField.setDATATYPE("SmallInt");
         } else if ("decimal".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("Decimal");
         } else if ("double".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("Decimal");
         } else if ("DECFLOAT".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH("15");
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION("15");
            sourceField.setDATATYPE("float");
         } else if ("INTEGER".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("integer");
         } else {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE((String)sou_bean.getCb().getTypeList().get(i));
         }

         sourceField.setLEVEL("0");
         sourceField.setNAME((String)sou_bean.getCb().getNameList().get(i));
         if ("PRIMARY KEY".equals(sou_bean.getCb().getKeytype().get(i))) {
            sourceField.setNULLABLE("NOTNULL");
         } else {
            sourceField.setNULLABLE("NULL");
         }

         sourceField.setKEYTYPE((String)sou_bean.getCb().getKeytype().get(i));
         sourceField.setOCCURS("0");
         offset += preOffset;
         sourceField.setOFFSET(offset + "");
         phyOffset += prePhyOffset;
         sourceField.setPHYSICALOFFSET(phyOffset + "");
         sourceField.setPICTURETEXT("");
         sourceField.setUSAGEFLAGS("");
         sourceFieldList.add(sourceField);
      }

      return sourceFieldList;
   }

   public static List<SOURCEFIELD> getSqlserverField(SourceBean sou_bean) {
      List<SOURCEFIELD> sourceFieldList = new ArrayList();
      int phyOffset = 0;
      int prePhyOffset = 0;
      int offset = 0;
      int preOffset = 0;

      for(int i = 0; i < sou_bean.getCb().getNameList().size(); ++i) {
         SOURCEFIELD sourceField = new SOURCEFIELD();
         sourceField.setBUSINESSNAME("");
         sourceField.setDESCRIPTION("");
         sourceField.setFIELDNUMBER(i + 1 + "");
         sourceField.setFIELDPROPERTY("0");
         sourceField.setFIELDTYPE("ELEMITEM");
         sourceField.setHIDDEN("NO");
         sourceField.setKEYTYPE((String)sou_bean.getCb().getKeytype().get(i));
         if ("bigint".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("20");
            sourceField.setPHYSICALLENGTH("19");
            sourceField.setPRECISION("19");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("bigint");
         } else if ("binary".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("2");
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("binary");
         } else if ("bit".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("1");
            sourceField.setPHYSICALLENGTH("1");
            sourceField.setPRECISION("1");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("bit");
         } else if ("char".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("char");
         } else if ("date".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("19");
            sourceField.setPHYSICALLENGTH("23");
            sourceField.setSCALE("3");
            sourceField.setPRECISION("23");
            sourceField.setDATATYPE("datetime");
         } else if ("datetime".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("19");
            sourceField.setPHYSICALLENGTH("23");
            sourceField.setSCALE("3");
            sourceField.setPRECISION("23");
            sourceField.setDATATYPE("datetime");
         } else if ("datetime2".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("19");
            sourceField.setPHYSICALLENGTH("27");
            sourceField.setPRECISION("27");
            sourceField.setSCALE("7");
            sourceField.setDATATYPE("datetime2");
         } else if ("datetimeoffset".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("34");
            sourceField.setPRECISION("34");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("nvarchar");
         } else if ("decimal".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("12");
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("decimal");
         } else if ("real".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("24");
            sourceField.setPHYSICALLENGTH("7");
            sourceField.setPRECISION("7");
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setDATATYPE("real");
         } else if ("geography".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("varchar");
         } else if ("geometry".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("varchar");
         } else if ("hierarchyid".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH("892");
            sourceField.setSCALE("892");
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("varchar");
         } else if ("image".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("8000");
            sourceField.setPHYSICALLENGTH("4000");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("4000");
            sourceField.setDATATYPE("image");
         } else if ("int".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("11");
            sourceField.setPHYSICALLENGTH("10");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("10");
            sourceField.setDATATYPE("int");
         } else if ("money".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("19");
            sourceField.setSCALE("4");
            sourceField.setPRECISION("19");
            sourceField.setDATATYPE("money");
         } else if ("nchar".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("nchar");
         } else if ("ntext".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("104857600");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("104857600");
            sourceField.setDATATYPE("ntext");
         } else if ("numeric".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("7");
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("numeric");
         } else if ("nvarchar".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("nvarchar");
         } else if ("smalldatetime".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("19");
            sourceField.setPHYSICALLENGTH("19");
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION("19");
            sourceField.setDATATYPE("smalldatetime");
         } else if ("smallint".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("6");
            sourceField.setPHYSICALLENGTH("5");
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION("5");
            sourceField.setDATATYPE("smallint");
         } else if ("smallmoney".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("10");
            sourceField.setSCALE("4");
            sourceField.setPRECISION("10");
            sourceField.setDATATYPE("smallmoney");
         } else if ("sql_variant".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("8000");
            sourceField.setSCALE("4");
            sourceField.setPRECISION("8000");
            sourceField.setDATATYPE("varchar");
         } else if ("sysname".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("128");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("128");
            sourceField.setDATATYPE("nvarchar");
         } else if ("text".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("4000");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("4000");
            sourceField.setDATATYPE("text");
         } else if ("time".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("19");
            sourceField.setPHYSICALLENGTH("23");
            sourceField.setSCALE("3");
            sourceField.setPRECISION("23");
            sourceField.setDATATYPE("datetime");
         } else if ("timestamp".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("16");
            sourceField.setPHYSICALLENGTH("8");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("8");
            sourceField.setDATATYPE("timestamp");
         } else if ("tinyint".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("4");
            sourceField.setPHYSICALLENGTH("3");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("3");
            sourceField.setDATATYPE("tinyint");
         } else if ("uniqueidentifier".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("38");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("38");
            sourceField.setDATATYPE("varchar");
         } else if ("float".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("15");
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION("15");
            sourceField.setDATATYPE("float");
         } else if ("varbinary".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("varchar");
         } else if ("varchar".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("varchar");
         } else {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE((String)sou_bean.getCb().getTypeList().get(i));
         }

         sourceField.setLEVEL("0");
         sourceField.setNAME((String)sou_bean.getCb().getNameList().get(i));
         if ("PRIMARY KEY".equals(sou_bean.getCb().getKeytype().get(i))) {
            sourceField.setNULLABLE("NOTNULL");
         } else {
            sourceField.setNULLABLE("NULL");
         }

         sourceField.setKEYTYPE((String)sou_bean.getCb().getKeytype().get(i));
         sourceField.setOCCURS("0");
         offset += preOffset;
         sourceField.setOFFSET(offset + "");
         phyOffset += prePhyOffset;
         sourceField.setPHYSICALOFFSET(phyOffset + "");
         sourceField.setPICTURETEXT("");
         sourceField.setUSAGEFLAGS("");
         sourceFieldList.add(sourceField);
      }

      return sourceFieldList;
   }

   public static List<SOURCEFIELD> getMysqlField(SourceBean sou_bean) {
      List<SOURCEFIELD> sourceFieldList = new ArrayList();
      int phyOffset = 0;
      int prePhyOffset = 0;
      int offset = 0;
      int preOffset = 0;

      for(int i = 0; i < sou_bean.getCb().getNameList().size(); ++i) {
         SOURCEFIELD sourceField = new SOURCEFIELD();
         sourceField.setBUSINESSNAME("");
         sourceField.setDESCRIPTION("");
         sourceField.setFIELDNUMBER(i + 1 + "");
         sourceField.setFIELDPROPERTY("0");
         sourceField.setFIELDTYPE("ELEMITEM");
         sourceField.setHIDDEN("NO");
         sourceField.setKEYTYPE((String)sou_bean.getCb().getKeytype().get(i));
         if ("TINYINT".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("4");
            sourceField.setPHYSICALLENGTH("3");
            sourceField.setPRECISION("3");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("tinyint");
         } else if ("SMALLINT".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("6");
            sourceField.setPHYSICALLENGTH("5");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("5");
            sourceField.setDATATYPE("smallint");
         } else if ("MEDIUMINT".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("integer");
         } else if ("INT".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("integer");
         } else if ("BIGINT".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("bigint");
         } else if ("BIT".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("1");
            sourceField.setPHYSICALLENGTH("1");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("1");
            sourceField.setDATATYPE("bit");
         } else if ("DOUBLE".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION("15");
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("double");
         } else if ("FLOAT".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION("7");
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("real");
         } else if ("DECIMAL".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("decimal");
         } else if ("CHAR".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("255");
            sourceField.setPRECISION("255");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("nchar");
         } else if ("VARCHAR".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("nvarchar");
         } else if ("DATE".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("19");
            sourceField.setPHYSICALLENGTH("19");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("10");
            sourceField.setDATATYPE("date");
         } else if ("TIME".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("19");
            sourceField.setPHYSICALLENGTH("8");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("8");
            sourceField.setDATATYPE("time");
         } else if ("YEAR".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("6");
            sourceField.setPHYSICALLENGTH("5");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("5");
            sourceField.setDATATYPE("smallint");
         } else if ("TIMESTAMP".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("19");
            sourceField.setPHYSICALLENGTH("29");
            sourceField.setSCALE("9");
            sourceField.setPRECISION("29");
            sourceField.setDATATYPE("timestamp");
         } else if ("DATETIME".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("19");
            sourceField.setPHYSICALLENGTH("29");
            sourceField.setSCALE("9");
            sourceField.setPRECISION("29");
            sourceField.setDATATYPE("timestamp");
         } else if ("TINYBLOB".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("510");
            sourceField.setPHYSICALLENGTH("255");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("255");
            sourceField.setDATATYPE("longvarbinary");
         } else if ("BLOB".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("131070");
            sourceField.setPHYSICALLENGTH("65535");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("65535");
            sourceField.setDATATYPE("longvarbinary");
         } else if ("MEDIUMBLOB".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("33554430");
            sourceField.setPHYSICALLENGTH("16777215");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("16777215");
            sourceField.setDATATYPE("longvarbinary");
         } else if ("LONGBLOB".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("4294967294");
            sourceField.setPHYSICALLENGTH("4294967295");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("4294967295");
            sourceField.setDATATYPE("longvarbinary");
         } else if ("TINYTEXT".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("255");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("255");
            sourceField.setDATATYPE("ntext");
         } else if ("TEXT".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("65535");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("65535");
            sourceField.setDATATYPE("ntext");
         } else if ("MEDIUMTEXT".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("16777215");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("16777215");
            sourceField.setDATATYPE("ntext");
         } else if ("LONGTEXT".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("4294967295");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("4294967295");
            sourceField.setDATATYPE("ntext");
         } else if ("ENUM".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("nchar");
         } else if ("SET".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("nchar");
         } else if ("BINARY".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("510");
            sourceField.setPHYSICALLENGTH("255");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("255");
            sourceField.setDATATYPE("binary");
         } else if ("VARBINARY".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("510");
            sourceField.setPHYSICALLENGTH("255");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("255");
            sourceField.setDATATYPE("varbinary");
         } else if ("POINT".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("4294967294");
            sourceField.setPHYSICALLENGTH("4294967294");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("4294967294");
            sourceField.setDATATYPE("longvarbinary");
         } else if ("LINESTRING".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("4294967294");
            sourceField.setPHYSICALLENGTH("4294967294");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("4294967294");
            sourceField.setDATATYPE("longvarbinary");
         } else if ("POLYGON".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("4294967294");
            sourceField.setPHYSICALLENGTH("4294967294");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("4294967294");
            sourceField.setDATATYPE("longvarbinary");
         } else if ("GEOMETRY".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("4294967294");
            sourceField.setPHYSICALLENGTH("4294967294");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("4294967294");
            sourceField.setDATATYPE("longvarbinary");
         } else if ("MULTIPOINT".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("4294967294");
            sourceField.setPHYSICALLENGTH("4294967294");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("4294967294");
            sourceField.setDATATYPE("longvarbinary");
         } else if ("MULTILINESTRING".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("4294967294");
            sourceField.setPHYSICALLENGTH("4294967294");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("4294967294");
            sourceField.setDATATYPE("longvarbinary");
         } else if ("MULTIPOLYGON".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("4294967294");
            sourceField.setPHYSICALLENGTH("4294967294");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("4294967294");
            sourceField.setDATATYPE("longvarbinary");
         } else if ("GEOMETRYCOLLECTION".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("4294967294");
            sourceField.setPHYSICALLENGTH("4294967294");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("4294967294");
            sourceField.setDATATYPE("longvarbinary");
         } else {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE((String)sou_bean.getCb().getTypeList().get(i));
         }

         sourceField.setLEVEL("0");
         sourceField.setNAME((String)sou_bean.getCb().getNameList().get(i));
         if ("PRIMARY KEY".equals(sou_bean.getCb().getKeytype().get(i))) {
            sourceField.setNULLABLE("NOTNULL");
         } else {
            sourceField.setNULLABLE("NULL");
         }

         sourceField.setKEYTYPE((String)sou_bean.getCb().getKeytype().get(i));
         sourceField.setOCCURS("0");
         offset += preOffset;
         sourceField.setOFFSET(offset + "");
         phyOffset += prePhyOffset;
         sourceField.setPHYSICALOFFSET(phyOffset + "");
         sourceField.setPICTURETEXT("");
         sourceField.setUSAGEFLAGS("");
         sourceFieldList.add(sourceField);
      }

      return sourceFieldList;
   }

   public static List<SOURCEFIELD> getASField(SourceBean sou_bean) {
      List<SOURCEFIELD> sourceFieldList = new ArrayList();
      int phyOffset = 0;
      int prePhyOffset = 0;
      int offset = 0;
      int preOffset = 0;

      for(int i = 0; i < sou_bean.getCb().getNameList().size(); ++i) {
         SOURCEFIELD sourceField = new SOURCEFIELD();
         sourceField.setBUSINESSNAME("");
         sourceField.setDESCRIPTION("");
         sourceField.setFIELDNUMBER(i + 1 + "");
         sourceField.setFIELDPROPERTY("0");
         sourceField.setFIELDTYPE("ELEMITEM");
         sourceField.setHIDDEN("NO");
         sourceField.setKEYTYPE((String)sou_bean.getCb().getKeytype().get(i));
         if ("BIGINT".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("20");
            sourceField.setPHYSICALLENGTH("19");
            sourceField.setPRECISION("19");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("bigint");
         } else if ("BLOB".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("2097152");
            sourceField.setPHYSICALLENGTH("1048576");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("1048576");
            sourceField.setDATATYPE("longvarbinary");
         } else if ("CHAR".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION("20");
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("20");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("char");
         } else if ("CHAR () FOR BIT DATA".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION("5");
            sourceField.setLENGTH("10");
            sourceField.setPHYSICALLENGTH("5");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("binary");
         } else if ("CLOB".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION("1048576");
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("1048576");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("text");
         } else if ("DATE".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("19");
            sourceField.setPHYSICALLENGTH("10");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("10");
            sourceField.setDATATYPE("date");
         } else if ("DBCLOB".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION("1048576");
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH("1048576");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("ntext");
         } else if ("DECFLOAT".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION("15");
            sourceField.setLENGTH("24");
            sourceField.setPHYSICALLENGTH("15");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("double");
         } else if ("DECIMAL".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("decimal");
         } else if ("DOUBLE".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("double");
         } else if ("GRAPHIC".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE("0");
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("nchar");
         } else if ("INTEGER".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("11");
            sourceField.setPHYSICALLENGTH("10");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("10");
            sourceField.setDATATYPE("integer");
         } else if ("LONG VARCHAR".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("32700");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("32700");
            sourceField.setDATATYPE("text");
         } else if ("LONG VARGRAPHIC".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("16350");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("16350");
            sourceField.setDATATYPE("ntext");
         } else if ("REAL".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("15");
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION("15");
            sourceField.setDATATYPE("double");
         } else if ("SMALLINT".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("6");
            sourceField.setPHYSICALLENGTH("5");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("5");
            sourceField.setDATATYPE("smallint");
         } else if ("TIME".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("19");
            sourceField.setPHYSICALLENGTH("8");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("8");
            sourceField.setDATATYPE("time");
         } else if ("TIMESTAMP".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("19");
            sourceField.setPHYSICALLENGTH("29");
            sourceField.setSCALE("9");
            sourceField.setPRECISION("29");
            sourceField.setDATATYPE("timestamp");
         } else if ("VARCHAR".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE("0");
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("varchar");
         } else if ("VARCHAR () FOR BIT DATA".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE("0");
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("varbinary");
         } else if ("VARGRAPHIC".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE("0");
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("nvarchar");
         } else if ("XML".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("4000");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("4000");
            sourceField.setDATATYPE("ntext");
         } else {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE((String)sou_bean.getCb().getTypeList().get(i));
         }

         sourceField.setLEVEL("0");
         sourceField.setNAME((String)sou_bean.getCb().getNameList().get(i));
         if ("PRIMARY KEY".equals(sou_bean.getCb().getKeytype().get(i))) {
            sourceField.setNULLABLE("NOTNULL");
         } else {
            sourceField.setNULLABLE("NULL");
         }

         sourceField.setKEYTYPE((String)sou_bean.getCb().getKeytype().get(i));
         sourceField.setOCCURS("0");
         offset += preOffset;
         sourceField.setOFFSET(offset + "");
         phyOffset += prePhyOffset;
         sourceField.setPHYSICALOFFSET(phyOffset + "");
         sourceField.setPICTURETEXT("");
         sourceField.setUSAGEFLAGS("");
         sourceFieldList.add(sourceField);
      }

      return sourceFieldList;
   }

   public static List<SOURCEFIELD> getHiveFileField(SourceBean sou_bean) {
      List<SOURCEFIELD> sourceFieldList = new ArrayList();
      int phyOffset = 0;
      int prePhyOffset = 0;
      int offset = 0;
      int preOffset = 0;

      for(int i = 0; i < sou_bean.getCb().getNameList().size(); ++i) {
         SOURCEFIELD sourceField = new SOURCEFIELD();
         sourceField.setBUSINESSNAME("");
         sourceField.setDESCRIPTION("");
         sourceField.setFIELDNUMBER(i + 1 + "");
         sourceField.setFIELDPROPERTY("0");
         sourceField.setFIELDTYPE("ELEMITEM");
         sourceField.setHIDDEN("NO");
         sourceField.setKEYTYPE("NOT A KEY");
         sourceField.setLEVEL("0");
         sourceField.setNAME((String)sou_bean.getCb().getNameList().get(i));
         sourceField.setNULLABLE("NULL");
         sourceField.setOCCURS("0");
         offset += preOffset;
         sourceField.setOFFSET(offset + "");
         phyOffset += prePhyOffset;
         sourceField.setPHYSICALOFFSET(phyOffset + "");
         sourceField.setUSAGEFLAGS("");
         sourceField.setSCALE("0");
         sourceField.setPRECISION("255");
         sourceField.setLENGTH("255");
         sourceField.setPHYSICALLENGTH("255");
         sourceField.setDATATYPE("string");
         sourceField.setPICTURETEXT("");
         sourceFieldList.add(sourceField);
      }

      return sourceFieldList;
   }

   public static List<SOURCEFIELD> getSybaseField(SourceBean sou_bean) {
      List<SOURCEFIELD> sourceFieldList = new ArrayList();
      int phyOffset = 0;
      int prePhyOffset = 0;
      int offset = 0;
      int preOffset = 0;

      for(int i = 0; i < sou_bean.getCb().getNameList().size(); ++i) {
         SOURCEFIELD sourceField = new SOURCEFIELD();
         sourceField.setBUSINESSNAME("");
         sourceField.setDESCRIPTION("");
         sourceField.setFIELDNUMBER(i + 1 + "");
         sourceField.setFIELDPROPERTY("0");
         sourceField.setFIELDTYPE("ELEMITEM");
         sourceField.setHIDDEN("NO");
         sourceField.setKEYTYPE((String)sou_bean.getCb().getKeytype().get(i));
         if ("bigint".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("20");
            sourceField.setPHYSICALLENGTH("19");
            sourceField.setPRECISION("19");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("bigint");
         } else if ("binary".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("binary");
         } else if ("bit".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("bit");
         } else if ("char".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("char");
         } else if ("date".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION("23");
            sourceField.setLENGTH("19");
            sourceField.setPHYSICALLENGTH("23");
            sourceField.setSCALE("3");
            sourceField.setDATATYPE("datetime");
         } else if ("datetime".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION("23");
            sourceField.setLENGTH("19");
            sourceField.setPHYSICALLENGTH("23");
            sourceField.setSCALE("3");
            sourceField.setDATATYPE("datetime");
         } else if ("decimal".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setDATATYPE("decimal");
         } else if ("float".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setDATATYPE("float");
         } else if ("image".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("8000");
            sourceField.setPHYSICALLENGTH("4000");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("4000");
            sourceField.setDATATYPE("decimal");
         } else if ("int".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setDATATYPE("int");
         } else if ("longsysname".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setDATATYPE("varchar");
         } else if ("varchar".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("varchar");
         } else if ("nchar".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("nchar");
         } else if ("nvarchar".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("nvarchar");
         } else if ("money".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("19");
            sourceField.setSCALE("4");
            sourceField.setPRECISION("19");
            sourceField.setDATATYPE("money");
         } else if ("real".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("24");
            sourceField.setPHYSICALLENGTH("7");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("7");
            sourceField.setDATATYPE("real");
         } else if ("smalldatetime".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("19");
            sourceField.setPHYSICALLENGTH("19");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("19");
            sourceField.setDATATYPE("smalldatetime");
         } else if ("smallint".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("6");
            sourceField.setPHYSICALLENGTH("5");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("5");
            sourceField.setDATATYPE("smallint");
         } else if ("smallmoney".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("10");
            sourceField.setSCALE("4");
            sourceField.setPRECISION("10");
            sourceField.setDATATYPE("smallmoney");
         } else if ("sysname".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("100");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("100");
            sourceField.setDATATYPE("varchar");
         } else if ("text".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("4000");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("4000");
            sourceField.setDATATYPE("text");
         } else if ("time".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("19");
            sourceField.setPHYSICALLENGTH("23");
            sourceField.setSCALE("3");
            sourceField.setPRECISION("23");
            sourceField.setDATATYPE("datetime");
         } else if ("timestamp".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION("8");
            sourceField.setLENGTH("16");
            sourceField.setPHYSICALLENGTH("8");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("varbinary");
         } else if ("tinyint".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setDATATYPE("tinyint");
         } else if ("unichar".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("200");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("200");
            sourceField.setDATATYPE("nchar");
         } else if ("unitext".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("4000");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("4000");
            sourceField.setDATATYPE("nvarchar");
         } else if ("univarchar".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("200");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("200");
            sourceField.setDATATYPE("nvarchar");
         } else if ("unsigned bigint".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setDATATYPE("bigint");
         } else if ("unsigned int".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("int");
         } else if ("unsigned smallint".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("5");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("5");
            sourceField.setDATATYPE("smallint");
         } else {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE((String)sou_bean.getCb().getTypeList().get(i));
         }

         sourceField.setLEVEL("0");
         sourceField.setNAME((String)sou_bean.getCb().getNameList().get(i));
         if ("PRIMARY KEY".equals(sou_bean.getCb().getKeytype().get(i))) {
            sourceField.setNULLABLE("NOTNULL");
         } else {
            sourceField.setNULLABLE("NULL");
         }

         sourceField.setKEYTYPE((String)sou_bean.getCb().getKeytype().get(i));
         sourceField.setOCCURS("0");
         offset += preOffset;
         sourceField.setOFFSET(offset + "");
         phyOffset += prePhyOffset;
         sourceField.setPHYSICALOFFSET(phyOffset + "");
         sourceField.setPICTURETEXT("");
         sourceField.setUSAGEFLAGS("");
         sourceFieldList.add(sourceField);
      }

      return sourceFieldList;
   }

   public static List<SOURCEFIELD> getInformixField(SourceBean sou_bean) {
      List<SOURCEFIELD> sourceFieldList = new ArrayList();
      int phyOffset = 0;
      int prePhyOffset = 0;
      int offset = 0;
      int preOffset = 0;

      for(int i = 0; i < sou_bean.getCb().getNameList().size(); ++i) {
         SOURCEFIELD sourceField = new SOURCEFIELD();
         sourceField.setBUSINESSNAME("");
         sourceField.setDESCRIPTION("");
         sourceField.setFIELDNUMBER(i + 1 + "");
         sourceField.setFIELDPROPERTY("0");
         sourceField.setFIELDTYPE("ELEMITEM");
         sourceField.setHIDDEN("NO");
         sourceField.setKEYTYPE((String)sou_bean.getCb().getKeytype().get(i));
         if ("blob".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION("4000");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("Byte");
            sourceField.setLENGTH("8000");
            sourceField.setPHYSICALLENGTH("8000");
         } else if ("boolean".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION("5");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("SmallInt");
            sourceField.setLENGTH("8000");
            sourceField.setPHYSICALLENGTH("8000");
         } else if ("byte".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION("4000");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("Byte");
            sourceField.setLENGTH("6");
            sourceField.setPHYSICALLENGTH("5");
         } else if ("varchar".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("Varchar");
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
         } else if ("char".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("Char");
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("100");
         } else if ("clob".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setSCALE("0");
            sourceField.setPRECISION("4000");
            sourceField.setDATATYPE("Text");
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("4000");
         } else if ("date".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION("19");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("Date");
            sourceField.setLENGTH("19");
            sourceField.setPHYSICALLENGTH("19");
         } else if ("datetime".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION("25");
            sourceField.setSCALE("5");
            sourceField.setDATATYPE("Datetime year to fraction(5)");
            sourceField.setLENGTH("19");
            sourceField.setPHYSICALLENGTH("25");
         } else if ("float".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION("15");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("Float");
            sourceField.setLENGTH("24");
            sourceField.setPHYSICALLENGTH("15");
         } else if ("int8".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION("19");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("Int8");
            sourceField.setLENGTH("20");
            sourceField.setPHYSICALLENGTH("19");
         } else if ("int".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION("10");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("Integer");
            sourceField.setLENGTH("11");
            sourceField.setPHYSICALLENGTH("10");
         } else if ("money".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION("16");
            sourceField.setSCALE("2");
            sourceField.setDATATYPE("Money");
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("16");
         } else if ("nchar".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("Char");
            sourceField.setLENGTH("0");
            sourceField.setPRECISION((String)sou_bean.getCb().getLengthList().get(i));
         } else if ("nvarchar".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("NVarchar");
            sourceField.setLENGTH("0");
            sourceField.setPRECISION((String)sou_bean.getCb().getLengthList().get(i));
         } else if ("lvarchar".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("varchar");
            sourceField.setLENGTH("0");
            sourceField.setPRECISION((String)sou_bean.getCb().getLengthList().get(i));
         } else if ("serial".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setSCALE("0");
            sourceField.setPRECISION("10");
            sourceField.setDATATYPE("Serial");
            sourceField.setLENGTH("11");
            sourceField.setPRECISION("10");
         } else if ("serial8".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setSCALE("0");
            sourceField.setPRECISION("19");
            sourceField.setDATATYPE("Int8");
         } else if ("smallfloat".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setSCALE("0");
            sourceField.setPRECISION("7");
            sourceField.setDATATYPE("SmallFloat");
            sourceField.setLENGTH("24");
            sourceField.setPRECISION("7");
         } else if ("smallint".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setSCALE("0");
            sourceField.setPRECISION("5");
            sourceField.setDATATYPE("SmallInt");
            sourceField.setLENGTH("6");
            sourceField.setPRECISION("5");
         } else if ("decimal".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE("Decimal");
            sourceField.setLENGTH("12");
            sourceField.setPRECISION("10");
         } else {
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE((String)sou_bean.getCb().getTypeList().get(i));
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
         }

         sourceField.setLEVEL("0");
         sourceField.setNAME((String)sou_bean.getCb().getNameList().get(i));
         if ("PRIMARY KEY".equals(sou_bean.getCb().getKeytype().get(i))) {
            sourceField.setNULLABLE("NOTNULL");
         } else {
            sourceField.setNULLABLE("NULL");
         }

         sourceField.setKEYTYPE((String)sou_bean.getCb().getKeytype().get(i));
         sourceField.setOCCURS("0");
         offset += preOffset;
         sourceField.setOFFSET(offset + "");
         phyOffset += prePhyOffset;
         sourceField.setPHYSICALOFFSET(phyOffset + "");
         sourceField.setPICTURETEXT("");
         sourceField.setUSAGEFLAGS("");
         sourceFieldList.add(sourceField);
      }

      return sourceFieldList;
   }

   public static List<SOURCEFIELD> getFileLimitField(SourceBean sou_bean) {
      List<SOURCEFIELD> sourceFieldList = new ArrayList();
      int phyOffset = 0;
      int prePhyOffset = 0;
      int offset = 0;
      int preOffset = 0;

      for(int i = 0; i < sou_bean.getCb().getNameList().size(); ++i) {
         SOURCEFIELD sourceField = new SOURCEFIELD();
         sourceField.setBUSINESSNAME("");
         sourceField.setDESCRIPTION("");
         sourceField.setFIELDNUMBER(i + 1 + "");
         sourceField.setFIELDPROPERTY("0");
         sourceField.setFIELDTYPE("ELEMITEM");
         sourceField.setHIDDEN("NO");
         sourceField.setKEYTYPE("NOT A KEY");
         sourceField.setLEVEL("0");
         sourceField.setNAME((String)sou_bean.getCb().getNameList().get(i));
         sourceField.setNULLABLE("NULL");
         sourceField.setOCCURS("0");
         offset += preOffset;
         sourceField.setOFFSET(offset + "");
         phyOffset += prePhyOffset;
         sourceField.setPHYSICALOFFSET(phyOffset + "");
         sourceField.setUSAGEFLAGS("");
         sourceField.setDATATYPE((String)sou_bean.getCb().getTypeList().get(i));
         if ("datetime".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("19");
            sourceField.setPHYSICALLENGTH("29");
            sourceField.setPRECISION("29");
            sourceField.setSCALE("9");
            sourceField.setPICTURETEXT((String)sou_bean.getCb().getDateformatlist().get(i));
         } else if ("bigint".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("20");
            sourceField.setPHYSICALLENGTH("19");
            sourceField.setPRECISION("19");
            sourceField.setSCALE("0");
            sourceField.setPICTURETEXT("");
         } else {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setPICTURETEXT("");
         }

         sourceFieldList.add(sourceField);
      }

      return sourceFieldList;
   }

   public static List<SOURCEFIELD> getFileSpaceField(SourceBean sou_bean) {
      List<SOURCEFIELD> sourceFieldList = new ArrayList();
      int phyOffset = 0;
      int prePhyOffset = 0;
      int offset = 0;
      int preOffset = 0;

      for(int i = 0; i < sou_bean.getCb().getNameList().size(); ++i) {
         SOURCEFIELD sourceField = new SOURCEFIELD();
         sourceField.setBUSINESSNAME("");
         sourceField.setDESCRIPTION("");
         sourceField.setFIELDNUMBER(i + 1 + "");
         sourceField.setFIELDPROPERTY("0");
         sourceField.setFIELDTYPE("ELEMITEM");
         sourceField.setHIDDEN("NO");
         sourceField.setKEYTYPE("NOT A KEY");
         sourceField.setLEVEL("0");
         sourceField.setNAME((String)sou_bean.getCb().getNameList().get(i));
         sourceField.setNULLABLE("NULL");
         sourceField.setOCCURS("0");
         offset += preOffset;
         sourceField.setOFFSET(offset + "");
         phyOffset += prePhyOffset;
         sourceField.setPHYSICALOFFSET(phyOffset + "");
         sourceField.setPICTURETEXT("");
         sourceField.setUSAGEFLAGS("");
         sourceField.setDATATYPE((String)sou_bean.getCb().getTypeList().get(i));
         if ("datetime".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("19");
            sourceField.setPHYSICALLENGTH("29");
            sourceField.setPRECISION("29");
            sourceField.setSCALE("9");
            sourceField.setPICTURETEXT((String)sou_bean.getCb().getDateformatlist().get(i));
         } else if ("bigint".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("20");
            sourceField.setPHYSICALLENGTH("19");
            sourceField.setPRECISION("19");
            sourceField.setSCALE("0");
            sourceField.setPICTURETEXT("");
         } else if ("NUMBER".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("24");
            sourceField.setPHYSICALLENGTH("15");
            sourceField.setPRECISION("15");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("number");
            sourceField.setPICTURETEXT("");
         } else {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setPICTURETEXT("");
         }

         sourceFieldList.add(sourceField);
      }

      return sourceFieldList;
   }

   public static List<SOURCEFIELD> getHiveField(SourceBean sou_bean) {
      List<SOURCEFIELD> sourceFieldList = new ArrayList();
      int phyOffset = 0;
      int prePhyOffset = 0;
      int offset = 0;
      int preOffset = 0;

      for(int i = 0; i < sou_bean.getCb().getNameList().size(); ++i) {
         SOURCEFIELD sourceField = new SOURCEFIELD();
         sourceField.setBUSINESSNAME("");
         sourceField.setDESCRIPTION("");
         sourceField.setFIELDNUMBER(i + 1 + "");
         sourceField.setFIELDPROPERTY("0");
         sourceField.setFIELDTYPE("ELEMITEM");
         sourceField.setHIDDEN("NO");
         sourceField.setKEYTYPE((String)sou_bean.getCb().getKeytype().get(i));
         if ("STRING".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("200");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("200");
            sourceField.setDATATYPE("varchar");
         } else if ("VARCHAR".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("0");
            sourceField.setPHYSICALLENGTH("200");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("200");
            sourceField.setDATATYPE("varchar");
         } else if ("DECIMAL".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION("16");
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH("16");
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setDATATYPE("decimal");
         } else if ("BOOLEAN".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION("1");
            sourceField.setLENGTH("1");
            sourceField.setPHYSICALLENGTH("1");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("bit");
         } else if ("TINYINT".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("tinyint");
         } else if ("SMALLINT".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("6");
            sourceField.setPHYSICALLENGTH("5");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("5");
            sourceField.setDATATYPE("smallint");
         } else if ("INT".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("11");
            sourceField.setPHYSICALLENGTH("10");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("10");
            sourceField.setDATATYPE("integer");
         } else if ("BIGINT".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION("19");
            sourceField.setLENGTH("20");
            sourceField.setPHYSICALLENGTH("19");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("bigint");
         } else if ("FLOAT".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setPRECISION("15");
            sourceField.setLENGTH("24");
            sourceField.setPHYSICALLENGTH("15");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("float");
         } else if ("BINARY".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("8000");
            sourceField.setPHYSICALLENGTH("4000");
            sourceField.setSCALE("0");
            sourceField.setPRECISION("4000");
            sourceField.setDATATYPE("binary");
         } else if ("DATE".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("19");
            sourceField.setPHYSICALLENGTH("10");
            sourceField.setPRECISION("10");
            sourceField.setSCALE("0");
            sourceField.setDATATYPE("date");
         } else if ("TIMESTAMP".equalsIgnoreCase((String)sou_bean.getCb().getTypeList().get(i))) {
            sourceField.setLENGTH("19");
            sourceField.setPHYSICALLENGTH("29");
            sourceField.setSCALE("9");
            sourceField.setPRECISION("29");
            sourceField.setDATATYPE("timestamp");
         } else {
            sourceField.setLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setPHYSICALLENGTH((String)sou_bean.getCb().getLengthList().get(i));
            sourceField.setSCALE((String)sou_bean.getCb().getScalelist().get(i));
            sourceField.setPRECISION((String)sou_bean.getCb().getPrecisionList().get(i));
            sourceField.setDATATYPE((String)sou_bean.getCb().getTypeList().get(i));
         }

         sourceField.setLEVEL("0");
         sourceField.setNAME((String)sou_bean.getCb().getNameList().get(i));
         if ("PRIMARY KEY".equals(sou_bean.getCb().getKeytype().get(i))) {
            sourceField.setNULLABLE("NOTNULL");
         } else {
            sourceField.setNULLABLE("NULL");
         }

         sourceField.setKEYTYPE((String)sou_bean.getCb().getKeytype().get(i));
         sourceField.setOCCURS("0");
         offset += preOffset;
         sourceField.setOFFSET(offset + "");
         phyOffset += prePhyOffset;
         sourceField.setPHYSICALOFFSET(phyOffset + "");
         sourceField.setPICTURETEXT("");
         sourceField.setUSAGEFLAGS("");
         sourceFieldList.add(sourceField);
      }

      return sourceFieldList;
   }
}
