package com.chenyang.nse.bussiness.entity.db;

import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ForeignKeyInfo {
   private String pktable;
   private String pkcolumn;
   private String fktable;
   private String fkcolumn;

   public ForeignKeyInfo() {
   }

   public ForeignKeyInfo(String pktable, String pkcolumn, String fktable, String fkcolumn) {
      this.pktable = pktable;
      this.pkcolumn = pkcolumn;
      this.fktable = fktable;
      this.fkcolumn = fkcolumn;
   }

   public String getPktable() {
      return this.pktable;
   }

   public void setPktable(String pktable) {
      this.pktable = pktable;
   }

   public String getPkcolumn() {
      return this.pkcolumn;
   }

   public void setPkcolumn(String pkcolumn) {
      this.pkcolumn = pkcolumn;
   }

   public String getFktable() {
      return this.fktable;
   }

   public void setFktable(String fktable) {
      this.fktable = fktable;
   }

   public String getFkcolumn() {
      return this.fkcolumn;
   }

   public void setFkcolumn(String fkcolumn) {
      this.fkcolumn = fkcolumn;
   }

   public String toString() {
      return "ForeignKeyInfo [pktable=" + this.pktable + ", pkcolumn=" + this.pkcolumn + ", fktable=" + this.fktable + ", fkcolumn=" + this.fkcolumn + "]";
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.fkcolumn == null ? 0 : this.fkcolumn.hashCode());
      result = 31 * result + (this.fktable == null ? 0 : this.fktable.hashCode());
      result = 31 * result + (this.pkcolumn == null ? 0 : this.pkcolumn.hashCode());
      result = 31 * result + (this.pktable == null ? 0 : this.pktable.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         ForeignKeyInfo other = (ForeignKeyInfo)obj;
         if (this.fkcolumn == null) {
            if (other.fkcolumn != null) {
               return false;
            }
         } else if (!this.fkcolumn.equals(other.fkcolumn)) {
            return false;
         }

         if (this.fktable == null) {
            if (other.fktable != null) {
               return false;
            }
         } else if (!this.fktable.equals(other.fktable)) {
            return false;
         }

         if (this.pkcolumn == null) {
            if (other.pkcolumn != null) {
               return false;
            }
         } else if (!this.pkcolumn.equals(other.pkcolumn)) {
            return false;
         }

         if (this.pktable == null) {
            if (other.pktable != null) {
               return false;
            }
         } else if (!this.pktable.equals(other.pktable)) {
            return false;
         }

         return true;
      }
   }

   public static List<ForeignKeyInfo> getForeignKeyInfoByConnection(Connection conn, String schema) {
      String dbtype = JdbcTool.getDataBaseType(conn);
      List<ForeignKeyInfo> list = null;
      if (dbtype == null) {
         return null;
      } else {
         if ("ORACLE".equals(dbtype)) {
            list = getForeignKeyInfoByConnectionForOracle(conn, schema);
         } else if ("DB2".equals(dbtype)) {
            list = getForeignKeyInfoByConnectionForDB2(conn, schema);
         } else if ("MYSQL".equals(dbtype)) {
            list = getForeignKeyInfoByConnectionForMysql(conn, schema);
         }

         return list;
      }
   }

   public static List<ForeignKeyInfo> getForeignKeyInfoByConnectionForOracle(Connection conn, String schema) {
      List<ForeignKeyInfo> list = null;
      String sql = XmlTool.getSql("jdbc", "queryForeignKeyForORACLE");
      PreparedStatement st = null;
      ResultSet rs = null;

      try {
         st = conn.prepareStatement(sql.toString());
         st.setString(1, schema);
         st.setString(2, schema);
         st.setString(3, schema);
         st.setString(4, schema);

         for(rs = st.executeQuery(); rs.next(); list.add(new ForeignKeyInfo(rs.getString("pktable"), rs.getString("pkcolumn"), rs.getString("fktable"), rs.getString("fkcolumn")))) {
            if (list == null) {
               list = new ArrayList();
            }
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (st != null) {
               st.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return list;
   }

   public static List<ForeignKeyInfo> getForeignKeyInfoByConnectionForDB2(Connection conn, String schema) {
      List<ForeignKeyInfo> list = null;
      String sql = XmlTool.getSql("jdbc", "queryForeignKeyForDB2");
      PreparedStatement st = null;
      ResultSet rs = null;

      try {
         st = conn.prepareStatement(sql.toString());
         st.setString(1, schema);

         for(rs = st.executeQuery(); rs.next(); list.add(new ForeignKeyInfo(rs.getString("pktable"), rs.getString("pkcolumn"), rs.getString("fktable"), rs.getString("fkcolumn")))) {
            if (list == null) {
               list = new ArrayList();
            }
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (st != null) {
               st.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return list;
   }

   public static List<ForeignKeyInfo> getForeignKeyInfoByConnectionForMysql(Connection conn, String schema) {
      List<ForeignKeyInfo> list = null;
      String sql = XmlTool.getSql("jdbc", "queryForeignKeyForMYSQL");
      PreparedStatement st = null;
      ResultSet rs = null;

      try {
         st = conn.prepareStatement(sql.toString());
         st.setString(1, schema);

         for(rs = st.executeQuery(); rs.next(); list.add(new ForeignKeyInfo(rs.getString("pktable"), rs.getString("pkcolumn"), rs.getString("fktable"), rs.getString("fkcolumn")))) {
            if (list == null) {
               list = new ArrayList();
            }
         }
      } catch (SQLException e) {
         e.printStackTrace();
      } finally {
         try {
            if (rs != null) {
               rs.close();
            }

            if (st != null) {
               st.close();
            }
         } catch (SQLException e) {
            e.printStackTrace();
         }

      }

      return list;
   }
}
