package com.chenyang.nse.bussiness.entity.orm.table.base;

import com.chenyang.nse.bussiness.entity.orm.table.TInitEntity;
import java.util.Date;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(
   name = "T_BASE_MENU"
)
public class TBaseMenu extends TInitEntity implements Comparable<TBaseMenu> {
   private String menuname;
   private String parentid;
   private Integer sortstring;
   private String icon;
   private String url;
   private Date createtime;
   private String parentname;
   @Transient
   private List<TBaseMenu> submenu;
   @Transient
   private List<TBaseButton> subbutton;
   private String type;

   public String getParentname() {
      return this.parentname;
   }

   public void setParentname(String parentname) {
      this.parentname = parentname;
   }

   public String getMenuname() {
      return this.menuname;
   }

   public void setMenuname(String menuname) {
      this.menuname = menuname;
   }

   public String getParentid() {
      return this.parentid;
   }

   public void setParentid(String parentid) {
      this.parentid = parentid;
   }

   public Integer getSortstring() {
      return this.sortstring;
   }

   public void setSortstring(Integer sortstring) {
      this.sortstring = sortstring;
   }

   public String getIcon() {
      return this.icon;
   }

   public void setIcon(String icon) {
      this.icon = icon;
   }

   public String getUrl() {
      return this.url;
   }

   public void setUrl(String url) {
      this.url = url;
   }

   public Date getCreatetime() {
      return this.createtime;
   }

   public void setCreatetime(Date createtime) {
      this.createtime = createtime;
   }

   public List<TBaseMenu> getSubmenu() {
      return this.submenu;
   }

   public void setSubmenu(List<TBaseMenu> submenu) {
      this.submenu = submenu;
   }

   public List<TBaseButton> getSubbutton() {
      return this.subbutton;
   }

   public void setSubbutton(List<TBaseButton> subbutton) {
      this.subbutton = subbutton;
   }

   public String getType() {
      return this.type;
   }

   public void setType(String type) {
      this.type = type;
   }

   public String toString() {
      return "TBaseMenu [menuname=" + this.menuname + ", parentid=" + this.parentid + ", sortstring=" + this.sortstring + ", icon=" + this.icon + ", url=" + this.url + ", createtime=" + this.createtime + "]";
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.createtime == null ? 0 : this.createtime.hashCode());
      result = 31 * result + (this.icon == null ? 0 : this.icon.hashCode());
      result = 31 * result + (this.menuname == null ? 0 : this.menuname.hashCode());
      result = 31 * result + (this.parentid == null ? 0 : this.parentid.hashCode());
      result = 31 * result + (this.sortstring == null ? 0 : this.sortstring.hashCode());
      result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         TBaseMenu other = (TBaseMenu)obj;
         if (this.createtime == null) {
            if (other.createtime != null) {
               return false;
            }
         } else if (!this.createtime.equals(other.createtime)) {
            return false;
         }

         if (this.icon == null) {
            if (other.icon != null) {
               return false;
            }
         } else if (!this.icon.equals(other.icon)) {
            return false;
         }

         if (this.menuname == null) {
            if (other.menuname != null) {
               return false;
            }
         } else if (!this.menuname.equals(other.menuname)) {
            return false;
         }

         if (this.parentid == null) {
            if (other.parentid != null) {
               return false;
            }
         } else if (!this.parentid.equals(other.parentid)) {
            return false;
         }

         if (this.sortstring == null) {
            if (other.sortstring != null) {
               return false;
            }
         } else if (!this.sortstring.equals(other.sortstring)) {
            return false;
         }

         if (this.url == null) {
            if (other.url != null) {
               return false;
            }
         } else if (!this.url.equals(other.url)) {
            return false;
         }

         return true;
      }
   }

   public int compareTo(TBaseMenu o) {
      if (o == null) {
         return 1;
      } else if (o.getSortstring() == null) {
         return 1;
      } else {
         return this.getSortstring() == null ? -1 : this.sortstring - o.getSortstring();
      }
   }
}
