package com.chenyang.nse.bussiness.entity.orm.table.console;

import com.chenyang.nse.bussiness.entity.orm.table.TBaseEntity;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(
   name = "T_CONSOLE_LOG"
)
public class TConsoleLog extends TBaseEntity {
   private String operationUser;
   private String module;
   private Date operationtime;
   private String logmessage;
   private String logno;
   private String operationObject;
   private String modifieduser;
   private String column_enc;

   public String getOperationObject() {
      return this.operationObject;
   }

   public void setOperationObject(String operationObject) {
      this.operationObject = operationObject;
   }

   public String getModifieduser() {
      return this.modifieduser;
   }

   public void setModifieduser(String modifieduser) {
      this.modifieduser = modifieduser;
   }

   public TConsoleLog() {
   }

   public TConsoleLog(String operationUser, String module, Date operationtime, String logmessage, String logno) {
      this.operationUser = operationUser;
      this.module = module;
      this.operationtime = operationtime;
      this.logmessage = logmessage;
      this.logno = logno;
   }

   public String toString() {
      return "TConsoleLog [operationUser=" + this.operationUser + ", module=" + this.module + ", operationtime=" + this.operationtime + ", logmessage=" + this.logmessage + ", logno=" + this.logno + "]";
   }

   public String getOperationUser() {
      return this.operationUser;
   }

   public void setUser(String operationUser) {
      this.operationUser = operationUser;
   }

   public String getModule() {
      return this.module;
   }

   public void setModule(String module) {
      this.module = module;
   }

   public Date getOperationtime() {
      return this.operationtime;
   }

   public void setOperationtime(Date operationtime) {
      this.operationtime = operationtime;
   }

   public String getLogmessage() {
      return this.logmessage;
   }

   public void setLogmessage(String logmessage) {
      this.logmessage = logmessage;
   }

   public String getLogno() {
      return this.logno;
   }

   public void setLogno(String logno) {
      this.logno = logno;
   }

   public void setOperationUser(String operationUser) {
      this.operationUser = operationUser;
   }

   public String getColumn_enc() {
      return this.column_enc;
   }

   public void setColumn_enc(String column_enc) {
      this.column_enc = column_enc;
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.operationtime == null ? 0 : this.operationtime.hashCode());
      result = 31 * result + (this.logmessage == null ? 0 : this.logmessage.hashCode());
      result = 31 * result + (this.logno == null ? 0 : this.logno.hashCode());
      result = 31 * result + (this.module == null ? 0 : this.module.hashCode());
      result = 31 * result + (this.operationUser == null ? 0 : this.operationUser.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         TConsoleLog other = (TConsoleLog)obj;
         if (this.operationtime == null) {
            if (other.operationtime != null) {
               return false;
            }
         } else if (!this.operationtime.equals(other.operationtime)) {
            return false;
         }

         if (this.logmessage == null) {
            if (other.logmessage != null) {
               return false;
            }
         } else if (!this.logmessage.equals(other.logmessage)) {
            return false;
         }

         if (this.logno == null) {
            if (other.logno != null) {
               return false;
            }
         } else if (!this.logno.equals(other.logno)) {
            return false;
         }

         if (this.module == null) {
            if (other.module != null) {
               return false;
            }
         } else if (!this.module.equals(other.module)) {
            return false;
         }

         if (this.operationUser == null) {
            if (other.operationUser != null) {
               return false;
            }
         } else if (!this.operationUser.equals(other.operationUser)) {
            return false;
         }

         return true;
      }
   }
}
