package com.chenyang.nse.bussiness.entity.orm.table.core.datamap;

import com.chenyang.nse.bussiness.entity.orm.table.TBaseEntity;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(
   name = "T_CORE_DATAMAP"
)
public class TCoreDatamap extends TBaseEntity {
   private String datasystemid;
   private String dbschema;
   private Date createtime;

   public TCoreDatamap() {
   }

   public TCoreDatamap(String datasystemid, String dbschema, Date createtime) {
      this.datasystemid = datasystemid;
      this.dbschema = dbschema;
      this.createtime = createtime;
   }

   public String getDatasystemid() {
      return this.datasystemid;
   }

   public void setDatasystemid(String datasystemid) {
      this.datasystemid = datasystemid;
   }

   public String getDbschema() {
      return this.dbschema;
   }

   public void setDbschema(String dbschema) {
      this.dbschema = dbschema;
   }

   public Date getCreatetime() {
      return this.createtime;
   }

   public void setCreatetime(Date createtime) {
      this.createtime = createtime;
   }

   public String toString() {
      return "TCoreDatamap [datasystemid=" + this.datasystemid + ", dbschema=" + this.dbschema + ", createtime=" + this.createtime + "]";
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.createtime == null ? 0 : this.createtime.hashCode());
      result = 31 * result + (this.datasystemid == null ? 0 : this.datasystemid.hashCode());
      result = 31 * result + (this.dbschema == null ? 0 : this.dbschema.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         TCoreDatamap other = (TCoreDatamap)obj;
         if (this.createtime == null) {
            if (other.createtime != null) {
               return false;
            }
         } else if (!this.createtime.equals(other.createtime)) {
            return false;
         }

         if (this.datasystemid == null) {
            if (other.datasystemid != null) {
               return false;
            }
         } else if (!this.datasystemid.equals(other.datasystemid)) {
            return false;
         }

         if (this.dbschema == null) {
            if (other.dbschema != null) {
               return false;
            }
         } else if (!this.dbschema.equals(other.dbschema)) {
            return false;
         }

         return true;
      }
   }
}
