package com.chenyang.nse.bussiness.entity.orm.table.core.datamap;

import com.chenyang.nse.bussiness.entity.orm.table.TBaseEntity;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(
   name = "T_CORE_DATAMAP_COLUMN"
)
public class TCoreDatamapColumn extends TBaseEntity {
   private String datamapid;
   private String columnname;
   private String datatype;
   private String datalength;
   private String datamaptableid;

   public TCoreDatamapColumn() {
   }

   public TCoreDatamapColumn(String datamapid, String columnname, String datatype, String datalength, String datamaptableid) {
      this.columnname = columnname;
      this.datatype = datatype;
      this.datalength = datalength;
      this.datamaptableid = datamaptableid;
      this.datamapid = datamapid;
   }

   public String getDatamapid() {
      return this.datamapid;
   }

   public void setDatamapid(String datamapid) {
      this.datamapid = datamapid;
   }

   public String getColumnname() {
      return this.columnname;
   }

   public void setColumnname(String columnname) {
      this.columnname = columnname;
   }

   public String getDatatype() {
      return this.datatype;
   }

   public void setDatatype(String datatype) {
      this.datatype = datatype;
   }

   public String getDatalength() {
      return this.datalength;
   }

   public void setDatalength(String datalength) {
      this.datalength = datalength;
   }

   public String getDatamaptableid() {
      return this.datamaptableid;
   }

   public void setDatamaptableid(String datamaptableid) {
      this.datamaptableid = datamaptableid;
   }

   public String toString() {
      return "TCoreDatamapColumn [datamapid=" + this.datamapid + ", columnname=" + this.columnname + ", datatype=" + this.datatype + ", datalength=" + this.datalength + ", datamaptableid=" + this.datamaptableid + "]";
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.columnname == null ? 0 : this.columnname.hashCode());
      result = 31 * result + (this.datalength == null ? 0 : this.datalength.hashCode());
      result = 31 * result + (this.datamapid == null ? 0 : this.datamapid.hashCode());
      result = 31 * result + (this.datamaptableid == null ? 0 : this.datamaptableid.hashCode());
      result = 31 * result + (this.datatype == null ? 0 : this.datatype.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         TCoreDatamapColumn other = (TCoreDatamapColumn)obj;
         if (this.columnname == null) {
            if (other.columnname != null) {
               return false;
            }
         } else if (!this.columnname.equals(other.columnname)) {
            return false;
         }

         if (this.datalength == null) {
            if (other.datalength != null) {
               return false;
            }
         } else if (!this.datalength.equals(other.datalength)) {
            return false;
         }

         if (this.datamapid == null) {
            if (other.datamapid != null) {
               return false;
            }
         } else if (!this.datamapid.equals(other.datamapid)) {
            return false;
         }

         if (this.datamaptableid == null) {
            if (other.datamaptableid != null) {
               return false;
            }
         } else if (!this.datamaptableid.equals(other.datamaptableid)) {
            return false;
         }

         if (this.datatype == null) {
            if (other.datatype != null) {
               return false;
            }
         } else if (!this.datatype.equals(other.datatype)) {
            return false;
         }

         return true;
      }
   }
}
