package com.chenyang.nse.bussiness.entity.orm.table.core.generate;

import com.chenyang.nse.bussiness.entity.orm.table.TBaseEntity;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(
   name = "T_CORE_DATA_GENERATE_STRATE"
)
public class TCoreDataGenerateStrate extends TBaseEntity {
   private String stratename;
   private String datatypeid;

   public TCoreDataGenerateStrate() {
   }

   public TCoreDataGenerateStrate(String stratename, String datatypeid) {
      this.stratename = stratename;
      this.datatypeid = datatypeid;
   }

   public String getStratename() {
      return this.stratename;
   }

   public void setStratename(String stratename) {
      this.stratename = stratename;
   }

   public String getDatatypeid() {
      return this.datatypeid;
   }

   public void setDatatypeid(String datatypeid) {
      this.datatypeid = datatypeid;
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.datatypeid == null ? 0 : this.datatypeid.hashCode());
      result = 31 * result + (this.stratename == null ? 0 : this.stratename.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         TCoreDataGenerateStrate other = (TCoreDataGenerateStrate)obj;
         if (this.datatypeid == null) {
            if (other.datatypeid != null) {
               return false;
            }
         } else if (!this.datatypeid.equals(other.datatypeid)) {
            return false;
         }

         if (this.stratename == null) {
            if (other.stratename != null) {
               return false;
            }
         } else if (!this.stratename.equals(other.stratename)) {
            return false;
         }

         return true;
      }
   }

   public String toString() {
      return "TCoreDataGenerateStrate [stratename=" + this.stratename + ", datatypeid=" + this.datatypeid + "]";
   }
}
