package com.chenyang.nse.bussiness.entity.orm.table.core.masking;

import com.chenyang.nse.bussiness.entity.orm.table.TBaseEntity;
import javax.persistence.Entity;
import javax.persistence.Table;

@Entity
@Table(
   name = "T_CORE_MASKING_RULE"
)
public class TCoreMaskingRule extends TBaseEntity {
   private String rulegroupname;
   private String rulename;
   private String ruledemo;

   public TCoreMaskingRule() {
   }

   public TCoreMaskingRule(String rulegroupname, String rulename, String ruledemo) {
      this.rulegroupname = rulegroupname;
      this.rulename = rulename;
      this.ruledemo = ruledemo;
   }

   public String getRulegroupname() {
      return this.rulegroupname;
   }

   public void setRulegroupname(String rulegroupname) {
      this.rulegroupname = rulegroupname;
   }

   public String getRulename() {
      return this.rulename;
   }

   public void setRulename(String rulename) {
      this.rulename = rulename;
   }

   public String getRuledemo() {
      return this.ruledemo;
   }

   public void setRuledemo(String ruledemo) {
      this.ruledemo = ruledemo;
   }

   public String toString() {
      return "TCoreMaskingRule [rulegroupname=" + this.rulegroupname + ", rulename=" + this.rulename + ", ruledemo=" + this.ruledemo + "]";
   }

   public int hashCode() {
      int prime = 31;
      int result = 1;
      result = 31 * result + (this.ruledemo == null ? 0 : this.ruledemo.hashCode());
      result = 31 * result + (this.rulegroupname == null ? 0 : this.rulegroupname.hashCode());
      result = 31 * result + (this.rulename == null ? 0 : this.rulename.hashCode());
      return result;
   }

   public boolean equals(Object obj) {
      if (this == obj) {
         return true;
      } else if (obj == null) {
         return false;
      } else if (this.getClass() != obj.getClass()) {
         return false;
      } else {
         TCoreMaskingRule other = (TCoreMaskingRule)obj;
         if (this.ruledemo == null) {
            if (other.ruledemo != null) {
               return false;
            }
         } else if (!this.ruledemo.equals(other.ruledemo)) {
            return false;
         }

         if (this.rulegroupname == null) {
            if (other.rulegroupname != null) {
               return false;
            }
         } else if (!this.rulegroupname.equals(other.rulegroupname)) {
            return false;
         }

         if (this.rulename == null) {
            if (other.rulename != null) {
               return false;
            }
         } else if (!this.rulename.equals(other.rulename)) {
            return false;
         }

         return true;
      }
   }
}
