package com.chenyang.nse.bussiness.entity.vo;

import java.io.BufferedOutputStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportExcel<T> {
   public void exportExcel(String[] headers, Collection<T> dataset, String fileName, HttpServletResponse response) {
      XSSFWorkbook workbook = new XSSFWorkbook();
      XSSFSheet sheet = workbook.createSheet(fileName);
      sheet.setDefaultColumnWidth(20);
      XSSFRow row = sheet.createRow(0);
      XSSFCellStyle titleStyle = workbook.createCellStyle();
      titleStyle.setAlignment((short)2);
      titleStyle.setVerticalAlignment((short)1);

      for(short i = 0; i < headers.length; ++i) {
         XSSFCell cell = row.createCell(i);
         XSSFRichTextString text = new XSSFRichTextString(headers[i]);
         cell.setCellValue(text);
         cell.setCellStyle(titleStyle);
      }

      try {
         Iterator<T> it = dataset.iterator();
         int index = 0;

         while(it.hasNext()) {
            ++index;
            row = sheet.createRow(index);
            T t = (T)it.next();
            java.lang.reflect.Field[] fields = t.getClass().getDeclaredFields();

            for(short i = 0; i < headers.length; ++i) {
               XSSFCell cell = row.createCell(i);
               java.lang.reflect.Field field = fields[i];
               String fieldName = field.getName();
               String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
               Class tCls = t.getClass();
               Method getMethod = tCls.getMethod(getMethodName);
               Object value = getMethod.invoke(t);
               String textValue = null;
               if (value != null && value != "") {
                  textValue = value.toString();
               }

               if (textValue != null) {
                  XSSFRichTextString richString = new XSSFRichTextString(textValue);
                  cell.setCellValue(richString);
               }
            }
         }

         this.getExportedFied(workbook, fileName, response);
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   public void getExportedFied(XSSFWorkbook workbook, String name, HttpServletResponse response) throws Exception {
      BufferedOutputStream fos = null;

      try {
         String fileName = name + ".xlsx";
         response.setContentType("application/x-msdownload");
         response.setHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("utf-8"), "ISO8859-1"));
         fos = new BufferedOutputStream(response.getOutputStream());
         workbook.write(fos);
      } catch (Exception e) {
         e.printStackTrace();
      } finally {
         if (fos != null) {
            fos.close();
         }

      }

   }

   public void exportExcel(String[] headers, List<Map<String, Object>> list, String fileName, HttpServletResponse response) {
   }
}
