package com.chenyang.nse.bussiness.enumeration;

import java.util.ArrayList;
import java.util.List;

public enum EcolumnType {
   ARRAY("ARRAY", "2003"),
   BIGINT("BIGINT", "-5"),
   BINARY("BINARY", "-2"),
   BIT("BIT", "-7"),
   BLOB("BLOB", "2004"),
   BOOLEAN("BOOLEAN", "16"),
   CHAR("CHAR", "1"),
   CLOB("CLOB", "2005"),
   DATALINK("DATALINK", "70"),
   DATE("DATE", "91"),
   DECIMAL("DECIMAL", "3"),
   DISTINCT("DISTINCT", "2001"),
   DOUBLE("DOUBLE", "8"),
   FLOAT("FLOAT", "6"),
   INTEGER("INTEGER", "4"),
   JAVA_OBJECT("JAVA_OBJECT", "2000"),
   LONGNVARCHAR("LONGNVARCHAR", "-16"),
   LONGVARBINARY("LONGVARBINARY", "-4"),
   LONGVARCHAR("LONGVARCHAR", "-1"),
   NCHAR("NCHAR", "-15"),
   NCLOB("NCLOB", "2011"),
   NULL("NULL", "0"),
   NUMERIC("NUMERIC", "2"),
   NVARCHAR("NVARCHAR", "-9"),
   OTHER("OTHER", "1111"),
   REAL("REAL", "7"),
   REF("REF", "2006"),
   REF_CURSOR("REF_CURSOR", "2012"),
   ROWID("ROWID", "-8"),
   SMALLINT("SMALLINT", "5"),
   SQLXML("SQLXML", "2009"),
   STRUCT("STRUCT", "2002"),
   TIME("TIME", "92"),
   TIMESTAMP("TIMESTAMP", "93"),
   TIMESTAMP_WITH_TIMEZONE("TIMESTAMP_WITH_TIMEZONE", "2014"),
   TIME_WITH_TIMEZONE("TIME_WITH_TIMEZONE", "2013"),
   TINYINT("TINYINT", "-6"),
   VARBINARY("VARBINARY", "-3"),
   VARCHAR("VARCHAR", "12");

   private String columnname;
   private String javatype;

   private EcolumnType(String columnname, String javatype) {
      this.columnname = columnname;
      this.setJavatype(javatype);
   }

   public String getColumnname() {
      return this.columnname;
   }

   public void setColumnname(String columnname) {
      this.columnname = columnname;
   }

   public static List<String> getColumnTypeList() {
      List<String> list = new ArrayList();
      EcolumnType[] db = values();

      for(EcolumnType ecolumnType : db) {
         list.add(ecolumnType.getColumnname());
      }

      return list;
   }

   public String getJavatype() {
      return this.javatype;
   }

   public void setJavatype(String javatype) {
      this.javatype = javatype;
   }
}
