package com.chenyang.nse.bussiness.incencryption.service.impl;

import com.chenyang.nse.bussiness.incencryption.service.IncEncryptionTask;
import org.springframework.core.task.TaskDecorator;

public class IncEncryptionTaskDecorator implements TaskDecorator {
   public Runnable decorate(Runnable runnable) {
      return () -> {
         if (!(runnable instanceof IncEncryptionTask)) {
            throw new NotIncEncryptionTaskException();
         } else {
            IncEncryptionTask task = (IncEncryptionTask)runnable;

            try {
               IncEncryptionTaskHolder.put(task);
               runnable.run();
            } finally {
               IncEncryptionTaskHolder.remove(task);
            }

         }
      };
   }

   public static class NotIncEncryptionTaskException extends RuntimeException {
   }
}
