package com.chenyang.nse.bussiness.interfaces;

import java.io.IOException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;

public interface IHiveRMI extends Remote {
   List<HashMap<String, String>> getHdfsList(String kerberosPath, String user, String hdfsPath) throws RemoteException, IOException;

   void readHdfsToPipe(List<String> hdfs_filepathlist, String kerberosPath, String user, String hdfsPath, String charset) throws RemoteException, IOException;

   void writeHdfsToPipe(String kerberosPath, String user, String filePath, String hdfsFile, String charset) throws RemoteException, IOException;

   void delHdfs(String kerberosPath, String user, String hdfsPath) throws RemoteException, IOException;

   void addHdfs(String kerberosPath, String user, String hdfsPath) throws RemoteException, IOException;

   String test() throws RemoteException, IOException;
}
