package com.chenyang.nse.bussiness.jar.db;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.dao.BaseDao;
import com.chenyang.nse.bussiness.jar.util.JarClientUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

@Repository
public class TCoreClientInfoDao extends BaseDao<TCoreClientInfo, String> {
   static final String CLIENT_FORBIDDEN_STATUS = "1";
   static final String CLIENT_UNFORBIDDEN_STATUS = "0";

   public TCoreClientInfo queryJarClients(String ip, int port, String projectId) {
      this.getSession().clear();
      new ArrayList();

      try {
         StringBuilder sql = new StringBuilder();
         sql.append("SELECT *FROM T_CORE_CLIENT_INFO  where client_ip = '" + ip + "' and client_port = " + port + " and project_id = '" + projectId + "'");
         List<TCoreClientInfo> resultList = this.getSession().createNativeQuery(sql.toString(), TCoreClientInfo.class).getResultList();
         if (resultList != null && resultList.size() > 0) {
            return (TCoreClientInfo)resultList.get(0);
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return null;
   }

   public List<TCoreClientInfo> queryJarClientsByProject(String projectId) {
      this.getSession().clear();
      new ArrayList();

      try {
         StringBuilder sql = new StringBuilder();
         sql.append("SELECT * FROM T_CORE_CLIENT_INFO ");
         sql.append(" where ");
         sql.append(" project_id = '" + projectId + "'");
         List<TCoreClientInfo> resultList = this.getSession().createNativeQuery(sql.toString(), TCoreClientInfo.class).getResultList();
         if (resultList != null) {
            return resultList;
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return null;
   }

   public List<TCoreClientInfo> queryJarClientsByIp(String ip, String projectId) {
      this.getSession().clear();
      new ArrayList();

      try {
         StringBuilder sql = new StringBuilder();
         sql.append("SELECT *FROM T_CORE_CLIENT_INFO  where client_ip = '" + ip + "' and project_id = '" + projectId + "'");
         List<TCoreClientInfo> resultList = this.getSession().createNativeQuery(sql.toString(), TCoreClientInfo.class).getResultList();
         if (resultList != null) {
            return resultList;
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return null;
   }

   public String getLastedUptTimeInEncryptionTime(String projectid) {
      String sql = "select DATE_FORMAT(createtime,'%Y-%m-%d %H:%i:%s') from t_core_encryption_field where projectid = '" + projectid + "' order by createtime DESC limit 1";
      if ("3".equals(HibernateConfig.PEIZHIKUDBTYPE)) {
         sql = "select TO_CHAR(CREATETIME , 'YYYY-MM-DD HH24:MI:SS') from t_core_encryption_field where projectid = '" + projectid + "' order by createtime DESC limit 1";
      }

      try {
         List<String> resultList = this.getSession().createNativeQuery(sql).getResultList();
         if (resultList != null && resultList.size() > 0) {
            return (String)resultList.get(0);
         }
      } catch (Exception var4) {
      }

      return "";
   }

   public List<TCoreClientInfo> list(String projectId, int currentpage, int pageSize, String clientIp, int clientPort, String syncStatus, String isForbidden) {
      this.getSession().clear();
      List<TCoreClientInfo> resultList = new ArrayList();
      List<TCoreClientInfo> resultListFilter = new ArrayList();

      try {
         StringBuilder sql = new StringBuilder();
         sql.append("SELECT *FROM T_CORE_CLIENT_INFO  where project_id='" + projectId + "' ");
         if (StringUtils.isNotEmpty(clientIp)) {
            sql.append(" and client_ip='" + clientIp + "'");
         }

         if (clientPort > 0) {
            sql.append(" and client_port=" + clientPort + "");
         }

         if (!syncStatus.equals("-1")) {
            sql.append(" and client_status='" + syncStatus + "'");
         }

         sql.append(" limit " + (currentpage - 1) * pageSize + "," + pageSize);
         resultList = this.getSession().createNativeQuery(sql.toString(), TCoreClientInfo.class).getResultList();
         if (resultList != null && resultList.size() > 0 && !isForbidden.equals("-1")) {
            for(TCoreClientInfo clientInfo : resultList) {
               if ("1".equalsIgnoreCase(isForbidden) && !JarClientUtil.checkAuth(projectId, clientInfo.getClient_ip())) {
                  clientInfo.setIsForbidden("1");
                  clientInfo.setIs_controlled('1');
                  resultListFilter.add(clientInfo);
               }

               if ("0".equalsIgnoreCase(isForbidden) && JarClientUtil.checkAuth(projectId, clientInfo.getClient_ip())) {
                  clientInfo.setIsForbidden("1");
                  clientInfo.setIs_controlled('0');
                  resultListFilter.add(clientInfo);
               }
            }

            return resultListFilter;
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return resultList;
   }

   public Integer getTotalPageForList(String projectId, String clientIp, int clientPort, String syncStatus, String isForbidden) {
      this.getSession().clear();
      List<TCoreClientInfo> resultList = new ArrayList();
      List<TCoreClientInfo> resultListFilter = new ArrayList();

      try {
         StringBuilder sql = new StringBuilder();
         sql.append("SELECT *FROM T_CORE_CLIENT_INFO  where project_id='" + projectId + "' ");
         if (StringUtils.isNotEmpty(clientIp)) {
            sql.append(" and client_ip='" + clientIp + "'");
         }

         if (clientPort > 0) {
            sql.append(" and client_port=" + clientPort + "");
         }

         if (!syncStatus.equals("-1")) {
            sql.append(" and client_status='" + syncStatus + "'");
         }

         resultList = this.getSession().createNativeQuery(sql.toString(), TCoreClientInfo.class).getResultList();
         if (resultList != null && resultList.size() > 0 && !isForbidden.equals("-1")) {
            for(TCoreClientInfo clientInfo : resultList) {
               if ("1".equalsIgnoreCase(isForbidden) && !JarClientUtil.checkAuth(projectId, clientInfo.getClient_ip())) {
                  clientInfo.setIsForbidden("1");
                  clientInfo.setIs_controlled('1');
                  resultListFilter.add(clientInfo);
               }

               if ("0".equalsIgnoreCase(isForbidden) && JarClientUtil.checkAuth(projectId, clientInfo.getClient_ip())) {
                  clientInfo.setIsForbidden("1");
                  clientInfo.setIs_controlled('0');
                  resultListFilter.add(clientInfo);
               }
            }

            return resultListFilter.size();
         }
      } catch (Exception e) {
         e.printStackTrace();
      }

      return resultList.size();
   }

   public void delete(String clientId) {
      String delClientSql = "delete from T_CORE_CLIENT_INFO  WHERE id = :id ";
      String delRuleLogSql = "delete from T_CORE_CLIENT_RULE_CHANGE_LOG  WHERE t_client_id = :id ";
      this.getSession().createNativeQuery(delClientSql).setParameter("id", clientId).executeUpdate();
      this.getSession().createNativeQuery(delRuleLogSql).setParameter("id", clientId).executeUpdate();
   }
}
