package com.chenyang.nse.bussiness.job;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.service.core.SchedulerService;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import java.io.IOException;
import java.util.Properties;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

@DisallowConcurrentExecution
public class DelefolderTaskJob implements Job {
   @Autowired
   private SchedulerService schedulerService;

   public void execute(JobExecutionContext context) throws JobExecutionException {
      SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext(this);

      try {
         System.out.println("开始删除文件任务啦");
         new Properties();

         try {
            Properties e = PropertiesLoaderUtils.loadAllProperties("config.properties");
            String path = "/F:/java/.metadata/.plugins/org.eclipse.wst.server.core/tmp1/wtpwebapps/ghca-platform/WEB-INF/classes/";
            path = this.getClass().getClassLoader().getResource("").getPath();
            path = path.replaceAll("WEB-INF/classes/", "");
            path = path.substring(1, path.length());
            System.out.println(path);
            FileTool.delAllFile(path + e.getProperty("file_down_path"));
            FileTool.delAllFile(path + e.getProperty("file_up_path"));
         } catch (IOException e) {
            e.printStackTrace();
         }

         System.out.println("删除文件任务执行完成啦");
      } catch (Exception e) {
         e.printStackTrace();
      }

   }
}
