package com.chenyang.nse.bussiness.job;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.service.core.SchedulerService;
import com.chenyang.nse.bussiness.tools.ticket.TicketTool;
import java.io.IOException;
import java.util.Properties;
import org.dom4j.DocumentException;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.context.support.SpringBeanAutowiringSupport;

@DisallowConcurrentExecution
public class GenerateTicketTaskJob implements Job {
   @Autowired
   private SchedulerService schedulerService;

   public void execute(JobExecutionContext context) throws JobExecutionException {
      SpringBeanAutowiringSupport.processInjectionBasedOnCurrentContext(this);
      System.out.println("开始生成票据");
      new Properties();

      try {
         Properties props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         String kerberos_command = props.getProperty("kerberos_command");
         String xmlpath = props.getProperty("xmlpath");
         String value = TicketTool.getkrb5cc(props.getProperty("kerberos_command"));
         TicketTool.updateHiveXml(props.getProperty("hivexmlpath"), value);
      } catch (IOException e) {
         e.printStackTrace();
         System.out.println("生成票据报错了");
      } catch (InterruptedException e) {
         e.printStackTrace();
         System.out.println("生成票据报错了");
      } catch (DocumentException e) {
         e.printStackTrace();
         System.out.println("生成票据报错了");
      }

      System.out.println("生成票据执行完成啦");
   }
}
