package com.chenyang.nse.bussiness.kms.service.impl;

import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.kms.service.SanWeiKmsService;
import com.sansec.jce.provider.SwxaProvider;
import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Properties;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import org.springframework.stereotype.Service;

@Service("SanWeiKmsServiceImpl")
public class SanWeiKmsServiceImpl implements SanWeiKmsService {
   private static final String RND = "RND";
   private static final String SWXA_JCE = "SwxaJCE";

   public String createRandomDataKey(int length) {
      try {
         Properties props = null;

         try {
            props = PropertiesLoaderUtils.loadAllProperties("config.properties");
         } catch (IOException e) {
            e.printStackTrace();
         }

         String swsdsPath = props.getProperty("swsdsPath");
         String config = swsdsPath + File.separator + "swsds.ini";
         Security.addProvider(new SwxaProvider((String)null, config));
         SecureRandom random = SecureRandom.getInstance(RND, SWXA_JCE);
         return ByteUtils.toHexString(random.generateSeed(length));
      } catch (Exception e) {
         e.printStackTrace();
         return null;
      }
   }
}
