package com.chenyang.nse.bussiness.odbc.business;

import java.util.Arrays;

public class OdbcApi {
   public static Object service(byte[] buffer) {
      if (buffer.length == 0) {
         return null;
      } else {
         OdbcApiCallable callable = null;
         switch (buffer[0]) {
            case 1:
               callable = new SQLParseApi();
               break;
            case 2:
               callable = new SQLReplaceApi();
               break;
            case 3:
               callable = new Sm4Api();
               break;
            case 4:
               callable = new RuleApi();
               break;
            case 5:
               callable = new MaskApi();
               break;
            default:
               return null;
         }

         try {
            byte[] bytes = Arrays.copyOfRange(buffer, 1, buffer.length);
            return callable.invoke(bytes);
         } catch (Exception e) {
            e.printStackTrace();
            return null;
         }
      }
   }
}
