package com.chenyang.nse.bussiness.performance_monitor.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;

public class UUIDGenerator {
   private static final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyyMMddhhmmssSSS");

   public static String getUUID() {
      String s = UUID.randomUUID().toString();
      return s.substring(0, 8) + s.substring(9, 13) + s.substring(14, 18) + s.substring(19, 23) + s.substring(24);
   }

   public static String transformUUID(String s) {
      return s.substring(0, 8) + s.substring(9, 13) + s.substring(14, 18) + s.substring(19, 23) + s.substring(24);
   }

   public static String[] getUUID(int number) {
      if (number < 1) {
         return null;
      } else {
         String[] ss = new String[number];

         for(int i = 0; i < number; ++i) {
            ss[i] = getUUID();
         }

         return ss;
      }
   }

   public static String getAdverseEventCode() {
      StringBuffer datestr = new StringBuffer("AE");
      return datestr.append(SIMPLE_DATE_FORMAT.format(new Date())).toString();
   }
}
