package com.chenyang.nse.bussiness.rmbackupfield.service.impl;

import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.rmbackupfield.service.RmBackupFieldService;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import java.sql.Connection;
import java.sql.Statement;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RmBackupFieldServiceImpl implements RmBackupFieldService {
   protected Logger logger = LoggerFactory.getLogger(this.getClass());
   @Autowired
   protected TCoreDatasystemDao tCoreDatasystemDao;

   public void rmBackupField(String projectId, String dataSystemId, String schema, String tableName, String columnName) {
      TCoreDatasystem datasystem = this.getDatasystem(dataSystemId);

      try {
         Connection conn = JdbcTool.getConnection(datasystem);
         Throwable var8 = null;

         try {
            Statement stmt = conn.createStatement();
            Throwable var10 = null;

            try {
               String dropColumnSql = this.dropColumnSql(schema, tableName, columnName);
               stmt.executeUpdate(dropColumnSql);
            } catch (Throwable var37) {
               var10 = var37;
               throw var37;
            } finally {
               if (stmt != null) {
                  if (var10 != null) {
                     try {
                        stmt.close();
                     } catch (Throwable var36) {
                        var10.addSuppressed(var36);
                     }
                  } else {
                     stmt.close();
                  }
               }

            }
         } catch (Throwable var39) {
            var8 = var39;
            throw var39;
         } finally {
            if (conn != null) {
               if (var8 != null) {
                  try {
                     conn.close();
                  } catch (Throwable var35) {
                     var8.addSuppressed(var35);
                  }
               } else {
                  conn.close();
               }
            }

         }

      } catch (RuntimeException re) {
         throw re;
      } catch (Exception e) {
         this.logger.error(e.getMessage(), e);
         throw new RuntimeException(e.getMessage(), e);
      }
   }

   private TCoreDatasystem getDatasystem(String dataSystemId) {
      TCoreDatasystem datasystem = (TCoreDatasystem)this.tCoreDatasystemDao.queryUnique(new Criterion[]{Restrictions.eq("id", dataSystemId)});
      if (datasystem == null) {
         throw new RuntimeException(String.format("NotFound dataSystemId=[%s]", dataSystemId));
      } else {
         return datasystem;
      }
   }

   private String dropColumnSql(String schema, String tableName, String columnName) {
      String sql = String.format("ALTER TABLE %s.%s DROP COLUMN %s", schema, tableName, columnName);
      this.logger.info(sql);
      return sql;
   }
}
