package com.chenyang.nse.bussiness.service.console.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleDbfieldtypeDao;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDbfieldtype;
import com.chenyang.nse.bussiness.service.console.DBFieldTypesService;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DBFieldTypesServiceImpl implements DBFieldTypesService {
   @Autowired
   private TConsoleDbfieldtypeDao tConsoleDbfieldtypeDao;
   private static List<TConsoleDbfieldtype> allDBFieldTypes = null;

   public List<TConsoleDbfieldtype> query(PageInfo pageInfo) {
      return this.tConsoleDbfieldtypeDao.queryByPageInfo(pageInfo);
   }

   public void remove(List<String> idlist) {
      for(String id : idlist) {
         this.tConsoleDbfieldtypeDao.removeById(id);
      }

   }

   public void save(TConsoleDbfieldtype dbFieldTypes) {
      this.tConsoleDbfieldtypeDao.saveOrUpdate(dbFieldTypes);
   }

   public String getColumnTypeByJavaType(String dbtype, String javatype) {
      Criterion cdbtype = Restrictions.eq("javatype", javatype);
      Criterion cjavatype = Restrictions.eq("dbtype", dbtype);
      List<TConsoleDbfieldtype> dbfieldtype = this.tConsoleDbfieldtypeDao.queryAll(new Criterion[]{cdbtype, cjavatype});
      return !dbfieldtype.isEmpty() ? ((TConsoleDbfieldtype)dbfieldtype.get(0)).getColumntype() : null;
   }

   public TConsoleDbfieldtype getColumnTypeByJavaType(String dbtype, String javatype, String enginecolumntype) {
      TConsoleDbfieldtype dbfieldtype = (TConsoleDbfieldtype)this.tConsoleDbfieldtypeDao.queryUnique(new Criterion[]{Restrictions.eq("javatype", javatype), Restrictions.eq("dbtype", dbtype), Restrictions.eq("enginecolumntype", enginecolumntype)});
      if (dbfieldtype == null) {
         dbfieldtype = (TConsoleDbfieldtype)this.tConsoleDbfieldtypeDao.queryUnique(new Criterion[]{Restrictions.eq("javatype", javatype), Restrictions.eq("dbtype", dbtype)});
      }

      if (dbfieldtype == null) {
         dbfieldtype = (TConsoleDbfieldtype)this.tConsoleDbfieldtypeDao.queryUnique(new Criterion[]{Restrictions.eq("enginecolumntype", enginecolumntype), Restrictions.eq("dbtype", dbtype)});
      }

      return dbfieldtype;
   }

   public void refreshDBFieldTypes() {
      allDBFieldTypes = this.tConsoleDbfieldtypeDao.queryAll();
   }

   public String getEngineType(String dbtype, String columntype) {
      if (allDBFieldTypes == null) {
         this.refreshDBFieldTypes();
      }

      for(TConsoleDbfieldtype t : allDBFieldTypes) {
         if (t.getDbtype().equals(dbtype) && t.getColumntype().equals(columntype)) {
            return t.getEnginecolumntype();
         }
      }

      return "null";
   }

   public String getColumnJavaType(String dbtype, String columntype) {
      List<TConsoleDbfieldtype> dbfieldtype = this.tConsoleDbfieldtypeDao.queryAll(new Criterion[]{Restrictions.eq("dbtype", dbtype), Restrictions.eq("columntype", columntype)});
      return dbfieldtype != null && dbfieldtype.size() > 0 ? ((TConsoleDbfieldtype)dbfieldtype.get(0)).getJavatype() : null;
   }

   public TConsoleDbfieldtype queryColumn(String sourcedbtype, String columnname, String javatype) {
      TConsoleDbfieldtype column = null;
      if (column == null) {
         column = (TConsoleDbfieldtype)this.tConsoleDbfieldtypeDao.queryUnique(new Criterion[]{Restrictions.eq("dbtype", sourcedbtype), Restrictions.eq("javatype", javatype)});
      }

      return column;
   }
}
