package com.chenyang.nse.bussiness.service.console.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.core.encryption.TCoreDesensitizationStrategyLogDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.encryption.TCoreDesensitizationStrategyLog;
import com.chenyang.nse.bussiness.entity.vo.desensitization.DesensitizationStrategyLogVO;
import com.chenyang.nse.bussiness.service.console.DesensitizationStrategyLogService;
import com.chenyang.nse.bussiness.tools.datatime.DateTimeTool;
import com.chenyang.nse.bussiness.tools.encryption.SM3Utils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@Transactional
public class DesensitizationStrategyLogImpl implements DesensitizationStrategyLogService {
   @Autowired
   TCoreDesensitizationStrategyLogDao tCoreDesensitizationStrategyLogDao;

public List<DesensitizationStrategyLogVO> queryRow(PageInfo pageInfo, String module, String range, String user, String projectId) {
    List<Criterion> criteriaList = new ArrayList<>();

    if (module != null && !module.isEmpty()) {
        criteriaList.add(Restrictions.eq("operModule", module));
    }
    if (user != null && !user.isEmpty()) {
        criteriaList.add(Restrictions.eq("createuser", user));
    }

    Date today = new Date();
    if (range != null && !range.isEmpty()) {
        if (!"0".equals(range)) {
            if (!"全部".equals(range)) {
                criteriaList.add(Restrictions.between("createtime", DateTimeTool.beforeDays(today, Integer.parseInt(range)), today));
            }
        } else {
            criteriaList.add(Restrictions.ge("createtime", DateTimeTool.dayOfStart(today)));
        }
    }
    if (projectId != null && !projectId.trim().isEmpty()) {
        criteriaList.add(Restrictions.eq("projectId", projectId));
    }

    List<TCoreDesensitizationStrategyLog> logList = tCoreDesensitizationStrategyLogDao
            .queryByPageInfo(pageInfo, Order.desc("createtime"), criteriaList.toArray(new Criterion[0]));

    List<DesensitizationStrategyLogVO> list = new ArrayList<>();
    if (!ObjectUtils.isEmpty(logList)) {
        logList.forEach(item -> {
            DesensitizationStrategyLogVO vo = new DesensitizationStrategyLogVO();
            BeanUtils.copyProperties(item, vo);
            list.add(vo);
        });
    }
    return list;
}

  public List<Map<String, Object>> queryList(String module, String range, String user, String projectId) {
       List<Criterion> criteria = new ArrayList<>();

       if (module != null && !module.isEmpty()) {
           criteria.add(Restrictions.eq("operModule", module));
       }
       if (user != null && !user.isEmpty()) {
           criteria.add(Restrictions.eq("createuser", user));
       }
       Date today = new Date();
       if (range != null && !range.isEmpty()) {
           if (!"0".equals(range)) {
               if (!"全部".equals(range)) {
                   criteria.add(Restrictions.between("createtime", DateTimeTool.beforeDays(today, Integer.valueOf(range)), today));
               }
           } else {
               criteria.add(Restrictions.ge("createtime", DateTimeTool.dayOfStart(today)));
           }
       }
       if (projectId != null && !projectId.trim().isEmpty()) {
           criteria.add(Restrictions.eq("projectId", projectId));
       }

       List<TCoreDesensitizationStrategyLog> logList = tCoreDesensitizationStrategyLogDao.queryAll(
               Order.desc("createtime"), criteria.toArray(new Criterion[0]));

       List<Map<String, Object>> mapList = new ArrayList<>();
       for (TCoreDesensitizationStrategyLog encryptionLogVo : logList) {
           Map<String, Object> resultMap = new HashMap<>();
           resultMap.put("用户", encryptionLogVo.getCreateuser());
           resultMap.put("时间", encryptionLogVo.getCreatetime());
           resultMap.put("操作代码", encryptionLogVo.getCode());
           resultMap.put("操作信息", encryptionLogVo.getOperationMassage());
           mapList.add(resultMap);
       }
       return mapList;
   }

   public boolean checkEnc(String module, String range, String user, String projectId) {
      Criterion moduleCon;
      if (module != null && !"".equals(module)) {
         moduleCon = Restrictions.eq("operModule", module);
      } else {
         moduleCon = Restrictions.like("operModule", "%%");
      }

      Criterion userCon;
      if (user != null && !"".equals(user)) {
         userCon = Restrictions.eq("createuser", user);
      } else {
         userCon = Restrictions.like("createuser", "%%");
      }

      Date today = new Date();
      List<TCoreDesensitizationStrategyLog> logList;
      if (range != null && !"".equals(range)) {
         if (!"0".equals(range)) {
            if (!"全部".equals(range)) {
               Criterion timeCon = Restrictions.between("createtime", DateTimeTool.beforeDays(today, Integer.valueOf(range)), today);
               if (null != projectId && !"".equals(projectId.trim())) {
                  logList = this.tCoreDesensitizationStrategyLogDao.queryAll(Order.desc("createtime"), new Criterion[]{moduleCon, timeCon, userCon, Restrictions.eq("projectId", projectId)});
               } else {
                  logList = this.tCoreDesensitizationStrategyLogDao.queryAll(Order.desc("createtime"), new Criterion[]{moduleCon, timeCon, userCon});
               }
            } else if (null != projectId && !"".equals(projectId.trim())) {
               logList = this.tCoreDesensitizationStrategyLogDao.queryAll(Order.desc("createtime"), new Criterion[]{moduleCon, userCon, Restrictions.eq("projectId", projectId)});
            } else {
               logList = this.tCoreDesensitizationStrategyLogDao.queryAll(Order.desc("createtime"), new Criterion[]{moduleCon, userCon});
            }
         } else {
            Criterion timeCon = Restrictions.ge("createtime", DateTimeTool.dayOfStart(today));
            if (null != projectId && !"".equals(projectId.trim())) {
               logList = this.tCoreDesensitizationStrategyLogDao.queryAll(Order.desc("createtime"), new Criterion[]{moduleCon, timeCon, userCon, Restrictions.eq("projectId", projectId)});
            } else {
               logList = this.tCoreDesensitizationStrategyLogDao.queryAll(Order.desc("createtime"), new Criterion[]{moduleCon, timeCon, userCon});
            }
         }
      } else if (null != projectId && !"".equals(projectId.trim())) {
         logList = this.tCoreDesensitizationStrategyLogDao.queryAll(Order.desc("createtime"), new Criterion[]{moduleCon, userCon, Restrictions.eq("projectId", projectId)});
      } else {
         logList = this.tCoreDesensitizationStrategyLogDao.queryAll(Order.desc("createtime"), new Criterion[]{moduleCon, userCon});
      }

      SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

      for(TCoreDesensitizationStrategyLog tCoreDesensitizationStrategyLog : logList) {
         Date date = tCoreDesensitizationStrategyLog.getCreatetime();
         String dateString = sdf.format(date);

         try {
            if (!SM3Utils.encrypt(tCoreDesensitizationStrategyLog.getCreateuser() + dateString + tCoreDesensitizationStrategyLog.getOperationMassage()).equals(tCoreDesensitizationStrategyLog.getColumn_enc())) {
               return false;
            }
         } catch (Exception e) {
            e.printStackTrace();
         }
      }

      return true;
   }
}
