package com.chenyang.nse.bussiness.service.console.impl;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleDbfieldtypeDao;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleDictionaryDao;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleDictionarytypeDao;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleSortDao;
import com.chenyang.nse.bussiness.dao.table.core.TcoreDiscoverySensitivecolumnDao;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.StringUtil;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDictionary;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDictionarytype;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreDiscoverySensitivecolumn;
import com.chenyang.nse.bussiness.entity.vo.RegexTypeColorVO;
import com.chenyang.nse.bussiness.service.console.DictionaryService;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DictionaryServiceImpl implements DictionaryService {
   @Autowired
   private TConsoleDictionaryDao tConsoleDictionaryDao;
   @Autowired
   private TConsoleDictionarytypeDao tConsoleDictionarytypeDao;
   @Autowired
   private TConsoleDbfieldtypeDao tConsoleDbfieldtypeDao;
   @Autowired
   private TConsoleSortDao tConsoleSortDao;
   @Autowired
   private TcoreDiscoverySensitivecolumnDao tcoreDiscoverySensitivecolumnDao;

   public void removeDictionaryType(List<String> idlist) {
      Criterion typecodeCon = Restrictions.in("typecode", idlist);
      this.tConsoleDictionaryDao.remove(new Criterion[]{typecodeCon});
      this.tConsoleDictionarytypeDao.remove(new Criterion[]{typecodeCon});
   }

   public List<TConsoleDictionary> queryDictionaryByTypeCode(String typecode, PageInfo pageInfo, Map<String, Object> params) {
      String value = "";
      if (null != params && null != params.get("value")) {
         value = (String)params.get("value");
      }

      String parvalue = "";
      if (null != params && null != params.get("parvalue")) {
         parvalue = (String)params.get("parvalue");
      }

      Criterion cngroupname = Restrictions.like("value", value, MatchMode.ANYWHERE).ignoreCase();
      Criterion cnremark = Restrictions.like("parvalue", parvalue, MatchMode.ANYWHERE).ignoreCase();
      Criterion typecodeCon = Restrictions.eq("typecode", typecode);
      List<TConsoleDictionary> list;
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         List<Long> countlist = this.tConsoleDictionaryDao.queryCountBytype(typecode, value);
         String longString = countlist.get(0) + "";
         Long longCount = Long.parseLong(longString);
         pageInfo.setCount(longCount);
         list = this.tConsoleDictionaryDao.queryBypage(pageInfo, typecode, value);
      } else {
         list = this.tConsoleDictionaryDao.queryByPageInfo(pageInfo, Order.desc("createtime"), new Criterion[]{cngroupname, cngroupname, typecodeCon});
      }

      return list;
   }

   public List<String> querySingleFirstName() {
      return this.tConsoleDictionaryDao.queryValueByTypeCode("1");
   }

   public List<String> queryDoubleFirstName() {
      return this.tConsoleDictionaryDao.queryValueByTypeCode("2");
   }

   public List<String> queryFirstTwoNumOfIdentifyNo() {
      return this.tConsoleDictionaryDao.queryValueByTypeCode("3");
   }

   public List<String> queryProvinceAndCity() {
      return this.tConsoleDictionaryDao.queryValueByTypeCode("4", "5");
   }

   public List<String> queryDictionaryValues(String typeCode) {
      return this.tConsoleDictionaryDao.queryValueByTypeCode(typeCode);
   }

   public List<TConsoleDictionary> queryRuleType() {
      Criterion ctypecode = Restrictions.eq("typecode", "6");
      Criterion cparent = Restrictions.isNull("parentid");
      return this.tConsoleDictionaryDao.queryAll(new Criterion[]{ctypecode, cparent});
   }

   public void save(String regexTypeName, String regexTypeColor) {
      Criterion cvalue = Restrictions.eq("value", regexTypeName);
      Criterion ctypecode = Restrictions.eq("typecode", "6");
      List<TConsoleDictionary> typeList = this.tConsoleDictionaryDao.queryAll(new Criterion[]{cvalue, ctypecode});
      if (typeList != null && typeList.size() > 0) {
         String parentId = ((TConsoleDictionary)typeList.get(0)).getId();
         Criterion cparentid = Restrictions.eq("parentid", parentId);
         List<TConsoleDictionary> colorList = this.tConsoleDictionaryDao.queryAll(new Criterion[]{cparentid, ctypecode});
         if (colorList != null && colorList.size() > 0) {
            TConsoleDictionary colorRecord = (TConsoleDictionary)colorList.get(0);
            if (!regexTypeColor.equals(colorRecord.getValue())) {
               colorRecord.setValue(regexTypeColor);
               this.tConsoleDictionaryDao.saveOrUpdate(colorRecord);
            }
         } else {
            TConsoleDictionary colorRecord = new TConsoleDictionary("6", regexTypeColor, (String)null, parentId);
            colorRecord.setId(StringTool.getTablePrimaryKey());
            this.tConsoleDictionaryDao.save(colorRecord);
         }
      } else {
         TConsoleDictionary typeRecord = new TConsoleDictionary("6", regexTypeName, (String)null, (String)null);
         typeRecord.setId(StringTool.getTablePrimaryKey());
         this.tConsoleDictionaryDao.save(typeRecord);
         TConsoleDictionary colorRecord = new TConsoleDictionary("6", regexTypeColor, (String)null, typeRecord.getId());
         colorRecord.setId(StringTool.getTablePrimaryKey());
         this.tConsoleDictionaryDao.save(colorRecord);
      }

   }

   public String queryRegexTypeColor(String regexTypeName) {
      String regexTypeColor = "";
      Criterion cvalue = Restrictions.eq("value", regexTypeName);
      Criterion ctypecode = Restrictions.eq("typecode", "6");
      List<TConsoleDictionary> typeList = this.tConsoleDictionaryDao.queryAll(new Criterion[]{cvalue, ctypecode});
      if (typeList != null && typeList.size() > 0) {
         String parentId = ((TConsoleDictionary)typeList.get(0)).getId();
         Criterion cparentid = Restrictions.eq("parentid", parentId);
         List<TConsoleDictionary> colorList = this.tConsoleDictionaryDao.queryAll(new Criterion[]{cparentid, ctypecode});
         if (colorList != null && colorList.size() > 0) {
            regexTypeColor = ((TConsoleDictionary)colorList.get(0)).getValue();
         }
      }

      return regexTypeColor;
   }

   public List<RegexTypeColorVO> queryAllRegexTypeColor() {
      return this.tConsoleDictionaryDao.queryAllRegexTypeColor();
   }

   public List<String> queryAllRegexTypes() {
      return this.tConsoleDictionaryDao.queryAllRegexTypes();
   }

   public void delete(String regexTypeName) {
      Criterion cvalue = Restrictions.eq("value", regexTypeName);
      Criterion ctypecode = Restrictions.eq("typecode", "6");
      List<TConsoleDictionary> typeList = this.tConsoleDictionaryDao.queryAll(new Criterion[]{cvalue, ctypecode});
      if (typeList != null && typeList.size() > 0) {
         TConsoleDictionary typeRecord = (TConsoleDictionary)typeList.get(0);
         Criterion cparentid = Restrictions.eq("parentid", typeRecord.getId());
         List<TConsoleDictionary> colorList = this.tConsoleDictionaryDao.queryAll(new Criterion[]{cparentid, ctypecode});
         if (colorList != null && colorList.size() > 0) {
            this.tConsoleDictionaryDao.remove(colorList.get(0));
         }

         this.tConsoleDictionaryDao.remove(typeRecord);
      }

   }

   public List<TConsoleDictionary> query(String fuzzySearch, String typecode, String value, PageInfo pageInfo) {
      if (null != value && !"".equals(value)) {
         List<TConsoleDictionary> list = this.tConsoleDictionaryDao.queryDictionaryLike(typecode, value, pageInfo);
         return list;
      } else {
         List<TConsoleDictionary> list = this.tConsoleDictionaryDao.queryALLDictionary(fuzzySearch, typecode, pageInfo);
         return list;
      }
   }

   public List<TConsoleDictionary> query(String typecode, String value, PageInfo pageInfo) {
      if ((null == value || "".equals(value)) && "ALL".equals(typecode)) {
         List<TConsoleDictionary> list = this.tConsoleDictionaryDao.queryALLDictionary(pageInfo);
         return list;
      } else {
         List<TConsoleDictionary> list = null;
         if ("ALL".equals(typecode)) {
            list = this.tConsoleDictionaryDao.queryALLDictionaryLike(value, pageInfo);
         }

         return list;
      }
   }

   public List<TConsoleDictionarytype> getDictinaryTypes() {
      return this.tConsoleDictionarytypeDao.queryAllDictionaryType();
   }

   public List<TConsoleDictionarytype> getDictinaryTypesbytypename(String typename) {
      return this.tConsoleDictionarytypeDao.queryAll(new Criterion[]{Restrictions.eq("typename", typename)});
   }

   public List<TConsoleDictionary> getDictinaryByname(String dicname) {
      return this.tConsoleDictionaryDao.queryAll(new Criterion[]{Restrictions.eq("name", dicname)});
   }

   public void removeSum(List<String> idlist) {
      for(String id : idlist) {
         this.tConsoleDictionaryDao.removeById(id);
      }

   }

   public void remove(String dicid) {
      if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
         StringBuilder sql = (new StringBuilder()).append("delete from T_CONSOLE_DICTIONARY where id = '").append(dicid).append("'");
         this.tConsoleDictionaryDao.savetCoreDicField(sql);
      } else {
         this.tConsoleDictionaryDao.removeById(dicid);
      }

   }

   public TConsoleDictionary initEditRude(String rowid, String typecode) {
      TConsoleDictionary tConsoleDictionary = new TConsoleDictionary();
      List<TConsoleDictionary> list = this.tConsoleDictionaryDao.queryoneDictionary(rowid, typecode);
      int i = 0;

      for(TConsoleDictionary tConsoleDictionary2 : list) {
         if (i == 0) {
            tConsoleDictionary.setTypecode(tConsoleDictionary2.getTypecode());
            tConsoleDictionary.setValue(tConsoleDictionary2.getValue());
            tConsoleDictionary.setName(tConsoleDictionary2.getName());
            tConsoleDictionary.setTypename(tConsoleDictionary2.getTypename());
            tConsoleDictionary.setId(tConsoleDictionary2.getId());
         }

         ++i;
      }

      return tConsoleDictionary;
   }

   public TConsoleDictionary initEditDictionary(String id) {
      TConsoleDictionary tConsoleDictionary = (TConsoleDictionary)this.tConsoleDictionaryDao.queryUnique(new Criterion[]{Restrictions.eq("id", id)});
      return tConsoleDictionary;
   }

   public TConsoleDictionarytype initEditDictionaryType(String id) {
      TConsoleDictionarytype tConsoleDictionaryType = (TConsoleDictionarytype)this.tConsoleDictionarytypeDao.queryUnique(new Criterion[]{Restrictions.eq("id", id)});
      return tConsoleDictionaryType;
   }

   public void save(TConsoleDictionary dictionary) {
      if (null != dictionary.getId() && !"".equals(dictionary.getId())) {
         if ("".equals(dictionary.getParentid())) {
            dictionary.setParentid((String)null);
         }

         if (null == dictionary.getParentvalue()) {
            dictionary.setParentvalue("");
         }

         dictionary.setUpdateuser(CommonUtils.loginUsername());
         dictionary.setUpdatetime(new Date());
         if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String utime = sdf.format(new Date());
            StringBuilder sql = (new StringBuilder()).append("update T_CONSOLE_DICTIONARY set typecode='").append(dictionary.getTypecode()).append("',").append("`value`='").append(dictionary.getValue()).append("',").append("name='").append(dictionary.getName()).append("',").append("parentvalue='").append(dictionary.getParentvalue()).append("',");
            if (null == dictionary.getParentid()) {
               sql.append("parentid=NULL,");
            } else {
               sql.append("parentid='").append(dictionary.getParentid()).append("',");
            }

            sql.append("updatetime='").append(utime).append("',").append("updateuser='").append(dictionary.getUpdateuser()).append("' where id='").append(dictionary.getId()).append("'");
            this.tConsoleDictionaryDao.savetCoreDicField(sql);
         } else {
            this.tConsoleDictionaryDao.update(dictionary);
         }
      } else {
         dictionary.setId(StringTool.getTablePrimaryKey());
         dictionary.setCreatetime(new Date());
         dictionary.setCreateuser(CommonUtils.loginUsername());
         if (HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String ctime = sdf.format(new Date());
            StringBuilder sql = (new StringBuilder()).append("insert into T_CONSOLE_DICTIONARY (createtime, createuser, flag, note, updatetime, updateuser, name, parentid, remark, typecode, `value`, id) values ('").append(ctime).append("','").append(CommonUtils.loginUsername()).append("','','',NULL,NULL,'").append(dictionary.getName()).append("','").append(dictionary.getParentid()).append("','','").append(dictionary.getTypecode()).append("','").append(dictionary.getValue()).append("','").append(dictionary.getId()).append("')");
            this.tConsoleDictionaryDao.savetCoreDicField(sql);
         } else {
            this.tConsoleDictionaryDao.save(dictionary);
         }
      }

   }

   public void addDictionaryType(TConsoleDictionarytype dictionaryType) {
      if (StringUtil.isBlank(dictionaryType.getId())) {
         List<TConsoleDictionarytype> list = this.tConsoleDictionarytypeDao.queryAll();
         int typeCode = 1;
         if (list != null && list.size() > 0) {
            for(TConsoleDictionarytype type : list) {
               int temp = Integer.parseInt(type.getTypecode());
               if (temp > typeCode) {
                  typeCode = temp;
               }
            }

            ++typeCode;
         }

         dictionaryType.setTypecode(typeCode + "");
         dictionaryType.setCreatetime(new Date());
         dictionaryType.setCreateuser(CommonUtils.loginUsername());
         this.tConsoleDictionarytypeDao.save(dictionaryType);
      } else {
         TConsoleDictionarytype dictionaryTypeUp = (TConsoleDictionarytype)this.tConsoleDictionarytypeDao.queryUnique(new Criterion[]{Restrictions.eq("id", dictionaryType.getId())});
         dictionaryTypeUp.setRemark(dictionaryType.getRemark());
         dictionaryTypeUp.setTypename(dictionaryType.getTypename());
         dictionaryTypeUp.setUpdateuser(CommonUtils.loginUsername());
         dictionaryTypeUp.setUpdatetime(new Date());
         this.tConsoleDictionarytypeDao.saveOrUpdate(dictionaryTypeUp);
      }

   }

   public long queryDictionaryTypeCount(String typename) {
      Criterion ctypename = Restrictions.eq("typename", typename);
      return this.tConsoleDictionarytypeDao.count(new Criterion[]{ctypename});
   }

   public List<TConsoleDictionary> querySensitiveTypes() {
      return this.tConsoleDictionaryDao.querySensitiveTypes();
   }

   public List<String> querySensitiveTypeNames() {
      return this.tConsoleDictionaryDao.querySensitiveTypeNames();
   }

   public void sortSensitiveTypes(List<String> ids) {
      this.tConsoleSortDao.sortSensitiveTypes(ids);
   }

   public void tcoreDiscoverySensitivecolumnSave(TcoreDiscoverySensitivecolumn tcoreDiscoverySensitivecolumn) {
      this.tcoreDiscoverySensitivecolumnDao.save(tcoreDiscoverySensitivecolumn);
   }

   public List<TcoreDiscoverySensitivecolumn> queryTcoreDiscoverySensitivecolumn(String groupid, String taskversion) {
      Criterion cgroupid = Restrictions.eq("groupid", groupid);
      Criterion ctaskversion = Restrictions.eq("taskversion", taskversion);
      List<TcoreDiscoverySensitivecolumn> listTcore = this.tcoreDiscoverySensitivecolumnDao.queryAll(new Criterion[]{cgroupid, ctaskversion});
      return listTcore;
   }

   public List<TConsoleDictionary> queryAll(PageInfo pageInfo) {
      return null;
   }

   public List<TConsoleDictionarytype> queryBycode(String code) {
      List<TConsoleDictionarytype> list = this.tConsoleDictionaryDao.queryBycode(code);
      return list;
   }

   public void removetype(String typecode) {
      this.tConsoleDictionarytypeDao.removebytype(typecode);
   }
}
