package com.chenyang.nse.bussiness.service.console.impl;

import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleLogDao;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleOperationrecordDao;
import com.chenyang.nse.bussiness.dao.table.core.DgDefineRuleDao;
import com.chenyang.nse.bussiness.dao.table.core.SensitiveCategoryLogDao;
import com.chenyang.nse.bussiness.engine.infa.powercenter961.pubtool.StringUtil;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleLog;
import com.chenyang.nse.bussiness.entity.orm.table.core.DgDefineRule;
import com.chenyang.nse.bussiness.entity.vo.MenuResourcesVO;
import com.chenyang.nse.bussiness.service.console.OperationService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OperationServiceImpl implements OperationService {
   @Autowired
   private TConsoleOperationrecordDao tConsoleOperationrecordDao;
   @Autowired
   TConsoleLogDao tConsoleLogDao;
   @Autowired
   private DgDefineRuleDao dgDefineRuleDao;
   @Autowired
   private SensitiveCategoryLogDao sensitiveCategoryLogDao;

   public void add(TConsoleLog record) {
      this.tConsoleLogDao.save(record);
   }

   public MenuResourcesVO queryMenuResourcesByUrl(String url) {
      return null;
   }

   public List<TConsoleLog> query(String username, String module, String operationtime) {
      Order order = Order.desc("operationtime");
      List<TConsoleLog> list = this.tConsoleLogDao.queryAll(order, new Criterion[]{Restrictions.like("operationUser", "%" + username + "%"), Restrictions.like("module", "%" + module + "%")});
      List<TConsoleLog> querylist = new ArrayList();

      for(TConsoleLog record : list) {
         SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
         String date = format.format(record.getOperationtime()).substring(0, 10);
         if (!StringUtil.isBlank(operationtime) && operationtime.contains(date)) {
            querylist.add(record);
         }
      }

      if (!StringUtil.isBlank(operationtime)) {
         return querylist;
      } else {
         return list;
      }
   }

   public List<TConsoleLog> query1(String username, String module, String operationtime, String operationObject) {
      Order order = Order.desc("operationtime");
      List<TConsoleLog> list;
      if ("".equals(operationObject)) {
         list = this.tConsoleLogDao.queryAll(order, new Criterion[]{Restrictions.like("operationUser", "%" + username + "%"), Restrictions.like("module", "%" + module + "%")});
      } else {
         list = this.tConsoleLogDao.queryAll(order, new Criterion[]{Restrictions.like("operationUser", "%" + username + "%"), Restrictions.like("module", "%" + module + "%"), Restrictions.like("operationObject", "%" + operationObject + "%")});
      }

      List<TConsoleLog> querylist = new ArrayList();

      for(TConsoleLog record : list) {
         SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
         String date = format.format(record.getOperationtime()).substring(0, 10);
         if (!StringUtil.isBlank(operationtime) && operationtime.contains(date)) {
            querylist.add(record);
         }
      }

      if (!StringUtil.isBlank(operationtime)) {
         return querylist;
      } else {
         return list;
      }
   }

   public List<TConsoleLog> getTConsoleLogBylogno(String logno) {
      Order order = Order.asc("flag");
      List<TConsoleLog> list = this.tConsoleLogDao.queryAll(order, new Criterion[]{Restrictions.eq("logno", logno)});
      return list;
   }

   public void addDefineLog(DgDefineRule record) {
      this.dgDefineRuleDao.save(record);
   }

   public List<Map<String, Object>> queryCategorySensitiveLog(PageInfo pageInfo, String ruletype, String createuser, String projectid) {
      return this.sensitiveCategoryLogDao.queryAllCategorySensitiveLog(pageInfo, ruletype, createuser, projectid);
   }
}
