package com.chenyang.nse.bussiness.service.console.impl;

import com.chenyang.nse.bussiness.dao.table.console.TConsolePrivilegeDao;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsolePrivilege;
import com.chenyang.nse.bussiness.service.console.PrivilegeService;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PrivilegeServiceImpl implements PrivilegeService {
   @Autowired
   private TConsolePrivilegeDao tConsolePrivilegeDao;

   public void save(String roleid, List<String> privileges) {
      this.tConsolePrivilegeDao.save(roleid, privileges);
   }

   public List<TConsolePrivilege> queryPrivilegeByRoleId(String roleid) {
      Criterion croleid = Restrictions.eq("roleid", roleid);
      List<TConsolePrivilege> list = this.tConsolePrivilegeDao.queryAll(new Criterion[]{croleid});
      return list;
   }
}
