package com.chenyang.nse.bussiness.service.console.impl;

import com.chenyang.nse.bussiness.config.HibernateConfig;
import com.chenyang.nse.bussiness.config.PropertiesLoaderUtils;
import com.chenyang.nse.bussiness.dao.PageInfo;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleDictionaryDao;
import com.chenyang.nse.bussiness.dao.table.console.TConsoleSearchregexDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreCurrencyInfoDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDataFileGroupDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreDatasystemDao;
import com.chenyang.nse.bussiness.dao.table.core.TCoreSensitivegroupDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreDataAreaDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreProjectFindruleDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreProjectSearchRegexDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreSearchregexVoDao;
import com.chenyang.nse.bussiness.dao.table.core.dataproject.TCoreTaskFindruleDao;
import com.chenyang.nse.bussiness.dao.table.core.file.TCoreFileStructureDao;
import com.chenyang.nse.bussiness.dao.table.core.file.TCoreFileStructurecolumnDao;
import com.chenyang.nse.bussiness.dao.table.core.file.TCoreFileStructurespliterDao;
import com.chenyang.nse.bussiness.entity.db.ColumnInfo;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleDictionary;
import com.chenyang.nse.bussiness.entity.orm.table.console.TConsoleSearchregex;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreCurrencyInfo;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDataFileGroup;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreDatasystem;
import com.chenyang.nse.bussiness.entity.orm.table.core.TCoreSensitivegroup;
import com.chenyang.nse.bussiness.entity.orm.table.core.dataproject.TCoreDataArea;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TCoreFieldSensitiveMemory;
import com.chenyang.nse.bussiness.entity.orm.table.core.discovery.TcoreTaskFindrule;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructure;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurespliter;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import com.chenyang.nse.bussiness.entity.vo.ProgressInfo;
import com.chenyang.nse.bussiness.entity.vo.SensitiveColumn;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreDataAreaVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreDataFileGroupVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreProjectFindruleVO;
import com.chenyang.nse.bussiness.entity.vo.dataproject.TCoreSearchregexVO;
import com.chenyang.nse.bussiness.entity.vo.maskingtask.ColumnInfoVO;
import com.chenyang.nse.bussiness.enumeration.EdbType;
import com.chenyang.nse.bussiness.service.console.OperationService;
import com.chenyang.nse.bussiness.service.console.SearchRegexService;
import com.chenyang.nse.bussiness.service.core.DataSystemService;
import com.chenyang.nse.bussiness.service.core.dataproject.DiscoverytaskService;
import com.chenyang.nse.bussiness.service.redis.RedisService;
import com.chenyang.nse.bussiness.tools.dmp.DmpDpTool;
import com.chenyang.nse.bussiness.tools.dmp.DmpTool;
import com.chenyang.nse.bussiness.tools.dmp.MultipleDmpDpTool;
import com.chenyang.nse.bussiness.tools.dmp.MultipleDmpTool;
import com.chenyang.nse.bussiness.tools.dmp.TableStructureInfo;
import com.chenyang.nse.bussiness.tools.io.FileTool;
import com.chenyang.nse.bussiness.tools.jdbc.JdbcTool;
import com.chenyang.nse.bussiness.tools.login.CommonUtils;
import com.chenyang.nse.bussiness.tools.net.FtpTool;
import com.chenyang.nse.bussiness.tools.net.SFTPUtil;
import com.chenyang.nse.bussiness.tools.number.IdnoTool;
import com.chenyang.nse.bussiness.tools.number.MobileNumberTool;
import com.chenyang.nse.bussiness.tools.object.ObjectTool;
import com.chenyang.nse.bussiness.tools.string.StringTool;
import com.chenyang.nse.bussiness.tools.xml.XmlTool;
import com.jcraft.jsch.SftpException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@Transactional
public class SearchRegexServiceImpl implements SearchRegexService {
   @Autowired
   private TCoreDatasystemDao tCoreDatasystemDao;
   @Autowired
   private TConsoleSearchregexDao tConsoleSearchregexDao;
   @Autowired
   private TCoreSearchregexVoDao tCoreSearchregexVoDao;
   @Autowired
   private TCoreSensitivegroupDao tCoreSensitivegroupDao;
   @Autowired
   private TCoreCurrencyInfoDao tCoreCurrencyInfoDao;
   @Autowired
   private TConsoleDictionaryDao tConsoleDictionaryDao;
   @Autowired
   private TCoreFileStructureDao tCoreFileStructureDao;
   @Autowired
   private TCoreFileStructurespliterDao tCoreFileStructurespliterDao;
   @Autowired
   private TCoreProjectSearchRegexDao tCoreProjectSearchRegexDao;
   @Autowired
   private TCoreDataAreaDao tCoreDataAreaDao;
   @Autowired
   private TCoreProjectFindruleDao tCoreProjectFindruleDao;
   @Autowired
   private DiscoverytaskService discoverytaskService;
   @Autowired
   private OperationService operationService;
   @Autowired
   private DataSystemService dataSystemService;
   @Autowired
   private TCoreFileStructurecolumnDao tCoreFileStructurecolumnDao;
   @Autowired
   private TCoreDataFileGroupDao tCoreDataFileGroupDao;
   @Autowired
   private TCoreTaskFindruleDao tCoreTaskFindruleDao;
   @Autowired
   private RedisService redisService;
   public static final String CURRENCY_TYPECODE = "18";
   public static final String FLOAT_TYPECODE = "19";
   public static final String NATION_TYPECODE = "20";
   public static final String MARRY_TYPECODE = "21";
   private Map<String, Method> methods = new HashMap();
   private int yearNow = 2100;
   private Pattern phoneNoReplacePattern;
   private Pattern allChinesePattern;
   private List<String> singleFirstNameList;
   private List<String> doubleFirstNameList;
   private Pattern allEnglishPattern;
   private List<String> nationality;
   private List<String> religionList;
   private List<String> nationList;
   private List<String> politicList;
   private List<String> birthAddress;
   private Pattern diplomapattern;
   private List<String> diplomaList;
   private List<String> diplomanoList;
   private List<String> socialList;
   private List<String> socialList1;
   private Pattern ip4Pattern;
   private List<String> firstSixNumList;
   private Pattern identifyNoPattern;
   private SimpleDateFormat identifyNoDateFormat;
   private int[] identifyNoFactors = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
   private char[] identifyNoResults = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
   private Pattern chineseAddressPattern;
   private Pattern chineseAddressPatternFirstSix;
   private Pattern chineseAddressPatternFirstThree;
   private Pattern telephoneNoSimplePattern;
   private Pattern isContainsChineseOrEnglish;
   private Pattern telephoneNoPattern;
   private Pattern mobilephoneNoSimplePattern;
   private List<String> firstThreeNoList;
   private Pattern phoneNoSimplePattern;
   private Pattern emailPattern;
   private Pattern emailPrefix;
   private Pattern emailSuffix;
   private Pattern companyNamePattern;
   private Pattern shopNamePattern;
   private List<String> postCodeList;
   private Pattern postCodePattern6;
   private int[] factors = new int[]{3, 7, 9, 10, 5, 8, 4, 2};
   private Pattern organizationCodePattern;
   private Pattern cardNoPattern;
   private Pattern taxCodePattern15;
   private Pattern taxCodePattern20;
   private List<String> zoneCodeList;
   private Pattern businessLicenseCodePattern;
   private List<String> ticketList;

   public List<TConsoleSearchregex> query(PageInfo pageInfo) {
      List<TConsoleSearchregex> list = this.tConsoleSearchregexDao.queryByPageInfo(pageInfo);
      return list;
   }

   public List<TCoreSearchregexVO> querySearchregex(String dataarea, String rulename, PageInfo pageInfo) {
      List<TCoreSearchregexVO> tCoreSearchregexVOvolist = new ArrayList();
      List<TCoreSearchregexVO> list = this.tCoreSearchregexVoDao.querySearchregexList(dataarea, rulename, pageInfo);
      if (!ObjectUtils.isEmpty(list)) {
         for(int i = 0; i < list.size(); ++i) {
            list.get(i);
            TCoreSearchregexVO tCoreSearchregexVO = new TCoreSearchregexVO();

            try {
               tCoreSearchregexVO = (TCoreSearchregexVO)ObjectTool.getObjectByMap(TCoreSearchregexVO.class, (Map)list.get(i));
            } catch (Exception e) {
               e.printStackTrace();
            }

            tCoreSearchregexVOvolist.add(tCoreSearchregexVO);
         }
      }

      return tCoreSearchregexVOvolist;
   }

   public List<TCoreSearchregexVO> queryDataAreaSearchregex(String dataarea, String rulename) {
      List<TCoreSearchregexVO> tCoreSearchregexVOvolist = new ArrayList();
      List<TCoreSearchregexVO> list = this.tCoreSearchregexVoDao.queryDataAreaSearchregexList(dataarea, rulename);
      if (!ObjectUtils.isEmpty(list)) {
         for(int i = 0; i < list.size(); ++i) {
            list.get(i);
            TCoreSearchregexVO tCoreSearchregexVO = new TCoreSearchregexVO();
            if (!HibernateConfig.PEIZHIKUDBTYPE.equals("3")) {
               try {
                  tCoreSearchregexVO = (TCoreSearchregexVO)ObjectTool.getObjectByMap(TCoreSearchregexVO.class, (Map)list.get(i));
               } catch (Exception e) {
                  e.printStackTrace();
               }
            } else {
               try {
                  tCoreSearchregexVO = (TCoreSearchregexVO)ObjectTool.getObjectByMapHsql(TCoreSearchregexVO.class, (Map)list.get(i));
               } catch (Exception e) {
                  e.printStackTrace();
               }
            }

            tCoreSearchregexVOvolist.add(tCoreSearchregexVO);
         }
      }

      for(int i = 0; i < tCoreSearchregexVOvolist.size(); ++i) {
         TCoreSearchregexVO tCoreSearchregexVOInfo = (TCoreSearchregexVO)tCoreSearchregexVOvolist.get(i);
         if ("02".equals(tCoreSearchregexVOInfo.getDiscoverway())) {
            String searchregexId = tCoreSearchregexVOInfo.getRuleid();
            Criterion searchregexIdCon = Restrictions.eq("searchregexid", searchregexId);
            List<TCoreDataFileGroup> datafileList = this.tCoreDataFileGroupDao.queryAll(new Criterion[]{searchregexIdCon});
            tCoreSearchregexVOInfo.setDatafile(datafileList);
         }
      }

      return tCoreSearchregexVOvolist;
   }

   public List<TCoreSearchregexVO> queryDataAreaSearchregexByProjectid(String projectid) {
      List<TCoreSearchregexVO> tCoreSearchregexVOvolist = new ArrayList();
      List<TCoreSearchregexVO> list = this.tCoreSearchregexVoDao.queryDataAreaSearchregexByProjectid(projectid);
      if (!ObjectUtils.isEmpty(list)) {
         for(int i = 0; i < list.size(); ++i) {
            list.get(i);
            TCoreSearchregexVO tCoreSearchregexVO = new TCoreSearchregexVO();

            try {
               tCoreSearchregexVO = (TCoreSearchregexVO)ObjectTool.getObjectByMap(TCoreSearchregexVO.class, (Map)list.get(i));
            } catch (Exception e) {
               e.printStackTrace();
            }

            tCoreSearchregexVOvolist.add(tCoreSearchregexVO);
         }
      }

      for(int i = 0; i < tCoreSearchregexVOvolist.size(); ++i) {
         TCoreSearchregexVO tCoreSearchregexVOInfo = (TCoreSearchregexVO)tCoreSearchregexVOvolist.get(i);
         if ("02".equals(tCoreSearchregexVOInfo.getDiscoverway())) {
            String searchregexId = tCoreSearchregexVOInfo.getRuleid();
            Criterion searchregexIdCon = Restrictions.eq("searchregexid", searchregexId);
            List<TCoreDataFileGroup> datafileList = this.tCoreDataFileGroupDao.queryAll(new Criterion[]{searchregexIdCon});
            tCoreSearchregexVOInfo.setDatafile(datafileList);
         }
      }

      return tCoreSearchregexVOvolist;
   }

   public List<TConsoleSearchregex> queryAllSearchRegex() {
      return this.tConsoleSearchregexDao.queryAll();
   }

   public void remove(List<String> idlist) {
      Criterion criterion = Restrictions.in("id", idlist);
      this.tConsoleSearchregexDao.remove(new Criterion[]{criterion});
   }

   public boolean checkNameExit(String name) {
      Criterion criterion = Restrictions.eq("name", name);
      return this.tConsoleSearchregexDao.count(new Criterion[]{criterion}) > 0L;
   }

   public void save(TConsoleSearchregex searchRegex) {
      if (null != searchRegex.getId() && !"".equals(searchRegex.getId())) {
         this.tConsoleSearchregexDao.saveOrUpdate(searchRegex);
      } else {
         this.tConsoleSearchregexDao.save(searchRegex);
      }

   }

   public List<TConsoleSearchregex> querySearchRegex(String flag) {
      Criterion criterion = Restrictions.eq("flag", flag);
      return this.tConsoleSearchregexDao.queryAll(new Criterion[]{criterion});
   }

   public Map<String, List<SensitiveColumn>> getAllTableColumnsByName(int queren, String samplingtype, String aifind, TCoreDatasystem datasystem, List<String> schemas, List<TConsoleSearchregex> searchRegexList, ProgressInfo progressInfo) {
      Map<String, List<SensitiveColumn>> tableColumns = new HashMap();
      Connection connection = JdbcTool.getConnection(datasystem);
      String dbType = datasystem.getDbtype();
      if (((String)schemas.get(0)).equals(",") || ((String)schemas.get(0)).equals("")) {
         schemas.remove(0);
      }

      long schemaIndex = 1L;
      HashMap<String, List<String>> scMap = new HashMap();
      List<String> schemaslist = new ArrayList();

      for(String schema : schemas) {
         List<String> tableLst = new ArrayList();
         String[] scArr = schema.split("~");
         String sc = scArr[0];
         String tableName = scArr[1];
         if (null == scMap.get(sc)) {
            tableLst.add(tableName);
            scMap.put(sc, tableLst);
            schemaslist.add(sc);
         } else {
            tableLst = (List)scMap.get(sc);
            tableLst.add(tableName);
            scMap.put(sc, tableLst);
         }
      }

      progressInfo.setSchemaCount((long)schemaslist.size());

      for(String schema : schemaslist) {
         progressInfo.setCurrentState("notReady");
         progressInfo.setCurrentSchema(schemaIndex);
         progressInfo.setCurrentSchemaName(schema);
         List<String> allTableListOfSchema = (List)scMap.get(schema);
         if (allTableListOfSchema.size() == 0) {
            if (schemaIndex == 1L) {
               progressInfo.setReady(true);
            }

            progressInfo.setTotalCount(0L);
            progressInfo.setCurrent(0L);
            progressInfo.setCurrentState("ready");
            ++schemaIndex;
         } else {
            progressInfo.setTotalCount((long)allTableListOfSchema.size());
            progressInfo.setCurrentState("ready");
            List<Pattern> patternList = new ArrayList();

            for(TConsoleSearchregex searchRegex : searchRegexList) {
               patternList.add(Pattern.compile(searchRegex.getRegex()));
            }

            long tableIndex = 1L;

            for(String tableName : allTableListOfSchema) {
               progressInfo.setCurrent(tableIndex);
               progressInfo.setCurrentTable(tableName);
               if (schemaIndex == 1L && tableIndex == 1L) {
                  progressInfo.setReady(true);
               }

               new ArrayList();
               HashMap<String, TCoreFieldSensitiveMemory> ha = new HashMap();
               if (aifind.equals("1")) {
                  for(TCoreFieldSensitiveMemory tCoreFieldSensitiveMemory : this.discoverytaskService.queryTCoreFieldSensitiveMemory(tableName, schema)) {
                     ha.put(tCoreFieldSensitiveMemory.getId(), tCoreFieldSensitiveMemory);
                  }
               }

               List<String> columnNames = this.getColumnsOfSchema(connection, dbType, tableName, schema);
               if (columnNames.size() > 0) {
                  List<SensitiveColumn> sensitiveColumns = new ArrayList();
                  tableColumns.put(schema + "#_#" + tableName, sensitiveColumns);

                  for(String columnName : columnNames) {
                     if (aifind.equals("1")) {
                        String keyid = schema + tableName + columnName;
                        if (ha.get(keyid) != null) {
                           SensitiveColumn sen = new SensitiveColumn();
                           sen.setColumnName(columnName);
                           sen.setDatasourceid(datasystem.getId());
                           sen.setDatasourcename(datasystem.getSysname());
                           sen.setDistinctCount(0L);
                           sen.setMatchCount(0L);
                           sen.setRegexType(((TCoreFieldSensitiveMemory)ha.get(keyid)).getRegextype());
                           sen.setRuleName(((TCoreFieldSensitiveMemory)ha.get(keyid)).getRuie());
                           sen.setRuleId(((TCoreFieldSensitiveMemory)ha.get(keyid)).getRuleid());
                           sen.setRegexName(((TCoreFieldSensitiveMemory)ha.get(keyid)).getRegextype());
                           sen.setSchema(schema);
                           sen.setSensitiveColumn(true);
                           sen.setTableName(tableName);
                           sen.setTotalCount(0L);
                           sen.setValidCount(0L);
                           sen.setIsIntelligent("1");
                           sensitiveColumns.add(sen);
                        } else {
                           sensitiveColumns.add(this.getSensitiveColumnByName(datasystem.getId(), datasystem.getSysname(), schema, tableName, columnName, searchRegexList, patternList));
                        }
                     } else {
                        sensitiveColumns.add(this.getSensitiveColumnByName(datasystem.getId(), datasystem.getSysname(), schema, tableName, columnName, searchRegexList, patternList));
                     }
                  }
               }

               ++tableIndex;
            }

            ++schemaIndex;
         }
      }

      return tableColumns;
   }

   public Map<String, List<SensitiveColumn>> getAllTableColumnsByContent(int queren, String samplingtype, String aifind, TCoreDatasystem datasystem, List<String> schemas, long maxRowCount, double rate, List<TConsoleSearchregex> searchRegexList, ProgressInfo progressInfo, String datasystemid) {
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String num = props.getProperty("random");
      List<String> timeLogList = new ArrayList();
      timeLogList.add("敏感字段查询开始：" + System.currentTimeMillis());
      new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      String chagneLineString = "\r\n";
      new ArrayList();
      new ArrayList();
      int queryTableDataErrorCount = 0;
      int queryTableDataAgainErrorCount = 0;
      int otherErrorCount = 0;
      List<String> allTableList = new ArrayList();
      new ArrayList();
      Map<String, List<SensitiveColumn>> tableColumns = new HashMap();
      String selectDataType = samplingtype;
      String dbType = datasystem.getDbtype();
      Connection connection = JdbcTool.getConnection(datasystem);
      long schemaIndex = 1L;
      progressInfo.setSchemaCount((long)schemas.size());
      HashMap<String, List<String>> hash = new HashMap();
      List<String> schemaslist = new ArrayList();
      List<String> floatdic = this.tConsoleDictionaryDao.queryValueByTypeCode("19");

      for(String schema : schemas) {
         List<String> table = new ArrayList();
         String[] s = schema.split("~");
         String a = s[0];
         String b = s[1];
         if (hash.get(a) == null) {
            table.add(b);
            hash.put(a, table);
            schemaslist.add(a);
         } else {
            table = (List)hash.get(a);
            table.add(b);
            hash.put(a, table);
         }
      }

      progressInfo.setSchemaCount((long)schemaslist.size());

      for(String schema : schemaslist) {
         String tableInfo = null;
         progressInfo.setCurrentState("notReady");
         progressInfo.setCurrentSchema(schemaIndex);
         progressInfo.setCurrentSchemaName(schema);
         new ArrayList();
         List<String> var73 = (List)hash.get(schema);
         if (var73.size() == 0) {
            if (schemaIndex == 1L) {
               progressInfo.setReady(true);
            }

            progressInfo.setTotalCount(0L);
            progressInfo.setCurrent(0L);
            progressInfo.setCurrentState("ready");
            ++schemaIndex;
         } else {
            allTableList.addAll(var73);
            progressInfo.setTotalCount((long)var73.size());
            progressInfo.setCurrentState("ready");
            String queryTableDataSql = this.getQuerySql(selectDataType, dbType, schema, maxRowCount, "");
            List<Pattern> patternList = new ArrayList();

            for(TConsoleSearchregex searchRegex : searchRegexList) {
               patternList.add(Pattern.compile(searchRegex.getRegex()));
            }

            try {
               long tableIndex = 1L;
               List<TCoreCurrencyInfo> tableInfoL = this.tCoreCurrencyInfoDao.getCurrencyInfoTable(datasystem.getSysname(), schema);
               if (tableInfoL.size() > 0) {
                  tableInfo = ((TCoreCurrencyInfo)tableInfoL.get(0)).getCurrencytable();
               }

               List<String> currdic = this.tConsoleDictionaryDao.queryValueByTypeCode("18");

               for(String tableName : var73) {
                  progressInfo.setCurrent(tableIndex);
                  progressInfo.setCurrentTable(tableName);
                  if (schemaIndex == 1L && tableIndex == 1L) {
                     progressInfo.setReady(true);
                  }

                  new ArrayList();
                  HashMap<String, TCoreFieldSensitiveMemory> ha = new HashMap();
                  if (aifind.equals("1")) {
                     Object obj = this.redisService.get(tableName + "+" + schema);
                     List<TCoreFieldSensitiveMemory> tCoreFieldSensitiveMemorylist = (List)obj;
                     if (tCoreFieldSensitiveMemorylist.size() > 0) {
                        for(TCoreFieldSensitiveMemory tCoreFieldSensitiveMemory : tCoreFieldSensitiveMemorylist) {
                           ha.put(tCoreFieldSensitiveMemory.getId(), tCoreFieldSensitiveMemory);
                        }
                     }
                  }

                  String queryTableDataSqlTemp = "";
                  String columnSurroundCharacterLeft = XmlTool.getFileValue(dbType + "/db-columnSurroundCharacterLeft");
                  String columnSurroundCharacterRight = XmlTool.getFileValue(dbType + "/db-columnSurroundCharacterRight");
                  List<ColumnInfo> columnamelist = JdbcTool.getAllColumnInfo(connection, schema, tableName);
                  String columnameliststr = "";
                  StringBuffer sb = new StringBuffer();
                  List<String> querencolumnname = new ArrayList();

                  for(int i = 0; i < columnamelist.size(); ++i) {
                     ColumnInfo temp = (ColumnInfo)columnamelist.get(i);
                     if (aifind.equals("1")) {
                        if (ha.get(schema + tableName + temp.getColumnname()) != null) {
                           querencolumnname.add(temp.getColumnname());
                           ++queren;
                        } else {
                           if (temp.getTypename().equalsIgnoreCase("sql_variant")) {
                              sb.append("convert(varchar(100), SERVERPROPERTY('" + temp.getColumnname() + "')) as " + columnSurroundCharacterLeft + temp.getColumnname() + columnSurroundCharacterRight);
                           } else {
                              sb.append(columnSurroundCharacterLeft + temp.getColumnname() + columnSurroundCharacterRight);
                           }

                           sb.append(",");
                        }
                     } else {
                        if (temp.getTypename().equalsIgnoreCase("sql_variant")) {
                           sb.append("convert(varchar(100), SERVERPROPERTY('" + temp.getColumnname() + "')) as " + columnSurroundCharacterLeft + temp.getColumnname() + columnSurroundCharacterRight);
                        } else {
                           sb.append(columnSurroundCharacterLeft + temp.getColumnname() + columnSurroundCharacterRight);
                        }

                        sb.append(",");
                     }
                  }

                  columnameliststr = sb.toString();
                  if (columnameliststr.length() > 0) {
                     columnameliststr = sb.toString().substring(0, sb.toString().length() - 1);
                  } else if (aifind.equals("1")) {
                     columnameliststr = "1";
                  } else {
                     columnameliststr = "*";
                  }

                  if (columnameliststr.equals("1")) {
                     queryTableDataSql = this.getQuerySql("1", dbType, schema, 1L, num);
                  }

                  queryTableDataSqlTemp = MessageFormat.format(queryTableDataSql, tableName, columnameliststr);
                  PreparedStatement tableDataStatement = null;
                  ResultSet tableDataResultSet = null;

                  try {
                     tableDataStatement = connection.prepareStatement(queryTableDataSqlTemp);
                     progressInfo.setCurrentState("查询表数据");
                     timeLogList.add(tableName);
                     timeLogList.add("查询表数据开始：" + System.currentTimeMillis());
                     tableDataResultSet = tableDataStatement.executeQuery();
                     timeLogList.add("查询表数据结束：" + System.currentTimeMillis());
                  } catch (Exception var65) {
                     ++queryTableDataErrorCount;
                     Connection oldConnection = connection;
                     connection = JdbcTool.getConnection(datasystem);

                     try {
                        oldConnection.close();
                     } catch (Exception var64) {
                     }

                     try {
                        tableDataStatement.close();
                     } catch (Exception var63) {
                     }
                  }

                  if (tableDataResultSet != null) {
                     List<SensitiveColumn> sensitiveColumns = new ArrayList();
                     if (aifind.equals("0")) {
                        sensitiveColumns = this.getSensitiveColumnsByContent(datasystem.getId(), datasystem.getSysname(), schema, tableDataResultSet, tableName, rate, searchRegexList, patternList, progressInfo, timeLogList, currdic, floatdic);
                     } else if (!columnameliststr.equals("1")) {
                        sensitiveColumns = this.getSensitiveColumnsByContent(datasystem.getId(), datasystem.getSysname(), schema, tableDataResultSet, tableName, rate, searchRegexList, patternList, progressInfo, timeLogList, currdic, floatdic);
                     }

                     for(String columnname : querencolumnname) {
                        String keyid = schema + tableName + columnname;
                        SensitiveColumn sen = new SensitiveColumn();
                        sen.setColumnName(columnname);
                        sen.setDatasourceid(datasystem.getId());
                        sen.setDatasourcename(datasystem.getSysname());
                        sen.setDistinctCount(0L);
                        sen.setMatchCount(0L);
                        sen.setMatchCount(0L);
                        sen.setRegexType(((TCoreFieldSensitiveMemory)ha.get(keyid)).getRegextype());
                        sen.setRuleName(((TCoreFieldSensitiveMemory)ha.get(keyid)).getRuie());
                        sen.setRuleId(((TCoreFieldSensitiveMemory)ha.get(keyid)).getRuleid());
                        sen.setRegexName(((TCoreFieldSensitiveMemory)ha.get(keyid)).getRegextype());
                        sen.setSchema(schema);
                        sen.setSensitiveColumn(true);
                        sen.setTableName(tableName);
                        sen.setTotalCount(0L);
                        sen.setValidCount(0L);
                        sen.setIsIntelligent("1");
                        sensitiveColumns.add(sen);
                     }

                     if (sensitiveColumns.size() > 0) {
                        tableColumns.put(schema + "#_#" + tableName, sensitiveColumns);
                     }
                  }

                  try {
                     tableDataStatement.close();
                  } catch (Exception var62) {
                  }

                  ++tableIndex;
               }
            } catch (Exception e) {
               ++otherErrorCount;
               e.printStackTrace();
            }

            ++schemaIndex;
         }
      }

      try {
         connection.close();
      } catch (Exception var61) {
      }

      return tableColumns;
   }

   public Map<String, List<SensitiveColumn>> getAlldmpTableColumnsByContent(String multiDempFile, int queren, String samplingtype, String aifind, TCoreDatasystem datasystem, List<String> schemas, long maxRowCount, double rate, List<TConsoleSearchregex> searchRegexList, ProgressInfo progressInfo, String datasystemid, String dmptype) {
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (IOException e) {
         e.printStackTrace();
      }

      String num = props.getProperty("random");
      List<String> timeLogList = new ArrayList();
      timeLogList.add("敏感字段查询开始：" + System.currentTimeMillis());
      new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      String chagneLineString = "\r\n";
      new ArrayList();
      new ArrayList();
      int queryTableDataErrorCount = 0;
      int queryTableDataAgainErrorCount = 0;
      int otherErrorCount = 0;
      List<String> allTableList = new ArrayList();
      new ArrayList();
      List<String> dmpfiledirlist = new ArrayList();
      Map<String, List<SensitiveColumn>> tableColumns = new HashMap();
      String selectDataType = samplingtype;
      String dbType = datasystem.getDbtype();
      long schemaIndex = 1L;
      progressInfo.setSchemaCount((long)schemas.size());
      HashMap<String, List<String>> hash = new HashMap();
      List<String> schemaslist = new ArrayList();
      String fileSuffix = "";
      List<String> floatdic = this.tConsoleDictionaryDao.queryValueByTypeCode("19");
      if ("0".equals(multiDempFile)) {
         for(String schema : schemas) {
            List<String> table = new ArrayList();
            String[] s = schema.split("~");
            String a = s[0].substring(0, s[0].lastIndexOf("."));
            fileSuffix = s[0].substring(s[0].lastIndexOf("."));
            String b = s[1];
            if (hash.get(a) == null) {
               table.add(b);
               hash.put(a, table);
               schemaslist.add(a);
            } else {
               table = (List)hash.get(a);
               table.add(b);
               hash.put(a, table);
            }
         }
      } else {
         for(String schema : schemas) {
            List<String> tableNameList = new ArrayList();
            String[] schemaArr = schema.split("~");
            String[] filelistdir = schemaArr[0].split("[+]");
            String dmpKey = "";
            dmpfiledirlist = new ArrayList();

            for(String filedir : filelistdir) {
               dmpKey = filedir.substring(0, filedir.lastIndexOf("."));
               fileSuffix = filedir.substring(filedir.lastIndexOf("."));
               dmpfiledirlist.add(dmpKey + fileSuffix);
            }

            if (!hash.containsKey(dmpKey)) {
               tableNameList.add(schemaArr[1]);
               hash.put(dmpKey, tableNameList);
               schemaslist.add(dmpKey);
            } else {
               tableNameList = (List)hash.get(dmpKey);
               tableNameList.add(schemaArr[1]);
               hash.put(dmpKey, tableNameList);
            }
         }
      }

      progressInfo.setSchemaCount((long)schemaslist.size());

      for(String schema : schemaslist) {
         String tableInfo = null;
         progressInfo.setCurrentState("notReady");
         progressInfo.setCurrentSchema(schemaIndex);
         progressInfo.setCurrentSchemaName(schema.substring(schema.lastIndexOf("/") + 1));
         new ArrayList();
         List<String> var78 = (List)hash.get(schema);
         if (var78.size() == 0) {
            if (schemaIndex == 1L) {
               progressInfo.setReady(true);
            }

            progressInfo.setTotalCount(0L);
            progressInfo.setCurrent(0L);
            progressInfo.setCurrentState("ready");
            ++schemaIndex;
         } else {
            allTableList.addAll(var78);
            progressInfo.setTotalCount((long)var78.size());
            progressInfo.setCurrentState("ready");
            this.getQuerySql(selectDataType, dbType, schema, maxRowCount, "");
            List<Pattern> patternList = new ArrayList();

            for(TConsoleSearchregex searchRegex : searchRegexList) {
               patternList.add(Pattern.compile(searchRegex.getRegex()));
            }

            try {
               long tableIndex = 1L;
               List<TCoreCurrencyInfo> tableInfoL = this.tCoreCurrencyInfoDao.getCurrencyInfoTable(datasystem.getSysname(), schema);
               if (tableInfoL.size() > 0) {
                  tableInfo = ((TCoreCurrencyInfo)tableInfoL.get(0)).getCurrencytable();
               }

               List<String> currdic = this.tConsoleDictionaryDao.queryValueByTypeCode("18");
               Map<String, List<List<Object>>> noaifindValuesMapList = null;
               Map<String, List<ColumnInfoVO>> columnameVoMapList = null;
               Map<String, Object> tableInfoMap = null;
               if ("0".equals(dmptype)) {
                  if ("1".equals(multiDempFile)) {
                     String redisTaskKey = "";

                     for(int i = 0; i < dmpfiledirlist.size(); ++i) {
                        if (i > 0) {
                           redisTaskKey = redisTaskKey + ",";
                        }

                        redisTaskKey = redisTaskKey + (String)dmpfiledirlist.get(i);
                     }

                     tableInfoMap = (Map)this.redisService.get(redisTaskKey + "multiDmpdp_tableInfoMap");
                     List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");
                     columnameVoMapList = new HashMap();

                     for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                        TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
                        columnameVoMapList.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
                     }

                     noaifindValuesMapList = MultipleDmpDpTool.prasingDataByTableNameByRowNum(dmpfiledirlist, tableInfoMap, var78, maxRowCount);
                  } else {
                     tableInfoMap = (Map)this.redisService.get(schema + fileSuffix + "Dmpdp_tableInfoMap");
                     List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");
                     columnameVoMapList = new HashMap();

                     for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                        TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
                        columnameVoMapList.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
                     }

                     noaifindValuesMapList = DmpDpTool.prasingDataByTableNameByRowNum(schema + fileSuffix, tableInfoMap, var78, maxRowCount);
                  }
               } else if ("1".equals(multiDempFile)) {
                  String redisTaskKey = "";

                  for(int i = 0; i < dmpfiledirlist.size(); ++i) {
                     if (i > 0) {
                        redisTaskKey = redisTaskKey + ",";
                     }

                     redisTaskKey = redisTaskKey + (String)dmpfiledirlist.get(i);
                  }

                  tableInfoMap = (Map)this.redisService.get(redisTaskKey + "multiDmp_tableInfoMap");
                  List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");
                  columnameVoMapList = new HashMap();

                  for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                     TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
                     columnameVoMapList.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
                  }

                  noaifindValuesMapList = MultipleDmpTool.prasingDataByTableNameByRowNum(dmpfiledirlist, tableInfoMap, var78, maxRowCount);
               } else {
                  tableInfoMap = (Map)this.redisService.get(schema + fileSuffix + "Dmp_tableInfoMap");
                  List<TableStructureInfo> tableStructureInfoList = (List)tableInfoMap.get("tableStructureInfoList");
                  columnameVoMapList = new HashMap();

                  for(int i = 0; i < tableStructureInfoList.size(); ++i) {
                     TableStructureInfo tableStructureInfo = (TableStructureInfo)tableStructureInfoList.get(i);
                     columnameVoMapList.put(tableStructureInfo.getTablename(), tableStructureInfo.getColInfoLst());
                  }

                  noaifindValuesMapList = DmpTool.prasingDataByTableNameByRowNum(schema + fileSuffix, tableInfoMap, var78, maxRowCount);
               }

               for(String tableName : var78) {
                  progressInfo.setCurrent(tableIndex);
                  progressInfo.setCurrentTable(tableName);
                  if (schemaIndex == 1L && tableIndex == 1L) {
                     progressInfo.setReady(true);
                  }

                  new ArrayList();
                  HashMap<String, TCoreFieldSensitiveMemory> ha = new HashMap();
                  if (aifind.equals("1")) {
                     Object obj = this.redisService.get(tableName + "+" + schema.substring(schema.lastIndexOf("/") + 1));
                     List<TCoreFieldSensitiveMemory> var103 = (List)obj;
                     if (var103.size() > 0) {
                        for(TCoreFieldSensitiveMemory tCoreFieldSensitiveMemory : var103) {
                           ha.put(tCoreFieldSensitiveMemory.getId(), tCoreFieldSensitiveMemory);
                        }
                     }
                  }

                  List<ColumnInfoVO> columnameVolist;
                  if ("0".equals(dmptype)) {
                     if ("0".equals(multiDempFile)) {
                        columnameVolist = (List)columnameVoMapList.get(tableName);
                     } else {
                        columnameVolist = (List)columnameVoMapList.get(tableName);
                     }
                  } else if ("0".equals(multiDempFile)) {
                     columnameVolist = (List)columnameVoMapList.get(tableName);
                  } else {
                     columnameVolist = (List)columnameVoMapList.get(tableName);
                  }

                  String columnameliststr = "";
                  StringBuffer sb = new StringBuffer();
                  List<String> querencolumnname = new ArrayList();
                  List<String> noquerencolumnname = new ArrayList();

                  for(int i = 0; i < columnameVolist.size(); ++i) {
                     ColumnInfo temp = (ColumnInfo)columnameVolist.get(i);
                     if (aifind.equals("1")) {
                        if (ha.get(schema + tableName + temp.getColumnname()) != null) {
                           querencolumnname.add(temp.getColumnname());
                           ++queren;
                        } else {
                           noquerencolumnname.add(temp.getColumnname());
                        }
                     }
                  }

                  columnameliststr = sb.toString();
                  if (columnameliststr.length() > 0) {
                     columnameliststr = sb.toString().substring(0, sb.toString().length() - 1);
                  } else if (aifind.equals("1")) {
                     columnameliststr = "1";
                  } else {
                     columnameliststr = "*";
                  }

                  if (columnameliststr.equals("1")) {
                     this.getQuerySql("1", dbType, schema, 1L, num);
                  }

                  List<List<Object>> noaifindValueslist = null;
                  List<List<Object>> aifindValueslist = null;
                  if ("0".equals(dmptype)) {
                     if ("0".equals(multiDempFile)) {
                        noaifindValueslist = (List)noaifindValuesMapList.get(tableName);
                        if ("1".equals(aifind)) {
                           aifindValueslist = DmpDpTool.prasingNotConfirmDataByTableNameByRowNum(schema + fileSuffix, tableName, tableInfoMap, maxRowCount, noquerencolumnname);
                        }
                     } else {
                        if ("1".equals(aifind)) {
                           aifindValueslist = MultipleDmpDpTool.prasingNotConfirmDataByTableNameByRowNum(dmpfiledirlist, tableName, maxRowCount, noquerencolumnname, tableInfoMap);
                        }

                        noaifindValueslist = (List)noaifindValuesMapList.get(tableName);
                     }
                  } else if ("0".equals(multiDempFile)) {
                     noaifindValueslist = (List)noaifindValuesMapList.get(tableName);
                     if ("1".equals(aifind)) {
                        aifindValueslist = DmpTool.prasingNotConfirmDataByTableNameByRowNum(schema + fileSuffix, tableName, tableInfoMap, maxRowCount, noquerencolumnname);
                     }
                  } else {
                     noaifindValueslist = (List)noaifindValuesMapList.get(tableName);
                     if ("1".equals(aifind)) {
                        aifindValueslist = MultipleDmpTool.prasingNotConfirmDataByTableNameByRowNum(dmpfiledirlist, tableName, maxRowCount, noquerencolumnname, tableInfoMap);
                     }
                  }

                  List<ColumnInfoVO> aifindcolumnameVolist = columnameVolist;
                  if (querencolumnname.size() > 0) {
                     for(int j = 0; j < columnameVolist.size(); ++j) {
                        for(int i = 0; i < querencolumnname.size(); ++i) {
                           if (((String)querencolumnname.get(i)).equals(((ColumnInfoVO)columnameVolist.get(j)).getColumnname())) {
                              aifindcolumnameVolist.remove(j);
                           }
                        }
                     }
                  }

                  if (noaifindValueslist != null) {
                     List<SensitiveColumn> sensitiveColumns = new ArrayList();
                     if (aifind.equals("0")) {
                        sensitiveColumns = this.getSensitivedmpColumnsByContent(datasystem.getId(), datasystem.getSysname(), schema, columnameVolist, noaifindValueslist, tableName, rate, searchRegexList, patternList, progressInfo, timeLogList, currdic, floatdic);
                     } else if (noquerencolumnname.size() > 0) {
                        sensitiveColumns = this.getSensitivedmpColumnsByContent(datasystem.getId(), datasystem.getSysname(), schema, aifindcolumnameVolist, aifindValueslist, tableName, rate, searchRegexList, patternList, progressInfo, timeLogList, currdic, floatdic);
                     }

                     for(String columnname : querencolumnname) {
                        String keyid = schema + tableName + columnname;
                        SensitiveColumn sen = new SensitiveColumn();
                        sen.setColumnName(columnname);
                        sen.setDatasourceid(datasystem.getId());
                        sen.setDatasourcename(datasystem.getSysname());
                        sen.setDistinctCount(0L);
                        sen.setMatchCount(0L);
                        sen.setMatchCount(0L);
                        sen.setRegexType(((TCoreFieldSensitiveMemory)ha.get(keyid)).getRegextype());
                        sen.setRuleName(((TCoreFieldSensitiveMemory)ha.get(keyid)).getRuie());
                        sen.setRuleId(((TCoreFieldSensitiveMemory)ha.get(keyid)).getRuleid());
                        sen.setRegexName(((TCoreFieldSensitiveMemory)ha.get(keyid)).getRegextype());
                        sen.setSchema(schema.substring(schema.lastIndexOf("/") + 1));
                        sen.setSensitiveColumn(true);
                        sen.setTableName(tableName);
                        sen.setTotalCount(0L);
                        sen.setValidCount(0L);
                        sen.setIsIntelligent("1");
                        sensitiveColumns.add(sen);
                     }

                     if (sensitiveColumns.size() > 0) {
                        tableColumns.put(schema + "#_#" + tableName, sensitiveColumns);
                     }
                  }

                  ++tableIndex;
               }
            } catch (Exception e) {
               ++otherErrorCount;
               e.printStackTrace();
            }

            ++schemaIndex;
         }
      }

      return tableColumns;
   }

   public Map<String, List<SensitiveColumn>> getAllFileColumnsByContent(String jiegou, TCoreDatasystem datasystem, List<String> filepath, long maxRowCount, double rate, List<TConsoleSearchregex> searchRegexList, ProgressInfo progressInfo) {
      List<String> timeLogList = new ArrayList();
      timeLogList.add("敏感字段查询开始：" + System.currentTimeMillis());
      new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
      String chagneLineString = "\r\n";
      new ArrayList();
      new ArrayList();
      int queryTableDataErrorCount = 0;
      int queryTableDataAgainErrorCount = 0;
      int otherErrorCount = 0;
      List<String> allTableList = new ArrayList();
      Map<String, List<SensitiveColumn>> tableColumns = new HashMap();
      TCoreFileStructure sy = (TCoreFileStructure)this.tCoreFileStructureDao.get(jiegou);
      List<TCoreFileStructurecolumn> list = this.tCoreFileStructurecolumnDao.queryAll("columnindex", true, new Criterion[]{Restrictions.eq("filestructureid", jiegou)});
      List<String> widthname = new ArrayList();
      List<String> tablehname = new ArrayList();

      for(TCoreFileStructurecolumn tCoreFileStructurecolumn : list) {
         widthname.add(tCoreFileStructurecolumn.getColumnaccuracy());
         tablehname.add(tCoreFileStructurecolumn.getColumnname());
      }

      boolean selectDataRandom = false;
      String dbType = datasystem.getDbtype();
      SFTPUtil sftp = null;
      switch (dbType) {
         case "FTP":
            try {
               filepath = FtpTool.list(datasystem.getDbip(), Integer.parseInt(datasystem.getDbport()), datasystem.getUsername(), datasystem.getPassword(), datasystem.getLocaldir(), "");
            } catch (NumberFormatException e1) {
               e1.printStackTrace();
            } catch (Exception e1) {
               e1.printStackTrace();
            }
            break;
         case "SFTP":
            sftp = new SFTPUtil(datasystem.getUsername(), datasystem.getPassword(), datasystem.getDbip(), Integer.parseInt(datasystem.getDbport()));

            try {
               SFTPUtil.login();
               filepath = sftp.list(datasystem.getLocaldir());
            } catch (SftpException e1) {
               e1.printStackTrace();
            }
      }

      if (((String)filepath.get(0)).equals(",")) {
         filepath.remove(0);
      }

      String code = datasystem.getPagecode();
      long schemaIndex = 1L;
      progressInfo.setSchemaCount((long)filepath.size());

      for(String schema : filepath) {
         progressInfo.setCurrentState("notReady");
         progressInfo.setCurrentSchema(schemaIndex);
         progressInfo.setCurrentSchemaName(datasystem.getLocaldir());
         List<String> allFileListOfSchema = new ArrayList();
         allFileListOfSchema.add(schema);
         if (allFileListOfSchema.size() == 0) {
            if (schemaIndex == 1L) {
               progressInfo.setReady(true);
            }

            progressInfo.setTotalCount(0L);
            progressInfo.setCurrent(0L);
            progressInfo.setCurrentState("ready");
            ++schemaIndex;
         }

         allTableList.addAll(allFileListOfSchema);
         progressInfo.setTotalCount((long)allFileListOfSchema.size());
         progressInfo.setCurrentState("ready");
         List<Pattern> patternList = new ArrayList();

         for(TConsoleSearchregex searchRegex : searchRegexList) {
            patternList.add(Pattern.compile(searchRegex.getRegex()));
         }

         try {
            long tableIndex = 1L;

            for(String fileName : allFileListOfSchema) {
               progressInfo.setCurrent(tableIndex);
               progressInfo.setCurrentTable(fileName);
               if (schemaIndex == 1L && tableIndex == 1L) {
                  progressInfo.setReady(true);
               }

               new HashMap();

               try {
                  progressInfo.setCurrentState("查询表数据");
                  TCoreFileStructurespliter tCoreFileStructurespliter = (TCoreFileStructurespliter)this.tCoreFileStructurespliterDao.queryUnique(new Criterion[]{Restrictions.eq("filestructureid", jiegou)});
                  List<TCoreFileStructurecolumn> tCoreFileStructurecolumn = this.tCoreFileStructurecolumnDao.queryAll(new Criterion[]{Restrictions.eq("filestructureid", jiegou)});
                  Map wjlist;
                  if (sy.getSplitertype().equals("0")) {
                     switch (dbType) {
                        case "FTP":
                           wjlist = FileTool.getFTPFileDataBySpliter(datasystem.getDbip(), Integer.parseInt(datasystem.getDbport()), datasystem.getUsername(), datasystem.getPassword(), datasystem.getLocaldir(), schema, (new Long(maxRowCount)).intValue(), tCoreFileStructurespliter.getDelimiters(), tCoreFileStructurespliter.getQuotecharacter(), code, tCoreFileStructurecolumn.size());
                           break;
                        case "SFTP":
                           wjlist = FileTool.getSFTPFileDataBySpliter(sftp, datasystem.getLocaldir(), schema, (new Long(maxRowCount)).intValue(), tCoreFileStructurespliter.getDelimiters(), code, tCoreFileStructurecolumn.size());
                           break;
                        default:
                           wjlist = FileTool.getFileDataBySpliter(fileName, (new Long(maxRowCount)).intValue(), tCoreFileStructurespliter.getDelimiters(), tCoreFileStructurespliter.getQuotecharacter(), code, tCoreFileStructurecolumn.size());
                     }
                  } else {
                     switch (dbType) {
                        case "FTP":
                           wjlist = FileTool.getFTPFileDataByWidth(datasystem.getDbip(), Integer.parseInt(datasystem.getDbport()), datasystem.getUsername(), datasystem.getPassword(), datasystem.getLocaldir(), schema, (new Long(maxRowCount)).intValue(), widthname, code);
                           break;
                        case "SFTP":
                           wjlist = FileTool.getSFTPFileDataByWidth(sftp, datasystem.getLocaldir(), schema, (new Long(maxRowCount)).intValue(), widthname, code);
                           break;
                        default:
                           wjlist = FileTool.getFileDataByWidth(fileName, (new Long(maxRowCount)).intValue(), widthname, code);
                     }
                  }

                  List<SensitiveColumn> sensitiveColumns = this.getFileSensitiveColumnsByContent(tablehname, datasystem.getId(), datasystem.getSysname(), datasystem.getLocaldir(), wjlist, fileName, rate, searchRegexList, patternList, progressInfo, timeLogList, tCoreFileStructurespliter.getQuotecharacter());
                  if (sensitiveColumns.size() > 0) {
                     tableColumns.put(fileName, sensitiveColumns);
                  }
               } catch (Exception var43) {
               }

               ++tableIndex;
            }
         } catch (Exception e) {
            ++otherErrorCount;
            e.printStackTrace();
         }

         ++schemaIndex;
      }

      if (sftp != null) {
         sftp.logout();
      }

      return tableColumns;
   }

   public SensitiveColumn getSensitiveColumnByName(String datasourceid, String datasourcename, String schema, String tableName, String columnName, List<TConsoleSearchregex> searchRegexList, List<Pattern> patternList) {
      SensitiveColumn column = new SensitiveColumn(datasourceid, datasourcename, schema, tableName, columnName);
      int index = 0;

      for(Pattern pattern : patternList) {
         if (pattern.matcher(column.getColumnName()).matches()) {
            TConsoleSearchregex searchRegex = (TConsoleSearchregex)searchRegexList.get(index);
            column.setMatchResult(searchRegex.getType(), searchRegex.getName());
            break;
         }

         ++index;
      }

      return column;
   }

   public List<String> getColumnsOfSchema(Connection connection, String dbType, String tableName, String schema) {
      List<String> columnNames = new ArrayList();

      try {
         ResultSet allColumnsResultSet = connection.getMetaData().getColumns((String)null, schema, tableName, "%");

         while(allColumnsResultSet.next()) {
            String columnName = allColumnsResultSet.getString("COLUMN_NAME");
            if (!columnNames.contains(columnName)) {
               columnNames.add(columnName);
            }
         }

         allColumnsResultSet.close();
      } catch (Exception e) {
         e.printStackTrace();
      }

      return columnNames;
   }

   public List<SensitiveColumn> getSensitiveColumnsByContent(String datasourceid, String datasourcename, String schema, ResultSet resultSet, String tableName, double rate, List<TConsoleSearchregex> searchRegexList, List<Pattern> patternList, ProgressInfo progressInfo, List<String> timeLogList, List<String> currdic, List<String> floatdic) {
      List<SensitiveColumn> sensitiveColumns = new ArrayList();
      new ArrayList();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (Exception var76) {
      }

      boolean ischarsetflag = false;
      String ischarset_s = "";
      String ischarset_t = "";
      if (datasourceid != null) {
         TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(datasourceid);
         if (tCoreDatasystem != null) {
            String ischarset = tCoreDatasystem.getIscharset();
            if (ischarset != null && !"".equals(ischarset) && ischarset.split(",").length == 2) {
               ischarsetflag = true;
               ischarset_s = ischarset.split(",")[0];
               ischarset_t = ischarset.split(",")[1];
            }
         }
      }

      String isrepeatvalue = props.get("isrepeatvalue").toString();

      Object var83;
      try {
         Map<Integer, List<String>> columnValueMap = new HashMap();
         Map<Integer, Set<String>> columnDistinctValueMap = new HashMap();
         ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
         int columnCount = resultSetMetaData.getColumnCount();
         long rowCount = 0L;
         long[] nullOrEmptyCount = new long[columnCount];
         int matchCurrencyCount = 0;
         boolean isMatchCurrency = false;
         progressInfo.setCurrentState("提取数据");
         timeLogList.add("提取表数据开始：" + System.currentTimeMillis());

         while(resultSet.next()) {
            for(int i = 0; i < columnCount; ++i) {
               if (rowCount == 0L) {
                  columnValueMap.put(i, new ArrayList());
                  columnDistinctValueMap.put(i, new HashSet());
               }

               Object columnValueObj = null;
               if (resultSetMetaData.getColumnType(i + 1) == 2009) {
                  System.out.println("表名：" + tableName);
                  System.out.println("不支持的列：" + resultSetMetaData.getColumnName(i + 1));
               } else {
                  try {
                     columnValueObj = resultSet.getObject(i + 1);
                     if (resultSetMetaData.getScale(i + 1) > 0) {
                        String fmt = "";

                        for(int j = 0; j < resultSetMetaData.getScale(i + 1); ++j) {
                           fmt = fmt + "0";
                        }

                        DecimalFormat df = new DecimalFormat("0." + fmt);
                        columnValueObj = df.format(columnValueObj);
                     }
                  } catch (Exception var77) {
                     columnValueObj = null;
                  }
               }

               if (columnValueObj != null) {
                  String columnValue = columnValueObj.toString();
                  if (columnValueObj instanceof byte[]) {
                     columnValue = "";
                  }

                  if (ischarsetflag) {
                     columnValue = new String(columnValue.getBytes(ischarset_s), ischarset_t);
                     System.out.println(columnValue);
                  }

                  if (!"".equals(columnValue.trim())) {
                     ((List)columnValueMap.get(i)).add(columnValue);
                     ((Set)columnDistinctValueMap.get(i)).add(columnValue);
                  } else {
                     int var10002 = (int) nullOrEmptyCount[i]++;
                  }
               } else {
                  int var108 = (int) nullOrEmptyCount[i]++;
               }
            }

            ++rowCount;
         }

         timeLogList.add("提取表数据结束：" + System.currentTimeMillis());
         if (rowCount != 0L) {
            timeLogList.add("匹配表数据开始：" + System.currentTimeMillis());
            progressInfo.setCurrentState("匹配数据");

            for(int i = 0; i < columnCount; ++i) {
               String columnname = resultSetMetaData.getColumnName(i + 1);
               long validCount = rowCount - nullOrEmptyCount[i];
               double distinctCount = (double)((Set)columnDistinctValueMap.get(i)).size();
               SensitiveColumn column = new SensitiveColumn(datasourceid, datasourcename, schema, tableName, columnname, rowCount, validCount, (long)distinctCount);
               sensitiveColumns.add(column);
               List<String> columnValues = (List)columnValueMap.get(i);
               if (null != columnValues && columnValues.size() != 0) {
                  long maxMatchCount = 0L;
                  List<String> maxMatchValues = null;
                  List<String> maxNotMathValues = null;
                  int patternIndex = 0;

                  for(Pattern pattern : patternList) {
                     TConsoleSearchregex searchRegex = (TConsoleSearchregex)searchRegexList.get(patternIndex++);
                     String regexType = searchRegex.getType();
                     String regexName = searchRegex.getName();
                     int level = 0;
                     long matchCount = 0L;
                     long nomatchCount = 0L;
                     List<String> tempMatchValues = new ArrayList();
                     List<String> matchValues = new ArrayList();
                     Set<String> matchValueSet = new HashSet();
                     List<String> notMatchValues = new ArrayList();
                     Map<String, Integer> namerepeatmap = new HashMap();
                     if (pattern.pattern().startsWith("MethodName:")) {
                        String methodName = pattern.pattern().substring(11);
                        int maxLength = -1;
                        if (methodName.contains("MaxLength:")) {
                           if (methodName.contains("Weight:")) {
                              String[] parameters = methodName.split("\\|MaxLength:");
                              if (parameters.length == 2) {
                                 methodName = parameters[0];
                                 String[] Weight = parameters[1].split("\\|Weight:");
                                 maxLength = Integer.parseInt(Weight[0]);

                                 try {
                                    level = Integer.parseInt(Weight[1]);
                                 } catch (Exception var75) {
                                    level = 0;
                                 }
                              }
                           } else {
                              String[] parameters = methodName.split("\\|MaxLength:");
                              if (parameters.length == 2) {
                                 methodName = parameters[0];
                                 maxLength = Integer.parseInt(parameters[1]);
                              }
                           }
                        }

                        if (methodName.contains("isCurrency")) {
                           for(String val : columnValues) {
                              if (this.FloatCol(val)) {
                                 ++matchCount;
                                 matchValues.add(val);
                                 tempMatchValues.add(regexType + ":" + val);
                                 matchValueSet.add(val);
                              } else {
                                 ++nomatchCount;
                                 notMatchValues.add(val);
                              }

                              if (this.isCurrency(val, currdic)) {
                                 ++matchCurrencyCount;
                              }
                           }
                        } else {
                           for(String val : columnValues) {
                              if (this.matches(methodName, maxLength, val, level)) {
                                 ++matchCount;
                                 matchValues.add(val);
                                 if ("姓名".equals(regexType)) {
                                    Integer integer = (Integer)namerepeatmap.get(val);
                                    namerepeatmap.put(val, integer == null ? 1 : integer + 1);
                                 }

                                 tempMatchValues.add(regexType + ":" + val);
                                 matchValueSet.add(val);
                              } else {
                                 ++nomatchCount;
                                 notMatchValues.add(val);
                              }
                           }
                        }
                     } else {
                        for(String val : columnValues) {
                           if (pattern.matcher(val).matches()) {
                              ++matchCount;
                              matchValues.add(val);
                              if ("姓名".equals(regexType)) {
                                 Integer integer = (Integer)namerepeatmap.get(val);
                                 namerepeatmap.put(val, integer == null ? 1 : integer + 1);
                              }

                              tempMatchValues.add(regexType + ":" + val);
                              matchValueSet.add(val);
                           } else {
                              ++nomatchCount;
                              notMatchValues.add(val);
                           }
                        }
                     }

                     boolean isrepeatdata = true;
                     if ("姓名".equals(regexType)) {
                        Integer matchValuessize = (int)((double)matchValues.size() * Double.parseDouble(isrepeatvalue));

                        for(Map.Entry<String, Integer> entry : namerepeatmap.entrySet()) {
                           if ((Integer)entry.getValue() > matchValuessize) {
                              isrepeatdata = false;
                              break;
                           }
                        }
                     }

                     if (matchCurrencyCount - columnValues.size() == 0) {
                        isMatchCurrency = true;
                        matchCurrencyCount = 0;
                     }

                     if ((double)matchCount / (double)columnValues.size() * (double)100.0F >= rate) {
                        if (isrepeatdata) {
                           column.setMatchResult(regexType, regexName, (long)matchValues.size(), matchValues, notMatchValues);
                        }

                        String key = schema + "_m" + tableName + "_m" + columnname;
                        HashMap<String, List<String>> keyhash = new HashMap();
                        List<String> matchValuesList = new ArrayList();
                        List<String> notMatchValuesList = new ArrayList();
                        if (matchValues.size() > 100) {
                           matchValuesList.addAll(matchValues.subList(0, 100));
                        } else if (matchValues.size() != 0) {
                           matchValuesList.addAll(matchValues.subList(0, matchValues.size()));
                        }

                        if (notMatchValues.size() > 100) {
                           notMatchValuesList.addAll(notMatchValues.subList(0, 100));
                        } else if (notMatchValues.size() != 0) {
                           notMatchValuesList.addAll(notMatchValues.subList(0, notMatchValues.size()));
                        }

                        keyhash.put("matchValues", matchValuesList);
                        keyhash.put("notMatchValues", notMatchValuesList);
                        this.redisService.set(key, keyhash);
                        break;
                     }

                     if (maxMatchCount < matchCount) {
                        maxMatchCount = matchCount;
                        maxMatchValues = tempMatchValues;
                        maxNotMathValues = notMatchValues;
                     }
                  }

                  if (!column.isSensitiveColumn()) {
                     if (maxMatchCount > 0L) {
                        column.setMatchCount(maxMatchCount);
                        column.setMatchValues(maxMatchValues);
                        column.setNotMatchValues(maxNotMathValues);
                     } else {
                        column.setNotMatchValues(columnValues);
                     }
                  }
               }
            }

            if (!isMatchCurrency) {
               for(int i = 0; i < sensitiveColumns.size(); ++i) {
                  if ("价格".equals(((SensitiveColumn)sensitiveColumns.get(i)).getRegexName())) {
                     ((SensitiveColumn)sensitiveColumns.get(i)).setRegexName((String)null);
                     ((SensitiveColumn)sensitiveColumns.get(i)).setRegexType((String)null);
                     ((SensitiveColumn)sensitiveColumns.get(i)).setMatchCount(0L);
                     ((SensitiveColumn)sensitiveColumns.get(i)).setMatchValues((List)null);
                     ((SensitiveColumn)sensitiveColumns.get(i)).setNotMatchValues((List)null);
                  }
               }
            }

            timeLogList.add("匹配表数据结束：" + System.currentTimeMillis());
            return sensitiveColumns;
         }

         for(int i = 0; i < columnCount; ++i) {
            String columnname = resultSetMetaData.getColumnName(i + 1);
            sensitiveColumns.add(new SensitiveColumn(datasourceid, datasourcename, schema, tableName, columnname, rowCount, 0L, 0L));
         }

         var83 = sensitiveColumns;
      } catch (Exception e) {
         e.printStackTrace();
         return sensitiveColumns;
      } finally {
         try {
            resultSet.close();
         } catch (Exception e1) {
            e1.printStackTrace();
         }

      }

      return (List<SensitiveColumn>)var83;
   }

   public List<SensitiveColumn> getSensitivedmpColumnsByContent(String datasourceid, String datasourcename, String schema, List<ColumnInfoVO> columnameVolist, List<List<Object>> ObjectValueslist, String tableName, double rate, List<TConsoleSearchregex> searchRegexList, List<Pattern> patternList, ProgressInfo progressInfo, List<String> timeLogList, List<String> currdic, List<String> floatdic) {
      List<SensitiveColumn> sensitiveColumns = new ArrayList();
      new ArrayList();
      Properties props = new Properties();

      try {
         props = PropertiesLoaderUtils.loadAllProperties("config.properties");
      } catch (Exception var70) {
      }

      boolean ischarsetflag = false;
      String ischarset_s = "";
      String ischarset_t = "";
      if (datasourceid != null) {
         TCoreDatasystem tCoreDatasystem = (TCoreDatasystem)this.tCoreDatasystemDao.get(datasourceid);
         if (tCoreDatasystem != null) {
            String ischarset = tCoreDatasystem.getIscharset();
            if (ischarset != null && !"".equals(ischarset) && ischarset.split(",").length == 2) {
               ischarsetflag = true;
               ischarset_s = ischarset.split(",")[0];
               ischarset_t = ischarset.split(",")[1];
            }
         }
      }

      String isrepeatvalue = props.get("isrepeatvalue").toString();

      try {
         try {
            Map<Integer, List<String>> columnValueMap = new HashMap();
            Map<Integer, Set<String>> columnDistinctValueMap = new HashMap();
            int columnCount = columnameVolist.size();
            long rowCount = 0L;
            long[] nullOrEmptyCount = new long[columnCount];
            int matchCurrencyCount = 0;
            boolean isMatchCurrency = false;
            progressInfo.setCurrentState("提取数据");
            timeLogList.add("提取表数据开始：" + System.currentTimeMillis());

            for(int z = 0; z < ObjectValueslist.size(); ++z) {
               for(int i = 0; i < columnameVolist.size(); ++i) {
                  if (rowCount == 0L) {
                     columnValueMap.put(i, new ArrayList());
                     columnDistinctValueMap.put(i, new HashSet());
                  }

                  Object columnValueObj = null;

                  try {
                     columnValueObj = ((List)ObjectValueslist.get(z)).get(i);
                     if (!((ColumnInfoVO)columnameVolist.get(i)).getDecimaldigits().equals("") && !((ColumnInfoVO)columnameVolist.get(i)).getDecimaldigits().equals("0")) {
                        String fmt = "";

                        for(int j = 0; j < Integer.parseInt(((ColumnInfoVO)columnameVolist.get(i)).getDecimaldigits()); ++j) {
                           fmt = fmt + "0";
                        }

                        DecimalFormat df = new DecimalFormat("0." + fmt);
                        columnValueObj = df.format(columnValueObj);
                     }
                  } catch (Exception var71) {
                     columnValueObj = null;
                  }

                  if (columnValueObj != null) {
                     String columnValue = columnValueObj.toString();
                     if (columnValueObj instanceof byte[]) {
                        columnValue = "";
                     }

                     if (ischarsetflag) {
                        columnValue = new String(columnValue.getBytes(ischarset_s), ischarset_t);
                        System.out.println(columnValue);
                     }

                     if (!"".equals(columnValue.trim())) {
                        ((List)columnValueMap.get(i)).add(columnValue);
                        ((Set)columnDistinctValueMap.get(i)).add(columnValue);
                     } else {
                        int var10002 = (int) nullOrEmptyCount[i]++;
                     }
                  } else {
                     int var103 = (int) nullOrEmptyCount[i]++;
                  }
               }

               ++rowCount;
            }

            timeLogList.add("提取表数据结束：" + System.currentTimeMillis());
            if (rowCount == 0L) {
               for(int i = 0; i < columnCount; ++i) {
                  String columnname = ((ColumnInfoVO)columnameVolist.get(i)).getColumnname();
                  sensitiveColumns.add(new SensitiveColumn(datasourceid, datasourcename, schema.substring(schema.lastIndexOf("/") + 1), tableName, columnname, rowCount, 0L, 0L));
               }

               return sensitiveColumns;
            }

            timeLogList.add("匹配表数据开始：" + System.currentTimeMillis());
            progressInfo.setCurrentState("匹配数据");

            for(int i = 0; i < columnCount; ++i) {
               String columnname = ((ColumnInfoVO)columnameVolist.get(i)).getColumnname();
               long validCount = rowCount - nullOrEmptyCount[i];
               double distinctCount = (double)((Set)columnDistinctValueMap.get(i)).size();
               SensitiveColumn column = new SensitiveColumn(datasourceid, datasourcename, schema.substring(schema.lastIndexOf("/") + 1), tableName, columnname, rowCount, validCount, (long)distinctCount);
               sensitiveColumns.add(column);
               List<String> columnValues = (List)columnValueMap.get(i);
               if (null != columnValues && columnValues.size() != 0) {
                  long maxMatchCount = 0L;
                  List<String> maxMatchValues = null;
                  List<String> maxNotMathValues = null;
                  int patternIndex = 0;

                  for(Pattern pattern : patternList) {
                     TConsoleSearchregex searchRegex = (TConsoleSearchregex)searchRegexList.get(patternIndex++);
                     String regexType = searchRegex.getType();
                     String regexName = searchRegex.getName();
                     int level = 0;
                     long matchCount = 0L;
                     long nomatchCount = 0L;
                     List<String> tempMatchValues = new ArrayList();
                     List<String> matchValues = new ArrayList();
                     Set<String> matchValueSet = new HashSet();
                     List<String> notMatchValues = new ArrayList();
                     Map<String, Integer> namerepeatmap = new HashMap();
                     if (pattern.pattern().startsWith("MethodName:")) {
                        String methodName = pattern.pattern().substring(11);
                        int maxLength = -1;
                        if (methodName.contains("MaxLength:")) {
                           if (methodName.contains("Weight:")) {
                              String[] parameters = methodName.split("\\|MaxLength:");
                              if (parameters.length == 2) {
                                 methodName = parameters[0];
                                 String[] Weight = parameters[1].split("\\|Weight:");
                                 maxLength = Integer.parseInt(Weight[0]);

                                 try {
                                    level = Integer.parseInt(Weight[1]);
                                 } catch (Exception var69) {
                                    level = 0;
                                 }
                              }
                           } else {
                              String[] parameters = methodName.split("\\|MaxLength:");
                              if (parameters.length == 2) {
                                 methodName = parameters[0];
                                 maxLength = Integer.parseInt(parameters[1]);
                              }
                           }
                        }

                        if (methodName.contains("isCurrency")) {
                           for(String val : columnValues) {
                              if (this.FloatCol(val)) {
                                 ++matchCount;
                                 matchValues.add(val);
                                 tempMatchValues.add(regexType + ":" + val);
                                 matchValueSet.add(val);
                              } else {
                                 ++nomatchCount;
                                 notMatchValues.add(val);
                              }

                              if (this.isCurrency(val, currdic)) {
                                 ++matchCurrencyCount;
                              }
                           }
                        } else {
                           for(String val : columnValues) {
                              if (this.matches(methodName, maxLength, val, level)) {
                                 ++matchCount;
                                 matchValues.add(val);
                                 if ("姓名".equals(regexType)) {
                                    Integer integer = (Integer)namerepeatmap.get(val);
                                    namerepeatmap.put(val, integer == null ? 1 : integer + 1);
                                 }

                                 tempMatchValues.add(regexType + ":" + val);
                                 matchValueSet.add(val);
                              } else {
                                 ++nomatchCount;
                                 notMatchValues.add(val);
                              }
                           }
                        }
                     } else {
                        for(String val : columnValues) {
                           if (pattern.matcher(val).matches()) {
                              ++matchCount;
                              matchValues.add(val);
                              if ("姓名".equals(regexType)) {
                                 Integer integer = (Integer)namerepeatmap.get(val);
                                 namerepeatmap.put(val, integer == null ? 1 : integer + 1);
                              }

                              tempMatchValues.add(regexType + ":" + val);
                              matchValueSet.add(val);
                           } else {
                              ++nomatchCount;
                              notMatchValues.add(val);
                           }
                        }
                     }

                     boolean isrepeatdata = true;
                     if ("姓名".equals(regexType)) {
                        Integer matchValuessize = (int)((double)matchValues.size() * Double.parseDouble(isrepeatvalue));

                        for(Map.Entry<String, Integer> entry : namerepeatmap.entrySet()) {
                           if ((Integer)entry.getValue() > matchValuessize) {
                              isrepeatdata = false;
                              break;
                           }
                        }
                     }

                     if (matchCurrencyCount - columnValues.size() == 0) {
                        isMatchCurrency = true;
                        matchCurrencyCount = 0;
                     }

                     if ((double)matchCount / (double)columnValues.size() * (double)100.0F >= rate) {
                        if (isrepeatdata) {
                           column.setMatchResult(regexType, regexName, (long)matchValues.size(), matchValues, notMatchValues);
                        }

                        String key = schema.substring(schema.lastIndexOf("/") + 1) + "_m" + tableName + "_m" + columnname;
                        HashMap<String, List<String>> keyhash = new HashMap();
                        List<String> matchValuesList = new ArrayList();
                        List<String> notMatchValuesList = new ArrayList();
                        if (matchValues.size() > 100) {
                           matchValuesList.addAll(matchValues.subList(0, 100));
                        } else if (matchValues.size() != 0) {
                           matchValuesList.addAll(matchValues.subList(0, matchValues.size()));
                        }

                        if (notMatchValues.size() > 100) {
                           notMatchValuesList.addAll(notMatchValues.subList(0, 100));
                        } else if (notMatchValues.size() != 0) {
                           notMatchValuesList.addAll(notMatchValues.subList(0, notMatchValues.size()));
                        }

                        keyhash.put("matchValues", matchValuesList);
                        keyhash.put("notMatchValues", notMatchValuesList);
                        this.redisService.set(key, keyhash);
                        break;
                     }

                     if (maxMatchCount < matchCount) {
                        maxMatchCount = matchCount;
                        maxMatchValues = tempMatchValues;
                        maxNotMathValues = notMatchValues;
                     }
                  }

                  if (!column.isSensitiveColumn()) {
                     if (maxMatchCount > 0L) {
                        column.setMatchCount(maxMatchCount);
                        column.setMatchValues(maxMatchValues);
                        column.setNotMatchValues(maxNotMathValues);
                     } else {
                        column.setNotMatchValues(columnValues);
                     }
                  }
               }
            }

            if (!isMatchCurrency) {
               for(int i = 0; i < sensitiveColumns.size(); ++i) {
                  if ("价格".equals(((SensitiveColumn)sensitiveColumns.get(i)).getRegexName())) {
                     ((SensitiveColumn)sensitiveColumns.get(i)).setRegexName((String)null);
                     ((SensitiveColumn)sensitiveColumns.get(i)).setRegexType((String)null);
                     ((SensitiveColumn)sensitiveColumns.get(i)).setMatchCount(0L);
                     ((SensitiveColumn)sensitiveColumns.get(i)).setMatchValues((List)null);
                     ((SensitiveColumn)sensitiveColumns.get(i)).setNotMatchValues((List)null);
                  }
               }
            }

            timeLogList.add("匹配表数据结束：" + System.currentTimeMillis());
         } catch (Exception e) {
            e.printStackTrace();
         }

         return sensitiveColumns;
      } finally {
         ;
      }
   }

   public List<SensitiveColumn> getFileSensitiveColumnsByContent(List<String> tablelist, String datasourceid, String datasourcename, String schema, Map<String, List<String>> resultSet, String tableName, double rate, List<TConsoleSearchregex> searchRegexList, List<Pattern> patternList, ProgressInfo progressInfo, List<String> timeLogList, String quotecharacter) {
      List<SensitiveColumn> sensitiveColumns = new ArrayList();

      try {
         Map<Integer, List<String>> columnValueMap = new HashMap();
         Map<Integer, Set<String>> columnDistinctValueMap = new HashMap();
         int columnCount = 0;
         if (resultSet != null) {
            columnCount = resultSet.size();
         }

         int hangcount = 0;
         if (null != resultSet && resultSet.get("1") != null) {
            hangcount = ((List)resultSet.get("1")).size();
         }

         long rowCount = (long)hangcount;
         long[] nullOrEmptyCount = new long[columnCount];
         progressInfo.setCurrentState("提取数据");

         for(int i = 0; i < columnCount; ++i) {
            Set<String> set = new HashSet();
            List<String> list = new ArrayList();

            for(int j = 0; j < hangcount; ++j) {
               set.add((resultSet.get(String.valueOf(i + 1))).get(j));
               list.add((resultSet.get(String.valueOf(i + 1))).get(j));
            }

            columnDistinctValueMap.put(i, set);
            columnValueMap.put(i, list);
         }

         if (rowCount == 0L) {
            for(int i = 0; i < columnCount; ++i) {
               String columnname = (String)tablelist.get(i);
               SensitiveColumn nodata = new SensitiveColumn(datasourceid, datasourcename, schema, tableName, columnname, rowCount, 0L, 0L);
               nodata.setIsfile("1");
               sensitiveColumns.add(nodata);
            }

            return sensitiveColumns;
         }

         progressInfo.setCurrentState("匹配数据");

         for(int i = 0; i < resultSet.size(); ++i) {
            String columnname = (String)tablelist.get(i);
            double distinctCount = (double)((Set)columnDistinctValueMap.get(i)).size();
            SensitiveColumn column = new SensitiveColumn(datasourceid, datasourcename, schema, tableName, columnname, rowCount, rowCount, (long)distinctCount);
            column.setIsfile("1");
            sensitiveColumns.add(column);
            List<String> columnValues = (List)columnValueMap.get(i);
            if (null != columnValues && columnValues.size() != 0) {
               long maxMatchCount = 0L;
               List<String> maxMatchValues = null;
               List<String> maxNotMathValues = null;
               int patternIndex = 0;

               for(Pattern pattern : patternList) {
                  TConsoleSearchregex searchRegex = (TConsoleSearchregex)searchRegexList.get(patternIndex++);
                  String regexType = searchRegex.getType();
                  String regexName = searchRegex.getName();
                  long matchCount = 0L;
                  List<String> tempMatchValues = new ArrayList();
                  List<String> matchValues = new ArrayList();
                  Set<String> matchValueSet = new HashSet();
                  List<String> notMatchValues = new ArrayList();
                  List<String> invalidValues = new ArrayList();
                  if (pattern.pattern().startsWith("MethodName:")) {
                     String methodName = pattern.pattern().substring(11);
                     int maxLength = -1;
                     int level = 0;
                     if (methodName.contains("MaxLength:")) {
                        if (methodName.contains("Weight:")) {
                           String[] parameters = methodName.split("\\|MaxLength:");
                           if (parameters.length == 2) {
                              methodName = parameters[0];
                              String[] Weight = parameters[1].split("\\|Weight:");
                              maxLength = Integer.parseInt(Weight[0]);

                              try {
                                 level = Integer.parseInt(Weight[1]);
                              } catch (Exception var55) {
                                 level = 0;
                              }
                           }
                        } else {
                           String[] parameters = methodName.split("\\|MaxLength:");
                           if (parameters.length == 2) {
                              methodName = parameters[0];
                              maxLength = Integer.parseInt(parameters[1]);
                           }
                        }
                     }

                     for(String val : columnValues) {
                        String vals = this.getquotecharacter(val, quotecharacter);
                        if (vals.trim().equals("")) {
                           invalidValues.add(val);
                        } else if (!vals.equals("ghca_value_no_marcher") && this.matches(methodName, maxLength, vals, 0)) {
                           ++matchCount;
                           matchValues.add(val);
                           tempMatchValues.add(regexType + ":" + val);
                           matchValueSet.add(val);
                        } else {
                           notMatchValues.add(val);
                        }
                     }
                  } else {
                     for(String val : columnValues) {
                        String vals = this.getquotecharacter(val, quotecharacter);
                        if (vals.trim().equals("")) {
                           invalidValues.add(val);
                        } else if (!vals.equals("ghca_value_no_marcher") && pattern.matcher(vals).matches()) {
                           ++matchCount;
                           matchValues.add(val);
                           tempMatchValues.add(regexType + ":" + val);
                           matchValueSet.add(val);
                        } else {
                           notMatchValues.add(val);
                        }
                     }
                  }

                  for(String string : invalidValues) {
                     columnValues.remove(string);
                  }

                  if ((double)matchCount / (double)columnValues.size() * (double)100.0F >= rate) {
                     column.setMatchResult(regexType, regexName, (long)matchValues.size(), matchValues, notMatchValues);
                     String key = schema + "_m" + tableName + "_m" + columnname;
                     HashMap<String, List<String>> keyhash = new HashMap();
                     List<String> matchValuesList = new ArrayList();
                     List<String> notMatchValuesList = new ArrayList();
                     if (matchValues.size() > 100) {
                        matchValuesList.addAll(matchValues.subList(0, 100));
                     } else if (matchValues.size() != 0) {
                        matchValuesList.addAll(matchValues.subList(0, matchValues.size()));
                     }

                     if (notMatchValues.size() > 100) {
                        notMatchValuesList.addAll(notMatchValues.subList(0, 100));
                     } else if (notMatchValues.size() != 0) {
                        notMatchValuesList.addAll(notMatchValues.subList(0, notMatchValues.size()));
                     }

                     keyhash.put("matchValues", matchValuesList);
                     keyhash.put("notMatchValues", notMatchValuesList);
                     this.redisService.set(key, keyhash);
                     break;
                  }

                  List<String> notMatchValuesList = new ArrayList();
                  if (notMatchValues.size() > 100) {
                     notMatchValuesList.addAll(notMatchValues.subList(0, 100));
                  } else if (notMatchValues.size() != 0) {
                     notMatchValuesList.addAll(notMatchValues.subList(0, notMatchValues.size()));
                  }

                  column.setIsshowdata("1");
                  String key = schema + "_m" + tableName + "_m" + columnname;
                  HashMap<String, List<String>> keyhash = new HashMap();
                  keyhash.put("matchValues", matchValues);
                  keyhash.put("notMatchValues", notMatchValuesList);
                  this.redisService.set(key, keyhash);
                  if (maxMatchCount < matchCount) {
                     maxMatchCount = matchCount;
                     maxMatchValues = tempMatchValues;
                     maxNotMathValues = notMatchValues;
                  }
               }

               if (!column.isSensitiveColumn()) {
                  if (maxMatchCount > 0L) {
                     column.setMatchCount(maxMatchCount);
                     column.setMatchValues(maxMatchValues);
                     column.setNotMatchValues(maxNotMathValues);
                  } else {
                     column.setNotMatchValues(columnValues);
                  }
               }
            }
         }

         timeLogList.add("匹配表数据结束：" + System.currentTimeMillis());
      } catch (Exception var56) {
         Exception e = var56;
         var56.printStackTrace();

         try {
            PrintStream printStream = new PrintStream(new FileOutputStream("c:/getAllTableColumnsByContentErrors.txt"));
            PrintStream oldStream = System.err;
            System.err.println(e.getMessage());
            printStream.close();
         } catch (Exception var54) {
         }
      }

      return sensitiveColumns;
   }

   public List<ComboboxVO> querySensitiveGroups() {
      List<TCoreSensitivegroup> list = this.tCoreSensitivegroupDao.queryAll();
      List<ComboboxVO> result = new ArrayList();
      if (list != null) {
         for(TCoreSensitivegroup group : list) {
            result.add(new ComboboxVO(group.getId(), group.getTname()));
         }
      }

      return result;
   }

   private String getquotecharacter(String value, String quotecharacter) {
      if (quotecharacter != null) {
         switch (quotecharacter) {
            case "single":
               if (value.startsWith("'") && value.startsWith("'", value.length() - 1)) {
                  if (value.length() > 1) {
                     value = value.substring(1, value.length() - 1);
                  }
               } else {
                  value = "ghca_value_no_marcher";
               }
               break;
            case "double":
               if (value.startsWith("\"") && value.startsWith("\"", value.length() - 1)) {
                  if (value.length() > 1) {
                     value = value.substring(1, value.length() - 1);
                  }
               } else {
                  value = "ghca_value_no_marcher";
               }
               break;
            default:
               if (value.startsWith("'") && value.startsWith("'", value.length() - 1) || value.startsWith("\"") && value.startsWith("\"", value.length() - 1)) {
                  value = "ghca_value_no_marcher";
               }
         }
      }

      return value;
   }

   private String getQuerySql(String selectDataType, String dbType, String schema, long maxRowCount, String num) {
      String sql = null;
      if (EdbType.ORACLE.toString().equals(dbType)) {
         if (selectDataType.equals("1")) {
            sql = "select {1} from " + schema + ".\"{0}\" where rownum <= " + maxRowCount;
         } else if (selectDataType.equals("2")) {
            sql = "";
         } else if (selectDataType.equals("3")) {
            if (num == null) {
               num = "50000";
            }

            sql = "select {1} from (select {1} from " + schema + ".\"{0}\" where rownum < " + num + " order by dbms_random.value) where rownum <= " + maxRowCount;
         }
      } else if (EdbType.DB2.toString().equals(dbType)) {
         if (selectDataType.equals("1")) {
            sql = "select {1} from " + schema + ".\"{0}\" FETCH FIRST " + maxRowCount + " ROWS ONLY";
         } else if (selectDataType.equals("2")) {
            sql = "";
         } else if (selectDataType.equals("3")) {
            sql = "select {1} from " + schema + ".\"{0}\" order by rand() FETCH FIRST " + maxRowCount + " ROWS ONLY";
         }
      } else if (EdbType.INFORMIX.toString().equals(dbType)) {
         if (selectDataType.equals("1")) {
            sql = "select first " + maxRowCount + " {1} from " + schema + ".{0} ";
         } else if (selectDataType.equals("2")) {
            sql = "";
         } else if (selectDataType.equals("3")) {
            sql = "";
         }
      } else if (!EdbType.MYSQL.toString().equals(dbType) && !EdbType.MARIADB.toString().equals(dbType) && !EdbType.RAPIDSDB.toString().equals(dbType)) {
         if (EdbType.MSSQLSERVER.toString().equals(dbType)) {
            if (selectDataType.equals("1")) {
               sql = "select top " + maxRowCount + " {1} from  " + schema + ".\"{0}\"";
            } else if (selectDataType.equals("2")) {
               sql = "";
            } else if (selectDataType.equals("3")) {
               sql = "select top " + maxRowCount + " {1} from " + schema + ".\"{0}\" order by newid()";
            }
         } else if (EdbType.HIVE.toString().equals(dbType)) {
            if (selectDataType.equals("1")) {
               sql = "select {1} from " + schema + ".{0} order by rand() limit " + maxRowCount;
            } else if (selectDataType.equals("2")) {
               sql = "";
            } else if (selectDataType.equals("3")) {
               sql = "select {1} from  " + schema + ".{0} limit " + maxRowCount;
            }
         } else if (EdbType.SYBASE.toString().equals(dbType)) {
            if (selectDataType.equals("1")) {
               sql = " SET ROWCOUNT " + maxRowCount + " SELECT {1} FROM " + schema + ".\"{0}\" SET ROWCOUNT 0";
            } else if (selectDataType.equals("2")) {
               sql = "";
            } else if (selectDataType.equals("3")) {
               sql = "set rowcount " + maxRowCount + "  select {1} from " + schema + ".\"{0}\"order by rand(convert(int,row1)+datepart(ms,getdate())) set rowcount 0";
            }
         } else if (EdbType.AS400.toString().equals(dbType)) {
            if (selectDataType.equals("1")) {
               sql = "select {1} from " + schema + ".\"{0}\" FETCH FIRST " + maxRowCount + " ROWS ONLY";
            } else if (selectDataType.equals("2")) {
               sql = "";
            } else if (selectDataType.equals("3")) {
               sql = "select {1} from " + schema + ".\"{0}\" order by rand() FETCH FIRST " + maxRowCount + " ROWS ONLY";
            }
         } else if (EdbType.SYBASE_IQ.toString().equals(dbType)) {
            if (selectDataType.equals("1")) {
               sql = " SET ROWCOUNT " + maxRowCount + " SELECT {1} FROM " + schema + ".\"{0}\" SET ROWCOUNT 0";
            } else if (selectDataType.equals("2")) {
               sql = "";
            } else if (selectDataType.equals("3")) {
               sql = "set rowcount " + maxRowCount + "  select {1} from " + schema + ".\"{0}\"order by rand(convert(int,row1)+datepart(ms,getdate())) set rowcount 0";
            }
         } else if (EdbType.TERADATA.toString().equals(dbType)) {
            if (selectDataType.equals("1")) {
               sql = " SELECT top " + maxRowCount + " {1} FROM " + schema + ".\"{0}\" ;";
            } else if (selectDataType.equals("2")) {
               sql = "";
            } else if (selectDataType.equals("3")) {
               sql = " SELECT {1} FROM " + schema + ".\"{0}\"   sample  " + maxRowCount + " ;";
            }
         } else if (EdbType.GREENPLUM.toString().equals(dbType)) {
            if (selectDataType.equals("1")) {
               sql = "select {1} from " + schema + ".{0}  limit  " + maxRowCount;
            } else if (selectDataType.equals("2")) {
               sql = "";
            } else if (selectDataType.equals("3")) {
               sql = "";
            }
         } else if (EdbType.HANA.toString().equals(dbType)) {
            if (selectDataType.equals("1")) {
               sql = "select {1} from " + schema + ".{0}  limit  " + maxRowCount;
            } else if (selectDataType.equals("2")) {
               sql = "";
            } else if (selectDataType.equals("3")) {
               sql = "";
            }
         }
      } else if (selectDataType.equals("1")) {
         sql = "select {1} from  " + schema + ".{0} limit " + maxRowCount;
      } else if (selectDataType.equals("2")) {
         sql = "";
      } else if (selectDataType.equals("3")) {
         sql = "select {1} from " + schema + ".{0} order by rand() limit " + maxRowCount;
      }

      return sql;
   }

   private List<String> getTablesOfSchema(Connection connection, String dbType, String schema) {
      List<String> allTableList = new ArrayList();

      try {
         ResultSet allTablesResultSet = connection.getMetaData().getTables((String)null, schema, "%", new String[]{"TABLE"});

         while(allTablesResultSet.next()) {
            allTableList.add(allTablesResultSet.getString("TABLE_NAME"));
         }

         allTablesResultSet.close();
      } catch (Exception e) {
         e.printStackTrace();
      }

      return allTableList;
   }

   public boolean matches(String methodName, int maxLength, String matchString, int level) {
      boolean result = false;
      if (methodName != null && matchString != null) {
         matchString = matchString.replaceAll(" ", "");
         if (!matchString.equals("")) {
            if (maxLength == -1) {
               try {
                  if (!this.methods.containsKey(methodName)) {
                     this.methods.put(methodName, this.getClass().getDeclaredMethod(methodName, String.class));
                  }

                  result = (Boolean)((Method)this.methods.get(methodName)).invoke(this, matchString);
               } catch (Exception e) {
                  e.printStackTrace();
               }
            } else if (matchString.length() <= maxLength) {
               try {
                  if (methodName.equals("isChineseAddress")) {
                     if (!this.methods.containsKey(methodName)) {
                        this.methods.put(methodName, this.getClass().getDeclaredMethod(methodName, String.class, Integer.TYPE, Integer.TYPE));
                     }

                     result = (Boolean)((Method)this.methods.get(methodName)).invoke(this, matchString, maxLength, level);
                  } else {
                     if (!this.methods.containsKey(methodName)) {
                        this.methods.put(methodName, this.getClass().getDeclaredMethod(methodName, String.class, Integer.TYPE));
                     }

                     result = (Boolean)((Method)this.methods.get(methodName)).invoke(this, matchString, maxLength);
                  }
               } catch (Exception e) {
                  e.printStackTrace();
               }
            }
         }
      }

      return result;
   }

   public void setYearNow() {
      this.yearNow = Calendar.getInstance().get(1);
   }

   public String getNumberOnly(String str) {
      if (null == this.phoneNoReplacePattern) {
         this.phoneNoReplacePattern = Pattern.compile("[^0-9]");
      }

      return this.phoneNoReplacePattern.matcher(str).replaceAll("");
   }

   public boolean isPersonName(String name, int maxLength) {
      boolean result = false;
      int length = name.length();
      if (length >= 2) {
         if (null == this.allChinesePattern) {
            this.allChinesePattern = Pattern.compile("[\\u4e00-\\u9fa5]+");
         }

         if (null == this.allEnglishPattern) {
            this.allEnglishPattern = Pattern.compile("[a-zA-Z\\s\\.\\']+");
         }

         if (this.allChinesePattern.matcher(name).matches()) {
            if (null == this.singleFirstNameList) {
               this.singleFirstNameList = this.tConsoleDictionaryDao.queryValueByTypeCode("1");
               this.doubleFirstNameList = this.tConsoleDictionaryDao.queryValueByTypeCode("2");
            }

            if (this.singleFirstNameList.contains(name.substring(0, 1)) && name.length() <= 3) {
               String lasename = name.substring(name.length() - 1, name.length());
               if (!lasename.equals("省") && !lasename.equals("市") && !lasename.equals("区") && !lasename.equals("县")) {
                  result = true;
               } else {
                  result = false;
               }
            } else if (this.doubleFirstNameList.contains(name.substring(0, 2)) && name.length() <= 4) {
               String lasename = name.substring(name.length() - 1, name.length());
               if (!lasename.equals("省") && !lasename.equals("市") && !lasename.equals("区") && !lasename.equals("县")) {
                  result = true;
               } else {
                  result = false;
               }
            }
         }
      }

      return result;
   }

   public boolean isNationality(String nation, int maxLength) {
      boolean result = false;
      int length = nation.length();
      if (length >= 2) {
         if (null == this.allChinesePattern) {
            this.allChinesePattern = Pattern.compile("[\\u4e00-\\u9fa5]+");
         }

         if (null == this.allEnglishPattern) {
            this.allEnglishPattern = Pattern.compile("[a-zA-Z\\s\\.\\']+");
         }

         if (this.allChinesePattern.matcher(nation).matches()) {
            if (null == this.nationality) {
               this.nationality = this.tConsoleDictionaryDao.queryValueByTypeCode("20");
            }

            if (this.nationality.contains(nation)) {
               result = true;
            } else {
               result = false;
            }
         }
      }

      return result;
   }

   public boolean isMarry(String marry, int maxLength) {
      boolean result = false;
      int length = marry.length();
      if (length >= 2) {
         if (null == this.allChinesePattern) {
            this.allChinesePattern = Pattern.compile("[\\u4e00-\\u9fa5]+");
         }

         if (this.allChinesePattern.matcher(marry).matches()) {
            if (!marry.equals("已婚") && !marry.equals("未婚") && !marry.equals("离异") && !marry.equals("丧偶")) {
               result = false;
            } else {
               result = true;
            }
         }
      }

      return result;
   }

   public boolean isReligion(String religion, int maxLength) {
      boolean result = false;
      int length = religion.length();
      if (length >= 2) {
         if (null == this.allChinesePattern) {
            this.allChinesePattern = Pattern.compile("[\\u4e00-\\u9fa5]+");
         }

         if (this.allChinesePattern.matcher(religion).matches()) {
            if (null == this.religionList) {
               this.religionList = this.tConsoleDictionaryDao.queryValueByTypeCode("21");
            }

            if (this.religionList.contains(religion)) {
               result = true;
            } else {
               result = false;
            }
         }
      }

      return result;
   }

   public boolean isPersonNation(String nation, int maxLength) {
      boolean result = false;
      int length = nation.length();
      if (length >= 2) {
         if (null == this.allChinesePattern) {
            this.allChinesePattern = Pattern.compile("[\\u4e00-\\u9fa5]+");
         }

         if (this.allChinesePattern.matcher(nation).matches() && null == this.nationList) {
            this.nationList = this.tConsoleDictionaryDao.queryValueByTypeCode("22");
            if (this.nationList.contains(nation)) {
               result = true;
            } else {
               result = false;
            }
         }
      }

      return result;
   }

   public boolean isPolitical(String politic, int maxLength) {
      boolean result = false;
      int length = politic.length();
      if (null == this.allChinesePattern) {
         this.allChinesePattern = Pattern.compile("[\\u4e00-\\u9fa5]+");
      }

      if (this.allChinesePattern.matcher(politic).matches() && null == this.politicList) {
         this.politicList = this.tConsoleDictionaryDao.queryValueByTypeCode("23");
         if (this.politicList.contains(politic)) {
            result = true;
         } else {
            result = false;
         }
      }

      return result;
   }

   public boolean isPassport(String passport, int maxLength) {
      boolean result = false;
      result = IdnoTool.validatePassport(passport);
      return result;
   }

   public boolean isBirthAddress(String address, int maxLength) {
      boolean result = false;
      int length = address.length();
      if (length >= 3) {
         if (null == this.allChinesePattern) {
            this.allChinesePattern = Pattern.compile("[\\u4e00-\\u9fa5]+");
         }

         if (this.allChinesePattern.matcher(address).matches()) {
            String lastname = address.substring(length - 1, length);
            if (lastname.equals("省")) {
               String firstname = address.substring(0, length - 1);
               if (null == this.birthAddress) {
                  this.birthAddress = this.tConsoleDictionaryDao.queryValueByTypeCode("4");
               }

               if (this.birthAddress.contains(firstname)) {
                  result = true;
               } else {
                  result = false;
               }
            }
         }
      }

      return result;
   }

   public boolean Diploma(String diploma, int maxLength) {
      boolean result = false;
      diploma = diploma.trim();
      int length = diploma.length();
      if (length == 17) {
         if (this.diplomapattern == null) {
            this.diplomapattern = Pattern.compile("[0-9]{17}");
         }

         if (this.diplomapattern.matcher(diploma).matches()) {
            if (null == this.diplomaList) {
               this.diplomaList = this.tConsoleDictionaryDao.queryValueByTypeCode("24");
            }

            String firstdiploma = diploma.substring(0, 5);
            String seconddiploma = diploma.substring(5, 6);
            String thirddiploma = diploma.substring(6, 10);
            String forthdiploma = diploma.substring(10, 12);
            if (this.diplomaList.contains(firstdiploma) && (seconddiploma.equals("1") || seconddiploma.equals("2") || seconddiploma.equals("3") || seconddiploma.equals("4") || seconddiploma.equals("5") || seconddiploma.equals("6") || seconddiploma.equals("7")) && Integer.parseInt(thirddiploma) >= 1800 && Integer.parseInt(thirddiploma) <= this.yearNow) {
               if (!forthdiploma.equals("01") && !forthdiploma.equals("02") && !forthdiploma.equals("04") && !forthdiploma.equals("05") && !forthdiploma.equals("06")) {
                  result = false;
               } else {
                  result = true;
               }
            }
         }
      }

      if (length == 18) {
         if (this.diplomapattern == null) {
            this.diplomapattern = Pattern.compile("[0-9]{18}");
         }

         if (this.diplomapattern.matcher(diploma).matches()) {
            String firstdiploma = diploma.substring(0, 5);
            String seconddiploma = diploma.substring(5, 6);
            String thirddiploma = diploma.substring(6, 10);
            String forthdiploma = diploma.substring(10, 12);
            if (null == this.diplomaList) {
               this.diplomaList = this.tConsoleDictionaryDao.queryValueByTypeCode("24");
            }

            if (this.diplomaList.contains(firstdiploma) && (seconddiploma.equals("1") || seconddiploma.equals("2") || seconddiploma.equals("3") || seconddiploma.equals("4") || seconddiploma.equals("5") || seconddiploma.equals("6") || seconddiploma.equals("7")) && Integer.parseInt(thirddiploma) >= 1800 && Integer.parseInt(thirddiploma) <= this.yearNow) {
               if (!forthdiploma.equals("01") && !forthdiploma.equals("02") && !forthdiploma.equals("04") && !forthdiploma.equals("05") && !forthdiploma.equals("06")) {
                  result = false;
               } else {
                  result = true;
               }
            }
         }
      }

      return result;
   }

   public boolean diplomaNo(String diplomano, int maxLength) {
      boolean result = false;
      diplomano = diplomano.trim();
      int length = diplomano.length();
      if (length == 16) {
         String firstdiploma = diplomano.substring(0, 5);
         String seconddiploma = diplomano.substring(5, 6);
         String thirddiploma = diplomano.substring(6, 10);
         if (this.diplomapattern == null) {
            this.diplomapattern = Pattern.compile("[0-9]{16}");
         }

         if (this.diplomapattern.matcher(diplomano).matches()) {
            if (null == this.diplomanoList) {
               this.diplomanoList = this.tConsoleDictionaryDao.queryValueByTypeCode("24");
            }

            if (this.diplomanoList.contains(firstdiploma) && (seconddiploma.equals("2") || seconddiploma.equals("3") || seconddiploma.equals("4"))) {
               if (Integer.parseInt(thirddiploma) >= 1800 && Integer.parseInt(thirddiploma) <= this.yearNow) {
                  result = true;
               } else {
                  result = false;
               }
            }
         }
      }

      return result;
   }

   public boolean SocialNo(String socialno, int maxLength) {
      boolean result = false;
      socialno = socialno.trim();
      int length = socialno.length();
      if (length == 10) {
         String socialnoft = socialno.substring(0, 2);
         String socialnosec = socialno.substring(2, 5);
         String socialnolast = socialno.substring(7, 10);
         if (this.diplomapattern == null) {
            this.diplomapattern = Pattern.compile("[0-9]{10}");
         }

         if (this.diplomapattern.matcher(socialno).matches()) {
            this.socialList = this.tConsoleDictionaryDao.queryValueByTypeCode("25");
            this.socialList1 = this.tConsoleDictionaryDao.queryValueByTypeCode("26");
         }

         if (this.socialList.contains(socialnoft) && this.socialList1.contains(socialnosec)) {
            result = true;
         }
      }

      if (length == 12) {
         String socialnoft = socialno.substring(0, 2);
         String socialnosec = socialno.substring(2, 5);
         String socialnolast = socialno.substring(7, 10);
         String socialnotird1 = socialno.substring(5, 9);
         String socialnolast1 = socialno.substring(9, 12);
         if (this.diplomapattern == null) {
            this.diplomapattern = Pattern.compile("[0-9]{12}");
         }

         if (this.diplomapattern.matcher(socialno).matches()) {
            this.socialList = this.tConsoleDictionaryDao.queryValueByTypeCode("25");
            this.socialList1 = this.tConsoleDictionaryDao.queryValueByTypeCode("26");
         }

         if (this.socialList.contains(socialnoft) && this.socialList1.contains(socialnosec) && Integer.parseInt(socialnotird1) >= 1800 && Integer.parseInt(socialnotird1) <= this.yearNow) {
            result = true;
         }
      }

      return result;
   }

   public boolean accumulationNo(String accNo, int maxLength) {
      boolean result = false;
      accNo = accNo.trim();
      int length = accNo.length();
      String firstNo = accNo.substring(0, 1);
      if (length == 9 && (accNo.startsWith("0") || accNo.startsWith("1"))) {
         result = true;
      }

      if (length == 12) {
         String lastNo = accNo.substring(length - 3, length);
         if (this.diplomapattern == null) {
            this.diplomapattern = Pattern.compile("[0-9]{12}");
         }

         if (this.diplomapattern.matcher(accNo).matches() && (accNo.startsWith("0") || accNo.startsWith("1")) && (lastNo.equals("205") || lastNo.equals("209"))) {
            result = true;
         }
      }

      return result;
   }

   public boolean isIP4(String ip) {
      boolean result = false;
      if (ip.length() >= 7 && ip.length() <= 15) {
         if (null == this.ip4Pattern) {
            this.ip4Pattern = Pattern.compile("[0-9]{1,3}(\\.[0-9]{1,3}){3}");
         }

         if (this.ip4Pattern.matcher(ip).matches()) {
            String[] ips = ip.split("\\.");
            if (ips.length == 4) {
               int matchCount = 0;

               for(int i = 0; i < 4; ++i) {
                  if (ips[i].startsWith("0")) {
                     if (!"0".equals(ips[i])) {
                        break;
                     }

                     ++matchCount;
                  } else {
                     int num = Integer.parseInt(ips[i]);
                     if (num <= 0 || num > 255) {
                        break;
                     }

                     ++matchCount;
                  }
               }

               if (matchCount == 4) {
                  result = true;
               }
            }
         }
      }

      return result;
   }

   public boolean isIdentifyNo(String idno) {
      boolean result = false;
      idno = idno.trim();
      if (idno.length() == 18) {
         idno = idno.toUpperCase();
         if (null == this.identifyNoPattern) {
            this.identifyNoPattern = Pattern.compile("[0-9]{17}[0-9X]");
         }

         if (this.identifyNoPattern.matcher(idno).matches() && this.checkIdentifyNoFirstSix(idno) && this.checkIdentifyNoDate(idno.substring(6, 14)) && this.getLastNoOfIdentifyNo(idno) == idno.charAt(17)) {
            result = true;
         }
      } else if (idno.length() == 15) {
         Pattern identifyNoPattern15 = Pattern.compile("[0-9]{15}");
         if (identifyNoPattern15.matcher(idno).matches() && this.checkIdentifyNoFirstSix(idno) && this.checkIdentifyNoDate("19" + idno.substring(6, 12))) {
            result = true;
         }
      }

      return result;
   }

   public boolean checkIdentifyNoFirstSix(String idno) {
      boolean result = false;
      if (null == this.firstSixNumList) {
         this.firstSixNumList = this.tConsoleDictionaryDao.queryValueByTypeCode("11");
      }

      if (this.firstSixNumList.contains(idno.substring(0, 6))) {
         result = true;
      }

      return result;
   }

   public boolean checkIdentifyNoDate(String datestr) {
      boolean result = false;
      if (null == this.identifyNoDateFormat) {
         this.identifyNoDateFormat = new SimpleDateFormat("yyyyMMdd");
         this.identifyNoDateFormat.setLenient(false);
      }

      try {
         this.identifyNoDateFormat.parse(datestr);
         int year = Integer.parseInt(datestr.substring(0, 4));
         if (year > 1800 && year <= this.yearNow) {
            result = true;
         }
      } catch (ParseException var4) {
      }

      return result;
   }

   public char getLastNoOfIdentifyNo(String idno) {
      int sum = 0;

      for(int i = 0; i < 17; ++i) {
         sum += (idno.charAt(i) - 48) * this.identifyNoFactors[i];
      }

      return this.identifyNoResults[sum % 11];
   }

   public boolean isChineseAddress(String address, int maxLength, int level) {
      boolean result = false;
      address = address.replaceAll("[^一-龥]", "");
      if (address.length() >= 6) {
         if (null == this.chineseAddressPatternFirstThree) {
            this.chineseAddressPatternFirstThree = Pattern.compile("[\\u4e00-\\u9fa5]{3}.*");
         }

         if (this.chineseAddressPatternFirstThree.matcher(address).matches()) {
            if (null == this.chineseAddressPattern) {
               List<String> list = this.tConsoleDictionaryDao.queryValueByTypeCode("4", "5", "17");
               if (list.size() > 0) {
                  StringBuilder pattern = new StringBuilder();

                  for(String str : list) {
                     pattern.append(str);
                     pattern.append("|");
                  }

                  pattern.deleteCharAt(pattern.length() - 1);
                  this.chineseAddressPattern = Pattern.compile(pattern.toString());
               }
            }

            Matcher matcher = this.chineseAddressPattern.matcher(address);

            int num;
            for(num = 0; matcher.find(); ++num) {
            }

            if (num != 0 && num >= level) {
               result = true;
            }
         }
      }

      return result;
   }

   public boolean isTelephoneNo(String telephoneNo, int maxLength) {
      boolean result = false;
      telephoneNo = MobileNumberTool.toHalfAngleDigital(telephoneNo);
      if (telephoneNo.length() >= 7 && telephoneNo.length() <= 25) {
         if (null == this.telephoneNoSimplePattern) {
            this.telephoneNoSimplePattern = Pattern.compile(".*[0-9]{7}");
         }

         if (null == this.isContainsChineseOrEnglish) {
            this.isContainsChineseOrEnglish = Pattern.compile("[一-龥[(A-Za-z)]]");
         }

         if (this.isContainsChineseOrEnglish.matcher(telephoneNo).find()) {
            return result;
         }

         if (this.telephoneNoSimplePattern.matcher(telephoneNo).matches()) {
            String numberOnly = this.getNumberOnly(telephoneNo);
            result = this.checkTelephoneNo(numberOnly);
         }
      }

      return result;
   }

   public boolean checkTelephoneNo(String numberOnly) {
      boolean result = false;
      int length = numberOnly.length();
      if (!StringUtils.isBlank(numberOnly) && !numberOnly.startsWith("19") && !numberOnly.startsWith("20")) {
         if (length >= 7 && length <= 16) {
            if (length <= 8) {
               if (numberOnly.startsWith("1") || numberOnly.startsWith("0")) {
                  return false;
               }

               SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");

               try {
                  format.setLenient(false);
                  format.parse(numberOnly);
                  Calendar cal = Calendar.getInstance();
                  cal.setTime(format.parse(numberOnly));
                  int year = cal.get(1);
                  if (year < 1970 || year > 2050) {
                     result = true;
                  }
               } catch (ParseException var7) {
                  result = true;
               }
            } else if (numberOnly.startsWith("86")) {
               if (length < 12) {
                  return false;
               }

               numberOnly = numberOnly.substring(2, numberOnly.length());
               result = this.checkTelephonearea(numberOnly);
            } else if (numberOnly.startsWith("0086")) {
               if (length < 14) {
                  return false;
               }

               numberOnly = numberOnly.substring(4, numberOnly.length());
               result = this.checkTelephonearea(numberOnly);
            } else {
               result = this.checkTelephonearea(numberOnly);
            }
         }

         return result;
      } else {
         return false;
      }
   }

   public boolean checkTelephonearea(String numberOnly) {
      if (null == this.telephoneNoPattern) {
         List<String> list = this.tConsoleDictionaryDao.queryValueByTypeCode("8");
         if (list.size() > 0) {
            StringBuilder pattern = new StringBuilder();

            for(String str : list) {
               pattern.append(str);
               pattern.append("|");
            }

            pattern.deleteCharAt(pattern.length() - 1);
            this.telephoneNoPattern = Pattern.compile(pattern.toString());
         }
      }

      String iszreo = numberOnly.substring(0, 1);
      boolean result = false;
      if (iszreo.equals("0")) {
         Matcher matcher = this.telephoneNoPattern.matcher(numberOnly.substring(0, 4));
         if (matcher.find()) {
            int realTelephoneNoLength = numberOnly.substring(matcher.group().length()).length();
            if (realTelephoneNoLength == 8 || realTelephoneNoLength == 7) {
               String a = numberOnly.substring(matcher.group().length(), matcher.group().length() + 1);
               if (!a.equals("0") && !a.equals("1")) {
                  result = true;
               }
            }
         }
      } else if (numberOnly.startsWith("1") && !numberOnly.startsWith("10")) {
         Matcher matcher = this.telephoneNoPattern.matcher("0" + numberOnly.substring(0, 3));
         if (matcher.find()) {
            int realTelephoneNoLength = numberOnly.substring(matcher.group().length()).length();
            if (realTelephoneNoLength == 8 || realTelephoneNoLength == 7) {
               String a = numberOnly.substring(matcher.group().length() - 1, matcher.group().length());
               if (!a.equals("0") && !a.equals("1")) {
                  result = true;
               }
            }
         }
      } else {
         result = false;
      }

      return result;
   }

   public boolean isMobilephoneNo(String mobilephoneNo, int maxLength) {
      boolean result = false;
      mobilephoneNo = MobileNumberTool.toHalfAngleDigital(mobilephoneNo);
      if (mobilephoneNo.length() == 11) {
         if (null == this.mobilephoneNoSimplePattern) {
            this.mobilephoneNoSimplePattern = Pattern.compile(".*[0-9]{11}");
         }

         if (this.mobilephoneNoSimplePattern.matcher(mobilephoneNo).matches()) {
            String numberOnly = this.getNumberOnly(mobilephoneNo);
            result = this.checkMobilephoneNo(numberOnly);
         }
      }

      return result;
   }

   public boolean checkMobilephoneNo(String numberOnly) {
      boolean result = false;
      int length = numberOnly.length();
      if (length == 11) {
         if (null == this.firstThreeNoList) {
            this.firstThreeNoList = this.tConsoleDictionaryDao.queryValueByTypeCode("9");
         }

         String firstThreeNo = numberOnly.substring(length - 11, length - 8);
         if (this.firstThreeNoList.contains(firstThreeNo)) {
            result = true;
         }
      }

      return result;
   }

   public boolean isPhoneNo(String phoneNo, int maxLength) {
      boolean result = false;
      phoneNo = MobileNumberTool.toHalfAngleDigital(phoneNo);
      if (phoneNo.length() >= 7 && phoneNo.length() <= 25) {
         if (null == this.phoneNoSimplePattern) {
            this.phoneNoSimplePattern = Pattern.compile(".*[0-9]{7}");
         }

         if (null == this.isContainsChineseOrEnglish) {
            this.isContainsChineseOrEnglish = Pattern.compile("[一-龥[(A-Za-z)]]");
         }

         if (this.isContainsChineseOrEnglish.matcher(phoneNo).find()) {
            return result;
         }

         if (this.phoneNoSimplePattern.matcher(phoneNo).matches()) {
            String numberOnly = this.getNumberOnly(phoneNo);
            result = this.checkMobilephoneNo(numberOnly);
            if (!result) {
               result = this.checkTelephoneNo(numberOnly);
            }
         }
      }

      return result;
   }

   public boolean isemail(String email) {
      boolean result = false;
      email = email.trim();
      if (email.length() < 6) {
         return result;
      } else {
         String[] emailsuffix = email.split("@");
         if (emailsuffix.length == 2) {
            result = true;
         }

         if (!result) {
            return result;
         } else {
            if (null == this.emailPrefix || null == this.emailSuffix) {
               this.emailPrefix = Pattern.compile("^((?!_\\-\\.)[a-zA-Z0-9]+)([a-zA-Z0-9_\\-\\.]*)");
               this.emailSuffix = Pattern.compile("^((?!\\.$)(?!\\_$)(?!\\-$).)*$");
            }

            if (this.emailPrefix.matcher(emailsuffix[0]).find() && this.emailSuffix.matcher(emailsuffix[0]).matches() && this.emailPrefix.matcher(emailsuffix[1]).find() && this.emailSuffix.matcher(emailsuffix[1]).matches()) {
               result = true;
            } else {
               result = false;
            }

            return result;
         }
      }
   }

   public boolean isCompanyName(String companyName, int maxLength) {
      boolean result = false;
      companyName = companyName.trim();
      int length = companyName.length();
      if (length >= 3) {
         result = this.isPersonName(companyName, 4);
         if (result) {
            return false;
         }

         if (null == this.allChinesePattern) {
            this.allChinesePattern = Pattern.compile("[\\u4e00-\\u9fa5]+");
         }

         if (null == this.companyNamePattern) {
            List<String> list = this.tConsoleDictionaryDao.queryValueByTypeCode("10");
            if (list.size() > 0) {
               StringBuilder pattern = new StringBuilder();

               for(String str : list) {
                  pattern.append(str);
                  pattern.append("$");
                  pattern.append("|");
               }

               pattern.deleteCharAt(pattern.length() - 1);
               this.companyNamePattern = Pattern.compile(pattern.toString());
            }
         }

         Matcher matcher = this.companyNamePattern.matcher(companyName);
         if (matcher.find()) {
            result = true;
         }
      }

      return result;
   }

   public boolean isShopName(String shopName, int maxLength) {
      boolean result = false;
      shopName = shopName.trim();
      int length = shopName.length();
      if (length >= 3) {
         result = this.isPersonName(shopName, 4);
         if (result) {
            return false;
         }

         if (null == this.allChinesePattern) {
            this.allChinesePattern = Pattern.compile("[\\u4e00-\\u9fa5]+");
         }

         if (this.allChinesePattern.matcher(shopName).matches()) {
            if (null == this.shopNamePattern) {
               List<String> list = this.tConsoleDictionaryDao.queryValueByTypeCode("10");
               if (list.size() > 0) {
                  StringBuilder pattern = new StringBuilder();

                  for(String str : list) {
                     pattern.append(str);
                     pattern.append("|");
                  }

                  pattern.deleteCharAt(pattern.length() - 1);
                  this.shopNamePattern = Pattern.compile(pattern.toString());
               }
            }

            Matcher matcher = this.shopNamePattern.matcher(shopName);
            if (matcher.find() && matcher.start() > 0 && matcher.end() == length) {
               result = true;
            }

            if (!result) {
               List<String> list = this.tConsoleDictionaryDao.queryValueByTypeCode("16");
               if (list.size() > 0) {
                  StringBuilder pattern = new StringBuilder();

                  for(String str : list) {
                     pattern.append(str);
                     pattern.append("|");
                  }

                  pattern.deleteCharAt(pattern.length() - 1);
                  this.shopNamePattern = Pattern.compile(pattern.toString());
               }

               matcher = this.shopNamePattern.matcher(shopName);
               if (matcher.find()) {
                  result = true;
               }
            }
         }
      }

      return result;
   }

   public boolean isPostCode(String code) {
      boolean result = false;
      int length = code.trim().length();
      if (length == 6) {
         if (null == this.postCodePattern6) {
            this.postCodePattern6 = Pattern.compile("[0-9]{6}");
         }

         if (this.postCodePattern6.matcher(code).matches()) {
            if (null == this.postCodeList) {
               this.postCodeList = this.tConsoleDictionaryDao.queryValueByTypeCode("13");
            }

            if (this.postCodeList.contains(code)) {
               result = true;
            }
         }
      }

      return result;
   }

   public boolean isPersonOrCompany(String name, int maxLength) {
      boolean result = false;
      if (name.length() >= 2) {
         result = this.isPersonName(name, 4);
         if (!result) {
            result = this.isCompanyName(name, maxLength);
         }
      }

      return result;
   }

   public boolean isOrganizationCode(String code) {
      boolean result = false;
      int length = code.length();
      if (length == 9 || length == 10) {
         if (null == this.organizationCodePattern) {
            this.organizationCodePattern = Pattern.compile("[0-9A-Z]{8}[^0-9a-zA-Z]?[0-9X]");
         }

         if (this.organizationCodePattern.matcher(code).matches()) {
            result = this.checkOrganizationCode(code);
         }
      }

      return result;
   }

   public boolean checkOrganizationCode(String code) {
      boolean result = false;
      String firstEightChars = code.substring(0, 8);
      char lastChar = code.charAt(code.length() - 1);
      int sum = 0;

      for(int i = 0; i < 8; ++i) {
         sum += this.getOrganizationCodeValue(firstEightChars.charAt(i)) * this.factors[i];
      }

      int checkNum = 11 - sum % 11;
      if (checkNum == 10) {
         checkNum = 88;
      } else if (checkNum == 11) {
         checkNum = 48;
      } else {
         checkNum += 48;
      }

      if (checkNum == lastChar) {
         result = true;
      }

      return result;
   }

   public int getOrganizationCodeValue(char oneCode) {
      int result;
      if (oneCode > '9') {
         result = oneCode - 65 + 10;
      } else {
         result = oneCode - 48;
      }

      return result;
   }

   public boolean isCardNo(String cardNo) {
      boolean result = false;
      int length = cardNo.length();
      if (length >= 16 && length <= 19) {
         if (null == this.cardNoPattern) {
            this.cardNoPattern = Pattern.compile("[0-9]{16,19}");
         }

         if (this.cardNoPattern.matcher(cardNo).matches() && this.checkCardNo(cardNo)) {
            result = true;
         }
      }

      return result;
   }

   public boolean checkCardNo(String cardNo) {
      boolean result = false;
      if (!StringUtils.isBlank(cardNo) && !cardNo.startsWith("0")) {
         char[] numbers = cardNo.toCharArray();
         int flag = 1;
         int sum = 0;

         for(int i = cardNo.length() - 1; i >= 0; --i) {
            int num = numbers[i] - 48;
            if (flag % 2 == 0) {
               int d = num * 2;
               sum += d;
               if (d > 9) {
                  sum -= 9;
               }
            } else {
               sum += num;
            }

            ++flag;
         }

         if (sum % 10 == 0) {
            result = true;
         }

         return result;
      } else {
         return false;
      }
   }

   public boolean isTrackInfo(String trackInfo) {
      boolean result = false;
      int length = trackInfo.length();
      if (length >= 18) {
         if (null == this.cardNoPattern) {
            this.cardNoPattern = Pattern.compile("[0-9]{16,19}");
         }

         Matcher matcher = this.cardNoPattern.matcher(trackInfo);
         if (matcher.find() && matcher.start() == 0) {
            String cardNo = matcher.group();
            String remaining = trackInfo.substring(matcher.end());
            if (remaining.length() > 1 && remaining.startsWith("=") && this.checkCardNo(cardNo)) {
               result = true;
            }
         }
      }

      return result;
   }

   public boolean isTaxCode(String code) {
      boolean result = false;
      int length = code.length();
      if (length == 15) {
         if (null == this.taxCodePattern15) {
            this.taxCodePattern15 = Pattern.compile("[0-9]{6}[0-9A-Z]{8}[0-9X]");
         }

         if (this.taxCodePattern15.matcher(code).matches() && this.checkZoneCode(code.substring(0, 6))) {
            result = this.checkOrganizationCode(code.substring(6));
         }
      } else if (length == 20) {
         if (null == this.taxCodePattern20) {
            this.taxCodePattern20 = Pattern.compile("[0-9]{17}[0-9xX][0-9]{2}");
         }

         if (this.taxCodePattern20.matcher(code).matches() && this.checkIdentifyNoFirstSix(code.substring(0, 6))) {
            if ("000".equals(code.substring(15, 18))) {
               result = this.checkIdentifyNoDate("19" + code.substring(6, 12));
            } else if (this.checkIdentifyNoDate(code.substring(6, 14)) && this.getLastNoOfIdentifyNo(code) == code.charAt(17)) {
               result = true;
            }
         }
      }

      return result;
   }

   public boolean checkZoneCode(String code) {
      boolean result = false;
      if (null == this.zoneCodeList) {
         this.zoneCodeList = this.tConsoleDictionaryDao.queryValueByTypeCode("11");
      }

      if (this.zoneCodeList.contains(code)) {
         result = true;
      }

      return result;
   }

   public boolean isMixedIdentificationCode(String code) {
      boolean result = false;
      if (StringUtils.isNotBlank(code)) {
         result = this.isBusinessLicenseCode(code);
         if (!result) {
            result = this.isOrganizationCode(code);
         }

         if (!result) {
            result = this.isTaxCode(code);
         }

         if (!result) {
            result = this.isIdentifyNo(code);
         }

         if (!result) {
            result = IdnoTool.validateCardOtherIdno(code);
         }
      }

      return result;
   }

   public boolean isBusinessLicenseCode(String code) {
      boolean result = false;
      if (null == this.businessLicenseCodePattern) {
         this.businessLicenseCodePattern = Pattern.compile("[a-zA-Z0-9]+");
      }

      if (this.businessLicenseCodePattern.matcher(code).matches() && StringUtils.isNotBlank(code)) {
         if (15 == code.length()) {
            result = isLicense_15(code);
         } else if (18 == code.length()) {
            result = isLicense_18(code);
         }
      }

      return result;
   }

   public static boolean isLicense_15(String businesslicense) {
      boolean reFlg = false;

      try {
         Pattern blicCodePattern = Pattern.compile("[0-9]{15}");
         if (StringUtils.isNotBlank(businesslicense) && blicCodePattern.matcher(businesslicense).matches()) {
            String businesslicensePrex14 = businesslicense.substring(0, 14);
            String businesslicense15 = businesslicense.substring(14, businesslicense.length());
            char[] chars = businesslicensePrex14.toCharArray();
            int[] ints = new int[chars.length];

            for(int i = 0; i < chars.length; ++i) {
               ints[i] = Integer.parseInt(String.valueOf(chars[i]));
            }

            getCheckCode(ints);
            if (businesslicense15.equals(getCheckCode(ints) + "")) {
               reFlg = true;
            }
         }

         return reFlg;
      } catch (Exception var11) {
         reFlg = false;
         System.out.println(">>isLicense15 erro code:" + businesslicense);
         return reFlg;
      } finally {
         ;
      }
   }

   private static int getCheckCode(int[] ints) {
      if (null != ints && ints.length > 1) {
         int ti = 0;
         int si = 0;
         int cj = 0;
         int pj = 10;

         for(int i = 0; i < ints.length; ++i) {
            ti = ints[i];
            pj = cj % 11 == 0 ? 10 : cj % 11;
            si = pj + ti;
            cj = (0 == si % 10 ? 10 : si % 10) * 2;
            if (i == ints.length - 1) {
               pj = cj % 11 == 0 ? 10 : cj % 11;
               return pj == 1 ? 1 : 11 - pj;
            }
         }
      }

      return -1;
   }

   public static boolean isLicense_18(String code) {
      boolean reFlg = false;

      try {
         String regex = "^([159Y]{1})([1239]{1})([0-9ABCDEFGHJKLMNPQRTUWXY]{6})([0-9ABCDEFGHJKLMNPQRTUWXY]{9})([0-90-9ABCDEFGHJKLMNPQRTUWXY])$";
         if (code.length() == 18 && code.matches(regex)) {
            String str = "0123456789ABCDEFGHJKLMNPQRTUWXY";
            int[] ws = new int[]{1, 3, 9, 27, 19, 26, 16, 17, 20, 29, 25, 13, 8, 24, 10, 30, 28};
            String[] codes = new String[]{code.substring(0, code.length() - 1), code.substring(code.length() - 1, code.length())};
            int sum = 0;

            for(int i = 0; i < 17; ++i) {
               sum += str.indexOf(codes[0].charAt(i)) * ws[i];
            }

            int c18 = 31 - sum % 31;
            if (c18 == 31) {
               c18 = str.indexOf(89);
            } else if (c18 == 30) {
               c18 = str.indexOf(48);
            }

            if (str.charAt(c18) == codes[1].charAt(0)) {
               reFlg = true;
            }
         }

         return reFlg;
      } catch (Exception var11) {
         reFlg = false;
         System.out.println(reFlg + " >>isLicense18 erro code:" + code);
         return reFlg;
      } finally {
         ;
      }
   }

   public Map<String, List<SensitiveColumn>> getAllFileColumnsByName(String jiegou, TCoreDatasystem datasystem, List<String> schemas, List<TConsoleSearchregex> searchRegexList, ProgressInfo progressInfo) {
      Map<String, List<SensitiveColumn>> tableColumns = new HashMap();
      String dbType = datasystem.getDbtype();
      TCoreFileStructure sy = (TCoreFileStructure)this.tCoreFileStructureDao.get(jiegou);
      List<TCoreFileStructurecolumn> list = this.tCoreFileStructurecolumnDao.queryAll("columnindex", true, new Criterion[]{Restrictions.eq("filestructureid", jiegou)});
      List<String> widthname = new ArrayList();
      List<String> tablehname = new ArrayList();

      for(TCoreFileStructurecolumn tCoreFileStructurecolumn : list) {
         widthname.add(tCoreFileStructurecolumn.getColumnaccuracy());
         tablehname.add(tCoreFileStructurecolumn.getColumnname());
      }

      long schemaIndex = 1L;
      if (((String)schemas.get(0)).equals(",") || ((String)schemas.get(0)).equals("")) {
         schemas.remove(0);
      }

      progressInfo.setSchemaCount((long)schemas.size());

      for(String schema : schemas) {
         progressInfo.setCurrentState("notReady");
         progressInfo.setCurrentSchema(schemaIndex);
         progressInfo.setCurrentSchemaName(datasystem.getLocaldir());
         List<String> allFileListOfSchema = new ArrayList();
         allFileListOfSchema.add(schema);
         if (allFileListOfSchema.size() == 0) {
            if (schemaIndex == 1L) {
               progressInfo.setReady(true);
            }

            progressInfo.setTotalCount(0L);
            progressInfo.setCurrent(0L);
            progressInfo.setCurrentState("ready");
            ++schemaIndex;
         } else {
            progressInfo.setTotalCount((long)allFileListOfSchema.size());
            progressInfo.setCurrentState("ready");
            List<Pattern> patternList = new ArrayList();

            for(TConsoleSearchregex searchRegex : searchRegexList) {
               patternList.add(Pattern.compile(searchRegex.getRegex()));
            }

            long tableIndex = 1L;

            for(String fileName : allFileListOfSchema) {
               progressInfo.setCurrent(tableIndex);
               progressInfo.setCurrentTable(fileName);
               if (schemaIndex == 1L && tableIndex == 1L) {
                  progressInfo.setReady(true);
               }

               new HashMap();

               try {
                  progressInfo.setCurrentState("查询表数据");
               } catch (Exception var26) {
               }

               if (tablehname.size() > 0) {
                  List<SensitiveColumn> sensitiveColumns = new ArrayList();
                  tableColumns.put(fileName, sensitiveColumns);

                  for(String columnName : tablehname) {
                     sensitiveColumns.add(this.getSensitiveColumnByName(datasystem.getId(), datasystem.getSysname(), schema, fileName, columnName, searchRegexList, patternList));
                  }
               }

               ++tableIndex;
            }

            ++schemaIndex;
         }
      }

      return tableColumns;
   }

   public void init() {
      this.zoneCodeList = null;
      this.singleFirstNameList = null;
      this.doubleFirstNameList = null;
      this.firstSixNumList = null;
      this.chineseAddressPattern = null;
      this.telephoneNoPattern = null;
      this.firstThreeNoList = null;
      this.companyNamePattern = null;
      this.shopNamePattern = null;
      this.postCodeList = null;
      this.ticketList = null;
      this.nationality = null;
      this.religionList = null;
      this.nationList = null;
      this.politicList = null;
      this.birthAddress = null;
      this.diplomapattern = null;
      this.diplomaList = null;
      this.diplomanoList = null;
      this.socialList = null;
      this.socialList1 = null;
   }

   public boolean isticket(String ticket, int maxLength) {
      boolean result = false;
      ticket = ticket.trim();
      if (null == this.phoneNoReplacePattern) {
         this.phoneNoReplacePattern = Pattern.compile("[^0-9]");
      }

      Matcher isnum = this.phoneNoReplacePattern.matcher(ticket);
      if (isnum.find()) {
         return false;
      } else {
         if (ticket.length() == 13) {
            if (null == this.ticketList) {
               this.ticketList = this.tConsoleDictionaryDao.queryValueByTypeCode("18");
            }

            if (this.ticketList.contains(ticket.substring(0, 3))) {
               result = true;
            }
         }

         return result;
      }
   }

   public boolean isAmount(String code) {
      boolean result = false;
      if (StringUtils.isNotBlank(code)) {
         Pattern pattern = Pattern.compile("^(([1-9]{1}\\d*)|([0]{1}))(\\.(\\d){0,2})?$");
         Matcher match = pattern.matcher(code);
         result = match.matches();
      }

      return result;
   }

   public boolean isCurrency(String code, List<String> currdic) {
      boolean result = false;
      result = currdic.contains(code);
      return result;
   }

   private boolean FloatCol(String code) {
      boolean result = false;
      if (StringUtils.isNotBlank(code) && code.contains(".")) {
         Pattern pattern = Pattern.compile("^([1-9]\\d{0,9}|0)([.]?|(\\.\\d{1,2})?)$");
         Matcher match = pattern.matcher(code);
         result = match.matches();
      }

      return result;
   }

   public List<TCoreProjectFindruleVO> queryFindrule(String projectid) {
      List<TCoreProjectFindruleVO> list = this.tCoreProjectSearchRegexDao.queryFindrulelist(projectid);
      return list;
   }

   public List<TConsoleSearchregex> initEditRegex(String rowid) {
      List<TConsoleSearchregex> tConsoleSearchregexlist = this.tConsoleSearchregexDao.queryAll(new Criterion[]{Restrictions.eq("id", rowid)});
      return tConsoleSearchregexlist;
   }

   public void delDataarea(String dataareaid) {
      try {
         this.tCoreDataAreaDao.removeById(dataareaid);
         this.tCoreProjectFindruleDao.delRuleByDataareaid(dataareaid);
      } catch (Exception e) {
         e.printStackTrace();
      }

   }

   public List<String> queryDataarea() {
      return this.tCoreDataAreaDao.queryAllDataarea();
   }

   public TCoreDataArea queryDataareaById(String id) {
      TCoreDataArea tCoreDataArea = (TCoreDataArea)this.tCoreDataAreaDao.queryUnique(new Criterion[]{Restrictions.eq("id", id)});
      return tCoreDataArea;
   }

   public boolean checkNameExitDataArea(String dataarea, String id) {
      Criterion criterion = Restrictions.eq("dataarea", dataarea);
      Criterion criterion2 = Restrictions.ne("id", id);
      if (id != null) {
         return this.tCoreDataAreaDao.count(new Criterion[]{criterion, criterion2}) > 0L;
      } else {
         return this.tCoreDataAreaDao.count(new Criterion[]{criterion}) > 0L;
      }
   }

   public List<TCoreDataArea> queryAllDataarea() {
      List<TCoreDataArea> list = this.tCoreDataAreaDao.queryAll(Order.asc("areatype"), Order.desc("createtime"), new Criterion[0]);
      return list;
   }

   public List<TCoreDataArea> queryAllDataarea(Map<String, Object> params) {
      String dataarea = "";
      if (null != params && null != params.get("rulename")) {
         dataarea = (String)params.get("rulename");
      }

      Criterion dataareaC = Restrictions.like("dataarea", dataarea, MatchMode.ANYWHERE).ignoreCase();
      List<TCoreDataArea> list = this.tCoreDataAreaDao.queryAll(Order.asc("areatype"), Order.desc("createtime"), new Criterion[]{dataareaC});
      return list;
   }

   public List<ComboboxVO> queryAllDataareaid() {
      List<ComboboxVO> list = this.tCoreDataAreaDao.queryAllDataareaid();
      return list;
   }

   public List<TCoreDataArea> queryDataareaByProjectid(String projectid) {
      List<TCoreDataArea> list = this.tCoreDataAreaDao.queryDataareaByProjectid(projectid);
      return list;
   }

   public List<ComboboxVO> queryDatafileList(String id) {
      List<ComboboxVO> list = this.tCoreDataFileGroupDao.queryDatafileList(id);
      return list;
   }

   public void saveConsoleSearchregex(TConsoleSearchregex searchRegex, String user) {
      String dataareaid = "";
      if (this.tCoreDataAreaDao.queryDataareaid(searchRegex.getType()).size() > 0) {
         dataareaid = (String)this.tCoreDataAreaDao.queryDataareaid(searchRegex.getType()).get(0);
      }

      String username = CommonUtils.loginUsername();
      if (dataareaid != null && !"".equals(dataareaid)) {
         searchRegex.setDataarea_id(dataareaid);
      } else {
         TCoreDataArea tCoreDataArea = new TCoreDataArea();
         tCoreDataArea.setDataarea(searchRegex.getType());
         tCoreDataArea.setCreatetime(new Date());
         tCoreDataArea.setCreateuser(username);
         this.tCoreDataAreaDao.save(tCoreDataArea);
         searchRegex.setDataarea_id(tCoreDataArea.getId());
      }

      if (null != searchRegex.getId() && !"".equals(searchRegex.getId())) {
         searchRegex.setUpdateuser(CommonUtils.loginUsername());
         searchRegex.setUpdatetime(new Date());
         this.tConsoleSearchregexDao.saveOrUpdate(searchRegex);
      } else {
         searchRegex.setCreateuser(CommonUtils.loginUsername());
         searchRegex.setCreatetime(new Date());
         this.tConsoleSearchregexDao.save(searchRegex);
      }

      if ("1".equalsIgnoreCase(searchRegex.getDefaulttype())) {
         List<TConsoleSearchregex> defaultList = this.tConsoleSearchregexDao.queryAll(new Criterion[]{Restrictions.eq("dataarea_id", searchRegex.getDataarea_id()), Restrictions.eq("defaulttype", "1")});
         if (null != defaultList && defaultList.size() > 0) {
            for(int i = 0; i < defaultList.size(); ++i) {
               if (!searchRegex.getId().equals(((TConsoleSearchregex)defaultList.get(i)).getId())) {
                  ((TConsoleSearchregex)defaultList.get(i)).setDefaulttype("0");
                  this.tConsoleSearchregexDao.saveOrUpdate(defaultList.get(i));
               }
            }
         }
      }

   }

   public TCoreDataArea saveTCoreDataArea(TCoreDataArea tCoreDataArea) {
      if (tCoreDataArea.getId() == null) {
         tCoreDataArea.setId(StringTool.getTablePrimaryKey());
         tCoreDataArea.setCreatetime(new Date());
         tCoreDataArea.setCreateuser(CommonUtils.loginUsername());
         tCoreDataArea.setAreatype("0");
         if (null == tCoreDataArea.getRemark()) {
            tCoreDataArea.setRemark("");
         }

         this.tCoreDataAreaDao.save(tCoreDataArea);
      } else {
         TCoreDataArea tCoreDataAreaUp = (TCoreDataArea)this.tCoreDataAreaDao.queryUnique(new Criterion[]{Restrictions.eq("id", tCoreDataArea.getId())});
         tCoreDataAreaUp.setDataarea(tCoreDataArea.getDataarea());
         tCoreDataAreaUp.setUpdateuser(CommonUtils.loginUsername());
         tCoreDataAreaUp.setUpdatetime(new Date());
         tCoreDataAreaUp.setRemark(tCoreDataArea.getRemark());
         this.tCoreDataAreaDao.saveOrUpdate(tCoreDataAreaUp);
      }

      return tCoreDataArea;
   }

   public void removeTCoreDataArea(List<String> idlist) {
      Criterion dataare_id = Restrictions.in("dataarea_id", idlist);
      this.tConsoleSearchregexDao.remove(new Criterion[]{dataare_id});
      Criterion id = Restrictions.in("id", idlist);
      this.tCoreDataAreaDao.remove(new Criterion[]{id});
   }

   public void saveConsoleSearchregex2(TConsoleSearchregex searchRegex, String user, List<Object> selectdatefilelist) {
      String dataareaid = "";
      if (this.tCoreDataAreaDao.queryDataareaid(searchRegex.getType()).size() > 0) {
         dataareaid = (String)this.tCoreDataAreaDao.queryDataareaid(searchRegex.getType()).get(0);
      }

      String username = CommonUtils.loginUsername();
      if (dataareaid != null && !"".equals(dataareaid)) {
         searchRegex.setDataarea_id(dataareaid);
      } else {
         TCoreDataArea tCoreDataArea = new TCoreDataArea();
         tCoreDataArea.setDataarea(searchRegex.getType());
         tCoreDataArea.setCreatetime(new Date());
         tCoreDataArea.setCreateuser(username);
         this.tCoreDataAreaDao.save(tCoreDataArea);
         searchRegex.setDataarea_id(tCoreDataArea.getId());
      }

      if ("1".equalsIgnoreCase(searchRegex.getDefaulttype())) {
         List<TConsoleSearchregex> defaultList = this.tConsoleSearchregexDao.queryAll(new Criterion[]{Restrictions.eq("dataarea_id", searchRegex.getDataarea_id()), Restrictions.eq("defaulttype", "1")});
         if (null != defaultList && defaultList.size() > 0) {
            for(int i = 0; i < defaultList.size(); ++i) {
               ((TConsoleSearchregex)defaultList.get(i)).setDefaulttype("0");
               this.tConsoleSearchregexDao.saveOrUpdate(defaultList.get(i));
            }
         }
      }

      String searchid = "";
      if (null != searchRegex.getId() && !"".equals(searchRegex.getId())) {
         searchRegex.setUpdateuser(CommonUtils.loginUsername());
         searchRegex.setUpdatetime(new Date());
         this.tConsoleSearchregexDao.getSession().merge(searchRegex);
      } else {
         searchRegex.setCreatetime(new Date());
         searchRegex.setCreateuser(username);
         this.tConsoleSearchregexDao.save(searchRegex);
         searchid = searchRegex.getId();
      }

      Criterion searchregexidCon = Restrictions.eq("searchregexid", searchRegex.getId());
      this.tCoreDataFileGroupDao.remove(new Criterion[]{searchregexidCon});

      for(int i = 0; i < selectdatefilelist.size(); ++i) {
         Map<String, String> map = (Map)selectdatefilelist.get(i);
         TCoreDataFileGroup o1 = new TCoreDataFileGroup();
         if (!"".equals(map.get("datefileid"))) {
            o1.setId(UUID.randomUUID().toString());
            if ("".equals(searchid)) {
               o1.setSearchregexid(searchRegex.getId());
            } else {
               o1.setSearchregexid(searchid);
            }

            o1.setDatafilename((String)map.get("datefilename"));
            o1.setDatafileid((String)map.get("datefileid"));
            o1.setSubsearchregexid((String)map.get("subsearchregexid"));
            o1.setCreatetime(new Date());
            o1.setCreateuser(username);
            o1.setFlag("0");
            this.tCoreDataFileGroupDao.save(o1);
         }
      }

   }

   public void saveConsoleSearchregex3(TConsoleSearchregex searchRegex, String user) {
      String dataareaid = "";
      if (this.tCoreDataAreaDao.queryDataareaid(searchRegex.getType()).size() > 0) {
         dataareaid = (String)this.tCoreDataAreaDao.queryDataareaid(searchRegex.getType()).get(0);
      }

      if (dataareaid != null && !"".equals(dataareaid)) {
         searchRegex.setDataarea_id(dataareaid);
      } else {
         TCoreDataArea tCoreDataArea = new TCoreDataArea();
         tCoreDataArea.setDataarea(searchRegex.getType());
         tCoreDataArea.setCreatetime(new Date());
         tCoreDataArea.setCreateuser(CommonUtils.loginUsername());
         this.tCoreDataAreaDao.save(tCoreDataArea);
         searchRegex.setDataarea_id(tCoreDataArea.getId());
      }

      if ("1".equalsIgnoreCase(searchRegex.getDefaulttype())) {
         List<TConsoleSearchregex> defaultList = this.tConsoleSearchregexDao.queryAll(new Criterion[]{Restrictions.eq("dataarea_id", searchRegex.getDataarea_id()), Restrictions.eq("defaulttype", "1")});
         if (null != defaultList && defaultList.size() > 0) {
            for(int i = 0; i < defaultList.size(); ++i) {
               ((TConsoleSearchregex)defaultList.get(i)).setDefaulttype("0");
               this.tConsoleSearchregexDao.saveOrUpdate(defaultList.get(i));
            }
         }
      }

      if (null != searchRegex.getId() && !"".equals(searchRegex.getId())) {
         this.tConsoleSearchregexDao.getSession().merge(searchRegex);
      } else {
         this.tConsoleSearchregexDao.save(searchRegex);
      }

   }

   public List<TCoreDataArea> queryAllDataArea() {
      List<TCoreDataArea> list = this.tCoreDataAreaDao.queryAll();
      return list;
   }

   public List<TCoreSearchregexVO> querySearchregexById(String id) {
      List<TCoreSearchregexVO> list = this.tCoreSearchregexVoDao.querySearchregexById(id);
      return list;
   }

   public int queryRuleCount(String dataareaId) {
      return this.tCoreSearchregexVoDao.queryRuleCount(dataareaId);
   }

   public void removeDataarea(String dataareaId) {
      this.tCoreDataAreaDao.remove(new Criterion[]{Restrictions.eq("id", dataareaId)});
   }

   public void setDefault(String ruleid) {
      TConsoleSearchregex rule = (TConsoleSearchregex)this.tConsoleSearchregexDao.get(ruleid);
      List<TConsoleSearchregex> defaultList = this.tConsoleSearchregexDao.queryAll(new Criterion[]{Restrictions.eq("dataarea_id", rule.getDataarea_id()), Restrictions.eq("defaulttype", "1")});
      if (null != defaultList && defaultList.size() > 0) {
         for(int i = 0; i < defaultList.size(); ++i) {
            ((TConsoleSearchregex)defaultList.get(i)).setDefaulttype("0");
            this.tConsoleSearchregexDao.saveOrUpdate(defaultList.get(i));
         }
      }

      rule.setDefaulttype("1");
      this.tConsoleSearchregexDao.saveOrUpdate(rule);
   }

   public void setOtherDefault(String id) {
      List<TConsoleSearchregex> temp = this.tConsoleSearchregexDao.queryAll(new Criterion[]{Restrictions.eq("dataarea_id", id)});
      if (!temp.isEmpty()) {
         ((TConsoleSearchregex)temp.get(0)).setDefaulttype("1");
         this.tConsoleSearchregexDao.saveOrUpdate(temp.get(0));
      }

   }

   public void removeselectdatefilelist(String id) {
      this.tCoreDataFileGroupDao.remove(new Criterion[]{Restrictions.eq("searchregexid", id)});
   }

   public void saveselectdatefilelist(TCoreDataFileGroup o) {
      this.tCoreDataFileGroupDao.save(o);
   }

   public List<Map<String, String>> querydatafileById(String rowid, String projectid) {
      return this.tCoreDataFileGroupDao.queryDataFileGroupList(rowid, projectid);
   }

   public List<TCoreDataFileGroup> querydatafileById(String rowid) {
      return this.tCoreDataFileGroupDao.queryAll(new Criterion[]{Restrictions.eq("searchregexid", rowid)});
   }

   public List<TCoreDataFileGroup> querydatafileBName(String name) {
      return this.tCoreDataFileGroupDao.queryAll(new Criterion[]{Restrictions.eq("searchregexid", name)});
   }

   public List<TConsoleSearchregex> getBydatafileid(String dataarea_id) {
      return this.tConsoleSearchregexDao.queryByDataareaid(dataarea_id);
   }

   public boolean dicmatch(String dictionaryClass, String matchingway, String val) {
      List<TConsoleDictionary> list = this.tConsoleDictionaryDao.queryDictionaryFile(dictionaryClass);
      new ArrayList();
      boolean flag = false;

      for(TConsoleDictionary dic : list) {
         String dicvalue = dic.getValue();
         if ("003".equals(matchingway)) {
            flag = val.startsWith(dicvalue);
            if (flag) {
               System.out.println(val + "=++" + dicvalue);
               break;
            }
         } else if ("004".equals(matchingway)) {
            flag = val.endsWith(dicvalue);
            if (flag) {
               break;
            }
         } else if ("001".equals(matchingway)) {
            flag = val.equals(dicvalue);
            if (flag) {
               break;
            }
         } else if ("002".equals(matchingway)) {
            if (val.indexOf(dicvalue) != -1) {
               flag = true;
               break;
            }

            flag = false;
         }
      }

      return flag;
   }

   public List<TCoreDataFileGroupVO> queryMutexDataarea(String dataareaid) {
      return this.tCoreDataFileGroupDao.queryMutexDataarea(dataareaid);
   }

   public List<TCoreDataFileGroupVO> queryMutexDataareaByrule(String dataareaid, String rulename) {
      return this.tCoreDataFileGroupDao.queryMutexDataareaByrule(dataareaid, rulename);
   }

   public List<TConsoleSearchregex> querySearchregexByDaid(String dataarea_id) {
      return this.tConsoleSearchregexDao.queryAll(new Criterion[]{Restrictions.eq("dataarea_id", dataarea_id)});
   }

   public List<TcoreTaskFindrule> queryTcoreTaskFindruleByRuleid(String ruleid) {
      return this.tCoreTaskFindruleDao.queryAll(new Criterion[]{Restrictions.eq("ruleid", ruleid)});
   }

   public String importExcel(Workbook wb, String username) {
      String result = this.checkExcelNull(wb);
      if (!result.equals("ok")) {
         return result;
      } else {
         Sheet sheet = wb.getSheetAt(0);
         int rowsNum = sheet.getLastRowNum();

         for(int i = 1; i < rowsNum + 1; ++i) {
            Row row = sheet.getRow(i);
            if (row != null) {
               TCoreDataArea area = new TCoreDataArea();
               TConsoleSearchregex regex = new TConsoleSearchregex();
               String dataarea = row.getCell(0).toString();
               String remark = row.getCell(1) == null ? "" : row.getCell(1).toString();
               boolean bool = this.checkNameExitDataArea(dataarea, (String)null);
               if (!bool) {
                  area.setDataarea(dataarea);
                  area.setRemark(remark);
                  area.setCreateuser(username);
                  area.setCreatetime(new Date());
                  area.setAreatype("0");
                  this.tCoreDataAreaDao.save(area);
               }

               String name = row.getCell(2).toString();
               regex.setName(name);
               String flag = row.getCell(3).toString();
               if (flag.equals("字段")) {
                  regex.setFlag("1");
               } else if (flag.equals("数据")) {
                  regex.setFlag("2");
               } else if (flag.equals("字段注释")) {
                  regex.setFlag("4");
               }

               String dicoveryway = row.getCell(4).toString();
               if (dicoveryway.equals("正则表达式")) {
                  regex.setDiscoverway("01");
               } else if (dicoveryway.equals("字典发现")) {
                  regex.setDiscoverway("03");
               } else if (dicoveryway.equals("自定义方法")) {
                  regex.setDiscoverway("04");
               }

               String expression = row.getCell(5) == null ? "" : row.getCell(5).toString();
               regex.setRegex(expression);
               String dictionaryClass = row.getCell(6) == null ? "" : row.getCell(6).toString();
               regex.setDictionaryClass(dictionaryClass);
               String matchingway = row.getCell(7) == null ? "" : row.getCell(7).toString();
               if (matchingway.equals("等于")) {
                  regex.setMatchingway("001");
               } else if (matchingway.equals("包含")) {
                  regex.setMatchingway("002");
               } else if (matchingway.equals("左匹配")) {
                  regex.setMatchingway("003");
               } else if (matchingway.equals("右匹配")) {
                  regex.setMatchingway("004");
               } else {
                  regex.setMatchingway("");
               }

               String ruleexample = row.getCell(8) == null ? "" : row.getCell(8).toString();
               regex.setRuleexample(ruleexample);
               String regRemark = row.getCell(9) == null ? "" : row.getCell(9).toString();
               regex.setRemark(regRemark);
               String defaulttype = row.getCell(10).toString();
               if (defaulttype.equals("是")) {
                  regex.setDefaulttype("1");
               } else {
                  regex.setDefaulttype("0");
               }

               TCoreDataArea dataArea = (TCoreDataArea)this.tCoreDataAreaDao.queryUnique(new Criterion[]{Restrictions.eq("dataarea", dataarea)});
               regex.setType(dataarea);
               regex.setDataarea_id(dataArea.getId());
               TConsoleSearchregex tConsoleSearchregex = (TConsoleSearchregex)this.tConsoleSearchregexDao.queryUnique(new Criterion[]{Restrictions.eq("dataarea_id", regex.getDataarea_id()), Restrictions.eq("name", regex.getName())});
               if (tConsoleSearchregex != null) {
                  this.tConsoleSearchregexDao.remove(new Criterion[]{Restrictions.eq("id", tConsoleSearchregex.getId())});
               }

               if (!"01".equals(regex.getDiscoverway()) && !"04".equals(regex.getDiscoverway())) {
                  if ("03".equals(regex.getDiscoverway())) {
                     this.saveConsoleSearchregex3(regex, (String)null);
                  }
               } else {
                  this.saveConsoleSearchregex(regex, (String)null);
               }
            }
         }

         return "导入成功";
      }
   }

   public String checkExcelNull(Workbook wb) {
      Sheet sheet = wb.getSheetAt(0);
      int rowNum = sheet.getLastRowNum();
      if (rowNum > 0) {
         for(int i = 1; i < rowNum + 1; ++i) {
            Row row = sheet.getRow(i);
            if (row != null) {
               if (row.getCell(0) == null) {
                  return "第" + (i + 1) + "行数据域名称不能为空";
               }

               if (row.getCell(2) == null) {
                  return "第" + (i + 1) + "行发现规则名称不能为空";
               }

               if (row.getCell(3) == null) {
                  return "第" + (i + 1) + "行发现方式不能为空";
               }

               if (row.getCell(4) == null) {
                  return "第" + (i + 1) + "行发现规则类型不能为空";
               }

               if (row.getCell(8) == null) {
                  return "第" + (i + 1) + "行样例不能为空";
               }

               if (row.getCell(10) == null) {
                  return "第" + (i + 1) + "行是否为默认规则不能为空";
               }
            }
         }

         return "ok";
      } else {
         return "不能导入空表单";
      }
   }

   public TCoreDataArea saveDataArea(TCoreDataAreaVO tCoreDataAreaVO) {
      TCoreDataArea tCoreDataArea = new TCoreDataArea();
      BeanUtils.copyProperties(tCoreDataAreaVO, tCoreDataArea);
      TCoreDataArea tCoreDataArea1 = this.queryDataareaById(tCoreDataArea.getId());
      if (null != tCoreDataArea1) {
         tCoreDataArea.setId(StringTool.getTablePrimaryKey());
      }

      tCoreDataArea.setCreatetime(new Date());
      this.tCoreDataAreaDao.save(tCoreDataArea);
      return tCoreDataArea;
   }

   public TConsoleSearchregex saveSearchRegex(TCoreSearchregexVO tCoreSearchregexVO) {
      TConsoleSearchregex tConsoleSearchregex = new TConsoleSearchregex();
      BeanUtils.copyProperties(tCoreSearchregexVO, tConsoleSearchregex);
      tConsoleSearchregex.setDataarea_id(tCoreSearchregexVO.getTid());
      tConsoleSearchregex.setType(tCoreSearchregexVO.getDataarea());
      tConsoleSearchregex.setId(tCoreSearchregexVO.getRuleid());
      tConsoleSearchregex.setName(tCoreSearchregexVO.getName());
      if ("1".equalsIgnoreCase(tCoreSearchregexVO.getDefaulttype())) {
         List<TConsoleSearchregex> defaultList = this.tConsoleSearchregexDao.queryAll(new Criterion[]{Restrictions.eq("dataarea_id", tConsoleSearchregex.getDataarea_id()), Restrictions.eq("defaulttype", "1")});
         if (null != defaultList && defaultList.size() > 0) {
            tConsoleSearchregex.setDefaulttype("0");
         } else {
            tConsoleSearchregex.setDefaulttype(tCoreSearchregexVO.getDefaulttype());
         }
      }

      List<TCoreSearchregexVO> list = this.querySearchregexById(tConsoleSearchregex.getId());
      if (null != list && list.size() > 0) {
         tConsoleSearchregex.setId(StringTool.getTablePrimaryKey());
      }

      tConsoleSearchregex.setCreatetime(new Date());
      this.tConsoleSearchregexDao.save(tConsoleSearchregex);
      return tConsoleSearchregex;
   }

   public TCoreDataArea queryByDataArea(String dataArea) {
      TCoreDataArea tCoreDataArea = (TCoreDataArea)this.tCoreDataAreaDao.queryUnique(new Criterion[]{Restrictions.eq("dataarea", dataArea)});
      return tCoreDataArea;
   }

   public boolean checkNameExit(String name, String dataareaId, String id) {
      Criterion criterion = Restrictions.eq("name", name);
      Criterion criterion_or = Restrictions.eq("name", name + "-分类分级发现规则同步");
      Criterion criterion1 = Restrictions.eq("dataarea_id", dataareaId);
      if (StringUtils.isNotBlank(id)) {
         Criterion criterion2 = Restrictions.eq("id", id);
         return this.tConsoleSearchregexDao.count(new Criterion[]{Restrictions.or(criterion, criterion_or), criterion1, Restrictions.not(criterion2)}) > 0L;
      } else {
         return this.tConsoleSearchregexDao.count(new Criterion[]{Restrictions.or(criterion, criterion_or), criterion1}) > 0L;
      }
   }

   public boolean checkNameExit(String name, String dataAreaId, String flag, String regex) {
      Criterion criterion = Restrictions.eq("name", name);
      Criterion criterion_or = Restrictions.eq("name", name + "-分类分级发现规则同步");
      Criterion criterion1 = Restrictions.eq("dataarea_id", dataAreaId);
      Criterion criterion2 = Restrictions.eq("flag", flag);
      if (StringUtils.isNotBlank(regex)) {
         Criterion criterion3 = Restrictions.eq("regex", regex);
         return this.tConsoleSearchregexDao.count(new Criterion[]{Restrictions.or(criterion, criterion_or), criterion1, criterion2, criterion3}) > 0L;
      } else {
         return this.tConsoleSearchregexDao.count(new Criterion[]{Restrictions.or(criterion, criterion_or), criterion1, criterion2}) > 0L;
      }
   }
}
