package com.chenyang.nse.bussiness.service.core;

import com.chenyang.nse.bussiness.dto.FilestructureDTO;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructure;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructureGroup;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurecolumn;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurespliter;
import com.chenyang.nse.bussiness.entity.orm.table.core.file.TCoreFileStructurewidth;
import com.chenyang.nse.bussiness.entity.orm.table.core.masking.TCoreMaskingFilesystem;
import com.chenyang.nse.bussiness.entity.param.filesystem.DemoFileImportParam;
import com.chenyang.nse.bussiness.entity.vo.ComboboxVO;
import java.sql.Connection;
import java.util.List;
import java.util.Map;

public interface FileSystemService {
   Connection getConnectionByDataSystemId(String datasystemid);

   void addFileStructure(FilestructureDTO filestructureDTO);

   void addFileStructure(DemoFileImportParam param);

   void dbInputFileStructure(Map<String, String> map);

   void removeFileStructure(String id);

   void modifyFileStructure(Map<String, String> map);

   List<TCoreFileStructure> queryFileStructure();

   List<TCoreFileStructure> queryRepeatName(String[] filestructurename, String filestructuregroup);

   TCoreFileStructurespliter queryFileStructureSpliter(String filestructureid);

   TCoreFileStructurewidth queryFileStructureWidth(String filestructureid);

   List<ComboboxVO> queryGroupname();

   List<ComboboxVO> queryGroupnameBySysid(String filesourceid);

   List<TCoreFileStructure> queryStructureByGroup(String groupname, String tableNamePattern);

   List<TCoreMaskingFilesystem> queryMaskingTaskStructure(String structureid);

   TCoreFileStructure getInfoByPk(String id);

   void dataWidthDouble(String structureid, String strtype);

   List<TCoreFileStructurecolumn> queryFileStructureColumn(String structureid);

   List<TCoreFileStructurecolumn> queryFileStructureColumnSearch(String structureid, String datatypes);

   void saveFileStructureGroup(TCoreFileStructureGroup group);

   Boolean checkRepeatGroupName(String groupname);

   void delFileStructureGroup(String groupid, String groupname);
}
