package com.chenyang.nse.bussiness.service.core.api.impl;

import com.chenyang.nse.bussiness.dao.table.core.api.ApiInfoLogDao;
import com.chenyang.nse.bussiness.entity.orm.table.core.api.ApiInfoLog;
import com.chenyang.nse.bussiness.service.core.api.ApiInfoLogService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ApiInfoLogServiceImpl implements ApiInfoLogService {
   @Autowired
   private ApiInfoLogDao apiInfoLogDao;

   public List<ApiInfoLog> querylist() {
      List<ApiInfoLog> list = this.apiInfoLogDao.queryAll();
      return list;
   }

   public List<ApiInfoLog> queryInfoByConditon(Map<String, String> condMap) {
      Criteria criteria = this.apiInfoLogDao.createCriteria();
      if (condMap.containsKey("username") && StringUtils.isNotBlank((String)condMap.get("username"))) {
         criteria.add(Restrictions.like("username", "%" + (String)condMap.get("username") + "%"));
      }

      if (condMap.containsKey("apitype") && StringUtils.isNotBlank((String)condMap.get("apitype"))) {
         criteria.add(Restrictions.eq("apitype", condMap.get("apitype")));
      }

      criteria.addOrder(Order.desc("calldatetime"));
      List<ApiInfoLog> list = this.apiInfoLogDao.queryAll(criteria);
      if (condMap.containsKey("calldatetime") && StringUtils.isNotBlank((String)condMap.get("calldatetime"))) {
         List<ApiInfoLog> querylist = new ArrayList();

         for(ApiInfoLog record : list) {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            String date = fmt.format(record.getCalldatetime()).substring(0, 10);
            if (((String)condMap.get("calldatetime")).contains(date)) {
               querylist.add(record);
            }
         }

         return querylist;
      } else {
         return list;
      }
   }

   public void save(ApiInfoLog info) {
      this.apiInfoLogDao.save(info);
   }
}
